/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.BeepParameter;
import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.CommandLine;
import com.ibm.lpex.core.FindTextOptions;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.ParameterIntegerDefault;
import com.ibm.lpex.core.ParameterOnOffDefault;
import com.ibm.lpex.core.ParameterStringDefault;
import com.ibm.lpex.core.Parameters;
import com.ibm.lpex.core.RealColumnNumbersParameter;
import com.ibm.lpex.core.TableNode;
import com.ibm.lpex.core.View;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Composite;

final class FindTextCommand {
    static final int ASIS = 1;
    static final int BLOCK = 2;
    static final int COLUMNS = 3;
    static final int EMPHASIS = 4;
    static final int END_COLUMN = 5;
    static final int FIND_TEXT = 6;
    static final int INCREMENTAL = 7;
    static final int MARK = 8;
    static final int REGULAR_EXPRESSION = 9;
    static final int REPLACE_TEXT = 10;
    static final int START_COLUMN = 11;
    static final int WHOLE_WORD = 12;
    static final int WRAP = 13;
    private static TableNode[] _parameters = new TableNode[]{new TableNode("asis", 1), new TableNode("block", 2), new TableNode("columns", 3), new TableNode("emphasis", 4), new TableNode("endColumn", 5), new TableNode("findText", 6), new TableNode("incremental", 7), new TableNode("mark", 8), new TableNode("regularExpression", 9), new TableNode("replaceText", 10), new TableNode("startColumn", 11), new TableNode("wholeWord", 12), new TableNode("wrap", 13)};
    private static AsisParameter _asisParameter;
    private static BlockParameter _blockParameter;
    private static ColumnsParameter _columnsParameter;
    private static EmphasisParameter _emphasisParameter;
    private static EndColumnParameter _endColumnParameter;
    private static FindTextParameter _findTextParameter;
    private static IncrementalParameter _incrementalParameter;
    private static MarkParameter _markParameter;
    private static RegularExpressionParameter _regularExpressionParameter;
    private static ReplaceTextParameter _replaceTextParameter;
    private static StartColumnParameter _startColumnParameter;
    private static WholeWordParameter _wholeWordParameter;
    private static WrapParameter _wrapParameter;

    static {
        TableNode.sort(_parameters);
    }

    FindTextCommand() {
    }

    static Parameter getParameter(String parameter) {
        TableNode p = TableNode.binarySearch(_parameters, Parameters.getParameterString(parameter));
        if (p != null) {
            switch (p.id()) {
                case 1: {
                    return FindTextCommand.asisParameter();
                }
                case 2: {
                    return FindTextCommand.blockParameter();
                }
                case 3: {
                    return FindTextCommand.columnsParameter();
                }
                case 4: {
                    return FindTextCommand.emphasisParameter();
                }
                case 5: {
                    return FindTextCommand.endColumnParameter();
                }
                case 6: {
                    return FindTextCommand.findTextParameter();
                }
                case 7: {
                    return FindTextCommand.incrementalParameter();
                }
                case 8: {
                    return FindTextCommand.markParameter();
                }
                case 9: {
                    return FindTextCommand.regularExpressionParameter();
                }
                case 10: {
                    return FindTextCommand.replaceTextParameter();
                }
                case 11: {
                    return FindTextCommand.startColumnParameter();
                }
                case 12: {
                    return FindTextCommand.wholeWordParameter();
                }
                case 13: {
                    return FindTextCommand.wrapParameter();
                }
            }
        }
        return null;
    }

    static AsisParameter asisParameter() {
        if (_asisParameter == null) {
            _asisParameter = new AsisParameter();
        }
        return _asisParameter;
    }

    static BlockParameter blockParameter() {
        if (_blockParameter == null) {
            _blockParameter = new BlockParameter();
        }
        return _blockParameter;
    }

    static ColumnsParameter columnsParameter() {
        if (_columnsParameter == null) {
            _columnsParameter = new ColumnsParameter();
        }
        return _columnsParameter;
    }

    static EmphasisParameter emphasisParameter() {
        if (_emphasisParameter == null) {
            _emphasisParameter = new EmphasisParameter();
        }
        return _emphasisParameter;
    }

    static EndColumnParameter endColumnParameter() {
        if (_endColumnParameter == null) {
            _endColumnParameter = new EndColumnParameter();
        }
        return _endColumnParameter;
    }

    static FindTextParameter findTextParameter() {
        if (_findTextParameter == null) {
            _findTextParameter = new FindTextParameter();
        }
        return _findTextParameter;
    }

    static IncrementalParameter incrementalParameter() {
        if (_incrementalParameter == null) {
            _incrementalParameter = new IncrementalParameter();
        }
        return _incrementalParameter;
    }

    static MarkParameter markParameter() {
        if (_markParameter == null) {
            _markParameter = new MarkParameter();
        }
        return _markParameter;
    }

    static RegularExpressionParameter regularExpressionParameter() {
        if (_regularExpressionParameter == null) {
            _regularExpressionParameter = new RegularExpressionParameter();
        }
        return _regularExpressionParameter;
    }

    static ReplaceTextParameter replaceTextParameter() {
        if (_replaceTextParameter == null) {
            _replaceTextParameter = new ReplaceTextParameter();
        }
        return _replaceTextParameter;
    }

    static StartColumnParameter startColumnParameter() {
        if (_startColumnParameter == null) {
            _startColumnParameter = new StartColumnParameter();
        }
        return _startColumnParameter;
    }

    static WholeWordParameter wholeWordParameter() {
        if (_wholeWordParameter == null) {
            _wholeWordParameter = new WholeWordParameter();
        }
        return _wholeWordParameter;
    }

    static WrapParameter wrapParameter() {
        if (_wrapParameter == null) {
            _wrapParameter = new WrapParameter();
        }
        return _wrapParameter;
    }

    static boolean doCommand(View view, String parameters) {
        return FindTextCommand.doCommand(view, parameters, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean doCommand(View view, String parameters, String caller) {
        boolean useFindTextSettings = true;
        FindTextOptions options = view != null ? view.getFindTextOptions() : new FindTextOptions();
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase("up")) {
                options._up = true;
                continue;
            }
            if (token.equalsIgnoreCase("checkStart")) {
                options._checkStart = true;
                continue;
            }
            if (token.equalsIgnoreCase("replace")) {
                options._replace = true;
                options._replaceText = FindTextCommand.replaceTextParameter().currentValue(view);
                continue;
            }
            if (token.equalsIgnoreCase("exclude")) {
                options._exclude = true;
                continue;
            }
            if (token.equalsIgnoreCase("all")) {
                options._all = true;
                continue;
            }
            if (token.equalsIgnoreCase("quiet")) {
                options._quiet = true;
                continue;
            }
            if (token.equalsIgnoreCase("noBeep")) {
                options._noBeep = true;
                continue;
            }
            if (token.equalsIgnoreCase("mark")) {
                options._mark = true;
                useFindTextSettings = false;
                continue;
            }
            if (token.equalsIgnoreCase("columns")) {
                options._columns = true;
                if (!st.hasMoreTokens()) return FindTextCommand.columnsMissing(view);
                token = st.nextToken();
                try {
                    options._startColumn = Integer.parseInt(token);
                }
                catch (NumberFormatException e) {
                    return CommandHandler.invalidParameter(view, token, "findText");
                }
                if (!st.hasMoreTokens()) return FindTextCommand.columnsMissing(view);
                token = st.nextToken();
                try {
                    options._endColumn = Integer.parseInt(token);
                }
                catch (NumberFormatException e) {
                    return CommandHandler.invalidParameter(view, token, "findText");
                }
                useFindTextSettings = false;
                continue;
            }
            if (token.equalsIgnoreCase("block") || token.equalsIgnoreCase("selection")) {
                options._block = true;
                useFindTextSettings = false;
                continue;
            }
            if (token.equalsIgnoreCase("noWrap")) {
                options._wrap = false;
                useFindTextSettings = false;
                continue;
            }
            if (token.equalsIgnoreCase("asis")) {
                options._asis = true;
                useFindTextSettings = false;
                continue;
            }
            if (token.equalsIgnoreCase("noEmphasis")) {
                options._emphasis = false;
                useFindTextSettings = false;
                continue;
            }
            if (token.equalsIgnoreCase("wholeWord")) {
                options._wholeWord = true;
                useFindTextSettings = false;
                continue;
            }
            if (token.equalsIgnoreCase("regularExpression")) {
                options._regularExpression = true;
                useFindTextSettings = false;
                continue;
            }
            if (token.equalsIgnoreCase("replaceWith")) {
                options._replace = true;
                options._replaceText = "";
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (LpexStringTokenizer.isInvalidQuotedString(token)) {
                        return CommandHandler.invalidQuotedParameter(view, token, "findText");
                    }
                    options._replaceText = LpexStringTokenizer.removeQuotes(token);
                }
                useFindTextSettings = false;
                continue;
            }
            if (token.equalsIgnoreCase("uiMode")) {
                options._uiMode = true;
                continue;
            }
            if (token.equalsIgnoreCase("subcommand")) {
                options._subcommand = true;
                continue;
            }
            if (LpexStringTokenizer.isInvalidQuotedString(token)) {
                return CommandHandler.invalidQuotedParameter(view, token, "findText");
            }
            options._findText = LpexStringTokenizer.removeQuotes(token);
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "findText");
            }
            useFindTextSettings = false;
            break;
        }
        if (useFindTextSettings) {
            options._mark = FindTextCommand.markParameter().currentValue(view);
            options._columns = FindTextCommand.columnsParameter().currentValue(view);
            options._startColumn = FindTextCommand.startColumnParameter().currentValue(view);
            options._endColumn = FindTextCommand.endColumnParameter().currentValue(view);
            options._block = FindTextCommand.blockParameter().currentValue(view);
            options._wholeWord = FindTextCommand.wholeWordParameter().currentValue(view);
            options._wrap = FindTextCommand.wrapParameter().currentValue(view);
            options._asis = FindTextCommand.asisParameter().currentValue(view);
            options._emphasis = FindTextCommand.emphasisParameter().currentValue(view);
            options._regularExpression = FindTextCommand.regularExpressionParameter().currentValue(view);
            options._replaceText = FindTextCommand.replaceTextParameter().currentValue(view);
            options._findText = FindTextCommand.findTextParameter().currentValue(view);
            options._originalFindText = FindTextCommand.findTextParameter().currentValue(view);
        }
        if (options._findText == null || options._findText.length() == 0) {
            if (view == null) return useFindTextSettings;
            view.setLpexMessageText("findText.noFindText");
            return useFindTextSettings;
        }
        options._startColumn = RealColumnNumbersParameter.getEffectiveColumnNumber(view, options._startColumn);
        options._endColumn = RealColumnNumbersParameter.getEffectiveColumnNumber(view, options._endColumn);
        if (view != null && view.nls().isIgnoringBidiMarks()) {
            options._findText = LpexNls.stripBidiMarks(options._findText);
            options._replaceText = LpexNls.stripBidiMarks(options._replaceText);
        }
        if (!options._asis && !options._regularExpression) {
            StringBuilder buffer = new StringBuilder(options._findText.length());
            int i = 0;
            while (i < options._findText.length()) {
                buffer.append(Character.toUpperCase(options._findText.charAt(i)));
                ++i;
            }
            options._findText = buffer.toString();
        } else if (options._regularExpression) {
            try {
                int patternFlags;
                Object regex = options._findText;
                int n = patternFlags = options._asis ? 0 : 66;
                if (!(!options._wholeWord || ((String)regex).startsWith("\\b") && ((String)regex).endsWith("\\b"))) {
                    regex = "\\b(?:" + (String)regex + ")\\b";
                }
                options._replaceText = FindTextCommand.replaceRegEx(options._replaceText);
                if (options._matcher == null || options._matcher.pattern().flags() != patternFlags || !options._matcher.pattern().pattern().equals(regex)) {
                    options._matcher = Pattern.compile((String)regex, patternFlags).matcher("");
                }
            }
            catch (Exception e) {
                if (!options._quiet && view != null) {
                    view.setLpexMessageText("findText.invalidPattern", options._findText);
                    if (!options._noBeep) {
                        BeepParameter.getParameter().setValue(true);
                    }
                }
                CommandHandler.setStatus("findText.invalidPattern");
                return true;
            }
        }
        if (options._block && options._uiMode && view != null) {
            Composite compCmd = view.window().commandLine();
            LpexView lpexView = view.lpexView();
            String blockType = lpexView.query("block.type");
            if (blockType != null && blockType.equals("stream") && compCmd instanceof CommandLine) {
                CommandLine cmdLine = (CommandLine)compCmd;
                cmdLine.setBlockTypeToCharacter(lpexView);
            }
        }
        if (view == null) return true;
        CommandHandler.setStatus(null);
        view.findText(options, caller);
        return true;
    }

    private static String replaceRegEx(String possiblePattern) {
        String retVal = possiblePattern;
        try {
            retVal = FindTextCommand.replaceWithCharPoint(retVal, Pattern.compile("\\\\u([0-9A-Fa-f]{4})"), 16);
        }
        catch (Exception e) {
            retVal = possiblePattern;
        }
        try {
            retVal = FindTextCommand.replaceWithCharPoint(retVal, Pattern.compile("\\\\x([0-9A-Fa-f]{4})"), 16);
        }
        catch (Exception e) {
            retVal = possiblePattern;
        }
        try {
            retVal = FindTextCommand.replaceWithCharPoint(retVal, Pattern.compile("\\\\x([0-9A-Fa-f]{3})"), 16);
        }
        catch (Exception e) {
            retVal = possiblePattern;
        }
        try {
            retVal = FindTextCommand.replaceWithCharPoint(retVal, Pattern.compile("\\\\x([0-9A-Fa-f]{2})"), 16);
        }
        catch (Exception e) {
            retVal = possiblePattern;
        }
        try {
            retVal = FindTextCommand.replaceWithCharPoint(retVal, Pattern.compile("\\\\0([0-3]{1}[0-7]{2})"), 8);
        }
        catch (Exception e) {
            retVal = possiblePattern;
        }
        try {
            retVal = FindTextCommand.replaceWithCharPoint(retVal, Pattern.compile("\\\\0([0-7]{2})"), 8);
        }
        catch (Exception e) {
            retVal = possiblePattern;
        }
        return retVal;
    }

    private static String replaceWithCharPoint(String regEx, Pattern pattern, int base) {
        String retVal = regEx;
        try {
            retVal = regEx == null ? null : FindTextCommand.patternReplaceAll(pattern, regEx, base);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    private static String patternReplaceAll(Pattern pattern, String regEx, int base) {
        String value = regEx;
        Matcher matcher = pattern.matcher(value);
        while (matcher.find()) {
            String target = matcher.group(0);
            String targetContent = matcher.group(1);
            String replacement = String.valueOf((char)Integer.parseInt(targetContent, base));
            value = value.replace(target, replacement);
            matcher = pattern.matcher(value);
        }
        return value;
    }

    private static boolean columnsMissing(View view) {
        if (view != null) {
            view.setLpexMessageText("findText.columnsMissing");
        }
        return false;
    }

    static final class AsisParameter
    extends ParameterOnOffDefault {
        AsisParameter() {
            super("findText.asis", false);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.findTextCommandSettings()._asis = value;
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.findTextCommandSettings()._asis : 2;
        }
    }

    static final class BlockParameter
    extends ParameterOnOffDefault {
        BlockParameter() {
            super("findText.block", false);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.findTextCommandSettings()._block = value;
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.findTextCommandSettings()._block : 2;
        }
    }

    static final class ColumnsParameter
    extends ParameterOnOffDefault {
        ColumnsParameter() {
            super("findText.columns", false);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.findTextCommandSettings()._columns = value;
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.findTextCommandSettings()._columns : 2;
        }
    }

    static final class EmphasisParameter
    extends ParameterOnOffDefault {
        EmphasisParameter() {
            super("findText.emphasis", true);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.findTextCommandSettings()._emphasis = value;
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.findTextCommandSettings()._emphasis : 2;
        }
    }

    static final class EndColumnParameter
    extends ParameterIntegerDefault {
        EndColumnParameter() {
            super("findText.endColumn", 80);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value, boolean useDefaultValue) {
            if (view != null) {
                Settings settings = view.findTextCommandSettings();
                settings._endColumn = value;
                settings._useDefaultEndColumn = useDefaultValue;
            }
            return true;
        }

        @Override
        boolean useDefaultValue(View view) {
            return view != null ? view.findTextCommandSettings()._useDefaultEndColumn : true;
        }

        @Override
        int value(View view) {
            return view != null ? view.findTextCommandSettings()._endColumn : 0;
        }
    }

    static final class FindTextParameter
    extends ParameterStringDefault {
        FindTextParameter() {
            super("findText.findText", null);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, String value) {
            if (view != null) {
                view.findTextCommandSettings()._findText = value;
            }
            return true;
        }

        @Override
        String value(View view) {
            return view != null ? view.findTextCommandSettings()._findText : null;
        }
    }

    static final class IncrementalParameter
    extends ParameterOnOffDefault {
        IncrementalParameter() {
            super("findText.incremental", true);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.setFindTextIncremental(value);
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.findTextIncremental() : 2;
        }
    }

    static final class MarkParameter
    extends ParameterOnOffDefault {
        MarkParameter() {
            super("findText.mark", false);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.findTextCommandSettings()._mark = value;
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.findTextCommandSettings()._mark : 2;
        }
    }

    static final class RegularExpressionParameter
    extends ParameterOnOffDefault {
        RegularExpressionParameter() {
            super("findText.regularExpression", false);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.findTextCommandSettings()._regularExpression = value;
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.findTextCommandSettings()._regularExpression : 2;
        }
    }

    static final class ReplaceTextParameter
    extends ParameterStringDefault {
        ReplaceTextParameter() {
            super("findText.replaceText", null);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, String value) {
            if (view != null) {
                view.findTextCommandSettings()._replaceText = value;
            }
            return true;
        }

        @Override
        String value(View view) {
            return view != null ? view.findTextCommandSettings()._replaceText : null;
        }
    }

    static final class Settings {
        int _asis = 2;
        int _block = 2;
        int _columns = 2;
        int _emphasis = 2;
        int _endColumn;
        boolean _useDefaultEndColumn = true;
        String _findText;
        int _mark = 2;
        int _regularExpression = 2;
        String _replaceText;
        int _startColumn;
        boolean _useDefaultStartColumn = true;
        int _wholeWord = 2;
        int _wrap = 2;

        Settings() {
        }
    }

    static final class StartColumnParameter
    extends ParameterIntegerDefault {
        StartColumnParameter() {
            super("findText.startColumn", 1);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value, boolean useDefaultValue) {
            if (view != null) {
                Settings settings = view.findTextCommandSettings();
                settings._startColumn = value;
                settings._useDefaultStartColumn = useDefaultValue;
            }
            return true;
        }

        @Override
        boolean useDefaultValue(View view) {
            return view != null ? view.findTextCommandSettings()._useDefaultStartColumn : true;
        }

        @Override
        int value(View view) {
            return view != null ? view.findTextCommandSettings()._startColumn : 0;
        }
    }

    static final class WholeWordParameter
    extends ParameterOnOffDefault {
        WholeWordParameter() {
            super("findText.wholeWord", false);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.findTextCommandSettings()._wholeWord = value;
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.findTextCommandSettings()._wholeWord : 2;
        }
    }

    static final class WrapParameter
    extends ParameterOnOffDefault {
        WrapParameter() {
            super("findText.wrap", true);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.findTextCommandSettings()._wrap = value;
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.findTextCommandSettings()._wrap : 2;
        }
    }
}

