/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.DisplayStyle;
import com.ibm.lpex.core.DisplayTextLayout;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.MarkList;
import com.ibm.lpex.core.ParsePending;
import com.ibm.lpex.core.PrefixAreaTextParameter;
import com.ibm.lpex.core.TextFontMetrics;
import com.ibm.lpex.core.View;

final class ElementView {
    ElementView _next;
    private Element _element;
    private View _view;
    private int _flags;
    private String _prefixText;
    private int _prefixScroll;
    private int _width;
    private int _prefixAreaWidth;
    private String _style;
    private DisplayStyle _displayStyle;
    private long _classes = 1L;
    private int _visibleOrdinal;
    private ParsePending _parsePending;
    private String _displayText;
    MarkNode _firstMarkNode;
    private static final int SHOW = 1;
    private static final int WIDTH_VALID = 2;
    private static final int ROUGH_WIDTH_VALID = 4;
    private static final int PREFIX_AREA_WIDTH_VALID = 8;
    private static final int FORCE_VISIBLE = 16;
    private static final int EXPANDED = 32;
    private static final int EXPANDED_VISIBLE = 64;

    ElementView(Element element, View view) {
        this._element = element;
        this._view = view;
    }

    ElementView(Element element, View view, boolean show) {
        this._element = element;
        this._view = view;
        this._flags = show ? 1 : 0;
    }

    Element element() {
        return this._element;
    }

    View view() {
        return this._view;
    }

    private boolean prefixAreaWidthValid() {
        return (this._flags & 8) != 0;
    }

    private void setPrefixAreaWidthValid(boolean prefixAreaWidthValid) {
        this._flags = prefixAreaWidthValid ? (this._flags |= 8) : (this._flags &= 0xFFFFFFF7);
    }

    boolean show() {
        return (this._flags & 1) != 0;
    }

    int roughWidth() {
        if ((this._flags & 4) == 0) {
            String text = this.displayText();
            if (text.length() == 0) {
                this._width = 0;
                this._flags |= 6;
            } else {
                TextFontMetrics textFontMetrics = this._view.screen().textFontMetrics();
                if (textFontMetrics != null) {
                    this._width = textFontMetrics.stringWidth(text);
                    this._flags |= 4;
                }
            }
        }
        return this._width;
    }

    int width() {
        if ((this._flags & 2) == 0) {
            if (LpexUtilities.isBidi() && this._element.hasBidi()) {
                this._width = DisplayTextLayout.width(this);
                this._flags |= 6;
            } else {
                this.roughWidth();
                if ((this._flags & 4) != 0) {
                    this._flags |= 2;
                }
            }
        }
        return this._width;
    }

    void setWidthInvalid() {
        this._flags &= 0xFFFFFFF9;
        if (this._view.maxElementWidthValid() && this.visible()) {
            this._view.setMaxElementWidthInvalid();
        }
    }

    int prefixAreaWidth() {
        if (!this.prefixAreaWidthValid()) {
            int prefixAreaTextValue = PrefixAreaTextParameter.getParameter().currentValue(this._view);
            if (prefixAreaTextValue == 3) {
                this._prefixAreaWidth = 0;
            } else {
                TextFontMetrics textFontMetrics;
                String prefixAreaText = "";
                if (prefixAreaTextValue == 2) {
                    prefixAreaText = this._view.document().elementList().getSequenceNumbersDisplayString(this._element, this._view);
                }
                if (prefixAreaText.length() == 0) {
                    prefixAreaText = this._view.lineNumbersText(this._element);
                }
                if ((textFontMetrics = this._view.screen().textFontMetrics()) != null) {
                    this._prefixAreaWidth = textFontMetrics.stringWidth(prefixAreaText) + 2;
                    this.setPrefixAreaWidthValid(true);
                }
            }
        }
        return this._prefixAreaWidth;
    }

    void setPrefixAreaWidthInvalid() {
        if (this.prefixAreaWidthValid()) {
            this.setPrefixAreaWidthValid(false);
            if (this._view.maxPrefixAreaWidthValid() && this.visible()) {
                this._view.setMaxPrefixAreaWidthInvalid();
            }
        }
    }

    int pixelCharPosition(int textPosition) {
        return this.pixelPosition(textPosition, true);
    }

    int pixelPosition(int textPosition) {
        return this.pixelPosition(textPosition, false);
    }

    int pixelPosition(int textPosition, boolean charPosition) {
        if (textPosition <= 0) {
            return 0;
        }
        int position = this._view.displayPosition(this, textPosition, charPosition);
        if (position == 1 && !LpexUtilities.isBidi()) {
            return 0;
        }
        TextFontMetrics textFontMetrics = this._view.screen().textFontMetrics();
        if (textFontMetrics == null) {
            return 0;
        }
        String text = this.displayText();
        if (text.length() == 0) {
            return textFontMetrics.spaceWidth() * (position - 1);
        }
        if (LpexUtilities.isBidi() && this._element.hasBidi()) {
            return DisplayTextLayout.pixelPosition(this, position);
        }
        if (text.length() > position - 1) {
            int subWidth = textFontMetrics.substringWidth(text, 0, position - 1);
            return subWidth;
        }
        int roughCalc = this.roughWidth();
        int spacewidthCalc = textFontMetrics.spaceWidth() * (position - 1 - text.length());
        int calc = roughCalc + spacewidthCalc;
        return calc;
    }

    boolean isRightToLeft(int textPosition) {
        if (!LpexUtilities.isBidi() || !this._element.hasBidi() || textPosition < 1) {
            return false;
        }
        int displayPosition = this._view.displayPosition(this, textPosition, true);
        return DisplayTextLayout.isRTLCharacter(this, displayPosition);
    }

    boolean isRightToLeftContext(int textPosition) {
        if (!LpexUtilities.isBidi() || !this._element.hasBidi() || textPosition < 1) {
            return false;
        }
        int displayPosition = this._view.displayPosition(this, textPosition, true);
        return DisplayTextLayout.isRTLContext(this, displayPosition);
    }

    long classes() {
        return this._classes;
    }

    void setClasses(long classes) {
        boolean wasVisible = this.visible();
        this._classes = classes | 1L | this._classes & 0xE000000000000000L;
        this.visibilityChanged(wasVisible);
    }

    void setTextClasses(long textClasses) {
        boolean wasVisible = this.visible();
        this._classes |= textClasses;
        this.visibilityChanged(wasVisible);
    }

    void clearTextClasses(long textClasses) {
        boolean wasVisible = this.visible();
        this._classes &= textClasses ^ 0xFFFFFFFFFFFFFFFFL;
        this.visibilityChanged(wasVisible);
    }

    void clearClasses(long clearClasses) {
        this._classes &= clearClasses ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private void visibilityChanged(boolean wasVisible) {
        if (wasVisible != this.visible()) {
            this._view.setVisibleElementOrdinalsInvalid();
            if (this._view.maxElementWidthValid() && this.roughWidth() >= this._view.maxElementWidth()) {
                this._view.setMaxElementWidthInvalid();
            }
            if (this._view.maxPrefixAreaWidthValid() && this.prefixAreaWidth() >= this._view.maxPrefixAreaWidth()) {
                this._view.setMaxPrefixAreaWidthInvalid();
            }
        }
    }

    boolean expandHideVisible() {
        return this._view.forceAllVisible() || this.forceVisible() || (!this._element.show() || this.show()) && (this._classes & this._view.includedClasses()) != 0L && (this._classes & this._view.excludedClasses()) == 0L && this._view.markList().visible(this._element);
    }

    boolean visible() {
        if (this._view.forceAllVisible()) {
            return true;
        }
        this._view.validateVisibleElements();
        return !(!this.expandHideVisible() && !this.expandedVisible() || this._element.show() && !this.show());
    }

    int visibleOrdinal() {
        return this._visibleOrdinal;
    }

    void setVisibleOrdinal(int visibleOrdinal) {
        this._visibleOrdinal = visibleOrdinal;
    }

    ParsePending parsePending() {
        return this._parsePending;
    }

    void setParsePending(ParsePending parsePending) {
        this._parsePending = parsePending;
    }

    void setPrefixText(String prefixText) {
        this._prefixText = prefixText;
    }

    String prefixText() {
        return this._prefixText;
    }

    int prefixEnd() {
        return this._prefixText != null ? this._prefixText.length() + 1 : 1;
    }

    int prefixScroll() {
        return this._prefixScroll;
    }

    void setPrefixScroll(int prefixScroll) {
        this._prefixScroll = prefixScroll;
    }

    void setForceVisible(boolean forceVisible) {
        this._flags = forceVisible ? (this._flags |= 0x10) : (this._flags &= 0xFFFFFFEF);
    }

    boolean forceVisible() {
        return (this._flags & 0x10) != 0;
    }

    void setExpanded(boolean expanded) {
        if (expanded != this.expanded()) {
            this._flags = expanded ? (this._flags |= 0x20) : (this._flags &= 0xFFFFFFDF);
            this._view.setVisibleElementOrdinalsInvalid();
        }
    }

    boolean expanded() {
        return (this._flags & 0x20) != 0;
    }

    void setExpandedVisible(boolean expandedVisible) {
        this._flags = expandedVisible ? (this._flags |= 0x40) : (this._flags &= 0xFFFFFFBF);
    }

    boolean expandedVisible() {
        return (this._flags & 0x40) != 0;
    }

    String displayText() {
        if (this._displayText != null) {
            return this._displayText;
        }
        String displayText = this._element.text();
        boolean expandTabs = this._element.tabs() && this._view.currentExpandTabs();
        boolean displayingSosi = this._view.nls().displayingSosi();
        boolean displayingWhitespaceChar = this._view.nls().displayingWhitespaceChar();
        boolean displayingHostChar = this._view.nls().displayingHostChar();
        String sourceEncoding = this._view.lpexView().nls().getSourceEncoding();
        if (!expandTabs) {
            if (displayingWhitespaceChar) {
                displayText = this._view.convertWhitespaceChar(displayText, false);
            }
            if (displayingHostChar) {
                displayText = this._view.convertHostChar(displayText, sourceEncoding, false);
            }
            if (!displayingSosi) {
                return this.cacheDisplayText(displayText);
            }
            return this.cacheDisplayText(this._view.nls().addSourceSosi(displayText));
        }
        if (displayingSosi) {
            displayText = this._view.nls().addSourceSosi(displayText);
        }
        if (displayingWhitespaceChar) {
            displayText = this._view.convertWhitespaceChar(displayText, true);
        }
        if (displayingHostChar) {
            displayText = this._view.convertHostChar(displayText, sourceEncoding, true);
        }
        if (!displayingWhitespaceChar) {
            displayText = this._view.expandTextTabs(displayText);
        }
        return this.cacheDisplayText(displayText);
    }

    String displayNetText() {
        if (!this._view.nls().displayingSosi()) {
            return this.displayText();
        }
        String displayText = this._element.text();
        if (this._element.tabs() && this._view.currentExpandTabs()) {
            displayText = this._view.expandTextTabs(displayText);
        }
        return displayText;
    }

    void resetDisplayText() {
        this._displayText = null;
        this._displayStyle = null;
        this.setWidthInvalid();
    }

    void resetDisplayTextFont() {
    }

    private String cacheDisplayText(String text) {
        this._displayText = text;
        return this._displayText;
    }

    String style() {
        return this._style == null ? "" : this._style;
    }

    void resetDisplayStyle() {
        this._displayStyle = null;
    }

    DisplayStyle displayStyle() {
        if (this._displayStyle != null) {
            return this._displayStyle;
        }
        LpexNls nls = this._view.nls();
        this._displayStyle = new DisplayStyle(this);
        String text = this._element.text();
        if (!this._element.tabs() || !this._view.currentExpandTabs()) {
            if (nls.displayingSosi()) {
                this._displayStyle.addSosi(text);
            }
            return this._displayStyle;
        }
        if (nls.displayingSosi()) {
            this._displayStyle.addSosi(text);
            text = nls.addSourceSosi(text);
        }
        this._displayStyle.expandTabs(text);
        return this._displayStyle;
    }

    void setStyle(String style) {
        this._style = style;
        this._displayStyle = null;
    }

    boolean expandHideHeader() {
        if (this.expandHideVisible()) {
            Element element = this._element.next();
            while (element != null) {
                ElementView elementView = element.elementView(this._view);
                if (elementView.expandHideVisible()) {
                    return false;
                }
                if (!element.show() || elementView.show()) {
                    return true;
                }
                element = element.next();
            }
        }
        return false;
    }

    String expandHideText() {
        if (this.expandHideHeader()) {
            return this.expanded() ? "-" : "+";
        }
        return "";
    }

    static final class MarkNode {
        MarkList.Mark _mark;
        MarkNode _next;

        MarkNode(MarkList.Mark mark) {
            this._mark = mark;
        }

        MarkList.Mark mark() {
            return this._mark;
        }
    }
}

