/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.BeepParameter;
import com.ibm.lpex.core.Block;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementView;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.PrefixAreaParameter;
import com.ibm.lpex.core.PrefixAreaTextParameter;
import com.ibm.lpex.core.SaveCommand;
import com.ibm.lpex.core.SequenceDefaultTextParameter;
import com.ibm.lpex.core.SequenceNumbersParameter;
import com.ibm.lpex.core.View;
import java.util.Arrays;

final class ElementList {
    private Document _document;
    private Element _firstElement;
    private Element _lastElement;
    private Element _lastOrdinalRequested;
    private Element _lastNonShowOrdinalRequested;
    private boolean _ordinalsValid;
    private Element _lastOrdinalValid;
    private boolean _nonShowOrdinalsValid;
    private Element _lastNonShowOrdinalValid;
    private int _textLimit;
    private int _sequenceNumbersColumn;
    private int _sequenceNumbersWidth;
    private int _sequenceNumbersNumColumn;
    private int _sequenceNumbersNumWidth;
    private int _sequenceNumbersTextColumn;
    private int _sequenceNumbersTextWidth;
    private String _sequenceNumbersStyle;
    private boolean _maintainSequenceNumbers;
    private boolean _sequenceNumbersValid;
    private int _maxSequenceNumber;
    String _sequenceDefaultTextParm;
    private String _sequenceDefaultText;
    private int _spacesLen;
    private String _spaces = "";

    ElementList(Document document) {
        this._document = document;
        this._maintainSequenceNumbers = true;
        this._textLimit = SaveCommand.TextLimitParameter.getParameter().currentValue(this._document._firstView);
        SequenceNumbersParameter seq = SequenceNumbersParameter.getParameter();
        this._sequenceNumbersNumColumn = seq.currentNumColumn(this._document);
        this._sequenceNumbersNumWidth = seq.currentNumWidth(this._document);
        this._sequenceNumbersTextColumn = seq.currentTextColumn(this._document);
        this._sequenceNumbersTextWidth = seq.currentTextWidth(this._document);
        this.cacheSequenceNumbersData();
    }

    Element first() {
        return this._firstElement;
    }

    Element last() {
        return this._lastElement;
    }

    /*
     * Unable to fully structure code
     */
    synchronized Element elementAt(int ordinal) {
        block8: {
            if (ordinal < 1 || ordinal > this.ordinalOf(this._lastElement)) {
                return null;
            }
            if (ordinal == this.ordinalOf(this._lastElement)) {
                return this._lastElement;
            }
            if (this._lastOrdinalRequested == null) {
                this._lastOrdinalRequested = this.first();
            } else {
                delta = ordinal - this.ordinalOf(this._lastOrdinalRequested);
                if (delta < 0) {
                    delta = -delta;
                }
                if (delta > ordinal) {
                    this._lastOrdinalRequested = this.first();
                }
            }
            if (ordinal < this.ordinalOf(this._lastOrdinalRequested)) ** GOTO lbl19
            while (this._lastOrdinalRequested != null && this.ordinalOf(this._lastOrdinalRequested) != ordinal) {
                this._lastOrdinalRequested = this._lastOrdinalRequested.next();
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                this._lastOrdinalRequested = this._lastOrdinalRequested.prev();
lbl19:
                // 2 sources

                ** while (this._lastOrdinalRequested != null && this.ordinalOf((Element)this._lastOrdinalRequested) != ordinal)
            }
        }
        return this._lastOrdinalRequested;
    }

    int ordinalOf(Element element) {
        if (element != null && element._partOfList) {
            if (!this._ordinalsValid) {
                Element current;
                int count;
                if (this._lastOrdinalValid == null) {
                    count = 1;
                    current = this.first();
                } else {
                    count = this._lastOrdinalValid._ordinal;
                    current = this._lastOrdinalValid;
                }
                while (current != null) {
                    current._ordinal = count++;
                    current = current.next();
                }
                this._ordinalsValid = true;
            }
            return element._ordinal;
        }
        return 0;
    }

    synchronized int count() {
        return this._lastElement == null ? 0 : this.ordinalOf(this._lastElement);
    }

    void addAfter(View view, Element prev, Element element) {
        this.addAfter(view, prev, element, false);
    }

    synchronized void addAfter(View view, Element prev, Element element, boolean undoElement) {
        if (element != null) {
            Element next;
            if (prev == null) {
                next = this._firstElement;
                this._firstElement = element;
            } else {
                next = prev.next();
                prev._next = element;
            }
            element._prev = prev;
            element._next = next;
            if (next != null) {
                next._prev = element;
            } else {
                this._lastElement = element;
            }
            element._partOfList = true;
            this._lastOrdinalValid = this._ordinalsValid ? prev : null;
            this._ordinalsValid = false;
            this._lastNonShowOrdinalValid = this._nonShowOrdinalsValid ? prev : null;
            this._nonShowOrdinalsValid = false;
            this.insert(view, element, undoElement);
        }
    }

    synchronized void addBefore(View view, Element next, Element element) {
        if (element != null) {
            Element prev;
            if (next == null) {
                prev = this._lastElement;
                this._lastElement = element;
            } else {
                prev = next.prev();
                next._prev = element;
            }
            element._next = next;
            element._prev = prev;
            if (prev != null) {
                prev._next = element;
            } else {
                this._firstElement = element;
            }
            element._partOfList = true;
            this._lastOrdinalValid = this._ordinalsValid ? prev : null;
            this._ordinalsValid = false;
            this._lastNonShowOrdinalValid = this._nonShowOrdinalsValid ? prev : null;
            this._nonShowOrdinalsValid = false;
            this.insert(view, element, false);
        }
    }

    private void insert(View view, Element element, boolean undoElement) {
        boolean sequenceNumbersOverflow = false;
        element.setWidthsInvalid();
        element.setPrefixAreaWidthsInvalid();
        boolean insertNotificationSent = false;
        if (!element.show()) {
            if (this._textLimit > 0 && this.saveLength(element) > this._textLimit) {
                view.setLpexMessageText("textLimit.overflow");
                BeepParameter.getParameter().setValue(true);
            }
            if (undoElement) {
                element.setSequenceText(element.sequenceText());
            } else if (this._maintainSequenceNumbers) {
                element.setSequenceText(this._sequenceDefaultText);
            }
            int sequenceNumber = element.sequenceNumber();
            Element prev = element.prevNonShow();
            Element next = element.nextNonShow();
            if (this._maintainSequenceNumbers && this._sequenceNumbersNumWidth > 0) {
                int nextSequenceNumber;
                int prevSequenceNumber = prev == null ? 0 : prev.sequenceNumber();
                int n = nextSequenceNumber = next == null ? this._maxSequenceNumber : next.sequenceNumber();
                if (prevSequenceNumber >= sequenceNumber || nextSequenceNumber <= sequenceNumber) {
                    Element firstSeqNumberReplaced = null;
                    Element lastSeqNumberReplaced = null;
                    int countSeqNumberReplaced = 0;
                    Element e = element;
                    sequenceNumber = prevSequenceNumber;
                    while (true) {
                        if (++sequenceNumber >= this._maxSequenceNumber) {
                            sequenceNumbersOverflow = true;
                            break;
                        }
                        e.setSequenceNumber(sequenceNumber);
                        if (!insertNotificationSent) {
                            this._document.elementInserted(view, element, undoElement);
                            insertNotificationSent = true;
                        } else {
                            if (firstSeqNumberReplaced == null) {
                                firstSeqNumberReplaced = e;
                            }
                            lastSeqNumberReplaced = e;
                            ++countSeqNumberReplaced;
                        }
                        if (next == null || sequenceNumber < next.sequenceNumber()) break;
                        e = next;
                        next = e.nextNonShow();
                    }
                    if (firstSeqNumberReplaced != null) {
                        if (countSeqNumberReplaced > 2) {
                            view.document().startChanges(view);
                        }
                        e = firstSeqNumberReplaced;
                        while (e != null) {
                            this._document.seqNumberReplaced(view, e);
                            this._document.elementAdjusted(view, e);
                            if (e == lastSeqNumberReplaced) break;
                            e = e.nextNonShow();
                        }
                        if (countSeqNumberReplaced > 2) {
                            view.document().endChanges(view);
                        }
                    }
                }
            } else if (this._sequenceNumbersValid && (sequenceNumber == 0 || sequenceNumber >= this._maxSequenceNumber || prev != null && prev.sequenceNumber() >= sequenceNumber || next != null && next.sequenceNumber() <= sequenceNumber)) {
                this._sequenceNumbersValid = false;
            }
        }
        if (!insertNotificationSent) {
            this._document.elementInserted(view, element, undoElement);
        }
        if (sequenceNumbersOverflow) {
            if (this._document.resequence(view) == 0) {
                view.setLpexMessageText("sequenceNumbers.overflow");
                this._maintainSequenceNumbers = false;
            } else {
                view.setLpexMessageText("sequenceNumbers.overflowReseq");
            }
        }
    }

    synchronized Element remove(View view, Element element) {
        this._document.elementRemoved(view, element);
        Block block = view == null ? Block.lpexBlock() : view.block();
        block.elementRemoved(element);
        if (!element.show()) {
            Element e2;
            Element e1 = element.prevNonShow();
            if (e1 != null) {
                this._document.addParsePending(e1, 2);
            }
            if ((e2 = element.nextNonShow()) != null) {
                this._document.addParsePending(e2, 4);
            }
            if (e1 == null && e2 == null) {
                e1 = element.prev();
                if (e1 != null) {
                    this._document.addParsePending(e1, 2);
                } else {
                    e2 = element.next();
                    if (e2 != null) {
                        this._document.addParsePending(e2, 4);
                    }
                }
            }
        } else {
            Element e = element.prevNonShow();
            if (e != null) {
                element.showView().parsePendingList().add(e, 8);
            }
            if ((e = element.nextNonShow()) != null) {
                element.showView().parsePendingList().add(e, 16);
            }
        }
        Element prev = element.prev();
        Element next = element.next();
        if (prev != null) {
            prev._next = next;
        } else {
            this._firstElement = next;
        }
        if (next != null) {
            next._prev = prev;
        } else {
            this._lastElement = prev;
        }
        element._next = null;
        element._prev = null;
        element._partOfList = false;
        this._lastOrdinalValid = this._ordinalsValid ? prev : null;
        this._ordinalsValid = false;
        if (this._lastOrdinalRequested == element) {
            this._lastOrdinalRequested = next;
        }
        if (this._lastNonShowOrdinalRequested == element) {
            this._lastNonShowOrdinalRequested = next;
        }
        element.setWidthsInvalid();
        element.setPrefixAreaWidthsInvalid();
        this._document.setVisibleElementOrdinalsInvalid();
        this._lastNonShowOrdinalValid = this._nonShowOrdinalsValid ? prev : null;
        this._nonShowOrdinalsValid = false;
        return element;
    }

    synchronized void clear(View view) {
        while (this._firstElement != null) {
            this.remove(view, this._firstElement);
        }
        this._lastOrdinalValid = null;
        this._ordinalsValid = false;
        this._document.resetUserActionElements();
        View v = this._document._firstView;
        while (v != null) {
            v.setMaxElementWidthInvalid();
            v.setMaxPrefixAreaWidthInvalid();
            v = v._next;
        }
        this._document.setVisibleElementOrdinalsInvalid();
        this._lastNonShowOrdinalValid = null;
        this._nonShowOrdinalsValid = false;
    }

    void disposeView(View view) {
        Element nextElement = null;
        Element element = this.first();
        while (element != null) {
            nextElement = element.next();
            if (element.show() && element.elementView(view).show()) {
                this.remove(view, element);
            } else {
                element.disposeView(view);
            }
            element = nextElement;
        }
    }

    void expandAll(View view, boolean expanded) {
        Element element = this.first();
        while (element != null) {
            element.elementView(view).setExpanded(expanded);
            element = element.next();
        }
    }

    /*
     * Unable to fully structure code
     */
    synchronized Element nonShowElementAt(int ordinal) {
        block7: {
            if (ordinal < 1 || ordinal > this.nonShowCount()) {
                return null;
            }
            if (this._lastNonShowOrdinalRequested == null || this._lastNonShowOrdinalRequested.show()) {
                this._lastNonShowOrdinalRequested = this.first();
            } else {
                delta = ordinal - this.nonShowOrdinalOf(this._lastNonShowOrdinalRequested);
                if (delta < 0) {
                    delta = -delta;
                }
                if (delta > ordinal) {
                    this._lastNonShowOrdinalRequested = this.first();
                }
            }
            if (ordinal < this.nonShowOrdinalOf(this._lastNonShowOrdinalRequested)) ** GOTO lbl17
            while (this._lastNonShowOrdinalRequested != null && (this.nonShowOrdinalOf(this._lastNonShowOrdinalRequested) != ordinal || this._lastNonShowOrdinalRequested.show())) {
                this._lastNonShowOrdinalRequested = this._lastNonShowOrdinalRequested.next();
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                this._lastNonShowOrdinalRequested = this._lastNonShowOrdinalRequested.prev();
lbl17:
                // 2 sources

                ** while (this._lastNonShowOrdinalRequested != null && (this.nonShowOrdinalOf((Element)this._lastNonShowOrdinalRequested) != ordinal || this._lastNonShowOrdinalRequested.show()))
            }
        }
        return this._lastNonShowOrdinalRequested;
    }

    int nonShowOrdinalOf(Element element) {
        if (element != null && element._partOfList) {
            if (!this._nonShowOrdinalsValid) {
                this.validateNonShowOrdinals();
            }
            return element.nonShowOrdinal();
        }
        return 0;
    }

    void validateNonShowOrdinals() {
        if (!this._nonShowOrdinalsValid) {
            Element current;
            int count;
            if (this._lastNonShowOrdinalValid == null) {
                count = 0;
                current = this.first();
            } else {
                count = this._lastNonShowOrdinalValid.nonShowOrdinal();
                current = this._lastNonShowOrdinalValid.next();
            }
            while (current != null) {
                if (!current.show()) {
                    ++count;
                }
                current.setNonShowOrdinal(count);
                current = current.next();
            }
            this._nonShowOrdinalsValid = true;
        }
    }

    int elementOfLine(int line) {
        return this.ordinalOf(this.nonShowElementAt(line));
    }

    int lineOfElement(int element) {
        return this.nonShowOrdinalOf(this.elementAt(element));
    }

    int nonShowCount() {
        return this._lastElement == null ? 0 : this.nonShowOrdinalOf(this.last());
    }

    Element firstVisible(View view) {
        Element element = this.first();
        if (element != null && !element.visible(view)) {
            element = element.nextVisible(view);
        }
        return element;
    }

    Element lastVisible(View view) {
        Element element = this.last();
        if (element != null && !element.visible(view)) {
            element = element.prevVisible(view);
        }
        return element;
    }

    static int nextWord(Element element, int position) {
        String text = element.text();
        int textLength = text.length();
        if (textLength > 0) {
            char c;
            if (position > 0) {
                while (position <= textLength) {
                    c = text.charAt(position - 1);
                    if (c == ' ' || c == '\t') break;
                    ++position;
                }
            }
            ++position;
            while (position <= textLength) {
                c = text.charAt(position - 1);
                if (c != ' ' && c != '\t') {
                    return position;
                }
                ++position;
            }
        }
        return 0;
    }

    static int nextWordEnd(Element element, int position) {
        String text = element.text();
        int textLength = text.length();
        if (textLength > 0) {
            char c;
            ++position;
            while (position <= textLength) {
                c = text.charAt(position - 1);
                if (c != ' ' && c != '\t') break;
                ++position;
            }
            if (position <= textLength) {
                while (position < textLength) {
                    c = text.charAt(position);
                    if (c == ' ' || c == '\t') break;
                    ++position;
                }
                return position;
            }
        }
        return 0;
    }

    static int prevWord(Element element, int position) {
        String text = element.text();
        int textLength = text.length();
        if (textLength > 0) {
            char c;
            if (position > textLength + 1) {
                position = textLength + 1;
            }
            --position;
            while (position > 0) {
                c = text.charAt(position - 1);
                if (c != ' ' && c != '\t') break;
                --position;
            }
            while (position > 0) {
                if (position == 1) {
                    return 1;
                }
                c = text.charAt(position - 2);
                if (c == ' ' || c == '\t') {
                    return position;
                }
                --position;
            }
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    static int prevWordEnd(Element element, int position) {
        block3: {
            block4: {
                text = element.text();
                textLength = text.length();
                if (textLength <= 0) break block3;
                if (position <= textLength) ** GOTO lbl9
                position = textLength;
                break block4;
                while ((c = text.charAt(position - 1)) != ' ' && c != '\t') {
                    --position;
lbl9:
                    // 2 sources

                    if (position > 0) continue;
                }
            }
            while (position > 0) {
                c = text.charAt(position - 1);
                if (c != ' ' && c != '\t') {
                    return position;
                }
                --position;
            }
        }
        return 0;
    }

    boolean maintainSequenceNumbers() {
        return this._maintainSequenceNumbers;
    }

    void setMaintainSequenceNumbers(View view, boolean maintainSequenceNumbers) {
        if (this._maintainSequenceNumbers != maintainSequenceNumbers) {
            this._maintainSequenceNumbers = maintainSequenceNumbers;
            if (this._maintainSequenceNumbers && !this._sequenceNumbersValid && this._sequenceNumbersNumWidth > 0) {
                int rc = this._document.resequence(view);
                if (rc == 2) {
                    view.screen().setMessageKey("sequenceNumbers.resequenced");
                } else if (rc == 0) {
                    view.screen().setMessageKey("sequenceNumbers.overflow");
                    this._maintainSequenceNumbers = false;
                }
            }
        }
    }

    void setSequenceNumbers(View view, int numColumn, int numWidth, int textColumn, int textWidth) {
        if (this._sequenceNumbersNumWidth != numWidth || this._sequenceNumbersTextWidth != textWidth || numWidth > 0 && this._sequenceNumbersNumColumn != numColumn || textWidth > 0 && this._sequenceNumbersTextColumn != textColumn) {
            this._document.resetUserActionElements();
            boolean recording = this._document.undo().setRecording(false);
            view.setIgnoreFields();
            this._document.startChanges(view);
            this._document.sendDocumentListenerNotifications(false);
            boolean taggedChanges = this.internalSetSequenceNumbers(view, numColumn, numWidth, textColumn, textWidth);
            this._document.sendDocumentListenerNotifications(true);
            if (taggedChanges) {
                Element element = this.first();
                while (element != null) {
                    if (element.tagged()) {
                        this._document.elementReplacedAndAdjusted(view, element);
                        element.clearTag();
                    }
                    element = element.next();
                }
            }
            this._document.endChanges(view);
            if (this._maintainSequenceNumbers && !this._sequenceNumbersValid && this._sequenceNumbersNumWidth != 0) {
                int rc = this._document.resequence(view);
                if (rc == 0) {
                    view.screen().setMessageKey("sequenceNumbers.overflow");
                    this._maintainSequenceNumbers = false;
                } else {
                    view.screen().setMessageKey("sequenceNumbers.resequenced");
                }
            }
            view.resetIgnoreFields();
            this._document.undo().setRecording(recording);
        }
    }

    void unnumber(View view, boolean trim) {
        this._document.resetUserActionElements();
        view.setIgnoreFields();
        this._document.startChanges(view);
        this._document.sendDocumentListenerNotifications(false);
        boolean taggedChanges = this.internalUnnumber(view, trim);
        this._document.sendDocumentListenerNotifications(true);
        if (taggedChanges) {
            Element element = this.first();
            while (element != null) {
                if (element.tagged()) {
                    this._document.elementReplaced(view, element);
                    element.clearTag();
                }
                element = element.next();
            }
        }
        this._document.endChanges(view);
        view.resetIgnoreFields();
    }

    private boolean internalUnnumber(View view, boolean trim) {
        boolean usingSourceColumns = LpexNls.usingSourceColumns(this._document);
        boolean documentChanged = false;
        if (this._sequenceNumbersWidth != 0) {
            boolean recording = this._document.undo().setRecording(false);
            Element element = this.first();
            while (element != null) {
                if (element.show()) {
                    ElementView elementView = element._firstElementView;
                    while (elementView != null) {
                        elementView.resetDisplayText();
                        elementView = elementView._next;
                    }
                } else {
                    Object sequenceNumbersText = this.getSequenceNumbersString(element);
                    if (usingSourceColumns) {
                        int len = LpexNls.sourceTruncate(element.text(), this._sequenceNumbersColumn - 1, this._document);
                        int spaces = this._sequenceNumbersColumn - LpexNls.sourceLength(element.text().substring(0, len), this._document) - 1;
                        if (spaces > 0) {
                            documentChanged = true;
                            element.setTag();
                        }
                        while (spaces-- > 0) {
                            sequenceNumbersText = " " + (String)sequenceNumbersText;
                        }
                        view.insertText(element, len + 1, (String)sequenceNumbersText, true);
                    } else {
                        view.insertText(element, this._sequenceNumbersColumn, (String)sequenceNumbersText, true);
                    }
                }
                element.disposeSequenceText();
                element = element.next();
            }
            this._document.undo().setRecording(recording);
            SequenceNumbersParameter.Settings settings = this._document.sequenceNumbersSettings();
            settings._numColumn = 1;
            settings._numWidth = 0;
            settings._textColumn = 1;
            settings._textWidth = 0;
            settings._useDefaultValue = false;
            this._sequenceNumbersNumColumn = 1;
            this._sequenceNumbersNumWidth = 0;
            this._sequenceNumbersTextColumn = 1;
            this._sequenceNumbersTextWidth = 0;
            this.cacheSequenceNumbersData();
            this.sequenceDefaultTextChanged();
            View v = this._document._firstView;
            while (v != null) {
                if (PrefixAreaParameter.getParameter().currentValue(v) && PrefixAreaTextParameter.getParameter().currentValue(v) == 2) {
                    v.setPrefixAreaWidthsInvalid();
                }
                v = v._next;
            }
        }
        if (!view.document().readonly()) {
            Element element = this.first();
            while (element != null) {
                if (!element.show() && !view.markList().protect(element)) {
                    if (view.clearColumns7380NoNotify(element, usingSourceColumns)) {
                        documentChanged = true;
                        element.setTag();
                    }
                    if (trim && view.trimElementNoNotify(element)) {
                        documentChanged = true;
                        element.setTag();
                    }
                }
                element = element.next();
            }
        }
        return documentChanged;
    }

    private boolean internalSetSequenceNumbers(View view, int numColumn, int numWidth, int textColumn, int textWidth) {
        Element element;
        boolean usingSourceColumns = LpexNls.usingSourceColumns(this._document);
        boolean documentChanged = false;
        if (this._sequenceNumbersWidth > 0) {
            element = this.first();
            while (element != null) {
                if (element.show()) {
                    ElementView elementView = element._firstElementView;
                    while (elementView != null) {
                        elementView.resetDisplayText();
                        elementView = elementView._next;
                    }
                } else {
                    Object sequenceNumbersText = this.getSequenceNumbersString(element);
                    if (usingSourceColumns) {
                        int len = LpexNls.sourceTruncate(element.text(), this._sequenceNumbersColumn - 1, this._document);
                        int spaces = this._sequenceNumbersColumn - LpexNls.sourceLength(element.text().substring(0, len), this._document) - 1;
                        if (spaces > 0) {
                            documentChanged = true;
                            element.setTag();
                        }
                        if (LpexNls.isIgnoringBidiMarks(this._document) && this._sequenceNumbersColumn > 1) {
                            int i = element.text().length() - 1;
                            while (i > 1) {
                                char ch = element.text().charAt(i);
                                if (ch >= 'A' && ch <= 'z') break;
                                if (ch > '\u0590' && (ch <= '\u07b1' || ch >= '\ufb1d' && ch <= '\ufefc')) {
                                    sequenceNumbersText = "\u200e" + (String)sequenceNumbersText;
                                    break;
                                }
                                --i;
                            }
                        }
                        while (spaces-- > 0) {
                            sequenceNumbersText = " " + (String)sequenceNumbersText;
                        }
                        view.insertText(element, len + 1, (String)sequenceNumbersText, true);
                    } else {
                        view.insertText(element, this._sequenceNumbersColumn, (String)sequenceNumbersText, true);
                    }
                }
                element = element.next();
            }
        }
        if (this._sequenceNumbersTextWidth > 0 && textWidth == 0) {
            element = this.first();
            while (element != null) {
                element.disposeSequenceText();
                element = element.next();
            }
        }
        this._sequenceNumbersNumColumn = numColumn;
        this._sequenceNumbersNumWidth = numWidth;
        this._sequenceNumbersTextColumn = textColumn;
        this._sequenceNumbersTextWidth = textWidth;
        this.cacheSequenceNumbersData();
        this.sequenceDefaultTextChanged();
        if (this._sequenceNumbersWidth != 0) {
            int prevSequenceNumber = 0;
            if (this._sequenceNumbersNumWidth > 0) {
                this._sequenceNumbersValid = true;
                view.screen().clearMessageKey("sequenceNumbers.resequenced");
            }
            Element element2 = this.first();
            while (element2 != null) {
                if (element2.show()) {
                    ElementView elementView = element2._firstElementView;
                    while (elementView != null) {
                        elementView.resetDisplayText();
                        elementView = elementView._next;
                    }
                } else {
                    int col1;
                    if (element2.length() < this._sequenceNumbersColumn + this._sequenceNumbersWidth - 1) {
                        documentChanged = true;
                        element2.setTag();
                    }
                    StringBuilder sequenceNumbersText = new StringBuilder();
                    if (usingSourceColumns) {
                        int len1 = LpexNls.sourceTruncate(element2.text(), this._sequenceNumbersColumn - 1, this._document);
                        int len2 = LpexNls.sourceTruncate(element2.text(), this._sequenceNumbersColumn - 1 + this._sequenceNumbersWidth, this._document);
                        if (len1 != this._sequenceNumbersColumn - 1 || len2 != this._sequenceNumbersColumn - 1 + this._sequenceNumbersWidth) {
                            documentChanged = true;
                            element2.setTag();
                        }
                        if (len2 > len1) {
                            sequenceNumbersText.append(ElementList.textSubstring(element2, len1, len2));
                            view.deleteText(element2, len1 + 1, len2 - len1, true, false);
                        }
                        if (LpexNls.isIgnoringBidiMarks(this._document) && sequenceNumbersText.length() > 0 && sequenceNumbersText.charAt(0) == '\u200e') {
                            sequenceNumbersText.deleteCharAt(0);
                        }
                        while (sequenceNumbersText.length() < this._sequenceNumbersWidth) {
                            sequenceNumbersText.append(' ');
                        }
                    } else {
                        sequenceNumbersText = new StringBuilder();
                        sequenceNumbersText.append(ElementList.textSubstring(element2, this._sequenceNumbersColumn - 1, this._sequenceNumbersColumn - 1 + this._sequenceNumbersWidth));
                        view.deleteText(element2, this._sequenceNumbersColumn, this._sequenceNumbersWidth, true, false);
                    }
                    int num = 0;
                    if (this._sequenceNumbersNumWidth > 0) {
                        col1 = this._sequenceNumbersNumColumn - this._sequenceNumbersColumn;
                        try {
                            num = Integer.parseInt(sequenceNumbersText.substring(col1, col1 + this._sequenceNumbersNumWidth));
                        }
                        catch (NumberFormatException ch) {
                            // empty catch block
                        }
                        if (num <= prevSequenceNumber) {
                            this._sequenceNumbersValid = false;
                        }
                    }
                    element2.setSequenceNumber(num);
                    prevSequenceNumber = num;
                    if (this._sequenceNumbersTextWidth > 0) {
                        col1 = this._sequenceNumbersTextColumn - this._sequenceNumbersColumn;
                        String text = sequenceNumbersText.substring(col1, col1 + this._sequenceNumbersTextWidth);
                        element2.quickSetSequenceText(text);
                    }
                }
                element2 = element2.next();
            }
        }
        View v = this._document._firstView;
        while (v != null) {
            if (PrefixAreaParameter.getParameter().currentValue(v) && PrefixAreaTextParameter.getParameter().currentValue(v) == 2) {
                v.setPrefixAreaWidthsInvalid();
            }
            v = v._next;
        }
        return documentChanged;
    }

    private static String textSubstring(Element element, int beginIndex, int endIndex) {
        String text = element.text();
        if (endIndex <= text.length()) {
            return text.substring(beginIndex, endIndex);
        }
        int end = endIndex <= text.length() ? endIndex : text.length();
        StringBuilder buffer = beginIndex < end ? new StringBuilder(text.substring(beginIndex)) : new StringBuilder();
        int i = buffer.length();
        while (i < endIndex - beginIndex) {
            buffer.append(' ');
            ++i;
        }
        return buffer.toString();
    }

    String getSequenceNumbersString(Element element) {
        StringBuilder str;
        block7: {
            str = new StringBuilder();
            if (this._sequenceNumbersNumWidth != 0) {
                str.append(String.valueOf(element.sequenceNumber()));
                while (str.length() < this._sequenceNumbersNumWidth) {
                    str.insert(0, '0');
                }
                while (str.length() > this._sequenceNumbersNumWidth) {
                    str.deleteCharAt(0);
                }
            }
            if (this._sequenceNumbersTextWidth == 0) break block7;
            String text = element.sequenceText();
            if (this._sequenceNumbersNumWidth == 0 || this._sequenceNumbersNumColumn < this._sequenceNumbersTextColumn) {
                str.append(text);
                while (str.length() < this._sequenceNumbersWidth) {
                    str.append(' ');
                }
            } else {
                str.insert(0, text);
                while (str.length() < this._sequenceNumbersWidth) {
                    str.insert(text.length(), ' ');
                }
            }
        }
        return str.toString();
    }

    String getSequenceNumbersDisplayString(Element element, View view) {
        if (this._sequenceNumbersWidth == 0) {
            return "";
        }
        boolean dontDisplay = element.show() && (!view.compareSession() || element.sequenceNumber() == 0 && element.sequenceText().length() == 0);
        String sequenceNumbersFormat = view.sequenceNumbersFormat();
        if (sequenceNumbersFormat == null) {
            return dontDisplay ? this.spaces(this._sequenceNumbersWidth) : this.getSequenceNumbersString(element);
        }
        String style = view.getSequenceNumbersStyle();
        if (dontDisplay) {
            return this.spaces(style.length());
        }
        StringBuilder formatted = new StringBuilder(style.length());
        String part = this._sequenceNumbersTextWidth > 0 ? element.sequenceText() : "";
        int p = 0;
        int i = 0;
        while (i < sequenceNumbersFormat.length()) {
            char c = sequenceNumbersFormat.charAt(i);
            if (c == 'X') {
                if (p < part.length()) {
                    formatted.append(part.charAt(p++));
                } else {
                    formatted.append(' ');
                }
            } else if (c == '9') {
                formatted.append('0');
            } else {
                if (c == '\\' && i < sequenceNumbersFormat.length() - 1) {
                    c = sequenceNumbersFormat.charAt(++i);
                }
                formatted.append(c);
            }
            ++i;
        }
        part = this._sequenceNumbersNumWidth > 0 ? String.valueOf(element.sequenceNumber()) : "";
        p = part.length() - 1;
        i = style.length() - 1;
        while (i >= 0 && p >= 0) {
            if (style.charAt(i) == '\u0001') {
                formatted.setCharAt(i, part.charAt(p--));
            }
            --i;
        }
        return formatted.toString();
    }

    private String spaces(int len) {
        if (len != this._spacesLen) {
            this._spacesLen = len;
            char[] spaces = new char[len];
            Arrays.fill(spaces, ' ');
            this._spaces = new String(spaces);
        }
        return this._spaces;
    }

    private String fullText(Element element, String text, boolean usingSourceColumns, boolean isSmartLogical) {
        int colIndex;
        int spaces;
        int lead;
        if (this._sequenceNumbersWidth == 0) {
            return text;
        }
        StringBuilder fullText = new StringBuilder(text);
        if (usingSourceColumns) {
            lead = LpexNls.sourceTruncate(text, this._sequenceNumbersColumn - 1, this._document);
            spaces = this._sequenceNumbersColumn - LpexNls.sourceLength(text.substring(0, lead), this._document) - 1;
            colIndex = lead + spaces;
        } else {
            lead = fullText.length();
            spaces = this._sequenceNumbersColumn - lead - 1;
            colIndex = this._sequenceNumbersColumn - 1;
        }
        while (spaces > 0) {
            fullText.insert(lead, ' ');
            --spaces;
        }
        String sequenceNumbers = this.getSequenceNumbersString(element);
        fullText.insert(colIndex, sequenceNumbers);
        if (colIndex != 0 && isSmartLogical && (LpexNls.hasBidi(text) || LpexNls.hasBidi(sequenceNumbers))) {
            fullText.insert(colIndex, '\u200e');
        }
        return fullText.toString();
    }

    private String fullText(Element element, String text) {
        if (this._sequenceNumbersWidth == 0) {
            return text;
        }
        return this.fullText(element, text, LpexNls.usingSourceColumns(this._document), this._document._firstView.nls().isSmartLogical());
    }

    /*
     * Unable to fully structure code
     */
    private void cacheSequenceNumbersData() {
        block11: {
            this._sequenceNumbersWidth = this._sequenceNumbersNumWidth + this._sequenceNumbersTextWidth;
            this._sequenceNumbersColumn = this._sequenceNumbersNumWidth != 0 && this._sequenceNumbersTextWidth != 0 ? Math.min(this._sequenceNumbersNumColumn, this._sequenceNumbersTextColumn) : (this._sequenceNumbersNumWidth != 0 ? this._sequenceNumbersNumColumn : this._sequenceNumbersTextColumn);
            this._maxSequenceNumber = 1;
            i = 0;
            while (i < this._sequenceNumbersNumWidth) {
                if (this._maxSequenceNumber == 1000000000) break;
                this._maxSequenceNumber *= 10;
                ++i;
            }
            this._sequenceNumbersValid = true;
            if (this._sequenceNumbersWidth == 0) {
                this._sequenceNumbersStyle = "";
                return;
            }
            buffer = new StringBuilder();
            if (this._sequenceNumbersNumWidth <= 0) ** GOTO lbl38
            while (buffer.length() < this._sequenceNumbersNumWidth) {
                buffer.append('\u0001');
            }
            if (this._sequenceNumbersTextWidth <= 0) break block11;
            if (this._sequenceNumbersNumColumn < this._sequenceNumbersTextColumn) {
                i = 0;
                while (i < this._sequenceNumbersTextWidth) {
                    buffer.append('\u0002');
                    ++i;
                }
            } else {
                i = 0;
                while (i < this._sequenceNumbersTextWidth) {
                    buffer.insert(0, '\u0002');
                    ++i;
                }
            }
            break block11;
lbl-1000:
            // 1 sources

            {
                buffer.append('\u0002');
lbl38:
                // 2 sources

                ** while (buffer.length() < this._sequenceNumbersTextWidth)
            }
        }
        this._sequenceNumbersStyle = buffer.toString();
    }

    int sequenceNumbersColumn() {
        return this._sequenceNumbersColumn;
    }

    int sequenceNumbersWidth() {
        return this._sequenceNumbersWidth;
    }

    int sequenceNumbersNumColumn() {
        return this._sequenceNumbersNumColumn;
    }

    int sequenceNumbersNumColumn(Element element) {
        if (this._sequenceNumbersColumn == 1 || !LpexNls.usingSourceColumns(this._document)) {
            return this._sequenceNumbersNumColumn;
        }
        String text = element.text();
        int lead = LpexNls.sourceTruncate(text, this._sequenceNumbersColumn - 1, this._document);
        int spaces = this._sequenceNumbersColumn - LpexNls.sourceLength(text.substring(0, lead), this._document);
        int colIndex = lead + spaces;
        if (this._sequenceNumbersColumn == this._sequenceNumbersNumColumn) {
            return colIndex;
        }
        return colIndex + this._sequenceNumbersTextWidth;
    }

    int sequenceNumbersNumWidth() {
        return this._sequenceNumbersNumWidth;
    }

    int sequenceNumbersTextColumn() {
        return this._sequenceNumbersTextColumn;
    }

    int sequenceNumbersTextColumn(Element element) {
        if (this._sequenceNumbersColumn == 1 || !LpexNls.usingSourceColumns(this._document)) {
            return this._sequenceNumbersTextColumn;
        }
        String text = element.text();
        int lead = LpexNls.sourceTruncate(text, this._sequenceNumbersColumn - 1, this._document);
        int spaces = this._sequenceNumbersColumn - LpexNls.sourceLength(text.substring(0, lead), this._document);
        int colIndex = lead + spaces;
        if (this._sequenceNumbersColumn == this._sequenceNumbersTextColumn) {
            return colIndex;
        }
        return colIndex + this._sequenceNumbersNumWidth;
    }

    int sequenceNumbersTextWidth() {
        return this._sequenceNumbersTextWidth;
    }

    int maxSequenceNumber() {
        return this._maxSequenceNumber;
    }

    void setSequenceNumbersValid(boolean valid) {
        this._sequenceNumbersValid = valid;
    }

    String sequenceNumbersStyle() {
        return this._sequenceNumbersStyle;
    }

    void setSequenceNumber(View view, Element element, int sequenceNumber) {
        if (element.show()) {
            view.setLpexMessageText("sequenceNumbers.showElement");
        } else if (view.document().readonly()) {
            view.setLpexMessageText("document.readonly");
        } else if (sequenceNumber >= this._maxSequenceNumber) {
            view.setLpexMessageText("sequenceNumbers.tooBig", sequenceNumber);
        } else {
            if (this._sequenceNumbersValid) {
                Element prev = element.prevNonShow();
                Element next = element.nextNonShow();
                if (prev != null && prev.sequenceNumber() >= sequenceNumber || next != null && next.sequenceNumber() <= sequenceNumber) {
                    this._sequenceNumbersValid = false;
                    if (this._maintainSequenceNumbers) {
                        this._maintainSequenceNumbers = false;
                        view.setLpexMessageText("sequenceNumbers.outOfOrder", sequenceNumber);
                    }
                }
            }
            if (element.setSequenceNumber(sequenceNumber)) {
                this._document.seqNumberReplaced(view, element);
            }
        }
    }

    void setSequenceDefaultTextParm(String newParameterValue) {
        this._sequenceDefaultTextParm = newParameterValue;
    }

    String sequenceDefaultText() {
        return this._sequenceDefaultText;
    }

    void sequenceDefaultTextChanged() {
        if (this._sequenceNumbersTextWidth == 0) {
            this._sequenceDefaultText = null;
        } else {
            this._sequenceDefaultText = SequenceDefaultTextParameter.getParameter().currentValue(this._document._firstView);
            if (this._sequenceDefaultText == null) {
                this._sequenceDefaultText = " ";
            }
            if (this._sequenceDefaultText.length() > this._sequenceNumbersTextWidth) {
                this._sequenceDefaultText = this._sequenceDefaultText.substring(0, this._sequenceNumbersTextWidth);
            }
            while (this._sequenceDefaultText.length() < this._sequenceNumbersTextWidth) {
                this._sequenceDefaultText = String.valueOf(this._sequenceDefaultText) + " ";
            }
        }
    }

    Element findSequenceNumber(int sequenceNumber) {
        if (this._sequenceNumbersNumWidth > 0) {
            Element element = this.first();
            while (element != null) {
                if (!element.show() && element.sequenceNumber() == sequenceNumber) {
                    return element;
                }
                element = element.next();
            }
        }
        return null;
    }

    int textLimit() {
        return this._textLimit;
    }

    void setTextLimit(View view, int textLimit) {
        this._textLimit = textLimit;
        if (this._textLimit > 0 && !this._document.readonly()) {
            Element element = this.first();
            while (element != null) {
                if (!element.show() && this.saveLength(element) > this._textLimit) {
                    view.screen().setMessageKey("textLimit.overflow");
                    break;
                }
                element = element.next();
            }
        }
    }

    int saveLength(Element element) {
        return this.saveLength(element, SaveCommand.TrimParameter.getParameter().currentValue(this._document._firstView));
    }

    int saveLength(Element element, boolean trim) {
        return this.saveLength(element, LpexNls.usingSourceColumns(this._document), this._document._firstView.nls().isSmartLogical(), trim);
    }

    int saveLength(Element element, boolean usingSourceColumns, boolean isSmartLogical, boolean trim) {
        int saveLength = element.length();
        if (trim && saveLength > 0) {
            String text = element.text();
            int i = saveLength - 1;
            while (i >= 0 && text.charAt(i) == ' ') {
                --saveLength;
                --i;
            }
        }
        if (usingSourceColumns || isSmartLogical) {
            String trimmedText;
            String string = trimmedText = saveLength == 0 ? "" : element.text().substring(0, saveLength);
            if (this._sequenceNumbersWidth > 0) {
                trimmedText = this.fullText(element, trimmedText, usingSourceColumns, isSmartLogical);
            }
            saveLength = usingSourceColumns ? LpexNls.sourceLength(trimmedText, this._document) : trimmedText.length();
        } else if (this._sequenceNumbersWidth > 0) {
            saveLength = this._sequenceNumbersColumn <= saveLength ? (saveLength += this._sequenceNumbersWidth) : this._sequenceNumbersColumn + this._sequenceNumbersWidth - 1;
        }
        return saveLength;
    }

    int fullTextLength(Element element) {
        return this._sequenceNumbersWidth > 0 ? this.fullText(element).length() : element.length();
    }

    String fullText(Element element) {
        return this.fullText(element, element.text());
    }

    String fullText(Element element, boolean usingSourceColumns, boolean isSmartLogical) {
        return this.fullText(element, element.text(), usingSourceColumns, isSmartLogical);
    }

    String lineFullText(int line) {
        Element e = this.nonShowElementAt(line);
        return e == null ? null : this.fullText(e, e.text());
    }

    int fullTextToTextPosition(Element element, int position) {
        if (this._sequenceNumbersWidth != 0 && element != null) {
            int lead;
            lead = this._sequenceNumbersColumn > 1 && LpexNls.usingSourceColumns(this._document) ? ((lead = LpexNls.sourceTruncate(element.text(), this.sequenceNumbersColumn() - 1, this._document)) == element.length() ? this._sequenceNumbersColumn : ++lead) : this._sequenceNumbersColumn;
            if (position > lead && (position -= this._sequenceNumbersWidth) < lead) {
                position = lead;
            }
        }
        return position;
    }

    int textToFullTextPosition(Element element, int position) {
        if (this._sequenceNumbersWidth != 0 && element != null) {
            int lead;
            lead = this._sequenceNumbersColumn > 1 && LpexNls.usingSourceColumns(this._document) ? ((lead = LpexNls.sourceTruncate(element.text(), this.sequenceNumbersColumn() - 1, this._document)) == element.length() ? this._sequenceNumbersColumn : ++lead) : this._sequenceNumbersColumn;
            if (position >= lead) {
                position += this._sequenceNumbersWidth;
            }
        }
        return position;
    }
}

