/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.DisplayTextLayout;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.LpexCommonParser;
import com.ibm.lpex.core.LpexParser;
import com.ibm.lpex.core.View;

final class ElementIterator {
    private View _view;
    private Element _element;
    private int _options;
    private int _lastPosition;
    private int _currPosition;
    private DisplayTextLayout _displayTextLayout;
    private int[] _fields;
    private boolean _usingSourceColumns;
    private LpexCommonParser _wordCharDefiner;

    ElementIterator(View view, Element element, int options) {
        this._view = view;
        this._element = element;
        this._options = options;
    }

    void dispose() {
        if (this._displayTextLayout != null) {
            this._displayTextLayout.dispose();
            this._displayTextLayout = null;
        }
    }

    private DisplayTextLayout displayTextLayout() {
        if (this._displayTextLayout == null) {
            this._displayTextLayout = new DisplayTextLayout(this._element.elementView(this._view));
        }
        return this._displayTextLayout;
    }

    private int[] fields() {
        if (this._fields == null) {
            this._fields = this._view.fields(this._element);
            if (this._fields != null) {
                this._usingSourceColumns = this._view.nls().usingSourceColumns();
            } else {
                this._fields = new int[0];
            }
        }
        return this._fields;
    }

    private void nextPosition() {
        if (this._currPosition < 0) {
            this._currPosition = 0;
        }
        this._lastPosition = this._currPosition;
        this._currPosition = this.displayTextLayout().getClusterOffsetNext(this._currPosition - 1) + 1;
    }

    private void prevPosition() {
        this._currPosition = this._lastPosition;
        this._lastPosition = this.displayTextLayout().getClusterOffsetPrev(this._currPosition - 1) + 1;
        if (this._lastPosition == this._currPosition) {
            this._lastPosition = 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int nextWord(int position) {
        if (position < 1 && (this._options & 0x24) != 0) {
            return 1;
        }
        String text = this._element.text();
        int textLength = text.length();
        if (textLength <= 0 || position > textLength) return 0;
        this._currPosition = position;
        int refAttr = this.getAttr();
        this.nextPosition();
        while (this._currPosition <= textLength) {
            int attr = this.getAttr();
            if ((attr & 2) != 0) {
                refAttr = 2;
            } else if (attr != refAttr) {
                if ((attr & 0x20) == 0) return this._currPosition;
                if ((this._options & 0x20) != 0) {
                    return this._currPosition;
                }
                refAttr = 32;
            } else if (((attr & 0x20) == 0 || (this._options & 0x20) != 0) && (this.isStyleChange() || this.isCaseChange() || this.isFieldStart())) {
                return this._currPosition;
            }
            this.nextPosition();
        }
        if ((this._options & 0x20) == 0) return 0;
        return textLength + 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int nextWordEnd(int position) {
        if (position < 0 && (this._options & 0x24) != 0) {
            return 0;
        }
        String text = this._element.text();
        int textLength = text.length();
        if (textLength <= 0 || position >= textLength) return -1;
        this._currPosition = position;
        this.nextPosition();
        int refAttr = this.getAttr();
        this.nextPosition();
        while (this._currPosition <= textLength) {
            int attr = this.getAttr();
            if ((attr & 2) != 0) {
                if (refAttr == 0 || (refAttr & 0x20) != 0 && (this._options & 0x20) != 0) {
                    return this._currPosition - 1;
                }
                refAttr = 2;
            } else if (attr != refAttr) {
                if ((refAttr & 2) != 0) {
                    refAttr = attr;
                } else {
                    if ((refAttr & 0x20) == 0) return this._currPosition - 1;
                    if ((this._options & 0x20) != 0) return this._currPosition - 1;
                    refAttr = attr;
                }
            } else if (((attr & 0x20) == 0 || (this._options & 0x20) != 0) && (this.isStyleChange() || this.isCaseChange() || this.isFieldStart())) {
                return this._currPosition - 1;
            }
            this.nextPosition();
        }
        if ((this._options & 0x20) == 0 && refAttr != 0 && ((refAttr & 0x20) == 0 || (this._options & 0x20) == 0)) return -1;
        return textLength;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int prevWord(int position) {
        String text = this._element.text();
        int textLength = text.length();
        if (position > textLength + 1) {
            if ((this._options & 0x20) != 0) {
                return textLength + 1;
            }
            position = textLength + 1;
        }
        if (textLength <= 0) return 0;
        if (position <= 1) return 0;
        this._lastPosition = position;
        this.prevPosition();
        this.prevPosition();
        while (this._currPosition != 1 || (this._options & 0x24) == 0) {
            int attr = this.getAttr();
            if (this._currPosition == 1) {
                if (attr != 0) return 0;
                return 1;
            }
            int refAttr = this.getAttr(this._lastPosition);
            if ((attr & 2) != 0) {
                refAttr = 2;
            } else if (attr != refAttr) {
                if ((attr & 0x20) == 0) return this._currPosition;
                if ((this._options & 0x20) != 0) {
                    return this._currPosition;
                }
                refAttr = 32;
            } else if ((attr & 0x20) == 0 || (this._options & 0x20) != 0) {
                if (this.isStyleChange()) return this._currPosition;
                if (this.isCaseChange()) return this._currPosition;
                if (this.isFieldStart()) {
                    return this._currPosition;
                }
            }
            this.prevPosition();
        }
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int prevWordEnd(int position) {
        String text = this._element.text();
        int textLength = text.length();
        if (position > textLength + 1) {
            if ((this._options & 0x20) != 0) {
                return textLength;
            }
            position = textLength + 1;
        }
        if (textLength <= 0 || position <= 1) return -1;
        this._lastPosition = position;
        this.prevPosition();
        while (true) {
            if (this._currPosition == 1) {
                if ((this._options & 0x24) == 0) return -1;
                return 0;
            }
            int attr = this.getAttr();
            int refAttr = this.getAttr(this._lastPosition);
            if ((attr & 2) != 0) {
                if (refAttr == 0 || (refAttr & 0x20) != 0 && (this._options & 0x20) != 0) {
                    return this._currPosition - 1;
                }
                refAttr = 2;
            } else if (attr != refAttr) {
                if ((refAttr & 2) != 0) {
                    refAttr = attr;
                } else {
                    if ((refAttr & 0x20) == 0) return this._currPosition - 1;
                    if ((this._options & 0x20) != 0) return this._currPosition - 1;
                    refAttr = attr;
                }
            } else if (((attr & 0x20) == 0 || (this._options & 0x20) != 0) && (this.isStyleChange() || this.isCaseChange() || this.isFieldStart())) {
                return this._currPosition - 1;
            }
            this.prevPosition();
        }
    }

    private int getAttr() {
        return this.isWhiteSpace() ? 2 : (!this.isWordCharacter() ? 32 : 0);
    }

    private int getAttr(int position) {
        return this.isWhiteSpace(position) ? 2 : (!this.isWordCharacter(position) ? 32 : 0);
    }

    private boolean isCaseChange() {
        int currChar;
        int lastChar;
        return (this._options & 0x10) != 0 && this._lastPosition > 0 && Character.isLetter(lastChar = this._element.text().codePointAt(this._lastPosition - 1)) && Character.isLetter(currChar = this._element.text().codePointAt(this._currPosition - 1)) && Character.isLowerCase(lastChar) && !Character.isLowerCase(currChar);
    }

    private boolean isFieldStart() {
        if ((this._options & 4) != 0 && this.fields().length > 0) {
            int position = this._currPosition;
            if (this._usingSourceColumns) {
                position = this._view.nls().encodingIndex(this._element.text(), position - 1) + 1;
            }
            int i = 0;
            while (i < this._fields.length) {
                if (this._fields[i] == position) {
                    return true;
                }
                if (this._fields[i] > position) {
                    return false;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isStyleChange() {
        if ((this._options & 8) != 0 && this._lastPosition > 0) {
            int currStyle;
            String style = this._element.elementView(this._view).style();
            int lastStyle = this._lastPosition <= style.length() ? (int)style.charAt(this._lastPosition - 1) : 33;
            int n = currStyle = this._currPosition <= style.length() ? (int)style.charAt(this._currPosition - 1) : 33;
            if (lastStyle != currStyle) {
                return true;
            }
        }
        return false;
    }

    private boolean isWhiteSpace() {
        return this.isWhiteSpace(this._currPosition);
    }

    private boolean isWhiteSpace(int position) {
        if (position <= 0 || position > this._element.length()) {
            return true;
        }
        char c = this._element.text().charAt(position - 1);
        return c == ' ' || c == '\t';
    }

    private boolean isWordCharacter() {
        return this.isWordCharacter(this._currPosition);
    }

    private boolean isWordCharacter(int position) {
        LpexParser lpexParser;
        if (position <= 0 || position > this._element.length()) {
            return false;
        }
        if ((this._options & 1) == 0) {
            return true;
        }
        if (this._wordCharDefiner == null && (lpexParser = this._view.parsePendingList().lpexParser()) instanceof LpexCommonParser) {
            this._wordCharDefiner = (LpexCommonParser)lpexParser;
        }
        return this._wordCharDefiner == null ? true : this._wordCharDefiner.isWordCharacter(this._view.document().elementList().ordinalOf(this._element), position);
    }
}

