/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Block;
import com.ibm.lpex.core.DisplayTextLayout;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.ElementView;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.Screen;
import com.ibm.lpex.core.TabsParameter;
import com.ibm.lpex.core.TextWindow;
import com.ibm.lpex.core.View;

final class DocumentPosition {
    private View _view;
    private Element _element;
    private int _position;
    private int _desiredPixelPosition;
    private int _direction;
    public static final int LTR = 0;
    public static final int RTL = 1;
    private boolean _ignoreKeyboardChanged;
    private int _emphasisPosition;
    private int _emphasisLength;
    private Element _emphasisElement;
    private int _emphasisCursorPosition;
    private int _prefixPosition;
    private int _desiredPrefixPixelPosition;
    private Element _jumpElement;
    private boolean _ignoreChanges;
    private Preserve _topPreserve;
    private Preserve _cachedPreserves;

    DocumentPosition(View view) {
        this._view = view;
        this.top();
    }

    Element element() {
        if (this._element == null || !this._element._partOfList || !this._element.visible(this._view)) {
            if (this._element == null || !this._element._partOfList) {
                this.goToTop();
            }
            if (this._element != null && !this._element.visible(this._view)) {
                Element nextVisible = this._element.nextVisible(this._view);
                this._element = nextVisible != null ? nextVisible : this._element.prevVisible(this._view);
                this._prefixPosition = 1;
                this._position = 1;
                this._desiredPixelPosition = -1;
                this._desiredPrefixPixelPosition = -1;
            }
            if (this._element != null) {
                this.setNewDirection();
            }
        }
        return this._element;
    }

    int position() {
        return this._position;
    }

    int direction() {
        return this._direction;
    }

    private void setDirection(int newDirection, int newKeyboardLanguage) {
        LpexWindow lpexWindow;
        this._direction = newDirection;
        if (LpexUtilities.isBidi() && (lpexWindow = this._view.window()) != null && ((TextWindow)lpexWindow.textWindow()).focusGained()) {
            this.setKeyboardLanguage(newKeyboardLanguage);
        }
    }

    private void setNewDirection() {
        if (LpexUtilities.isBidi() && this.element() != null) {
            ElementView elementView = this._element.elementView(this._view);
            boolean currRTL = elementView.isRightToLeft(this._position);
            boolean currRTLContext = elementView.isRightToLeftContext(this._position);
            int newDirection = currRTL ? 1 : 0;
            int newKeyboard = currRTLContext ? 1 : 0;
            this.setDirection(newDirection, newKeyboard);
        }
    }

    private void setKeyboardLanguage(int newKeyboardLanguage) {
        this._ignoreKeyboardChanged = true;
        LpexUtilities.setKeyboardLanguage(newKeyboardLanguage);
        this._ignoreKeyboardChanged = false;
    }

    void restoreKeyboardLanguage() {
        if (!this._view.document().visual() && this.element() != null) {
            int newLanguage = this._element.elementView(this._view).isRightToLeftContext(this._position) ? 1 : 0;
            this.setKeyboardLanguage(newLanguage);
        }
    }

    void languageChanged() {
        if (!this._ignoreKeyboardChanged) {
            boolean currRTL;
            ElementView elementView;
            boolean prevRTL;
            int newKeyboardDirection = LpexUtilities.getKeyboardLanguage();
            if (this.element() != null && !this._view.inPrefix() && (prevRTL = (elementView = this._element.elementView(this._view)).isRightToLeft(this._position - 1)) != (currRTL = elementView.isRightToLeft(this._position))) {
                this._direction = newKeyboardDirection;
            }
            this._view.screen().show();
        }
    }

    void insertModeChanged() {
        if (!this._view.document().visual() && this.element() != null && !this._view.insertMode() && LpexUtilities.isBidi()) {
            boolean currRTLContext = this._element.elementView(this._view).isRightToLeftContext(this._position);
            this.setKeyboardLanguage(currRTLContext ? 1 : 0);
        }
    }

    void inPrefixChanged() {
        if (this._view.inPrefix() && LpexUtilities.isBidi()) {
            this.setKeyboardLanguage(0);
        }
    }

    int prefixPosition() {
        return this._prefixPosition;
    }

    void setPrefixPosition(int n) {
        if (!this._ignoreChanges) {
            this._prefixPosition = n;
            if (this.element() == null) {
                this._prefixPosition = 1;
            } else {
                int prefixEnd = this._element.elementView(this._view).prefixEnd();
                if (this._prefixPosition > prefixEnd) {
                    this._prefixPosition = prefixEnd;
                }
                if (this._prefixPosition < 1) {
                    this._prefixPosition = 1;
                }
            }
            this._desiredPrefixPixelPosition = -1;
        }
    }

    private void goToTop() {
        if (!this._ignoreChanges) {
            this._element = this._view.document().elementList().first();
            if (this._element != null && !this._element.visible(this._view)) {
                this._element = this._element.nextVisible(this._view);
            }
            if (this._element != null && this._view.visibleElementOrdinalOf(this._element) > 1) {
                this._view.screen().setCursorRow(this._view.visibleElementOrdinalOf(this._element));
            }
            this._prefixPosition = 1;
            this._position = 1;
            this._desiredPixelPosition = -1;
            this._desiredPrefixPixelPosition = -1;
        }
    }

    void top() {
        if (!this._ignoreChanges) {
            this.goToTop();
            if (this._view.insertMode()) {
                this.setDirection(0, 0);
            } else {
                this.setNewDirection();
            }
        }
    }

    void documentTop() {
        if (!this._ignoreChanges) {
            this._view.verifyDocumentSectionLine(1);
            this.top();
        }
    }

    void bottom() {
        if (!this._ignoreChanges) {
            this._element = this._view.document().elementList().last();
            if (this._element != null) {
                if (!this._element.visible(this._view)) {
                    this._element = this._element.prevVisible(this._view);
                }
                if (this._element != null) {
                    this._prefixPosition = 1;
                    this._position = this._element.end();
                    this.setDirection(0, 0);
                    this._desiredPixelPosition = -1;
                    this._desiredPrefixPixelPosition = -1;
                }
            }
        }
    }

    void documentBottom() {
        if (!this._ignoreChanges) {
            this._view.verifyDocumentSectionLine(this._view.document().linesCount());
            this.bottom();
        }
    }

    int next(int n) {
        if (!this._ignoreChanges && this.element() != null) {
            int i = 0;
            while (i < n) {
                Element next = this._element.nextVisible(this._view);
                if (next == null) {
                    return i;
                }
                this._element = next;
                ++i;
            }
            return n;
        }
        return 0;
    }

    int prev(int n) {
        if (!this._ignoreChanges && this.element() != null) {
            int i = 0;
            while (i < n) {
                Element prev = this._element.prevVisible(this._view);
                if (prev == null) {
                    return i;
                }
                this._element = prev;
                ++i;
            }
            return n;
        }
        return 0;
    }

    void down() {
        this.down(1);
    }

    void down(int n) {
        if (!this._ignoreChanges && this.element() != null) {
            this._view.verifyDocumentSectionDelta(n);
            this.preserveDesiredPosition();
            this.next(n);
            this.adjustToDesiredPosition();
            this._view.screen().setCursorRow(this._view.screen().cursorRow() + n);
            this.setNewDirection();
        }
    }

    void pageDown() {
        if (!this._ignoreChanges) {
            int n = this._view.screen().rows();
            this._view.verifyDocumentSectionDelta(n);
            this.preserveDesiredPosition();
            this.next(n);
            this.adjustToDesiredPosition();
            this.setNewDirection();
        }
    }

    void up() {
        this.up(1);
    }

    void up(int n) {
        if (!this._ignoreChanges && this.element() != null) {
            this._view.verifyDocumentSectionDelta(-n);
            this.preserveDesiredPosition();
            int actualN = this.prev(n);
            this.adjustToDesiredPosition();
            this._view.screen().setCursorRow(this._view.screen().cursorRow() - actualN);
            if (actualN < n && this._element != null && this._view.visibleElementOrdinalOf(this._element) > 1) {
                int remainingN = n - actualN;
                this._view.screen().setCursorRow(this._view.screen().cursorRow() + remainingN);
            }
            this.setNewDirection();
        }
    }

    void pageUp() {
        if (!this._ignoreChanges) {
            int n = this._view.screen().rows();
            this._view.verifyDocumentSectionDelta(-n);
            this.preserveDesiredPosition();
            int actualN = this.prev(n);
            this.adjustToDesiredPosition();
            if (actualN < n && this.element() != null && this._view.visibleElementOrdinalOf(this._element) > 1) {
                int remainingN = n - actualN;
                this._view.screen().setCursorRow(this._view.screen().cursorRow() + remainingN);
            }
            this.setNewDirection();
        }
    }

    void right() {
        this.right(1);
    }

    void right(int n) {
        if (!this._ignoreChanges) {
            this._desiredPixelPosition = -1;
            this._position += n;
        }
    }

    void arrowRight() {
        if (!this._ignoreChanges && this.element() != null) {
            ElementView elementView = this._element.elementView(this._view);
            this._desiredPixelPosition = -1;
            if (this._view.insertMode() && LpexUtilities.isBidi()) {
                boolean currRTL = elementView.isRightToLeft(this._position);
                boolean prevRTL = elementView.isRightToLeft(this._position - 1);
                boolean currRTLContext = elementView.isRightToLeftContext(this._position);
                if (currRTL != prevRTL) {
                    if (this._direction == 0 && currRTL) {
                        this.setDirection(1, 1);
                        return;
                    }
                    if (this._direction == 1 && !currRTL) {
                        this.setDirection(0, currRTLContext ? 1 : 0);
                        return;
                    }
                } else {
                    boolean prevRTLContext = elementView.isRightToLeftContext(this._position - 1);
                    if (!currRTLContext && prevRTLContext && this._direction == 0 && LpexUtilities.getKeyboardLanguage() == 1) {
                        this.setDirection(this._direction, 0);
                        return;
                    }
                }
            }
            this._position = DisplayTextLayout.getClusterOffsetNext(this._element.text(), this._position - 1) + 1;
            if (!this._view.insertMode() && LpexUtilities.isBidi()) {
                int newDirection = elementView.isRightToLeft(this._position) ? 1 : 0;
                int newLanguage = elementView.isRightToLeftContext(this._position) ? 1 : 0;
                this.setDirection(newDirection, newLanguage);
            }
        }
    }

    void arrowRight(int n) {
        while (n > 0) {
            this.arrowRight();
            --n;
        }
    }

    void prefixRight(int n) {
        this.setPrefixPosition(this._prefixPosition + n);
    }

    void left() {
        this.left(1);
    }

    void left(int n) {
        if (!this._ignoreChanges) {
            this._desiredPixelPosition = -1;
            this._position -= n;
            if (this._position < 1) {
                this._position = 1;
            }
        }
    }

    void arrowLeft() {
        if (!this._ignoreChanges && this.element() != null) {
            ElementView elementView = this._element.elementView(this._view);
            this._desiredPixelPosition = -1;
            if (this._view.insertMode() && LpexUtilities.isBidi()) {
                boolean currRTL = elementView.isRightToLeft(this._position);
                boolean prevRTL = elementView.isRightToLeft(this._position - 1);
                boolean prevRTLContext = elementView.isRightToLeftContext(this._position - 1);
                if (currRTL != prevRTL) {
                    if (this._direction == 1 && currRTL) {
                        this.setDirection(0, prevRTLContext ? 1 : 0);
                        return;
                    }
                    if (this._direction == 0 && !currRTL) {
                        this.setDirection(1, 1);
                        return;
                    }
                } else {
                    boolean currRTLContext = elementView.isRightToLeftContext(this._position);
                    if (!currRTLContext && prevRTLContext && this._direction == 0 && LpexUtilities.getKeyboardLanguage() == 0) {
                        this.setDirection(this._direction, 1);
                        return;
                    }
                }
            }
            this._position = DisplayTextLayout.getClusterOffsetPrev(this._element.text(), this._position - 1) + 1;
            if (this._position < 1) {
                this._position = 1;
            }
            if (!this._view.insertMode() && LpexUtilities.isBidi()) {
                int newDirection = elementView.isRightToLeft(this._position) ? 1 : 0;
                int newLanguage = elementView.isRightToLeftContext(this._position) ? 1 : 0;
                this.setDirection(newDirection, newLanguage);
            }
        }
    }

    void arrowLeft(int n) {
        while (n > 0) {
            this.arrowLeft();
            --n;
        }
    }

    void prefixLeft(int n) {
        this.setPrefixPosition(this._prefixPosition - n);
    }

    void nextTabStop() {
        if (this._ignoreChanges) {
            return;
        }
        Element element = this.element();
        if (element == null) {
            return;
        }
        ElementView elementView = element.elementView(this._view);
        int displayPosition = this._view.displayColumn(elementView, this._position);
        TabsParameter.Settings tabs = TabsParameter.getParameter().currentValue(this._view);
        int tabStop = 1;
        if (tabs._tabStops != null) {
            int i = 0;
            while (tabStop <= displayPosition && i < tabs._tabStops.length) {
                tabStop = tabs._tabStops[i];
                ++i;
            }
        }
        if (tabStop <= displayPosition && tabs._tabIncrement > 0) {
            while (tabStop <= displayPosition) {
                tabStop += tabs._tabIncrement;
            }
        }
        if (tabStop > displayPosition) {
            this._position = this._view.positionFromDisplayPosition(elementView, tabStop);
            if (this._view.nls().isIgnoringBidiMarks()) {
                this._position = this.bidiMarksTextPosition(element.text(), this._position);
            }
            this._position = DisplayTextLayout.getClusterOffset(element.text(), this._position - 1) + 1;
            if (this._view.displayColumn(elementView, this._position) <= displayPosition) {
                this._position = DisplayTextLayout.getClusterOffsetNext(element.text(), this._position - 1) + 1;
            }
            this._desiredPixelPosition = -1;
        }
    }

    void prevTabStop() {
        int newTabStop;
        if (this._ignoreChanges) {
            return;
        }
        Element element = this.element();
        if (element == null) {
            return;
        }
        ElementView elementView = element.elementView(this._view);
        int displayPosition = this._view.displayColumn(elementView, this._position);
        TabsParameter.Settings tabs = TabsParameter.getParameter().currentValue(this._view);
        int prevTabStop = 1;
        int tabStop = 1;
        if (tabs._tabStops != null) {
            int i = 0;
            while (tabStop < displayPosition && i < tabs._tabStops.length) {
                prevTabStop = tabStop;
                tabStop = tabs._tabStops[i];
                ++i;
            }
        }
        if (tabStop < displayPosition && tabs._tabIncrement > 0) {
            while (tabStop < displayPosition) {
                prevTabStop = tabStop;
                tabStop += tabs._tabIncrement;
            }
        }
        int n = newTabStop = tabStop < displayPosition ? tabStop : prevTabStop;
        if (newTabStop < displayPosition) {
            this._position = this._view.positionFromDisplayPosition(elementView, newTabStop);
            if (this._view.nls().isIgnoringBidiMarks()) {
                this._position = this.bidiMarksTextPosition(element.text(), this._position);
            }
            this._position = DisplayTextLayout.getClusterOffset(element.text(), this._position - 1) + 1;
            this._desiredPixelPosition = -1;
        }
    }

    private int bidiMarksTextPosition(String text, int position) {
        int i = 0;
        while (i < position && i < text.length()) {
            if (LpexNls.isBidiMark(text.charAt(i))) {
                ++position;
            }
            ++i;
        }
        return position;
    }

    boolean nextWord() {
        if (!this._ignoreChanges && this.element() != null) {
            Element newElement = this._element;
            int newPosition = this._position;
            if (newElement.show() && (newElement = newElement.nextVisibleNonShow(this._view)) != null) {
                newPosition = 0;
            }
            while (newElement != null) {
                if ((newPosition = ElementList.nextWord(newElement, newPosition)) != 0) {
                    this.jump(newElement, newPosition);
                    return true;
                }
                newElement = newElement.nextVisibleNonShow(this._view);
                newPosition = 0;
            }
        }
        return false;
    }

    boolean nextWordEnd() {
        return this.nextWordEnd(0);
    }

    boolean nextWordEnd(int offset) {
        if (!this._ignoreChanges && this.element() != null) {
            Element newElement = this._element;
            int newPosition = this._position - offset;
            if (newElement.show() && (newElement = newElement.nextVisibleNonShow(this._view)) != null) {
                newPosition = 0;
            }
            while (newElement != null) {
                if ((newPosition = ElementList.nextWordEnd(newElement, newPosition)) != 0) {
                    this.jump(newElement, newPosition + offset);
                    return true;
                }
                newElement = newElement.nextVisibleNonShow(this._view);
                newPosition = 0;
            }
        }
        return false;
    }

    boolean prevWord() {
        if (!this._ignoreChanges && this.element() != null) {
            Element newElement = this._element;
            int newPosition = this._position;
            if (newElement.show() && (newElement = newElement.prevVisibleNonShow(this._view)) != null) {
                newPosition = newElement.end();
            }
            while (newElement != null) {
                if ((newPosition = ElementList.prevWord(newElement, newPosition)) != 0) {
                    this.jump(newElement, newPosition);
                    return true;
                }
                if ((newElement = newElement.prevVisibleNonShow(this._view)) == null) continue;
                newPosition = newElement.end();
            }
        }
        return false;
    }

    boolean prevWordEnd() {
        return this.prevWordEnd(0);
    }

    boolean prevWordEnd(int offset) {
        if (!this._ignoreChanges && this.element() != null) {
            Element newElement = this._element;
            int newPosition = this._position - offset;
            if (newElement.show() && (newElement = newElement.prevVisibleNonShow(this._view)) != null) {
                newPosition = newElement.end();
            }
            while (newElement != null) {
                if ((newPosition = ElementList.prevWordEnd(newElement, newPosition)) != 0) {
                    this.jump(newElement, newPosition + offset);
                    return true;
                }
                if ((newElement = newElement.prevVisibleNonShow(this._view)) == null) continue;
                newPosition = newElement.end();
            }
        }
        return false;
    }

    void positionPageLeft() {
        if (!this._ignoreChanges && this.element() != null) {
            int width = this._view.screen().textAreaWidth();
            this._view.screen().build();
            this._view.screen().setScroll(this._view.screen().scroll() - width);
            while (this._position > 1 && width > 0) {
                --this._position;
                width -= this._view.charWidth(this._element, this._position);
            }
            this._desiredPixelPosition = -1;
        }
    }

    void positionPageRight() {
        if (!this._ignoreChanges && this.element() != null) {
            int width = this._view.screen().textAreaWidth();
            this._view.screen().build();
            this._view.screen().setScroll(this._view.screen().scroll() + width);
            while (width > 0) {
                width -= this._view.charWidth(this._element, this._position);
                ++this._position;
            }
            this._desiredPixelPosition = -1;
        }
    }

    void goHome() {
        if (!this._ignoreChanges) {
            this._position = 1;
            this._desiredPixelPosition = -1;
        }
    }

    void home() {
        if (!this._ignoreChanges) {
            this._position = 1;
            if (this._view.insertMode()) {
                this.setDirection(0, 0);
            } else {
                this.setNewDirection();
            }
            this._desiredPixelPosition = -1;
        }
    }

    void prefixHome() {
        if (!this._ignoreChanges) {
            this._prefixPosition = 1;
            this._desiredPrefixPixelPosition = -1;
        }
    }

    void end() {
        if (!this._ignoreChanges) {
            this._position = this.element() != null ? this._element.end() : 1;
            this.setDirection(0, 0);
            this._desiredPixelPosition = -1;
        }
    }

    void prefixEnd() {
        if (!this._ignoreChanges) {
            this._prefixPosition = this.element() != null ? this._element.elementView(this._view).prefixEnd() : 1;
            this._desiredPrefixPixelPosition = -1;
        }
    }

    void scrollDown(int n) {
        Element topElement;
        int topElementNumber;
        if (this._ignoreChanges) {
            return;
        }
        Document document = this._view.document();
        int linesBeforeStart = document.linesBeforeStart();
        int targetLine = 1;
        if ((linesBeforeStart != 0 || document.linesAfterEnd() != 0) && (targetLine = (topElementNumber = linesBeforeStart + ((topElement = this._view.screen().element(1)) != null ? this._view.visibleElementOrdinalOf(topElement) : 1)) + n) > document.linesCount()) {
            targetLine = document.linesCount();
        }
        boolean sameEnvironment = this._view.verifyDocumentSectionDelta(n);
        Screen screen = this._view.screen();
        int rows = screen.rows();
        this.preserveDesiredPosition();
        if (!sameEnvironment) {
            Element targetElement = document.elementList().nonShowElementAt(targetLine - document.linesBeforeStart());
            if (targetElement == null) {
                targetElement = document.elementList().last();
            }
            this._element = targetElement;
            screen.setCursorRow(1);
            screen.build();
            screen.verticalScrollBar().forceUpdate();
        } else {
            int i = 0;
            while (i < n) {
                screen.build();
                int cursorRow = screen.cursorRow();
                if (cursorRow <= 1 || screen.element(rows) == null || screen.element(rows).nextVisible(this._view) == null) {
                    this.next(n - i);
                    break;
                }
                screen.setCursorRow(cursorRow - 1);
                ++i;
            }
        }
        this.adjustToDesiredPosition();
        this.setNewDirection();
    }

    void scrollScreenDown(int n) {
        Screen screen = this._view.screen();
        int rows = screen.rows();
        int i = 0;
        while (i < n) {
            screen.build();
            if (screen.element(rows) == null || screen.element(rows).nextVisible(this._view) == null) break;
            screen.setCursorRow(screen.cursorRow() - 1);
            ++i;
        }
    }

    void scrollUp(int n) {
        Element topElement;
        int topElementNumber;
        if (this._ignoreChanges) {
            return;
        }
        Document document = this._view.document();
        int linesBeforeStart = document.linesBeforeStart();
        int targetLine = 1;
        if ((linesBeforeStart != 0 || document.linesAfterEnd() != 0) && (targetLine = (topElementNumber = linesBeforeStart + ((topElement = this._view.screen().element(1)) != null ? this._view.visibleElementOrdinalOf(topElement) : 1)) - n) < 1) {
            targetLine = 1;
        }
        boolean sameEnvironment = this._view.verifyDocumentSectionDelta(-n);
        Screen screen = this._view.screen();
        int rows = screen.rows();
        this.preserveDesiredPosition();
        if (!sameEnvironment) {
            Element targetElement = document.elementList().nonShowElementAt(targetLine - document.linesBeforeStart());
            if (targetElement == null) {
                targetElement = document.elementList().first();
            }
            this._element = targetElement;
            screen.setCursorRow(1);
            screen.build();
            screen.verticalScrollBar().forceUpdate();
        } else {
            int i = 0;
            while (i < n) {
                screen.build();
                int cursorRow = screen.cursorRow();
                if (cursorRow >= rows || screen.element(1) == null || this._view.visibleElementOrdinalOf(screen.element(1)) <= 1) {
                    this.prev(n - i);
                    break;
                }
                screen.setCursorRow(cursorRow + 1);
                ++i;
            }
        }
        this.adjustToDesiredPosition();
        this.setNewDirection();
    }

    void scrollScreenUp(int n) {
        Screen screen = this._view.screen();
        int i = 0;
        while (i < n) {
            screen.build();
            if (screen.element(1) == null || this._view.visibleElementOrdinalOf(screen.element(1)) <= 1) break;
            screen.setCursorRow(screen.cursorRow() + 1);
            ++i;
        }
    }

    void scrollLeft(int n) {
        if (!this._ignoreChanges && this.element() != null) {
            this._view.screen().build();
            this._view.screen().setScroll(this._view.screen().scroll() - n);
            int newScroll = this._view.screen().scroll();
            int screenWidth = this._view.screen().textAreaWidth();
            ElementView elementView = this._element.elementView(this._view);
            while (this._position > 0 && elementView.pixelPosition(this._position) > newScroll + screenWidth - this._view.charWidth(this._element, this._position)) {
                --this._position;
            }
            this._desiredPixelPosition = -1;
        }
    }

    void scrollRight(int n) {
        if (!this._ignoreChanges && this.element() != null) {
            this._view.screen().build();
            this._view.screen().setScroll(this._view.screen().scroll() + n);
            int newScroll = this._view.screen().scroll();
            ElementView elementView = this._element.elementView(this._view);
            while (elementView.pixelPosition(this._position) < newScroll) {
                ++this._position;
            }
            this._desiredPixelPosition = -1;
        }
    }

    void windowBottom() {
        this._view.screen().build();
        int x = this._view.screen().rows() - this._view.screen().cursorRow();
        this.down(x);
    }

    void windowTop() {
        this._view.screen().build();
        int x = this._view.screen().cursorRow() - 1;
        this.up(x);
    }

    void windowMiddle() {
        this._view.screen().build();
        int x = this._view.screen().cursorRow() - (this._view.screen().rows() + 1) / 2;
        if (x < 0) {
            this.down(-x);
        } else {
            this.up(x);
        }
    }

    void jump(Element element, int position, boolean setNewDirection) {
        this.jump(element, position, setNewDirection, true);
    }

    void jump(Element element, int position, boolean setNewDirection, boolean isScroll) {
        if (!this._ignoreChanges && element != null) {
            boolean scrollUp;
            Element currentElement = this.element();
            this._position = position;
            if (this._position <= 0) {
                this._position = 1;
            }
            this._desiredPixelPosition = -1;
            if (element != currentElement) {
                this._prefixPosition = 1;
                this._desiredPrefixPixelPosition = -1;
            }
            int rows = this._view.screen().rows();
            Element top = this._view.screen().element(1);
            Element bottom = this._view.screen().element(rows);
            boolean scrollDown = top != null && top._ordinal > element._ordinal;
            boolean bl = scrollUp = bottom != null && bottom._ordinal < element._ordinal;
            if (scrollDown) {
                if (isScroll) {
                    this._view.screen().setCursorRow(rows / 3);
                }
            } else if (scrollUp) {
                if (isScroll) {
                    this._view.screen().setCursorRow(rows * 2 / 3);
                } else {
                    this._view.screen().setCursorRow(rows);
                }
            }
            this._jumpElement = this._element;
            this._element = element;
            if (setNewDirection && !this._view.document().visual()) {
                this.setNewDirection();
            }
        }
    }

    void jump(Element element, int position) {
        this.jump(element, position, true, true);
    }

    void jump(int position) {
        this.jump(this.element(), position);
    }

    void jump(LpexDocumentLocation documentLocation) {
        if (!this._ignoreChanges && documentLocation != null) {
            this.jump(this._view.document().elementList().elementAt(documentLocation.element), documentLocation.position);
        }
    }

    void resetJumpPending() {
        this._jumpElement = null;
    }

    void processPendingJump() {
        if (this._jumpElement != null) {
            Element element = this._element;
            this._element = this._jumpElement;
            this._jumpElement = null;
            Screen screen = this._view.screen();
            screen.build();
            int rows = screen.rows();
            int i = 1;
            while (i <= rows && screen.element(i) != element) {
                ++i;
            }
            if (i <= rows) {
                screen.setCursorRow(i);
            }
            this._element = element;
        }
    }

    void setPosition(int x, int y, boolean click) {
        if (this._view.insertMode()) {
            click = false;
        }
        if (this._ignoreChanges) {
            return;
        }
        Screen screen = this._view.screen();
        screen.build();
        int row = y / screen.textFontMetrics().textHeight() + 1;
        Element element = null;
        if (row < 1) {
            Element firstVisibleElement = screen.element(1);
            if (firstVisibleElement != null) {
                element = firstVisibleElement.prevVisible(this._view);
                row = 1;
            } else {
                return;
            }
        }
        if (row > screen.rows() && (element = screen.element(row = screen.rows())) != null) {
            element = element.nextVisible(this._view);
        }
        if (element == null && row >= 1) {
            element = screen.element(row);
        }
        while (element == null && row > 1) {
            element = screen.element(--row);
        }
        if (element == null) {
            return;
        }
        ElementView elementView = element.elementView(this._view);
        int expandHideAreaWidth = screen.expandHideAreaWidth();
        int prefixAreaWidth = screen.prefixAreaWidth();
        boolean setNewDirection = false;
        if (x > expandHideAreaWidth && x < expandHideAreaWidth + prefixAreaWidth) {
            this._view.setInPrefix(true);
            this._prefixPosition = this._view.prefixPosition(elementView, x - expandHideAreaWidth);
            this._desiredPrefixPixelPosition = -1;
            if (this.element() != element) {
                this._position = 1;
                this._desiredPixelPosition = -1;
            }
        } else {
            setNewDirection = !this._view.document().visual();
            this._view.setInPrefix(false);
            int screenWidth = this._view.screen().width();
            boolean xBelowScreen = false;
            if (x > screenWidth) {
                x = screenWidth;
            } else if (x < expandHideAreaWidth + prefixAreaWidth) {
                x = expandHideAreaWidth + prefixAreaWidth - 1;
                xBelowScreen = true;
            }
            int scr = screen.scroll();
            int value = scr + x - expandHideAreaWidth - prefixAreaWidth;
            int oldPosition = this._position;
            int n = this._position = click ? this._view.position(elementView, value) : this._view.positionAtMouse(elementView, value);
            if (xBelowScreen && oldPosition == this._position) {
                --this._position;
            }
            if (this._position < 1) {
                this._position = 1;
            }
            this._desiredPixelPosition = -1;
            if (element != this.element()) {
                this._prefixPosition = 1;
                this._desiredPrefixPixelPosition = -1;
            }
        }
        screen.setCursorRow(row);
        this._element = element;
        if (setNewDirection) {
            this.setNewDirection();
        }
    }

    boolean above(Element element, int position) {
        return this.compare(element, position) == 1;
    }

    boolean equals(Element element, int position) {
        return this.compare(element, position) == 0;
    }

    int compare(Element element, int position) {
        if (element == this._element) {
            if (position == this._position) {
                return 0;
            }
            return position > this._position ? 1 : -1;
        }
        ElementList elementList = this._view.document().elementList();
        return elementList.ordinalOf(element) > elementList.ordinalOf(this._element) ? 1 : -1;
    }

    private void preserveDesiredPosition() {
        if (!this._ignoreChanges && this.element() != null) {
            if (this._desiredPixelPosition < 0) {
                this._desiredPixelPosition = DisplayTextLayout.cursorPixelPosition(this._view);
            }
            if (this._desiredPrefixPixelPosition < 0) {
                this._desiredPrefixPixelPosition = this._view.prefixPixelPosition(this._element.elementView(this._view), this._prefixPosition);
            }
        }
    }

    private void adjustToDesiredPosition() {
        if (!this._ignoreChanges && this.element() != null) {
            if (this._desiredPixelPosition >= 0) {
                this._position = this._view.position(this._element.elementView(this._view), this._desiredPixelPosition);
            }
            if (this._desiredPrefixPixelPosition >= 0) {
                this._prefixPosition = this._view.prefixPosition(this._element.elementView(this._view), this._desiredPrefixPixelPosition);
            }
        }
    }

    void blockTop() {
        Block block;
        if (!this._ignoreChanges && (block = this._view.block()).type() != 0 && block.view() == this._view) {
            this.jump(block.topElement(), block.topPosition());
        }
    }

    void blockBottom() {
        Block block;
        if (!this._ignoreChanges && (block = this._view.block()).type() != 0 && block.view() == this._view) {
            this.jump(block.bottomElement(), block.bottomPosition());
        }
    }

    LpexDocumentLocation documentLocation() {
        return new LpexDocumentLocation(this._view.document().elementList().ordinalOf(this.element()), this.position());
    }

    void setEmphasisPosition(int emphasisPosition) {
        this._emphasisPosition = emphasisPosition;
        this._emphasisLength = 0;
    }

    int emphasisPosition() {
        return this._emphasisPosition;
    }

    void setEmphasisLength(int emphasisLength) {
        if (!this._ignoreChanges) {
            if (emphasisLength > 0) {
                this._emphasisLength = emphasisLength;
                this._emphasisElement = this.element();
                this._emphasisCursorPosition = this._position;
            } else {
                this._emphasisLength = 0;
                this._emphasisPosition = 0;
            }
        }
    }

    int emphasisLength() {
        if (this._emphasisLength > 0 && (this.element() != this._emphasisElement || this._emphasisPosition == 0 && this._position != this._emphasisCursorPosition)) {
            this._emphasisLength = 0;
            this._emphasisPosition = 0;
        }
        return this._emphasisLength;
    }

    Preserve preserve() {
        Preserve preserve;
        if (this._cachedPreserves != null) {
            preserve = this._cachedPreserves;
            this._cachedPreserves = preserve._next;
        } else {
            preserve = new Preserve();
        }
        preserve.init();
        preserve._next = this._topPreserve;
        this._topPreserve = preserve;
        return preserve;
    }

    void disposePreserve(Preserve preserve) {
        preserve.reset();
        Preserve prevPreserve = null;
        Preserve p = this._topPreserve;
        while (p != null) {
            if (p == preserve) {
                if (prevPreserve == null) {
                    this._topPreserve = preserve._next;
                } else {
                    prevPreserve._next = preserve._next;
                }
                preserve._next = this._cachedPreserves;
                this._cachedPreserves = preserve;
                break;
            }
            prevPreserve = p;
            p = p._next;
        }
    }

    void setIgnoreChanges(boolean ignoreChanges) {
        this._ignoreChanges = ignoreChanges;
    }

    void elementRemoved(Element element) {
        if (!this._ignoreChanges) {
            if (this._element == element) {
                this._element = element.next() != null ? element.next() : element.prev();
                this._position = 1;
                this.setDirection(0, 0);
                this._desiredPixelPosition = -1;
                this._prefixPosition = 1;
                this._desiredPrefixPixelPosition = -1;
            }
            if (this._emphasisElement == element) {
                this._emphasisLength = 0;
                this._emphasisElement = null;
                this._emphasisPosition = 0;
            }
            if (this._jumpElement == element) {
                this._jumpElement = element.next() != null ? element.next() : element.prev();
            }
            Preserve preserve = this._topPreserve;
            while (preserve != null) {
                preserve.elementRemoved(element);
                preserve = preserve._next;
            }
        }
    }

    void textInserted(Element element, int position, int len) {
        if (this._ignoreChanges) {
            return;
        }
        if (this._element == element && this._position >= position) {
            if (LpexUtilities.isBidi() && this._position == position && len == 1) {
                int language;
                this._direction = language = LpexUtilities.getKeyboardLanguage();
                if (language == 1 && Character.isDigit(this._element.text().charAt(this._position - 1))) {
                    this._direction = 0;
                }
            }
            this._position += len;
            this._desiredPixelPosition = -1;
        }
        Preserve preserve = this._topPreserve;
        while (preserve != null) {
            preserve.textInserted(element, position, len);
            preserve = preserve._next;
        }
    }

    void prefixTextInserted(Element element, int prefixPosition, int length) {
        if (!this._ignoreChanges) {
            if (this._element == element && this._prefixPosition >= prefixPosition) {
                this._prefixPosition += length;
                this._desiredPrefixPixelPosition = -1;
            }
            Preserve preserve = this._topPreserve;
            while (preserve != null) {
                preserve.prefixTextInserted(element, prefixPosition, length);
                preserve = preserve._next;
            }
        }
    }

    void textDeleted(Element element, int position, int length) {
        if (this._ignoreChanges) {
            return;
        }
        if (this._element == element && this._position > position) {
            this._position = this._position >= position + length ? (this._position -= length) : position;
            this._desiredPixelPosition = -1;
        }
        Preserve preserve = this._topPreserve;
        while (preserve != null) {
            preserve.textDeleted(element, position, length);
            preserve = preserve._next;
        }
    }

    void prefixTextDeleted(Element element, int prefixPosition, int length) {
        if (!this._ignoreChanges) {
            if (this._element == element && this._prefixPosition > prefixPosition) {
                this._prefixPosition = this._prefixPosition >= prefixPosition + length ? (this._prefixPosition -= length) : prefixPosition;
                this._desiredPrefixPixelPosition = -1;
            }
            Preserve preserve = this._topPreserve;
            while (preserve != null) {
                preserve.prefixTextDeleted(element, prefixPosition, length);
                preserve = preserve._next;
            }
        }
    }

    void splitElement(Element element, int position) {
        if (!this._ignoreChanges) {
            if (this._element == element && this._position >= position) {
                this._element = element.next();
                this._position = this._position - position + 1;
                this._prefixPosition = 1;
                this._desiredPixelPosition = -1;
                this._desiredPrefixPixelPosition = -1;
                this._view.screen().setCursorRow(this._view.screen().cursorRow() + 1);
            }
            Preserve preserve = this._topPreserve;
            while (preserve != null) {
                preserve.splitElement(element, position);
                preserve = preserve._next;
            }
        }
    }

    void joinElements(Element element1, Element element2) {
        if (!this._ignoreChanges) {
            if (this._element == element2) {
                this._element = element1;
                this._position = element1.length() + this._position;
                this._prefixPosition = 1;
                this._desiredPixelPosition = -1;
                this._desiredPrefixPixelPosition = -1;
            }
            Preserve preserve = this._topPreserve;
            while (preserve != null) {
                preserve.joinElements(element1, element2);
                preserve = preserve._next;
            }
        }
    }

    final class Preserve {
        Preserve _next;
        private Element _element;
        private int _position;
        private int _desiredPixelPosition;
        private int _emphasisPosition;
        private int _emphasisLength;
        private Element _emphasisElement;
        private int _emphasisCursorPosition;
        private int _prefixPosition;
        private int _desiredPrefixPixelPosition;
        private Element _jumpElement;
        private int _cursorRow;

        Preserve() {
        }

        void init() {
            this._element = DocumentPosition.this._element;
            this._position = DocumentPosition.this._position;
            this._desiredPixelPosition = DocumentPosition.this._desiredPixelPosition;
            this._emphasisPosition = DocumentPosition.this._emphasisPosition;
            this._emphasisLength = DocumentPosition.this._emphasisLength;
            this._emphasisElement = DocumentPosition.this._emphasisElement;
            this._emphasisCursorPosition = DocumentPosition.this._emphasisCursorPosition;
            this._prefixPosition = DocumentPosition.this._prefixPosition;
            this._desiredPrefixPixelPosition = DocumentPosition.this._desiredPrefixPixelPosition;
            this._jumpElement = DocumentPosition.this._jumpElement;
            this._cursorRow = DocumentPosition.this._view.screen().cursorRow();
        }

        void reset() {
            this._element = null;
            this._emphasisElement = null;
            this._jumpElement = null;
        }

        void restore() {
            DocumentPosition.this._element = this._element;
            DocumentPosition.this._position = this._position;
            DocumentPosition.this._desiredPixelPosition = this._desiredPixelPosition;
            DocumentPosition.this._emphasisPosition = this._emphasisPosition;
            DocumentPosition.this._emphasisLength = this._emphasisLength;
            DocumentPosition.this._emphasisElement = this._emphasisElement;
            DocumentPosition.this._emphasisCursorPosition = this._emphasisCursorPosition;
            DocumentPosition.this._prefixPosition = this._prefixPosition;
            DocumentPosition.this._desiredPrefixPixelPosition = this._desiredPrefixPixelPosition;
            DocumentPosition.this._view.screen().setCursorRow(this._cursorRow);
            DocumentPosition.this._jumpElement = this._jumpElement;
        }

        void elementRemoved(Element element) {
            if (this._element == element) {
                this._element = element.next() != null ? element.next() : element.prev();
                if (!element.show()) {
                    this._position = 1;
                    this._desiredPixelPosition = -1;
                }
                this._prefixPosition = 1;
                this._desiredPrefixPixelPosition = -1;
            }
            if (this._emphasisElement == element) {
                this._emphasisLength = 0;
                this._emphasisElement = null;
                this._emphasisPosition = 0;
            }
            if (this._jumpElement == element) {
                this._jumpElement = element.next() != null ? element.next() : element.prev();
            }
        }

        void textInserted(Element element, int position, int len) {
            if (this._element == element && this._position >= position) {
                this._position += len;
                this._desiredPixelPosition = -1;
            }
        }

        void prefixTextInserted(Element element, int prefixPosition, int len) {
            if (this._element == element && this._prefixPosition >= prefixPosition) {
                this._prefixPosition += len;
                this._desiredPrefixPixelPosition = -1;
            }
        }

        void textDeleted(Element element, int position, int len) {
            if (this._element == element && this._position > position) {
                this._position = this._position >= position + len ? (this._position -= len) : position;
                this._desiredPixelPosition = -1;
            }
        }

        void prefixTextDeleted(Element element, int prefixPosition, int len) {
            if (this._element == element && this._prefixPosition > prefixPosition) {
                this._prefixPosition = this._prefixPosition >= prefixPosition + len ? (this._prefixPosition -= len) : prefixPosition;
                this._desiredPrefixPixelPosition = -1;
            }
        }

        void splitElement(Element element, int position) {
            if (this._element == element && this._position >= position) {
                this._element = element.next();
                this._position = this._position - position + 1;
                this._desiredPixelPosition = -1;
                this._prefixPosition = 1;
                this._desiredPrefixPixelPosition = -1;
                ++this._cursorRow;
            }
        }

        void joinElements(Element element1, Element element2) {
            if (this._element == element2) {
                this._element = element1;
                this._position = element1.length() + this._position;
                this._desiredPixelPosition = -1;
                this._prefixPosition = 1;
                this._desiredPrefixPixelPosition = -1;
            }
        }
    }
}

