/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.List;
import com.ibm.lpex.core.ListNode;
import com.ibm.lpex.core.LpexDocumentListener;
import com.ibm.lpex.core.LpexView;

final class DocumentListenerList
extends List {
    private boolean _insertingText;
    private LpexView _lpexView;
    private int _line;

    DocumentListenerList(Document document) {
    }

    void addListener(LpexDocumentListener listener) {
        if (this.find(listener) == null) {
            this.addAfter(null, new ListenerNode(listener));
        }
    }

    void appendListener(LpexDocumentListener listener) {
        if (this.find(listener) == null) {
            this.append(new ListenerNode(listener));
        }
    }

    void removeListener(LpexDocumentListener listener) {
        ListenerNode node;
        if (listener != null && (node = this.find(listener)) != null) {
            this.remove(node);
        }
    }

    void setInsertingText(boolean insertingText) {
        if (insertingText) {
            if (!this._insertingText) {
                this._insertingText = true;
                this._lpexView = null;
            }
        } else if (this._insertingText) {
            this._insertingText = false;
            if (this._lpexView != null) {
                this.issueNotification(this._lpexView, 5, this._line, 0, 1);
            }
        }
    }

    void documentChanged(LpexView lpexView, int type, int line, int position, int count) {
        if (this._insertingText) {
            if (this._lpexView != null) {
                if (type == 2 && lpexView == this._lpexView && line == this._line) {
                    this.issueNotification(lpexView, 5, line, 0, 1);
                    this._lpexView = null;
                    return;
                }
                this.issueNotification(this._lpexView, 5, this._line, 0, 1);
                this._lpexView = null;
            }
            if (type == 5 && count == 1) {
                this._lpexView = lpexView;
                this._line = line;
                return;
            }
        }
        this.issueNotification(lpexView, type, line, position, count);
    }

    private void issueNotification(LpexView lpexView, int type, int line, int position, int count) {
        this.beginScanning();
        List.Node node = this.first();
        while (node != null) {
            if (!node.removePending()) {
                ((ListenerNode)node).listener().documentChanged(lpexView, type, line, position, count);
            }
            node = node.next();
        }
        this.endScanning();
    }

    ListenerNode find(LpexDocumentListener listener) {
        ListenerNode node = (ListenerNode)this.first();
        while (node != null) {
            if (node.listener() == listener) {
                return node;
            }
            node = (ListenerNode)node.next();
        }
        return null;
    }

    boolean empty() {
        return this.first() == null;
    }

    private static class ListenerNode
    extends ListNode {
        private LpexDocumentListener _listener;

        ListenerNode(LpexDocumentListener listener) {
            this._listener = listener;
        }

        LpexDocumentListener listener() {
            return this._listener;
        }
    }
}

