/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Block;
import com.ibm.lpex.core.DisplayStyle;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementView;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.Screen;
import com.ibm.lpex.core.TextFontMetrics;
import com.ibm.lpex.core.View;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;

final class DisplayTextLayout {
    private TextLayout _textLayout;
    private ElementView _elementView;
    private String _text;
    private static final boolean TRAILING_EDGE = true;
    private static final boolean LEADING_EDGE = false;
    private static final int[] NO_SEGMENTS = new int[2];

    DisplayTextLayout(ElementView elementView) {
        this._elementView = elementView;
    }

    void dispose() {
        this.disposeTextLayout();
        this._elementView = null;
    }

    private void disposeTextLayout() {
        if (this._textLayout != null) {
            this._textLayout.dispose();
            this._textLayout = null;
        }
    }

    int getClusterOffsetNext(int offset) {
        if (this._text == null) {
            this._text = this._elementView.element().text();
        }
        if (offset >= 0 && offset < this._text.length()) {
            if (this._textLayout == null) {
                this._textLayout = DisplayTextLayout.getTextLayout(this._text);
            }
            if (this._textLayout != null) {
                offset = this._textLayout.getNextOffset(offset, 2);
                return offset;
            }
        }
        return offset + 1;
    }

    static int getClusterOffsetNext(String text, int offset) {
        TextLayout textLayout;
        if (offset >= 0 && offset < text.length() && (textLayout = DisplayTextLayout.getTextLayout(text)) != null) {
            offset = textLayout.getNextOffset(offset, 2);
            textLayout.dispose();
            return offset;
        }
        return offset + 1;
    }

    int getClusterOffsetPrev(int offset) {
        if (this._text == null) {
            this._text = this._elementView.element().text();
        }
        if (offset >= 0 && offset <= this._text.length()) {
            if (this._textLayout == null) {
                this._textLayout = DisplayTextLayout.getTextLayout(this._text);
            }
            if (this._textLayout != null) {
                offset = this._textLayout.getPreviousOffset(offset, 2);
                return offset;
            }
        }
        return offset - 1;
    }

    static int getClusterOffsetPrev(String text, int offset) {
        TextLayout textLayout;
        if (offset >= 0 && offset <= text.length() && (textLayout = DisplayTextLayout.getTextLayout(text)) != null) {
            offset = textLayout.getPreviousOffset(offset, 2);
            textLayout.dispose();
            return offset;
        }
        return offset - 1;
    }

    static int getClusterOffset(String text, int offset) {
        TextLayout textLayout;
        int txtlen;
        int n = txtlen = text == null ? 0 : text.length();
        if (offset > 0 && offset < txtlen && (textLayout = DisplayTextLayout.getTextLayout(text)) != null) {
            offset = textLayout.getNextOffset(offset, 2);
            offset = textLayout.getPreviousOffset(offset, 2);
            textLayout.dispose();
        }
        return offset;
    }

    static int width(ElementView elementView) {
        TextLayout textLayout = DisplayTextLayout.getTextLayout(elementView);
        if (textLayout == null) {
            return 0;
        }
        textLayout.setFont(elementView.view().screen().currentFont().getFont());
        int width = textLayout.getBounds().width;
        textLayout.dispose();
        return width;
    }

    static int charWidth(ElementView elementView, int logicalDisplayPosition) {
        if (--logicalDisplayPosition < 0) {
            return 0;
        }
        TextLayout textLayout = DisplayTextLayout.getTextLayout(elementView);
        if (textLayout == null) {
            return 0;
        }
        textLayout.setFont(elementView.view().screen().currentFont().getFont());
        int loc1 = textLayout.getLocation((int)logicalDisplayPosition, (boolean)false).x;
        int loc2 = textLayout.getLocation((int)logicalDisplayPosition, (boolean)true).x;
        textLayout.dispose();
        return Math.abs(loc2 - loc1);
    }

    static int[] charBlockSegments(ElementView elementView) {
        boolean innerElement;
        Element element = elementView.element();
        View view = elementView.view();
        Block block = view.block();
        Element topElement = block.topElement();
        Element bottomElement = block.bottomElement();
        int topPosition = block.topPosition();
        int bottomPosition = block.bottomPosition();
        if (block.type() == 1) {
            --bottomPosition;
        }
        int len = elementView.displayText().length();
        boolean bl = innerElement = element != topElement && element != bottomElement;
        if (innerElement && len == 0) {
            return NO_SEGMENTS;
        }
        int textOffset = view.displayPosition(elementView, 1, true) - 1;
        int startOffset = view.displayPosition(elementView, topPosition, true) - 1;
        int endOffset = view.displayPosition(elementView, bottomPosition, true);
        if (innerElement) {
            startOffset = textOffset;
            endOffset = len;
        } else if (element == topElement) {
            if (element != bottomElement) {
                endOffset = len;
            }
        } else if (element != topElement) {
            startOffset = textOffset;
        }
        TextLayout textLayout = DisplayTextLayout.getTextLayout(elementView);
        if (textLayout == null) {
            return NO_SEGMENTS;
        }
        textLayout.setFont(view.screen().currentFont().getFont());
        if (innerElement) {
            int width = textLayout.getBounds().width;
            textLayout.dispose();
            int[] nArray = new int[2];
            nArray[1] = width;
            return nArray;
        }
        if (startOffset >= len) {
            int width = textLayout.getBounds().width;
            int spaceWidth = view.screen().textFontMetrics().spaceWidth();
            int blockStartPosition = width + spaceWidth * (startOffset - len);
            int blockEndPosition = element == bottomElement ? width + spaceWidth * (endOffset - len) : blockStartPosition;
            textLayout.dispose();
            return new int[]{blockStartPosition, blockEndPosition};
        }
        if (endOffset == textOffset) {
            textLayout.dispose();
            return NO_SEGMENTS;
        }
        if (endOffset <= len && textLayout.getLevel(startOffset) == 0 && textLayout.getLevel(endOffset - 1) == 0) {
            Rectangle r = textLayout.getBounds(startOffset, endOffset - 1);
            textLayout.dispose();
            return new int[]{r.x, r.x + r.width};
        }
        int[] levels = new int[len];
        int i = 0;
        while (i < len) {
            levels[i] = textLayout.getLevel(i);
            ++i;
        }
        int[] visualChars = new int[len];
        int i2 = 0;
        while (i2 < len) {
            visualChars[i2] = i2 < startOffset || i2 >= endOffset ? -1 : i2;
            ++i2;
        }
        DisplayTextLayout.reorderToVisual(visualChars, levels);
        int[] segments = new int[10];
        int count = 0;
        boolean searchingForStart = true;
        int iV = 0;
        while (iV < len) {
            if (searchingForStart) {
                if (visualChars[iV] != -1) {
                    int currLogicalOffset = visualChars[iV];
                    edge = (levels[currLogicalOffset] & 1) != 0;
                    segments[count++] = textLayout.getLocation((int)currLogicalOffset, (boolean)edge).x;
                    searchingForStart = false;
                }
            } else if (visualChars[iV] == -1) {
                int prevLogicalOffset = visualChars[iV - 1];
                edge = (levels[prevLogicalOffset] & 1) == 0;
                segments[count++] = textLayout.getLocation((int)prevLogicalOffset, (boolean)edge).x;
                searchingForStart = true;
            }
            ++iV;
        }
        if (!searchingForStart) {
            int end = textLayout.getBounds().width;
            if (endOffset > len) {
                end += view.screen().textFontMetrics().spaceWidth() * (endOffset - len);
            }
            segments[count++] = end;
        }
        textLayout.dispose();
        if (count == segments.length) {
            return segments;
        }
        int[] result = new int[count];
        System.arraycopy(segments, 0, result, 0, count);
        return result;
    }

    static int[] emphasisSegments(ElementView elementView) {
        View view = elementView.view();
        int emphasisLength = view.documentPosition().emphasisLength();
        if (emphasisLength == 0) {
            return NO_SEGMENTS;
        }
        int emphasisPosition = view.documentPosition().emphasisPosition();
        if (emphasisPosition == 0) {
            emphasisPosition = view.documentPosition().position();
        }
        int startOffset = view.displayPosition(elementView, emphasisPosition, true) - 1;
        int endOffset = view.displayPosition(elementView, emphasisPosition + emphasisLength, true) - 1;
        endOffset = Math.min(endOffset, elementView.element().length());
        TextLayout textLayout = DisplayTextLayout.getTextLayout(elementView);
        if (textLayout == null) {
            return NO_SEGMENTS;
        }
        textLayout.setFont(view.screen().currentFont().getFont());
        int len = elementView.displayText().length();
        if (startOffset >= len) {
            int width = textLayout.getBounds().width;
            int spaceWidth = view.screen().textFontMetrics().spaceWidth();
            int emphasisStartPosition = width + spaceWidth * (startOffset - len);
            int emphasisEndPosition = width + spaceWidth * (endOffset - len);
            textLayout.dispose();
            return new int[]{emphasisStartPosition, emphasisEndPosition};
        }
        if (textLayout.getLevel(startOffset) == 0 && textLayout.getLevel(endOffset - 1) == 0) {
            Rectangle r = textLayout.getBounds(startOffset, endOffset - 1);
            textLayout.dispose();
            return new int[]{r.x, r.x + r.width};
        }
        int[] levels = new int[len];
        int i = 0;
        while (i < len) {
            levels[i] = textLayout.getLevel(i);
            ++i;
        }
        int[] visualChars = new int[len];
        int i2 = 0;
        while (i2 < len) {
            visualChars[i2] = i2 < startOffset || i2 >= endOffset ? -1 : i2;
            ++i2;
        }
        DisplayTextLayout.reorderToVisual(visualChars, levels);
        int[] segments = new int[10];
        int count = 0;
        boolean searchingForStart = true;
        int iV = 0;
        while (iV < len) {
            if (searchingForStart) {
                if (visualChars[iV] != -1) {
                    int currLogicalOffset = visualChars[iV];
                    edge = (levels[currLogicalOffset] & 1) != 0;
                    segments[count++] = textLayout.getLocation((int)currLogicalOffset, (boolean)edge).x;
                    searchingForStart = false;
                }
            } else if (visualChars[iV] == -1) {
                int prevLogicalOffset = visualChars[iV - 1];
                edge = (levels[prevLogicalOffset] & 1) == 0;
                segments[count++] = textLayout.getLocation((int)prevLogicalOffset, (boolean)edge).x;
                searchingForStart = true;
            }
            ++iV;
        }
        if (!searchingForStart) {
            int end = textLayout.getBounds().width;
            if (endOffset > len) {
                end += view.screen().textFontMetrics().spaceWidth() * (endOffset - len);
            }
            segments[count++] = end;
        }
        textLayout.dispose();
        if (count == segments.length) {
            return segments;
        }
        int[] result = new int[count];
        System.arraycopy(segments, 0, result, 0, count);
        return result;
    }

    private static void reorderToVisual(int[] line, int[] levels) {
        int startSegment = 0;
        int endSegment = line.length;
        int highestLevel = 0;
        int lowestOddLevel = 63;
        int i = startSegment;
        while (i < endSegment) {
            int level = levels[i];
            if (level > highestLevel) {
                highestLevel = level;
            }
            if ((level & 1) != 0 && level < lowestOddLevel) {
                lowestOddLevel = level;
            }
            ++i;
        }
        int level = highestLevel;
        while (level >= lowestOddLevel) {
            int i2 = startSegment;
            while (i2 < endSegment) {
                if (levels[i2] >= level) {
                    int start = i2;
                    int end = start + 1;
                    while (end < endSegment && levels[end] >= level) {
                        ++end;
                    }
                    i2 = end;
                    int j = end - 1;
                    while (start < j) {
                        int tmp = line[start];
                        line[start] = line[j];
                        line[j] = tmp;
                        ++start;
                        --j;
                    }
                }
                ++i2;
            }
            --level;
        }
    }

    static int logicalTextLength(ElementView elementView, int startPixelPosition, int endPixelPosition) {
        if (startPixelPosition < 0 || endPixelPosition <= 0) {
            return 0;
        }
        TextLayout textLayout = DisplayTextLayout.getTextLayout(elementView);
        if (textLayout == null) {
            return 0;
        }
        Screen screen = elementView.view().screen();
        textLayout.setFont(screen.currentFont().getFont());
        int width = textLayout.getBounds().width;
        int spacePixels = 0;
        if (endPixelPosition > width) {
            spacePixels = startPixelPosition >= width ? endPixelPosition - startPixelPosition : endPixelPosition - width;
            endPixelPosition = width;
        }
        int len = 0;
        if (startPixelPosition < width) {
            String displayText = elementView.displayText();
            int i = 0;
            while (i < displayText.length()) {
                int leading = textLayout.getLocation((int)i, (boolean)false).x;
                if (leading > startPixelPosition && leading < endPixelPosition) {
                    ++len;
                } else {
                    int trailing = textLayout.getLocation((int)i, (boolean)true).x;
                    if (trailing > startPixelPosition && trailing < endPixelPosition) {
                        ++len;
                    }
                }
                ++i;
            }
        }
        if (spacePixels > 0) {
            len += spacePixels / screen.textFontMetrics().spaceWidth();
        }
        textLayout.dispose();
        return len;
    }

    static void logicalText(ElementView elementView, int startPixelPosition, int endPixelPosition, StringBuilder textBuffer) {
        if (startPixelPosition < 0 || endPixelPosition <= 0) {
            return;
        }
        TextLayout textLayout = DisplayTextLayout.getTextLayout(elementView);
        if (textLayout == null) {
            return;
        }
        Screen screen = elementView.view().screen();
        textLayout.setFont(screen.currentFont().getFont());
        int width = textLayout.getBounds().width;
        int spacePixels = 0;
        if (endPixelPosition > width) {
            spacePixels = startPixelPosition >= width ? endPixelPosition - startPixelPosition : endPixelPosition - width;
            endPixelPosition = width;
        }
        if (startPixelPosition < width) {
            String displayText = elementView.displayText();
            int i = 0;
            while (i < displayText.length()) {
                int leading = textLayout.getLocation((int)i, (boolean)false).x;
                if (leading > startPixelPosition && leading < endPixelPosition) {
                    textBuffer.append(displayText.charAt(i));
                } else {
                    int trailing = textLayout.getLocation((int)i, (boolean)true).x;
                    if (trailing > startPixelPosition && trailing < endPixelPosition) {
                        textBuffer.append(displayText.charAt(i));
                    }
                }
                ++i;
            }
        }
        if (spacePixels > 0) {
            int spaces = spacePixels / screen.textFontMetrics().spaceWidth();
            while (spaces > 0) {
                textBuffer.append(' ');
                --spaces;
            }
        }
        textLayout.dispose();
    }

    static void logicalText(ElementView elementView, int startPixelPosition, int endPixelPosition, StringBuilder textBuffer, StringBuilder fgStyleBuffer, StringBuilder bgStyleBuffer) {
        if (startPixelPosition < 0 || endPixelPosition <= 0) {
            return;
        }
        TextLayout textLayout = DisplayTextLayout.getTextLayout(elementView);
        if (textLayout == null) {
            return;
        }
        Screen screen = elementView.view().screen();
        textLayout.setFont(screen.currentFont().getFont());
        int width = textLayout.getBounds().width;
        int spacePixels = 0;
        if (endPixelPosition > width) {
            spacePixels = startPixelPosition >= width ? endPixelPosition - startPixelPosition : endPixelPosition - width;
            endPixelPosition = width;
        }
        DisplayStyle displayStyle = elementView.displayStyle();
        String fgStyle = displayStyle.foreground();
        String bgStyle = displayStyle.background();
        int bgStyleLength = bgStyle == null ? 0 : bgStyle.length();
        String displayText = elementView.displayText();
        if (startPixelPosition < width) {
            int i = 0;
            while (i < displayText.length()) {
                int leading = textLayout.getLocation((int)i, (boolean)false).x;
                if (leading > startPixelPosition && leading < endPixelPosition) {
                    textBuffer.append(displayText.charAt(i));
                    if (i < fgStyle.length()) {
                        fgStyleBuffer.append(fgStyle.charAt(i));
                    }
                    if (i < bgStyleLength) {
                        bgStyleBuffer.append(bgStyle.charAt(i));
                    }
                } else {
                    int trailing = textLayout.getLocation((int)i, (boolean)true).x;
                    if (trailing > startPixelPosition && trailing < endPixelPosition) {
                        textBuffer.append(displayText.charAt(i));
                        if (i < fgStyle.length()) {
                            fgStyleBuffer.append(fgStyle.charAt(i));
                        }
                        if (i < bgStyleLength) {
                            bgStyleBuffer.append(bgStyle.charAt(i));
                        }
                    }
                }
                ++i;
            }
        }
        if (spacePixels > 0) {
            int spaces = spacePixels / screen.textFontMetrics().spaceWidth();
            int i = displayText.length();
            while (spaces > 0) {
                textBuffer.append(' ');
                if (i < fgStyle.length()) {
                    fgStyleBuffer.append(fgStyle.charAt(i));
                }
                if (i < bgStyleLength) {
                    bgStyleBuffer.append(bgStyle.charAt(i));
                }
                --spaces;
                ++i;
            }
        }
        textLayout.dispose();
    }

    static int displayPosition(ElementView elementView, int pixelPosition) {
        TextLayout textLayout = DisplayTextLayout.getTextLayout(elementView);
        if (textLayout == null) {
            return 0;
        }
        textLayout.setFont(elementView.view().screen().currentFont().getFont());
        int[] trailing = new int[1];
        int displayOffset = textLayout.getOffset(pixelPosition, 0, trailing);
        if (trailing[0] != 0) {
            displayOffset += trailing[0];
        }
        textLayout.dispose();
        return displayOffset + 1;
    }

    static int textPosition(ElementView elementView, int pixelPosition) {
        int textPosition;
        View view = elementView.view();
        TextFontMetrics textFontMetrics = view.screen().textFontMetrics();
        if (textFontMetrics == null) {
            return 1;
        }
        int spaceWidth = textFontMetrics.spaceWidth();
        if (spaceWidth <= 0) {
            return 1;
        }
        String displayText = elementView.displayText();
        if (displayText.length() == 0) {
            return pixelPosition / spaceWidth + 1;
        }
        TextLayout textLayout = DisplayTextLayout.getTextLayout(elementView);
        if (textLayout == null) {
            return 1;
        }
        textLayout.setFont(view.screen().currentFont().getFont());
        int width = textLayout.getBounds().width;
        if (pixelPosition > width) {
            textPosition = elementView.element().length() + (pixelPosition - width) / spaceWidth + 1;
        } else {
            int[] trailing = new int[1];
            int displayOffset = textLayout.getOffset(pixelPosition, 0, trailing);
            if (trailing[0] != 0) {
                displayOffset += trailing[0];
            }
            textPosition = view.positionFromDisplayPosition(elementView, displayOffset + 1);
        }
        textLayout.dispose();
        return textPosition;
    }

    static int pixelPosition(ElementView elementView, int displayPosition) {
        if (--displayPosition < 0) {
            return 0;
        }
        TextLayout textLayout = DisplayTextLayout.getTextLayout(elementView);
        if (textLayout == null) {
            return 0;
        }
        textLayout.setFont(elementView.view().screen().currentFont().getFont());
        int pixelPosition = 0;
        String text = elementView.displayText();
        if (text.length() > displayPosition) {
            boolean leftEdge = DisplayTextLayout.isRTLCharacter(textLayout, displayPosition);
            pixelPosition = textLayout.getLocation((int)displayPosition, (boolean)leftEdge).x;
        } else {
            TextFontMetrics textFontMetrics = elementView.view().screen().textFontMetrics();
            pixelPosition = textLayout.getBounds().width + textFontMetrics.spaceWidth() * (displayPosition - text.length());
        }
        textLayout.dispose();
        return pixelPosition;
    }

    static int cursorPixelDrawPosition(View view) {
        return DisplayTextLayout.cursorPixelPosition(view, view.documentPosition().element(), view.documentPosition().position(), view.insertMode(), true);
    }

    static int cursorPixelPosition(View view) {
        return DisplayTextLayout.cursorPixelPosition(view, view.documentPosition().element(), view.documentPosition().position(), view.insertMode(), false);
    }

    static int cursorPixelPosition(View view, Element element, int textPosition, boolean insertMode, boolean adjustForDraw) {
        int cursorPixelPosition;
        if (element == null || textPosition <= 0) {
            return 0;
        }
        if (!LpexUtilities.isBidi()) {
            return view.cursorPixelPosition(element, textPosition, insertMode);
        }
        TextFontMetrics textFontMetrics = view.screen().textFontMetrics();
        if (textFontMetrics == null) {
            return 0;
        }
        ElementView elementView = element.elementView(view);
        String displayText = elementView.displayText();
        if (displayText.length() == 0) {
            return textFontMetrics.spaceWidth() * (textPosition - 1);
        }
        TextLayout textLayout = DisplayTextLayout.getTextLayout(elementView);
        if (textLayout == null) {
            return 0;
        }
        textLayout.setFont(view.screen().currentFont().getFont());
        int displayPosition = view.displayPosition(elementView, textPosition, true);
        if (displayPosition > displayText.length() + 1) {
            int cursorPixelPosition2 = textLayout.getBounds().width + textFontMetrics.spaceWidth() * (displayPosition - 1 - displayText.length());
            textLayout.dispose();
            return cursorPixelPosition2;
        }
        int cursorDirection = view.documentPosition().direction();
        boolean currRTL = DisplayTextLayout.isRTLCharacter(textLayout, displayPosition);
        boolean prevRTL = DisplayTextLayout.isRTLCharacter(textLayout, displayPosition - 1);
        boolean insertCursor = insertMode && !view.vi() || view.block().view() == view && view.block().type() == 1 && view.block().anythingSelected();
        int currOffset = displayPosition - 1;
        int prevOffset = currOffset - 1;
        if (!insertCursor) {
            cursorPixelPosition = currRTL ? textLayout.getLocation((int)currOffset, (boolean)true).x : textLayout.getLocation((int)currOffset, (boolean)false).x;
        } else if (currRTL != prevRTL) {
            if (cursorDirection == 0) {
                cursorPixelPosition = currRTL ? (currOffset == 0 ? 0 : textLayout.getLocation((int)prevOffset, (boolean)true).x) : textLayout.getLocation((int)currOffset, (boolean)false).x;
            } else if (currRTL) {
                cursorPixelPosition = textLayout.getLocation((int)currOffset, (boolean)false).x;
                if (adjustForDraw) {
                    cursorPixelPosition -= view.cursorWidth();
                }
            } else {
                cursorPixelPosition = textLayout.getLocation((int)prevOffset, (boolean)true).x;
                if (adjustForDraw) {
                    cursorPixelPosition -= view.cursorWidth();
                }
            }
        } else {
            boolean currRTLcontext = DisplayTextLayout.isRTLContext(textLayout, displayPosition);
            boolean prevRTLcontext = DisplayTextLayout.isRTLContext(textLayout, displayPosition - 1);
            if (prevRTLcontext && !currRTLcontext && cursorDirection == 0 && LpexUtilities.getKeyboardLanguage() == 1) {
                cursorPixelPosition = textLayout.getLocation((int)prevOffset, (boolean)true).x;
            } else if (currRTL) {
                cursorPixelPosition = textLayout.getLocation((int)currOffset, (boolean)false).x;
                if (adjustForDraw) {
                    cursorPixelPosition -= view.cursorWidth();
                }
            } else {
                cursorPixelPosition = textLayout.getLocation((int)currOffset, (boolean)false).x;
            }
        }
        textLayout.dispose();
        if (cursorPixelPosition < 0) {
            cursorPixelPosition = 0;
        }
        return cursorPixelPosition;
    }

    private static boolean isRTLCharacter(TextLayout textLayout, int position) {
        if (position < 1 || position > textLayout.getText().length()) {
            return false;
        }
        return (textLayout.getLevel(--position) & 1) != 0;
    }

    static boolean isRTLCharacter(ElementView elementView, int displayPosition) {
        TextLayout textLayout = DisplayTextLayout.getTextLayout(elementView);
        if (textLayout == null) {
            return false;
        }
        boolean rc = DisplayTextLayout.isRTLCharacter(textLayout, displayPosition);
        textLayout.dispose();
        return rc;
    }

    private static boolean isRTLContext(TextLayout textLayout, int displayPosition) {
        int level;
        if (displayPosition < 1 || displayPosition > textLayout.getText().length()) {
            return false;
        }
        return (level = textLayout.getLevel(--displayPosition)) == 1 || level == 2;
    }

    static boolean isRTLContext(ElementView elementView, int displayPosition) {
        TextLayout textLayout = DisplayTextLayout.getTextLayout(elementView);
        if (textLayout == null) {
            return false;
        }
        boolean rc = DisplayTextLayout.isRTLContext(textLayout, displayPosition);
        textLayout.dispose();
        return rc;
    }

    private static TextLayout getTextLayout(String text) {
        Display display = Display.getCurrent();
        if (display != null) {
            TextLayout textLayout = new TextLayout((Device)display);
            textLayout.setText(text);
            return textLayout;
        }
        return null;
    }

    private static TextLayout getTextLayout(ElementView elementView) {
        Display display = Display.getCurrent();
        if (display != null) {
            TextLayout textLayout = new TextLayout((Device)display);
            textLayout.setText(elementView.displayText());
            int[] segments = DisplayTextLayout.getSegments(elementView);
            if (segments != null) {
                textLayout.setSegments(segments);
            }
            return textLayout;
        }
        return null;
    }

    static int[] getSegments(ElementView elementView) {
        int textLen = elementView.displayText().length();
        if (textLen == 0) {
            return null;
        }
        String style = elementView.displayStyle().foreground();
        int styleLen = style.length();
        if (styleLen == 0) {
            int[] nArray = new int[2];
            nArray[1] = textLen;
            return nArray;
        }
        int[] offsets = new int[textLen + 1];
        offsets[0] = 0;
        int count = 1;
        char tokenStyle = style.charAt(0);
        int i = 1;
        while (i < textLen) {
            char c;
            char c2 = c = i < styleLen ? (char)style.charAt(i) : (char)'!';
            if (c != tokenStyle) {
                offsets[count++] = i;
                tokenStyle = c;
            }
            ++i;
        }
        offsets[count++] = textLen;
        if (count == offsets.length) {
            return offsets;
        }
        int[] segments = new int[count];
        System.arraycopy(offsets, 0, segments, 0, count);
        return segments;
    }

    public String toString() {
        return this._textLayout == null ? "DisplayTextLayout { " + this._elementView.displayText() + " }" : this._textLayout.toString();
    }

    static String clusters(String text) {
        TextLayout textLayout;
        if (text != null && (textLayout = DisplayTextLayout.getTextLayout(text)) != null) {
            StringBuilder sb = new StringBuilder(text.length());
            sb.append('1');
            int i = 0;
            while (i < text.length()) {
                i = textLayout.getNextOffset(i, 2);
                sb.append(' ').append(i + 1);
            }
            textLayout.dispose();
            return sb.toString();
        }
        return "";
    }

    static String levels(ElementView elementView) {
        TextLayout textLayout;
        if (elementView != null && (textLayout = DisplayTextLayout.getTextLayout(elementView)) != null) {
            int len = textLayout.getText().length();
            StringBuilder sb = new StringBuilder(len);
            int i = 0;
            while (i < len) {
                sb.append(textLayout.getLevel(i));
                ++i;
            }
            textLayout.dispose();
            return sb.toString();
        }
        return "";
    }
}

