/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.ElementView;
import com.ibm.lpex.core.LpexCommonParser;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexParser;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.MarkList;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.ParameterIntegerDefault;
import com.ibm.lpex.core.ParameterOnOffDefault;
import com.ibm.lpex.core.Parameters;
import com.ibm.lpex.core.SequenceNumbersParameter;
import com.ibm.lpex.core.TableNode;
import com.ibm.lpex.core.View;
import java.io.File;
import java.io.IOException;

final class CompareCommand {
    static final int COLOR_UNIQUE = 4;
    static final int COLOR_A_BACKGROUND = 5;
    static final int COLOR_B_BACKGROUND = 6;
    static final int COLOR_MATCHED_BACKGROUND = 7;
    private static final int COLUMNS = 0;
    private static final int END_COLUMN = 1;
    private static final int IGNOREALLBLANKS = 2;
    private static final int IGNORECASE = 3;
    private static final int IGNORECOMMENTS = 4;
    private static final int IGNORELEADINGBLANKS = 5;
    private static final int IGNORESEQUENCENUMBERS = 6;
    private static final int IGNORETRAILINGBLANKS = 7;
    private static final int START_COLUMN = 8;
    private static TableNode[] _parameters = new TableNode[]{new TableNode("columns", 0), new TableNode("endColumn", 1), new TableNode("ignoreAllBlanks", 2), new TableNode("ignoreCase", 3), new TableNode("ignoreComments", 4), new TableNode("ignoreLeadingBlanks", 5), new TableNode("ignoreSequenceNumbers", 6), new TableNode("ignoreTrailingBlanks", 7), new TableNode("startColumn", 8)};
    private static ColumnsParameter _columnsParameter;
    private static EndColumnParameter _endColumnParameter;
    private static IgnoreAllBlanksParameter _ignoreAllBlanksParameter;
    private static IgnoreCaseParameter _ignoreCaseParameter;
    private static IgnoreCommentsParameter _ignoreCommentsParameter;
    private static IgnoreLeadingBlanksParameter _ignoreLeadingBlanksParameter;
    private static IgnoreSequenceNumbersParameter _ignoreSequenceNumbersParameter;
    private static IgnoreTrailingBlanksParameter _ignoreTrailingBlanksParameter;
    private static StartColumnParameter _startColumnParameter;

    static {
        TableNode.sort(_parameters);
    }

    CompareCommand() {
    }

    static Parameter getParameter(String parameter) {
        TableNode p = TableNode.binarySearch(_parameters, Parameters.getParameterString(parameter));
        if (p != null) {
            switch (p.id()) {
                case 0: {
                    return CompareCommand.columnsParameter();
                }
                case 1: {
                    return CompareCommand.endColumnParameter();
                }
                case 2: {
                    return CompareCommand.ignoreAllBlanksParameter();
                }
                case 3: {
                    return CompareCommand.ignoreCaseParameter();
                }
                case 4: {
                    return CompareCommand.ignoreCommentsParameter();
                }
                case 5: {
                    return CompareCommand.ignoreLeadingBlanksParameter();
                }
                case 6: {
                    return CompareCommand.ignoreSequenceNumbersParameter();
                }
                case 7: {
                    return CompareCommand.ignoreTrailingBlanksParameter();
                }
                case 8: {
                    return CompareCommand.startColumnParameter();
                }
            }
        }
        return null;
    }

    static boolean doCommand(View view, String parameters) {
        String docName;
        boolean fileNameParameter;
        boolean promptParameter = false;
        String fileName = null;
        String fileEncoding = null;
        String ignoredStyles = null;
        String sequenceNumbers = null;
        int numColumn = 1;
        int numWidth = 0;
        int textColumn = 1;
        int textWidth = 0;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase("clear")) {
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "compare");
                }
                CompareCommand.endCompareSession(view);
                return true;
            }
            if (token.equalsIgnoreCase("refresh")) {
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "compare");
                }
                if (view == null) {
                    Document doc = Document._firstDocument;
                    while (doc != null) {
                        View v = doc._firstView;
                        while (v != null) {
                            CompareCommand.compareRefresh(v);
                            v = v._next;
                        }
                        doc = doc._next;
                    }
                } else {
                    CompareCommand.compareRefresh(view);
                }
                return true;
            }
            if (token.equalsIgnoreCase("next")) {
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "compare");
                }
                if (view != null && view.compareSession()) {
                    CompareCommand.nextMismatch(view);
                }
                return true;
            }
            if (token.equalsIgnoreCase("previous")) {
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "compare");
                }
                if (view != null && view.compareSession()) {
                    CompareCommand.previousMismatch(view);
                }
                return true;
            }
            if ("ignoredStyles".equalsIgnoreCase(token)) {
                if (!st.hasMoreTokens()) {
                    return CommandHandler.incomplete(view, "compare");
                }
                ignoredStyles = st.nextToken();
                if (LpexStringTokenizer.isValidQuotedString(ignoredStyles)) {
                    ignoredStyles = LpexStringTokenizer.removeQuotes(ignoredStyles);
                }
                String string = token = st.hasMoreTokens() ? st.nextToken() : null;
            }
            if ("prompt".equalsIgnoreCase(token)) {
                promptParameter = true;
                String string = token = st.hasMoreTokens() ? st.nextToken() : null;
            }
            if ("sequenceNumbers".equalsIgnoreCase(token)) {
                if (promptParameter) {
                    return CommandHandler.invalidParameter(view, "prompt sequenceNumbers", "compare");
                }
                if (!st.hasMoreTokens()) {
                    return CommandHandler.incomplete(view, "compare");
                }
                token = st.nextToken();
                try {
                    numColumn = Integer.parseInt(token);
                    if (!st.hasMoreTokens()) {
                        return CommandHandler.incomplete(view, "compare");
                    }
                    token = st.nextToken();
                    numWidth = Integer.parseInt(token);
                    if (!st.hasMoreTokens()) {
                        return CommandHandler.incomplete(view, "compare");
                    }
                    token = st.nextToken();
                    textColumn = Integer.parseInt(token);
                    if (!st.hasMoreTokens()) {
                        return CommandHandler.incomplete(view, "compare");
                    }
                    token = st.nextToken();
                    textWidth = Integer.parseInt(token);
                    if (!SequenceNumbersParameter.validSequenceNumbers(numColumn, numWidth, textColumn, textWidth, view, "compare")) {
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    return CommandHandler.invalidParameter(view, token, "compare");
                }
                sequenceNumbers = numColumn + " " + numWidth + " " + textColumn + " " + textWidth;
                String string = token = st.hasMoreTokens() ? st.nextToken() : null;
            }
            if ("encoding".equalsIgnoreCase(token) || "enc".equalsIgnoreCase(token)) {
                if (promptParameter) {
                    return CommandHandler.invalidParameter(view, "prompt " + token, "compare");
                }
                if (!st.hasMoreTokens()) {
                    return CommandHandler.incomplete(view, "compare");
                }
                fileEncoding = st.nextToken();
                if ("\"\"".equalsIgnoreCase(fileEncoding)) {
                    fileEncoding = "";
                } else if (!LpexNls.isValidEncoding(fileEncoding)) {
                    return CommandHandler.invalidParameter(view, token + " " + fileEncoding, "compare");
                }
                String string = token = st.hasMoreTokens() ? st.nextToken() : null;
            }
            if (token != null) {
                if (LpexStringTokenizer.isInvalidQuotedString(token)) {
                    return CommandHandler.invalidQuotedParameter(view, token, "compare");
                }
                fileName = LpexStringTokenizer.trimQuotes(token);
            }
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "compare");
            }
        }
        if (view == null) {
            return true;
        }
        boolean bl = fileNameParameter = fileName != null;
        if (fileName == null || fileName.length() == 0) {
            if (promptParameter) {
                fileName = view.fileLastComparedTo();
            }
            if (fileName == null) {
                fileName = view.document().name();
                if (!promptParameter && fileEncoding == null && (fileEncoding = view.document().fileEncoding()) == null) {
                    fileEncoding = "";
                }
            }
        }
        if (promptParameter) {
            String defaultFileName = fileName;
            fileName = LpexUtilities.fileDialog(view, LpexResources.message("fileDialog.compare"), false, defaultFileName);
            if (defaultFileName != null && defaultFileName.equalsIgnoreCase(view.document().name())) {
                fileEncoding = view.document().fileEncoding();
            }
        } else if (fileNameParameter && (docName = view.document().name()) != null) {
            try {
                File compareFile = new File(fileName);
                File currentFile = new File(docName);
                currentFile = new File(currentFile.getCanonicalPath());
                if (compareFile.isDirectory()) {
                    compareFile = new File(compareFile, currentFile.getName());
                }
                if (!compareFile.isAbsolute()) {
                    String parentPathname = currentFile.getParent();
                    if (fileName.startsWith("\\") && !fileName.startsWith("\\\\") && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                        File parentFile = currentFile;
                        while (parentFile.getParentFile() != null) {
                            parentPathname = parentFile.getParent();
                            parentFile = parentFile.getParentFile();
                        }
                    }
                    compareFile = new File(parentPathname, compareFile.getPath());
                }
                fileName = compareFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (fileName != null) {
            view.compareCommandSettings()._ignoredStyles = ignoredStyles;
            CompareCommand.compare(view, fileName, fileEncoding, sequenceNumbers, true);
            if (CommandHandler.getStatus() == null) {
                view.setFileLastComparedTo(fileName);
                view.setFileLastComparedToEncoding(view.compareCommandSettings()._compareFileEncoding);
                view.setFileLastComparedToSequenceNumbers(sequenceNumbers);
            }
        }
        return true;
    }

    static void compareRefresh(View view) {
        if (!view.compareSession()) {
            return;
        }
        String fileName = view.fileLastComparedTo();
        if (fileName != null) {
            Element element = view.documentPosition().element();
            int line = element != null ? element.nonShowOrdinal() : 0;
            LpexDocumentLocation cursor = view.documentPosition().documentLocation();
            int cursorRow = view.screen().cursorRow();
            CompareCommand.compare(view, fileName, view.fileLastComparedToEncoding(), view.fileLastComparedToSequenceNumbers(), false);
            view.documentPosition().jump(cursor);
            int newLine = view.document().elementList().nonShowOrdinalOf(view.documentPosition().element());
            if (line != newLine && line > 0) {
                view.commandHandler().doCommand("locate line " + line);
                view.commandHandler().doCommand("set position " + cursor.position);
            }
            view.screen().setCursorRow(cursorRow);
        }
    }

    private static void endCompareSession(View mainView) {
        if (mainView != null) {
            CompareCommand.clear(mainView);
            mainView.setCompareSession(false);
            mainView.screen().clearMessageKey("compare.mismatches");
            mainView.screen().clearMessageKey("compare.noMismatches");
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static void compare(View view, String fileName, String fileEncoding, String sequenceNumbers, boolean newSession) {
        CommandHandler.setStatus(null);
        lpexView2 = new LpexView(fileName, fileEncoding, false);
        view2 = lpexView2._view;
        if (CommandHandler.getStatus() != null) {
            if (CommandHandler.getStatus().equalsIgnoreCase("file.notFound")) {
                view.setLpexMessageText("compare.fileNotFound");
            } else {
                view.screen().setMessageText(view2.screen().messageText());
            }
            lpexView2.dispose();
            return;
        }
        view.compareCommandSettings()._compareFileEncoding = view2.document().fileEncoding();
        mainSequenceNumbers = view.lpexView().query("current.sequenceNumbers");
        if (sequenceNumbers == null) {
            sequenceNumbers = mainSequenceNumbers;
        }
        if (!"1 0 1 0".equalsIgnoreCase(sequenceNumbers)) {
            lpexView2.doCommand("set maintainSequenceNumbers off");
            lpexView2.doCommand("set sequenceNumbers " + sequenceNumbers);
        }
        showSequenceNumbers = "1 0 1 0".equalsIgnoreCase(mainSequenceNumbers) == false;
        view.compareCommandSettings()._sessionIgnoreSequenceNumbers = CompareCommand.ignoreSequenceNumbersParameter().currentValue(view) != false || showSequenceNumbers == false || mainSequenceNumbers.equalsIgnoreCase(sequenceNumbers) == false;
        fileEndingEol1 = view.lpexView().queryOn("current.fileEndingEol");
        if (fileEndingEol1 != lpexView2.queryOn("current.fileEndingEol") && !fileEndingEol1) {
            elements1 = view.lpexView().elements();
            if (view.lpexView().elementText(elements1).length() == 0) {
                elements2 = lpexView2.elements();
                lpexView2.doCommand(new LpexDocumentLocation(elements2, 1), "add");
            }
        }
        forceAllVisible = view.forceAllVisible();
        view.setForceAllVisible(true);
        CompareCommand.clear(view);
        maxLineLength = CompareCommand.maxLineLength(view);
        maxLineLength2 = CompareCommand.maxLineLength(view2);
        if (maxLineLength2 > maxLineLength) {
            maxLineLength = maxLineLength2;
        }
        random = new long[maxLineLength + 1];
        random[0] = 2882400001L;
        i = 1;
        while (i < maxLineLength) {
            random[i] = random[i - 1] * 5L + 2882400001L & 0xFFFFFFFFL;
            ++i;
        }
        if (newSession) {
            view.setCompareSession(true);
        }
        CompareCommand.initializeViews(view, view2);
        lines1 = CompareCommand.elementCount(view, view);
        lines2 = CompareCommand.elementCount(view2, view);
        totalLines = lines1 + lines2;
        tableSize = totalLines + 1;
        hashValues = new long[tableSize];
        elements = new Element[tableSize];
        index = CompareCommand.getHashValues(view, hashValues, elements, 1, random, view);
        CompareCommand.getHashValues(view2, hashValues, elements, index, random, view);
        hashTable = new int[tableSize];
        lineChains = new int[tableSize];
        i = 0;
        while (i < tableSize) {
            hashTable[i] = 0;
            ++i;
        }
        i = 1;
        while (i <= totalLines) {
            hashTableIndex = CompareCommand.findHashTableIndex(totalLines, hashValues, hashTable, i);
            lineChains[i] = pair = hashTable[hashTableIndex];
            hashTable[hashTableIndex] = i++;
        }
        linePairs = new int[tableSize];
        System.arraycopy(lineChains, 0, linePairs, 0, lineChains.length);
        hashTableIndex = 0;
        while (hashTableIndex < totalLines) {
            block47: {
                i = hashTable[hashTableIndex];
                if (i == 0) break block47;
                pair = lineChains[i];
                if (pair == 0 || lineChains[pair] != 0 || i <= lines1 || pair > lines1) ** GOTO lbl83
                linePairs[i] = pair;
                linePairs[pair] = i;
                break block47;
lbl-1000:
                // 1 sources

                {
                    pair = linePairs[i];
                    linePairs[i] = 0;
                    i = pair;
lbl83:
                    // 2 sources

                    ** while (i != 0)
                }
            }
            ++hashTableIndex;
        }
        i = 0;
        while (i <= lines1 + 1) {
            pair = i == 0 ? lines1 : (i > lines1 ? totalLines + 1 : linePairs[i]);
            if (pair != 0) {
                j = 1;
                while (pair + j <= totalLines && i + j <= lines1 && hashValues[i + j] == hashValues[pair + j] && linePairs[i + j] == 0 && linePairs[pair + j] == 0) {
                    linePairs[i + j] = pair + j;
                    linePairs[pair + j] = i + j;
                    ++j;
                }
                j = -1;
                while (pair + j > lines1 && i + j > 0 && hashValues[i + j] == hashValues[pair + j] && linePairs[i + j] == 0 && linePairs[pair + j] == 0) {
                    linePairs[i + j] = pair + j;
                    linePairs[pair + j] = i + j;
                    --j;
                }
            }
            ++i;
        }
        lowerBound = lines1;
        upperBound = lines1;
        i = 1;
        while (i <= lines1) {
            pair = linePairs[i];
            if (pair != 0) {
                lowerBound = pair;
            } else {
                chain = hashTable[CompareCommand.findHashTableIndex(totalLines, hashValues, hashTable, i)];
                latestMatch = -1;
                while (lineChains[chain] != 0 && chain > lowerBound) {
                    latestMatch = chain;
                    chain = lineChains[chain];
                }
                if (latestMatch > 0) {
                    if (lowerBound >= upperBound) {
                        j = i + 1;
                        while (linePairs[j] == 0 && j < lines1) {
                            ++j;
                        }
                        upperBound = linePairs[j] != 0 ? linePairs[j] : totalLines;
                    }
                    if (latestMatch < upperBound) {
                        linePairs[i] = latestMatch;
                        linePairs[latestMatch] = i;
                        lowerBound = latestMatch;
                    }
                }
            }
            ++i;
        }
        CompareCommand.pruneBlock(linePairs, 1, lines1, lines1 + 1, tableSize);
        firstMark /* !! */  = null;
        addedBlocks = 0;
        i = 1;
        while (i <= lines1) {
            pair = linePairs[i];
            if (pair == 0) {
                startLine = i;
                endLine = i;
                while (i < lines1 && linePairs[i + 1] == 0) {
                    endLine = ++i;
                }
                mark = new AddedLines(view, elements[startLine], elements[endLine]);
                if (++addedBlocks == 1) {
                    firstMark /* !! */  = mark;
                }
            }
            ++i;
        }
        deletedBlocks = 0;
        preserve = view.documentPosition().preserve();
        lastMatch = 0;
        i = lines1 + 1;
        while (i < tableSize) {
            pair = linePairs[i];
            if (pair == 0) {
                deletedShowElement = new Element(view);
                deletedElement = elements[i];
                deletedLine = view2.document().elementList().nonShowOrdinalOf(deletedElement);
                deletedCount = 1;
                deletedShowElement.setText(view, deletedElement.text());
                deletedShowElement.elementView(view).setStyle(deletedElement.elementView(view2).style());
                if (showSequenceNumbers && !"1 0 1 0".equalsIgnoreCase(sequenceNumbers)) {
                    deletedShowElement.setSequenceNumber(deletedElement.sequenceNumber());
                    deletedShowElement.setSequenceText(deletedElement.sequenceText());
                }
                if (lastMatch == 0) {
                    matchElement = CompareCommand.getMatchElement(view, null);
                    view.documentPosition().jump(matchElement, 1);
                    if (matchElement == view.document().elementList().first()) {
                        view.insertElementBefore(deletedShowElement);
                    } else {
                        view.insertElement(deletedShowElement);
                    }
                } else {
                    matchElement = CompareCommand.getMatchElement(view, elements[lastMatch]);
                    view.documentPosition().jump(matchElement, 1);
                    view.insertElement(deletedShowElement);
                }
                endDeletedShowElement = deletedShowElement;
                while (i < tableSize - 1 && linePairs[i + 1] == 0) {
                    endDeletedShowElement = new Element(view);
                    deletedElement = elements[++i];
                    ++deletedCount;
                    endDeletedShowElement.setText(view, deletedElement.text());
                    endDeletedShowElement.elementView(view).setStyle(deletedElement.elementView(view2).style());
                    if (showSequenceNumbers && !"1 0 1 0".equalsIgnoreCase(sequenceNumbers)) {
                        endDeletedShowElement.setSequenceNumber(deletedElement.sequenceNumber());
                        endDeletedShowElement.setSequenceText(deletedElement.sequenceText());
                    }
                    view.insertElement(endDeletedShowElement);
                }
                mark = new DeletedLines(view, deletedShowElement, endDeletedShowElement, deletedLine, deletedCount);
                if (++deletedBlocks == 1) {
                    if (firstMark /* !! */  == null) {
                        firstMark /* !! */  = mark;
                    } else {
                        firstMarkLoc = firstMark /* !! */ .documentLocation();
                        markLoc = mark.documentLocation();
                        if (firstMarkLoc.element > markLoc.element) {
                            firstMark /* !! */  = mark;
                        }
                    }
                }
            } else {
                lastMatch = pair;
            }
            ++i;
        }
        preserve.restore();
        view.documentPosition().disposePreserve(preserve);
        lpexView2.dispose();
        if (newSession && firstMark /* !! */  != null) {
            view.documentPosition().jump(firstMark /* !! */ .documentLocation());
            rows = view.screen().rows();
            view.screen().setCursorRow(rows / 2);
        }
        if (addedBlocks == 0 && deletedBlocks == 0) {
            view.screen().setMessageKey("compare.noMismatches");
        } else {
            view.screen().setMessageKey("compare.mismatches");
        }
        view.setForceAllVisible(forceAllVisible);
    }

    private static int findHashTableIndex(int totalLines, long[] hashValues, int[] hashTable, int lineIndex) {
        long hashValue = hashValues[lineIndex];
        int hashTableIndex = (int)(hashValue % (long)totalLines);
        if (hashTableIndex < 0) {
            hashTableIndex = -hashTableIndex;
        }
        int duplicate = hashTable[hashTableIndex];
        while (duplicate != 0 && hashValues[duplicate] != hashValue) {
            if (++hashTableIndex >= totalLines) {
                hashTableIndex = 0;
            }
            duplicate = hashTable[hashTableIndex];
        }
        return hashTableIndex;
    }

    private static Element getMatchElement(View mainView, Element element) {
        int endColumn;
        Element lastElement = element != null ? element : mainView.document().elementList().first();
        String ignoredStyles = mainView.compareCommandSettings()._sessionIgnoredStyles;
        if (ignoredStyles == null) {
            return lastElement;
        }
        boolean ignoreSequenceNumbers = mainView.compareCommandSettings()._sessionIgnoreSequenceNumbers;
        boolean columns = CompareCommand.columnsParameter().currentValue(mainView);
        int startColumn = columns ? CompareCommand.startColumnParameter().currentValue(mainView) : 0;
        int n = endColumn = columns ? CompareCommand.endColumnParameter().currentValue(mainView) : 0;
        if (element == null && CompareCommand.effectiveElement(mainView, lastElement, ignoredStyles, ignoreSequenceNumbers, startColumn, endColumn)) {
            return lastElement;
        }
        Element e = lastElement.next();
        while (e != null) {
            if (CompareCommand.effectiveElement(mainView, e, ignoredStyles, ignoreSequenceNumbers, startColumn, endColumn)) break;
            lastElement = e;
            e = e.next();
        }
        return lastElement;
    }

    private static void nextMismatch(View view) {
        Element currentElement = view.documentPosition().element();
        if (currentElement != null) {
            MarkList.Mark currentMark = null;
            ElementView.MarkNode currentNode = currentElement.elementView((View)view)._firstMarkNode;
            while (currentNode != null && !(currentNode.mark() instanceof CompareMark)) {
                currentNode = currentNode._next;
            }
            if (currentNode != null) {
                currentMark = currentNode.mark();
            }
            Element element = currentElement.next();
            while (element != null) {
                MarkList.Mark nextMark = null;
                ElementView.MarkNode markNode = element.elementView((View)view)._firstMarkNode;
                while (markNode != null && nextMark == null) {
                    nextMark = markNode.mark();
                    if (!(nextMark instanceof CompareMark) || nextMark == currentMark) {
                        nextMark = null;
                    }
                    markNode = markNode._next;
                }
                if (nextMark != null) {
                    view.documentPosition().jump(element, 1);
                    int rows = view.screen().rows();
                    view.screen().setCursorRow(rows / 2);
                    return;
                }
                element = element.next();
            }
        }
        view.setLpexMessageText("compare.noMoreMismatches");
    }

    private static void previousMismatch(View view) {
        Element currentElement = view.documentPosition().element();
        if (currentElement != null) {
            MarkList.Mark currentMark = null;
            ElementView.MarkNode currentNode = currentElement.elementView((View)view)._firstMarkNode;
            while (currentNode != null && !(currentNode.mark() instanceof CompareMark)) {
                currentNode = currentNode._next;
            }
            if (currentNode != null) {
                currentMark = currentNode.mark();
            }
            Element element = currentElement.prev();
            while (element != null) {
                MarkList.Mark prevMark = null;
                ElementView.MarkNode markNode = element.elementView((View)view)._firstMarkNode;
                while (markNode != null && prevMark == null) {
                    prevMark = markNode.mark();
                    if (!(prevMark instanceof CompareMark) || prevMark == currentMark) {
                        prevMark = null;
                    }
                    markNode = markNode._next;
                }
                if (prevMark != null) {
                    view.documentPosition().jump(prevMark.documentLocation());
                    int rows = view.screen().rows();
                    view.screen().setCursorRow(rows / 2);
                    return;
                }
                element = element.prev();
            }
        }
        view.setLpexMessageText("compare.noMoreMismatches");
    }

    private static void initializeViews(View mainView, View view) {
        LpexParser parser;
        String commentStyles;
        LpexParser mainParser;
        boolean ignoreComments;
        Object ignoredStyles = mainView.compareCommandSettings()._ignoredStyles;
        mainView.parse();
        if (!view.updateProfileIssued()) {
            view.updateProfile();
        }
        if ((ignoreComments = CompareCommand.ignoreCommentsParameter().currentValue(mainView)) && (mainParser = mainView.parsePendingList().lpexParser()) != null && mainParser instanceof LpexCommonParser && (commentStyles = ((LpexCommonParser)mainParser).getCommentStyleCharacters()) != null && (parser = view.parsePendingList().lpexParser()) != null && (parser.getClass().isAssignableFrom(mainParser.getClass()) || mainParser.getClass().isAssignableFrom(parser.getClass()))) {
            ignoredStyles = ignoredStyles == null ? commentStyles : (String)ignoredStyles + commentStyles;
        }
        mainView.compareCommandSettings()._sessionIgnoredStyles = ignoredStyles;
    }

    private static int elementCount(View view, View mainView) {
        ElementList elementList = view.document().elementList();
        String ignoredStyles = mainView.compareCommandSettings()._sessionIgnoredStyles;
        if (ignoredStyles == null) {
            return elementList.nonShowCount();
        }
        int count = 0;
        boolean ignoreSequenceNumbers = mainView.compareCommandSettings()._sessionIgnoreSequenceNumbers;
        boolean columns = CompareCommand.columnsParameter().currentValue(mainView);
        int startColumn = columns ? CompareCommand.startColumnParameter().currentValue(mainView) : 0;
        int endColumn = columns ? CompareCommand.endColumnParameter().currentValue(mainView) : 0;
        Element element = elementList.first();
        while (element != null) {
            if (CompareCommand.effectiveElement(view, element, ignoredStyles, ignoreSequenceNumbers, startColumn, endColumn)) {
                ++count;
            }
            element = element.next();
        }
        return count;
    }

    private static String effectiveText(View view, Element element, String ignoredStyles, boolean ignoreSequenceNumbers, int startColumn, int endColumn) {
        String text = element.text();
        if (startColumn != 0) {
            text = CompareCommand.substring(text, startColumn, endColumn);
        }
        if (ignoreSequenceNumbers && ignoredStyles == null) {
            return text;
        }
        StringBuilder code = new StringBuilder(text.length());
        if (!ignoreSequenceNumbers) {
            code.append(view.document().elementList().getSequenceNumbersString(element));
        }
        if (ignoredStyles == null) {
            code.append(text);
        } else {
            String style = element.elementView(view).style();
            if (startColumn != 0) {
                style = CompareCommand.substring(style, startColumn, endColumn);
            }
            int i = 0;
            while (i < text.length()) {
                char currentChar = text.charAt(i);
                if (currentChar != ' ' && currentChar != '\t') {
                    char currentStyle;
                    char c = currentStyle = i < style.length() ? style.charAt(i) : (char)'\u0000';
                    if (ignoredStyles.indexOf(currentStyle) < 0) {
                        code.append(currentChar);
                    }
                }
                ++i;
            }
            if (code.length() == 0 && text.length() != 0) {
                return null;
            }
        }
        return code.toString();
    }

    private static boolean effectiveElement(View view, Element element, String ignoredStyles, boolean ignoreSequenceNumbers, int startColumn, int endColumn) {
        if (element.show()) {
            return false;
        }
        if (!ignoreSequenceNumbers || ignoredStyles == null) {
            return true;
        }
        String text = element.text();
        if (startColumn != 0) {
            text = CompareCommand.substring(text, startColumn, endColumn);
        }
        if (text.length() == 0) {
            return true;
        }
        String style = element.elementView(view).style();
        if (startColumn != 0) {
            style = CompareCommand.substring(style, startColumn, endColumn);
        }
        int i = 0;
        while (i < text.length()) {
            char currentChar = text.charAt(i);
            if (currentChar != ' ' && currentChar != '\t') {
                char currentStyle;
                char c = currentStyle = i < style.length() ? style.charAt(i) : (char)'\u0000';
                if (ignoredStyles.indexOf(currentStyle) < 0) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static String substring(String s, int startPosition, int endPosition) {
        if (startPosition > s.length() || endPosition < startPosition) {
            return "";
        }
        if (endPosition > s.length()) {
            return startPosition == 1 ? s : s.substring(startPosition - 1);
        }
        return s.substring(startPosition - 1, endPosition);
    }

    private static int maxLineLength(View view) {
        ElementList elementList = view.document().elementList();
        int sequenceNumbersWidth = elementList.sequenceNumbersWidth();
        int maxLineLength = 0;
        Element element = elementList.first();
        while (element != null) {
            int textLength;
            if (!element.show() && (textLength = element.length() + sequenceNumbersWidth) > maxLineLength) {
                maxLineLength = textLength;
            }
            element = element.next();
        }
        return maxLineLength;
    }

    private static int getHashValues(View view, long[] hashValues, Element[] elements, int index, long[] random, View mainView) {
        boolean ignoreAllBlanks = CompareCommand.ignoreAllBlanksParameter().currentValue(mainView);
        boolean ignoreCase = CompareCommand.ignoreCaseParameter().currentValue(mainView);
        boolean ignoreLeadingBlanks = CompareCommand.ignoreLeadingBlanksParameter().currentValue(mainView);
        boolean ignoreSequenceNumbers = mainView.compareCommandSettings()._sessionIgnoreSequenceNumbers;
        boolean ignoreTrailingBlanks = CompareCommand.ignoreTrailingBlanksParameter().currentValue(mainView);
        String ignoredStyles = mainView.compareCommandSettings()._sessionIgnoredStyles;
        boolean columns = CompareCommand.columnsParameter().currentValue(mainView);
        int startColumn = columns ? CompareCommand.startColumnParameter().currentValue(mainView) : 0;
        int endColumn = columns ? CompareCommand.endColumnParameter().currentValue(mainView) : 0;
        ElementList elementList = view.document().elementList();
        Element element = elementList.first();
        while (element != null) {
            String text;
            if (!element.show() && (text = CompareCommand.effectiveText(view, element, ignoredStyles, ignoreSequenceNumbers, startColumn, endColumn)) != null) {
                if (ignoreCase) {
                    text = text.toLowerCase();
                }
                if (ignoredStyles == null && (ignoreLeadingBlanks || ignoreTrailingBlanks || ignoreAllBlanks)) {
                    char currentChar;
                    int textLength = text.length();
                    int start = 0;
                    int end = textLength - 1;
                    if (ignoreLeadingBlanks) {
                        try {
                            currentChar = text.charAt(start);
                            while (currentChar == ' ' || currentChar == '\t') {
                                currentChar = text.charAt(++start);
                            }
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            start = textLength;
                        }
                    }
                    if (ignoreTrailingBlanks) {
                        try {
                            currentChar = text.charAt(end);
                            while ((currentChar == ' ' || currentChar == '\t') && end >= start) {
                                currentChar = text.charAt(--end);
                            }
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            end = -1;
                        }
                    }
                    if (ignoreAllBlanks) {
                        StringBuilder strippedText = new StringBuilder(textLength);
                        while (start <= end) {
                            currentChar = text.charAt(start);
                            if (currentChar != ' ' && currentChar != '\t') {
                                strippedText.append(currentChar);
                            }
                            ++start;
                        }
                        text = strippedText.toString();
                    } else {
                        text = start <= end ? text.substring(start, end + 1) : "";
                    }
                }
                int len = text.length();
                long hashValue = 0L;
                int i = 0;
                while (i < len) {
                    hashValue += random[i] * (long)text.charAt(i);
                    hashValue &= 0xFFFFFFFFL;
                    ++i;
                }
                hashValues[index] = hashValue;
                elements[index] = element;
                ++index;
            }
            element = element.next();
        }
        return index;
    }

    private static void pruneBlock(int[] linePairs, int topA, int bottomA, int topB, int bottomB) {
        int maxBlockLength = 0;
        int maxBlockTop = 0;
        int maxBlockBottom = 0;
        int currentBlockLength = 0;
        int currentBlockTop = 0;
        int currentBlockBottom = 0;
        int lastPair = 0;
        int i = topA;
        while (i <= bottomA) {
            int pair = linePairs[i];
            if (pair > bottomB || pair < topB) {
                linePairs[i] = 0;
                linePairs[pair] = 0;
                pair = 0;
            }
            if (currentBlockLength == 0) {
                if (pair != 0) {
                    currentBlockLength = 1;
                    currentBlockTop = i;
                    currentBlockBottom = i;
                }
            } else if (pair == 0 || pair != lastPair + 1) {
                if (currentBlockLength > maxBlockLength) {
                    maxBlockLength = currentBlockLength;
                    maxBlockTop = currentBlockTop;
                    maxBlockBottom = currentBlockBottom;
                }
                currentBlockLength = 0;
            } else {
                ++currentBlockLength;
                currentBlockBottom = i;
            }
            lastPair = pair;
            ++i;
        }
        if (currentBlockLength > maxBlockLength) {
            maxBlockLength = currentBlockLength;
            maxBlockTop = currentBlockTop;
            maxBlockBottom = currentBlockBottom;
        }
        if (maxBlockLength > 0) {
            if (topA < maxBlockTop) {
                CompareCommand.pruneBlock(linePairs, topA, maxBlockTop - 1, topB, linePairs[maxBlockTop] - 1);
            }
            if (maxBlockBottom < bottomA) {
                CompareCommand.pruneBlock(linePairs, maxBlockBottom + 1, bottomA, linePairs[maxBlockBottom] + 1, bottomB);
            }
        }
    }

    private static void clear(View view) {
        MarkList.MarkNode next = null;
        MarkList.MarkNode markNode = (MarkList.MarkNode)view.markList().first();
        while (markNode != null) {
            next = (MarkList.MarkNode)markNode.next();
            MarkList.Mark mark = markNode.mark();
            if (mark instanceof CompareMark) {
                if (mark instanceof DeletedLines) {
                    Element element = mark._element1;
                    Element elementEnd = mark._element2 != null ? mark._element2.next() : null;
                    mark.clear();
                    if (element != null) {
                        while (element != elementEnd) {
                            Element nextElement = element.next();
                            view.deleteElement(element);
                            element = nextElement;
                        }
                    }
                } else {
                    mark.clear();
                }
            }
            markNode = next;
        }
    }

    static ColumnsParameter columnsParameter() {
        if (_columnsParameter == null) {
            _columnsParameter = new ColumnsParameter();
        }
        return _columnsParameter;
    }

    static EndColumnParameter endColumnParameter() {
        if (_endColumnParameter == null) {
            _endColumnParameter = new EndColumnParameter();
        }
        return _endColumnParameter;
    }

    static IgnoreAllBlanksParameter ignoreAllBlanksParameter() {
        if (_ignoreAllBlanksParameter == null) {
            _ignoreAllBlanksParameter = new IgnoreAllBlanksParameter();
        }
        return _ignoreAllBlanksParameter;
    }

    static IgnoreCaseParameter ignoreCaseParameter() {
        if (_ignoreCaseParameter == null) {
            _ignoreCaseParameter = new IgnoreCaseParameter();
        }
        return _ignoreCaseParameter;
    }

    static IgnoreCommentsParameter ignoreCommentsParameter() {
        if (_ignoreCommentsParameter == null) {
            _ignoreCommentsParameter = new IgnoreCommentsParameter();
        }
        return _ignoreCommentsParameter;
    }

    static IgnoreLeadingBlanksParameter ignoreLeadingBlanksParameter() {
        if (_ignoreLeadingBlanksParameter == null) {
            _ignoreLeadingBlanksParameter = new IgnoreLeadingBlanksParameter();
        }
        return _ignoreLeadingBlanksParameter;
    }

    static IgnoreSequenceNumbersParameter ignoreSequenceNumbersParameter() {
        if (_ignoreSequenceNumbersParameter == null) {
            _ignoreSequenceNumbersParameter = new IgnoreSequenceNumbersParameter();
        }
        return _ignoreSequenceNumbersParameter;
    }

    static IgnoreTrailingBlanksParameter ignoreTrailingBlanksParameter() {
        if (_ignoreTrailingBlanksParameter == null) {
            _ignoreTrailingBlanksParameter = new IgnoreTrailingBlanksParameter();
        }
        return _ignoreTrailingBlanksParameter;
    }

    static StartColumnParameter startColumnParameter() {
        if (_startColumnParameter == null) {
            _startColumnParameter = new StartColumnParameter();
        }
        return _startColumnParameter;
    }

    static final class AddedLines
    extends CompareMark {
        AddedLines(View view, Element element1, Element element2) {
            super(view, element1, element2, '\u0003');
        }
    }

    static final class ColumnsParameter
    extends ParameterOnOffDefault {
        ColumnsParameter() {
            super("compare.columns", false);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.compareCommandSettings()._columns = value;
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.compareCommandSettings()._columns : 2;
        }
    }

    static class CompareMark
    extends MarkList.ElementMark {
        CompareMark(View view, Element element1, Element element2, char styleCharacter) {
            MarkList markList = view.markList();
            markList.getClass();
            super(null, 0, element1, element2, false);
            this.setHighlight(true);
            this.setStyleCharacter(styleCharacter);
        }
    }

    static final class DeletedLines
    extends CompareMark {
        int _firstLine;
        int _count;

        DeletedLines(View view, Element element1, Element element2, int firstLine, int count) {
            super(view, element1, element2, '\u0004');
            this.setProtect(true);
            this._firstLine = firstLine;
            this._count = count;
        }

        int firstLine() {
            return this._firstLine;
        }

        int count() {
            return this._count;
        }
    }

    static final class EndColumnParameter
    extends ParameterIntegerDefault {
        EndColumnParameter() {
            super("compare.endColumn", 80);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value, boolean useDefaultValue) {
            if (view != null) {
                Settings settings = view.compareCommandSettings();
                settings._endColumn = value;
                settings._useDefaultEndColumn = useDefaultValue;
            }
            return true;
        }

        @Override
        boolean useDefaultValue(View view) {
            return view != null ? view.compareCommandSettings()._useDefaultEndColumn : true;
        }

        @Override
        int value(View view) {
            return view != null ? view.compareCommandSettings()._endColumn : 0;
        }
    }

    static final class IgnoreAllBlanksParameter
    extends ParameterOnOffDefault {
        IgnoreAllBlanksParameter() {
            super("compare.ignoreAllBlanks", false);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.compareCommandSettings()._ignoreAllBlanks = value;
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.compareCommandSettings()._ignoreAllBlanks : 2;
        }
    }

    static final class IgnoreCaseParameter
    extends ParameterOnOffDefault {
        IgnoreCaseParameter() {
            super("compare.ignoreCase", false);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.compareCommandSettings()._ignoreCase = value;
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.compareCommandSettings()._ignoreCase : 2;
        }
    }

    static final class IgnoreCommentsParameter
    extends ParameterOnOffDefault {
        IgnoreCommentsParameter() {
            super("compare.ignoreComments", false);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.compareCommandSettings()._ignoreComments = value;
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.compareCommandSettings()._ignoreComments : 2;
        }
    }

    static final class IgnoreLeadingBlanksParameter
    extends ParameterOnOffDefault {
        IgnoreLeadingBlanksParameter() {
            super("compare.ignoreLeadingBlanks", false);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.compareCommandSettings()._ignoreLeadingBlanks = value;
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.compareCommandSettings()._ignoreLeadingBlanks : 2;
        }
    }

    static final class IgnoreSequenceNumbersParameter
    extends ParameterOnOffDefault {
        IgnoreSequenceNumbersParameter() {
            super("compare.ignoreSequenceNumbers", true);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.compareCommandSettings()._ignoreSequenceNumbers = value;
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.compareCommandSettings()._ignoreSequenceNumbers : 2;
        }
    }

    static final class IgnoreTrailingBlanksParameter
    extends ParameterOnOffDefault {
        IgnoreTrailingBlanksParameter() {
            super("compare.ignoreTrailingBlanks", false);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value) {
            if (view != null) {
                view.compareCommandSettings()._ignoreTrailingBlanks = value;
            }
            return true;
        }

        @Override
        int value(View view) {
            return view != null ? view.compareCommandSettings()._ignoreTrailingBlanks : 2;
        }
    }

    static final class Settings {
        int _ignoreAllBlanks = 2;
        int _ignoreCase = 2;
        int _ignoreComments = 2;
        int _ignoreLeadingBlanks = 2;
        int _ignoreTrailingBlanks = 2;
        int _ignoreSequenceNumbers = 2;
        int _columns = 2;
        int _startColumn;
        boolean _useDefaultStartColumn = true;
        int _endColumn;
        boolean _useDefaultEndColumn = true;
        String _ignoredStyles;
        String _sessionIgnoredStyles;
        boolean _sessionIgnoreSequenceNumbers;
        String _compareFileEncoding;

        Settings() {
        }
    }

    static final class StartColumnParameter
    extends ParameterIntegerDefault {
        StartColumnParameter() {
            super("compare.startColumn", 1);
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        @Override
        boolean setValue(View view, int value, boolean useDefaultValue) {
            if (view != null) {
                Settings settings = view.compareCommandSettings();
                settings._startColumn = value;
                settings._useDefaultStartColumn = useDefaultValue;
            }
            return true;
        }

        @Override
        boolean useDefaultValue(View view) {
            return view != null ? view.compareCommandSettings()._useDefaultStartColumn : true;
        }

        @Override
        int value(View view) {
            return view != null ? view.compareCommandSettings()._startColumn : 0;
        }
    }
}

