/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.ClassNode;
import com.ibm.lpex.core.LpexStringTokenizer;

final class Classes {
    static final long NONE = 0L;
    static final long DEFAULT = 1L;
    static final long FIND_TEXT = Long.MIN_VALUE;
    static final long EXCLUDE_TEXT = 0x4000000000000000L;
    static final long INTERNAL = 0x2000000000000000L;
    static final long USER = 0x1FFFFFFFFFFFFFFEL;
    static final long ALL = -1L;
    private long _usedBits = -2305843009213693951L;
    private ClassNode _firstClass;

    Classes() {
    }

    long register(String name) {
        if (name == null) {
            return 0L;
        }
        ClassNode classNode = this.find(name);
        if (classNode != null) {
            return classNode.mask();
        }
        if (this._usedBits != -1L) {
            long mask = 1L;
            int i = 0;
            while (i < 64) {
                if ((this._usedBits & mask) == 0L) {
                    this._usedBits |= mask;
                    classNode = new ClassNode(name, mask);
                    classNode._next = this._firstClass;
                    this._firstClass = classNode;
                    return mask;
                }
                mask <<= 1;
                ++i;
            }
        }
        return 0L;
    }

    void deregister(String name) {
        ClassNode previousNode = null;
        ClassNode classNode = this._firstClass;
        while (classNode != null) {
            if (classNode.name().equals(name)) {
                this._usedBits &= classNode.mask() ^ 0xFFFFFFFFFFFFFFFFL;
                if (previousNode == null) {
                    this._firstClass = classNode._next;
                    break;
                }
                previousNode._next = classNode._next;
                break;
            }
            previousNode = classNode;
            classNode = classNode._next;
        }
    }

    long mask(String names) {
        long mask = 0L;
        LpexStringTokenizer st = new LpexStringTokenizer(names);
        while (st.hasMoreTokens()) {
            ClassNode classNode = this.find(st.nextToken());
            if (classNode == null) continue;
            mask |= classNode.mask();
        }
        return mask;
    }

    long userMask(long mask) {
        long userMask = 0L;
        long currentMask = 1L;
        int i = 0;
        while (i < 64) {
            ClassNode classNode;
            if ((mask & currentMask) != 0L && (classNode = this.find(currentMask)) != null) {
                userMask |= currentMask;
            }
            currentMask <<= 1;
            ++i;
        }
        return userMask;
    }

    String names(long mask) {
        StringBuilder names = new StringBuilder(256);
        long currentMask = 1L;
        int i = 0;
        while (i < 64) {
            ClassNode classNode;
            if ((mask & currentMask) != 0L && (classNode = this.find(currentMask)) != null) {
                if (names.length() != 0) {
                    names.append(' ');
                }
                names.append(classNode.name());
            }
            currentMask <<= 1;
            ++i;
        }
        return names.toString();
    }

    String name(long mask) {
        ClassNode classNode = this.find(mask);
        return classNode != null ? classNode.name() : "";
    }

    String list() {
        StringBuilder list = new StringBuilder(256);
        ClassNode classNode = this._firstClass;
        while (classNode != null) {
            if (list.length() != 0) {
                list.append(' ');
            }
            list.append(classNode.name());
            classNode = classNode._next;
        }
        return list.toString();
    }

    private ClassNode find(String name) {
        ClassNode classNode = this._firstClass;
        while (classNode != null) {
            if (classNode.name().equals(name)) {
                return classNode;
            }
            classNode = classNode._next;
        }
        return null;
    }

    private ClassNode find(long mask) {
        ClassNode classNode = this._firstClass;
        while (classNode != null) {
            if ((mask & classNode.mask()) != 0L) {
                return classNode;
            }
            classNode = classNode._next;
        }
        return null;
    }
}

