/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.List;
import com.ibm.lpex.core.ListNode;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.UpdateProfileCommand;
import com.ibm.lpex.core.View;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class ClassLoaderList
extends List {
    private static ClassLoaderList _classLoaderList;
    private static ClassLoader _extensionsClassLoader;

    ClassLoaderList() {
    }

    static void setClassLoader(ClassLoader classLoader) {
        if (_classLoaderList == null) {
            _classLoaderList = new ClassLoaderList();
        }
        if (_classLoaderList.find(classLoader) == null) {
            _classLoaderList.addAfter(null, new ClassLoaderNode(classLoader));
        }
    }

    static Class<?> loadClass(String className, View view) {
        if (className == null || className.length() == 0) {
            return null;
        }
        if (_classLoaderList != null) {
            ClassLoaderNode node = (ClassLoaderNode)_classLoaderList.first();
            while (node != null) {
                try {
                    return Class.forName(className, true, node.classLoader());
                }
                catch (Throwable throwable) {
                    node = (ClassLoaderNode)node.next();
                }
            }
        }
        if (view != null && view.document().extensionsClassLoader() != null) {
            try {
                return Class.forName(className, true, view.document().extensionsClassLoader());
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        if (ClassLoaderList.extensionsClassLoader() != null) {
            try {
                return Class.forName(className, true, ClassLoaderList.extensionsClassLoader());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private static ClassLoader extensionsClassLoader() {
        String extensionsClasspath;
        if (_extensionsClassLoader == null && (extensionsClasspath = UpdateProfileCommand.ExtensionsClasspathParameter.getParameter().currentValue(null)) != null) {
            _extensionsClassLoader = ClassLoaderList.getClassLoader(extensionsClasspath);
        }
        return _extensionsClassLoader;
    }

    static ClassLoader getClassLoader(String classpath) {
        ClassLoader classLoader = null;
        if (classpath != null) {
            classpath = LpexStringTokenizer.trimQuotes(classpath);
            String[] filenames = classpath.split(File.pathSeparator);
            final URL[] urls = new URL[filenames.length];
            try {
                int i = 0;
                while (i < filenames.length) {
                    File file = new File(filenames[i]);
                    urls[i] = file.toURI().toURL();
                    ++i;
                }
            }
            catch (MalformedURLException x) {
                return null;
            }
            try {
                classLoader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

                    @Override
                    public URLClassLoader run() {
                        return new URLClassLoader(urls);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return classLoader;
    }

    static void extensionsClasspathChanged() {
        _extensionsClassLoader = null;
    }

    private ClassLoaderNode find(ClassLoader classLoader) {
        ClassLoaderNode node = (ClassLoaderNode)this.first();
        while (node != null) {
            if (node.classLoader() == classLoader) {
                return node;
            }
            node = (ClassLoaderNode)node.next();
        }
        return null;
    }

    private static class ClassLoaderNode
    extends ListNode {
        private ClassLoader _classLoader;

        ClassLoaderNode(ClassLoader classLoader) {
            this._classLoader = classLoader;
        }

        ClassLoader classLoader() {
            return this._classLoader;
        }
    }
}

