/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.View;

final class BoundsParameter
extends Parameter {
    private static BoundsParameter _parameter;

    static BoundsParameter getParameter() {
        if (_parameter == null) {
            _parameter = new BoundsParameter();
        }
        return _parameter;
    }

    private BoundsParameter() {
        super("bounds");
    }

    @Override
    String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
        return view == null ? null : "" + view.getBoundsStartCol() + ' ' + view.getBoundsEndCol();
    }

    @Override
    boolean set(View view, String qualifier, String parameters) {
        int startColumn = 0;
        int endColumn = 0;
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!st.hasMoreTokens()) {
                return CommandHandler.incomplete(view, "set " + this.name());
            }
            try {
                startColumn = Integer.parseInt(token);
                token = st.nextToken();
                endColumn = Integer.parseInt(token);
            }
            catch (NumberFormatException e) {
                return CommandHandler.invalidParameter(view, token, "set " + this.name());
            }
        }
        if (st.hasMoreTokens()) {
            return CommandHandler.invalidParameter(view, st.nextToken(), "set " + this.name());
        }
        if (endColumn == 0 && startColumn != 0 || startColumn < 0) {
            return CommandHandler.invalidParameter(view, String.valueOf(startColumn), "set " + this.name());
        }
        if (startColumn == 0 && endColumn != 0 || endColumn < 0 || endColumn < startColumn) {
            return CommandHandler.invalidParameter(view, String.valueOf(endColumn), "set " + this.name());
        }
        if (view != null) {
            view.setBoundsStartCol(startColumn);
            view.setBoundsEndCol(endColumn);
        }
        return true;
    }
}

