/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.Block;
import com.ibm.lpex.core.CommandHandler;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.Install;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.ParameterDefault;
import com.ibm.lpex.core.ParameterIntegerQuery;
import com.ibm.lpex.core.ParameterOnOffDefault;
import com.ibm.lpex.core.ParameterOnOffQuery;
import com.ibm.lpex.core.ParameterQuery;
import com.ibm.lpex.core.Parameters;
import com.ibm.lpex.core.Profile;
import com.ibm.lpex.core.TableNode;
import com.ibm.lpex.core.TextWindow;
import com.ibm.lpex.core.View;
import org.eclipse.swt.widgets.Widget;

final class BlockCommand {
    private static final int ANYTHING_SELECTED = 1;
    private static final int BOTTOM_ELEMENT = 2;
    private static final int BOTTOM_POSITION = 3;
    private static final int DEFAULT_TYPE = 4;
    private static final int DRAG_AND_DROP = 5;
    private static final int ELEMENT_TEXT = 6;
    private static final int IN_VIEW = 7;
    private static final int TEXT = 8;
    private static final int TOP_ELEMENT = 9;
    private static final int TOP_POSITION = 10;
    private static final int TYPE = 11;
    private static TableNode[] _parameters = new TableNode[]{new TableNode("anythingSelected", 1), new TableNode("bottomElement", 2), new TableNode("bottomPosition", 3), new TableNode("defaultType", 4), new TableNode("dragAndDrop", 5), new TableNode("elementText", 6), new TableNode("inView", 7), new TableNode("text", 8), new TableNode("topElement", 9), new TableNode("topPosition", 10), new TableNode("type", 11)};

    static {
        TableNode.sort(_parameters);
    }

    BlockCommand() {
    }

    static Parameter getParameter(String parameter) {
        TableNode p = TableNode.binarySearch(_parameters, Parameters.getParameterString(parameter));
        if (p != null) {
            switch (p.id()) {
                case 1: {
                    return AnythingSelectedParameter.getParameter();
                }
                case 2: {
                    return BottomElementParameter.getParameter();
                }
                case 3: {
                    return BottomPositionParameter.getParameter();
                }
                case 4: {
                    return DefaultTypeParameter.getParameter();
                }
                case 5: {
                    return DragAndDropParameter.getParameter();
                }
                case 6: {
                    return ElementTextParameter.getParameter();
                }
                case 7: {
                    return InViewParameter.getParameter();
                }
                case 8: {
                    return TextParameter.getParameter();
                }
                case 9: {
                    return TopElementParameter.getParameter();
                }
                case 10: {
                    return TopPositionParameter.getParameter();
                }
                case 11: {
                    return TypeParameter.getParameter();
                }
            }
        }
        return null;
    }

    static boolean doCommand(View view, String parameters) {
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (st.countTokens() == 0) {
            return CommandHandler.noParameters(view, "block");
        }
        String token = st.nextToken();
        if (token.equalsIgnoreCase("clear")) {
            return BlockCommand.clear(view, st);
        }
        if (token.equalsIgnoreCase("copy")) {
            return BlockCommand.copy(view, st);
        }
        if (token.equalsIgnoreCase("delete")) {
            return BlockCommand.delete(view, st);
        }
        if (token.equalsIgnoreCase("fill")) {
            return BlockCommand.fill(view, st);
        }
        if (token.equalsIgnoreCase("find")) {
            return BlockCommand.find(view, st);
        }
        if (token.equalsIgnoreCase("lowerCase")) {
            return BlockCommand.lowerCase(view, st);
        }
        if (token.equalsIgnoreCase("move")) {
            return BlockCommand.move(view, st);
        }
        if (token.equalsIgnoreCase("overlay")) {
            return BlockCommand.overlay(view, st);
        }
        if (token.equalsIgnoreCase("set")) {
            return BlockCommand.set(view, st);
        }
        if (token.equalsIgnoreCase("shift")) {
            return BlockCommand.shift(view, st);
        }
        if (token.equalsIgnoreCase("upperCase")) {
            return BlockCommand.upperCase(view, st);
        }
        return CommandHandler.invalidParameter(view, token, "block");
    }

    private static boolean clear(View view, LpexStringTokenizer st) {
        if (st.hasMoreTokens()) {
            return CommandHandler.invalidParameter(view, st.nextToken(), "block clear");
        }
        Block block = view == null ? Block.lpexBlock() : view.block();
        block.clear();
        return true;
    }

    private static boolean copy(View view, LpexStringTokenizer st) {
        if (st.hasMoreTokens()) {
            return CommandHandler.invalidParameter(view, st.nextToken(), "block copy");
        }
        if (view != null) {
            view.block().copy(view);
        }
        return true;
    }

    private static boolean delete(View view, LpexStringTokenizer st) {
        if (st.hasMoreTokens()) {
            return CommandHandler.invalidParameter(view, st.nextToken(), "block delete");
        }
        Block block = view == null ? Block.lpexBlock() : view.block();
        block.delete();
        return true;
    }

    private static boolean move(View view, LpexStringTokenizer st) {
        if (st.hasMoreTokens()) {
            return CommandHandler.invalidParameter(view, st.nextToken(), "block move");
        }
        if (view != null) {
            view.block().move(view);
        }
        return true;
    }

    private static boolean fill(View view, LpexStringTokenizer st) {
        String token = " ";
        if (st.hasMoreTokens()) {
            token = st.remainingText();
            if (LpexStringTokenizer.isValidQuotedString(token)) {
                token = LpexStringTokenizer.removeQuotes(token);
            }
            if (token.length() == 0) {
                token = " ";
            }
        }
        Block block = view == null ? Block.lpexBlock() : view.block();
        block.fill(token);
        return true;
    }

    private static boolean find(View view, LpexStringTokenizer st) {
        Block block;
        Block block2 = block = view == null ? Block.lpexBlock() : view.block();
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase("end")) {
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "block find end");
                }
                if (block.view() != null) {
                    block.view().documentPosition().blockBottom();
                    return true;
                }
            } else {
                return CommandHandler.invalidParameter(view, token, "block find");
            }
        }
        if (block.view() != null) {
            block.view().documentPosition().blockTop();
        }
        return true;
    }

    private static boolean lowerCase(View view, LpexStringTokenizer st) {
        if (st.hasMoreTokens()) {
            return CommandHandler.invalidParameter(view, st.nextToken(), "block lowerCase");
        }
        Block block = view == null ? Block.lpexBlock() : view.block();
        block.lowerCase();
        return true;
    }

    private static boolean upperCase(View view, LpexStringTokenizer st) {
        if (st.hasMoreTokens()) {
            return CommandHandler.invalidParameter(view, st.nextToken(), "block upperCase");
        }
        Block block = view == null ? Block.lpexBlock() : view.block();
        block.upperCase();
        return true;
    }

    private static boolean overlay(View view, LpexStringTokenizer st) {
        boolean transparent = false;
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase("transparent")) {
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "block overlay transparent");
                }
                transparent = true;
            } else {
                return CommandHandler.invalidParameter(view, token, "block overlay");
            }
        }
        if (view != null) {
            view.block().overlay(view, transparent);
        }
        return true;
    }

    private static boolean set(View view, LpexStringTokenizer st) {
        if (st.hasMoreTokens()) {
            String token;
            String type = token = st.nextToken();
            int blockType = 0;
            if (type.equalsIgnoreCase("stream")) {
                blockType = 1;
            } else if (type.equalsIgnoreCase("character")) {
                blockType = 2;
            } else if (type.equalsIgnoreCase("element")) {
                blockType = 4;
            } else if (type.equalsIgnoreCase("rectangle")) {
                blockType = 3;
            } else {
                return CommandHandler.invalidParameter(view, token, "block set");
            }
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "block set " + type);
            }
            if (view != null) {
                view.block().set(blockType, view);
            }
            return true;
        }
        if (view != null) {
            view.block().set(view);
        }
        return true;
    }

    private static boolean shift(View view, LpexStringTokenizer st) {
        boolean right = true;
        int count = 1;
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            String direction = token;
            if (direction.equalsIgnoreCase("left")) {
                right = false;
                token = null;
            } else if (direction.equalsIgnoreCase("right")) {
                token = null;
            }
            if (token == null && st.hasMoreTokens()) {
                token = st.nextToken();
            }
            if (token != null) {
                try {
                    count = Integer.parseInt(token);
                }
                catch (NumberFormatException e) {
                    return CommandHandler.invalidParameter(view, token, "block shift");
                }
            }
            if (st.hasMoreTokens()) {
                return CommandHandler.invalidParameter(view, st.nextToken(), "block shift");
            }
        }
        if (!right) {
            count = -count;
        }
        Block block = view == null ? Block.lpexBlock() : view.block();
        block.shift(count);
        return true;
    }

    static final class AnythingSelectedParameter
    extends ParameterOnOffQuery {
        private static AnythingSelectedParameter _parameter;

        static AnythingSelectedParameter getParameter() {
            if (_parameter == null) {
                _parameter = new AnythingSelectedParameter();
            }
            return _parameter;
        }

        private AnythingSelectedParameter() {
            super("block.anythingSelected");
        }

        @Override
        boolean value(View view, LpexDocumentLocation documentLocation, String qualifier) {
            Block block = view == null ? Block.lpexBlock() : view.block();
            return block.anythingSelected();
        }
    }

    static final class BottomElementParameter
    extends ParameterIntegerQuery {
        private static BottomElementParameter _parameter;

        static BottomElementParameter getParameter() {
            if (_parameter == null) {
                _parameter = new BottomElementParameter();
            }
            return _parameter;
        }

        private BottomElementParameter() {
            super("block.bottomElement");
        }

        @Override
        boolean isQueryAvailable(View view, LpexDocumentLocation documentLocation, String qualifier) {
            return true;
        }

        @Override
        int value(View view, LpexDocumentLocation documentLocation, String qualifier) {
            Element element;
            Block block = view == null ? Block.lpexBlock() : view.block();
            if ((view = block.view()) != null && (element = block.bottomElement()) != null) {
                return view.document().elementList().ordinalOf(element) + view.document().linesBeforeStart();
            }
            return 0;
        }
    }

    static final class BottomPositionParameter
    extends ParameterIntegerQuery {
        private static BottomPositionParameter _parameter;

        static BottomPositionParameter getParameter() {
            if (_parameter == null) {
                _parameter = new BottomPositionParameter();
            }
            return _parameter;
        }

        private BottomPositionParameter() {
            super("block.bottomPosition");
        }

        @Override
        boolean isQueryAvailable(View view, LpexDocumentLocation documentLocation, String qualifier) {
            return true;
        }

        @Override
        int value(View view, LpexDocumentLocation documentLocation, String qualifier) {
            Block block = view == null ? Block.lpexBlock() : view.block();
            return block.view() != null ? block.bottomPosition() : 0;
        }
    }

    static final class DefaultTypeParameter
    extends ParameterDefault {
        private static DefaultTypeParameter _parameter;
        private int _installValue;
        protected boolean _installValueLoaded;
        private int _defaultValue;
        protected boolean _defaultValueLoaded;

        static DefaultTypeParameter getParameter() {
            if (_parameter == null) {
                _parameter = new DefaultTypeParameter();
            }
            return _parameter;
        }

        private DefaultTypeParameter() {
            super("block.defaultType");
            Install.addProfileChangedListener(new Install.ProfileChangedListener(){

                @Override
                public void profileChanged() {
                    _installValueLoaded = false;
                }
            });
            Profile.addProfileChangedListener(new Profile.ProfileChangedListener(){

                @Override
                public void profileChanged() {
                    _defaultValueLoaded = false;
                }
            });
        }

        @Override
        String name(String qualifier) {
            return this.name();
        }

        int installValue() {
            if (!this._installValueLoaded) {
                String value = Install.getString("install." + this.name());
                this._installValue = value == null ? 1 : (value.equalsIgnoreCase("character") ? 2 : (value.equalsIgnoreCase("element") ? 4 : (value.equalsIgnoreCase("rectangle") ? 3 : 1)));
                this._installValueLoaded = true;
            }
            return this._installValue;
        }

        int defaultValue() {
            if (!this._defaultValueLoaded) {
                String value = Profile.getString("default." + this.name());
                this._defaultValue = value == null ? 0 : (value.equalsIgnoreCase("character") ? 2 : (value.equalsIgnoreCase("element") ? 4 : (value.equalsIgnoreCase("rectangle") ? 3 : 1)));
                this._defaultValueLoaded = true;
            }
            return this._defaultValue;
        }

        int currentValue(View view) {
            int value = this.value(view);
            if (value == 0 && (value = this.defaultValue()) == 0) {
                value = this.installValue();
            }
            return value;
        }

        @Override
        boolean set(View view, String qualifier, String parameters) {
            int value = 0;
            LpexStringTokenizer st = new LpexStringTokenizer(parameters);
            if (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.equalsIgnoreCase("stream")) {
                    value = 1;
                } else if (token.equalsIgnoreCase("character")) {
                    value = 2;
                } else if (token.equalsIgnoreCase("element")) {
                    value = 4;
                } else if (token.equalsIgnoreCase("rectangle")) {
                    value = 3;
                } else if (token.equalsIgnoreCase("default")) {
                    value = 0;
                } else {
                    return CommandHandler.invalidParameter(view, token, "set " + this.name());
                }
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "set " + this.name());
                }
            }
            return this.setValue(view, value);
        }

        boolean setValue(View view, int value) {
            if (view != null) {
                view.blockCommandSettings()._defaultType = value;
            }
            return true;
        }

        @Override
        boolean setDefault(View view, String qualifier, String parameters) {
            int value = 0;
            String token = null;
            LpexStringTokenizer st = new LpexStringTokenizer(parameters);
            if (st.hasMoreTokens()) {
                token = st.nextToken();
                if (token.equalsIgnoreCase("stream")) {
                    value = 1;
                } else if (token.equalsIgnoreCase("character")) {
                    value = 2;
                } else if (token.equalsIgnoreCase("element")) {
                    value = 4;
                } else if (token.equalsIgnoreCase("rectangle")) {
                    value = 3;
                } else if (token.equalsIgnoreCase("install")) {
                    value = 0;
                } else {
                    return CommandHandler.invalidParameter(view, token, "set default." + this.name());
                }
                if (st.hasMoreTokens()) {
                    return CommandHandler.invalidParameter(view, st.nextToken(), "set default." + this.name());
                }
            }
            this._defaultValue = value;
            this._defaultValueLoaded = true;
            if (this._defaultValue != 0) {
                Profile.putString("default." + this.name(), token);
            } else {
                Profile.remove("default." + this.name());
            }
            return true;
        }

        @Override
        String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
            if (view != null) {
                int value = this.value(view);
                return value == 0 ? "default" : DefaultTypeParameter.getTypeName(value);
            }
            return null;
        }

        int value(View view) {
            return view != null ? view.blockCommandSettings()._defaultType : 0;
        }

        @Override
        String queryInstall(String qualifier) {
            return DefaultTypeParameter.getTypeName(this.installValue());
        }

        @Override
        String queryDefault(String qualifier) {
            int value = this.defaultValue();
            return value == 0 ? "install" : DefaultTypeParameter.getTypeName(value);
        }

        @Override
        String queryCurrent(View view, String qualifier) {
            return DefaultTypeParameter.getTypeName(this.currentValue(view));
        }

        static String getTypeName(int type) {
            switch (type) {
                case 1: {
                    return "stream";
                }
                case 2: {
                    return "character";
                }
                case 4: {
                    return "element";
                }
                case 3: {
                    return "rectangle";
                }
            }
            return null;
        }
    }

    static final class DragAndDropParameter
    extends ParameterOnOffDefault {
        private static DragAndDropParameter _parameter;

        static DragAndDropParameter getParameter() {
            if (_parameter == null) {
                _parameter = new DragAndDropParameter();
            }
            return _parameter;
        }

        private DragAndDropParameter() {
            super("block.dragAndDrop", LpexUtilities.getPlatform() == 1);
        }

        @Override
        boolean setValue(View view, int value) {
            LpexWindow lpexWindow;
            if (view != null && LpexUtilities.okToUse((Widget)(lpexWindow = view.window()))) {
                ((TextWindow)lpexWindow.textWindow()).setDragAndDrop(value);
                this.currentValueChanged(view);
            }
            return true;
        }

        @Override
        void currentValueChanged(View view) {
            LpexWindow lpexWindow;
            if (view != null && LpexUtilities.okToUse((Widget)(lpexWindow = view.window()))) {
                ((TextWindow)lpexWindow.textWindow()).dragAndDropChanged();
            }
        }

        @Override
        int value(View view) {
            LpexWindow lpexWindow;
            if (view != null && LpexUtilities.okToUse((Widget)(lpexWindow = view.window()))) {
                return ((TextWindow)lpexWindow.textWindow()).dragAndDrop();
            }
            return 2;
        }
    }

    static final class ElementTextParameter
    extends ParameterQuery {
        private static ElementTextParameter _parameter;

        static ElementTextParameter getParameter() {
            if (_parameter == null) {
                _parameter = new ElementTextParameter();
            }
            return _parameter;
        }

        private ElementTextParameter() {
            super("block.elementText");
        }

        @Override
        String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
            Element element;
            if (view != null && documentLocation != null && (element = view.document().elementList().elementAt(documentLocation.element)) != null && view.block().partOfBlock(view, element)) {
                StringBuilder buffer = new StringBuilder(element.length());
                view.block().getSelectedText(view, element, buffer);
                return buffer.toString();
            }
            return null;
        }
    }

    static final class InViewParameter
    extends ParameterOnOffQuery {
        private static InViewParameter _parameter;

        static InViewParameter getParameter() {
            if (_parameter == null) {
                _parameter = new InViewParameter();
            }
            return _parameter;
        }

        private InViewParameter() {
            super("block.inView");
        }

        @Override
        boolean value(View view, LpexDocumentLocation documentLocation, String qualifier) {
            Block block;
            Block block2 = block = view == null ? Block.lpexBlock() : view.block();
            return block.view() == view;
        }
    }

    static final class Settings {
        int _defaultType = 0;

        Settings() {
        }
    }

    static final class TextParameter
    extends ParameterQuery {
        private static TextParameter _parameter;

        static TextParameter getParameter() {
            if (_parameter == null) {
                _parameter = new TextParameter();
            }
            return _parameter;
        }

        private TextParameter() {
            super("block.text");
        }

        @Override
        String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
            Block block = view == null ? Block.lpexBlock() : view.block();
            return block.selectedText();
        }
    }

    static final class TopElementParameter
    extends ParameterIntegerQuery {
        private static TopElementParameter _parameter;

        static TopElementParameter getParameter() {
            if (_parameter == null) {
                _parameter = new TopElementParameter();
            }
            return _parameter;
        }

        private TopElementParameter() {
            super("block.topElement");
        }

        @Override
        boolean isQueryAvailable(View view, LpexDocumentLocation documentLocation, String qualifier) {
            return true;
        }

        @Override
        int value(View view, LpexDocumentLocation documentLocation, String qualifier) {
            Element element;
            Block block = view == null ? Block.lpexBlock() : view.block();
            if ((view = block.view()) != null && (element = block.topElement()) != null) {
                return view.document().elementList().ordinalOf(element) + view.document().linesBeforeStart();
            }
            return 0;
        }
    }

    static final class TopPositionParameter
    extends ParameterIntegerQuery {
        private static TopPositionParameter _parameter;

        static TopPositionParameter getParameter() {
            if (_parameter == null) {
                _parameter = new TopPositionParameter();
            }
            return _parameter;
        }

        private TopPositionParameter() {
            super("block.topPosition");
        }

        @Override
        boolean isQueryAvailable(View view, LpexDocumentLocation documentLocation, String qualifier) {
            return true;
        }

        @Override
        int value(View view, LpexDocumentLocation documentLocation, String qualifier) {
            Block block = view == null ? Block.lpexBlock() : view.block();
            return block.view() != null ? block.topPosition() : 0;
        }
    }

    static final class TypeParameter
    extends ParameterQuery {
        private static TypeParameter _parameter;

        static TypeParameter getParameter() {
            if (_parameter == null) {
                _parameter = new TypeParameter();
            }
            return _parameter;
        }

        private TypeParameter() {
            super("block.type");
        }

        @Override
        String query(View view, LpexDocumentLocation documentLocation, String qualifier) {
            Block block = view == null ? Block.lpexBlock() : view.block();
            switch (block.type()) {
                case 1: {
                    return "stream";
                }
                case 2: {
                    return "character";
                }
                case 4: {
                    return "element";
                }
                case 3: {
                    return "rectangle";
                }
            }
            return "none";
        }
    }
}

