/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.BlockCommand;
import com.ibm.lpex.core.DisplayTextLayout;
import com.ibm.lpex.core.DocumentPosition;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ElementList;
import com.ibm.lpex.core.ElementView;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.ProcessPrefixCommand;
import com.ibm.lpex.core.RtfWriter;
import com.ibm.lpex.core.Screen;
import com.ibm.lpex.core.TextFontMetrics;
import com.ibm.lpex.core.View;

final class Block {
    private static final Block _lpexBlock = new Block();
    private static String _platformEol = System.getProperty("line.separator");
    static final int NONE = 0;
    static final int STREAM = 1;
    static final int CHARACTER = 2;
    static final int RECTANGLE = 3;
    static final int ELEMENT = 4;
    private int _type = 0;
    private View _view;
    private Element _anchorElement;
    private int _anchorPosition;
    private Element _selectionElement;
    private int _selectionPosition;
    private int _ignoreTextInsertedCount;

    Block() {
    }

    static Block lpexBlock() {
        return _lpexBlock;
    }

    int type() {
        return this._type;
    }

    boolean anythingSelected() {
        return this.selectionVisible() && (this._type != 1 || this._anchorElement != this._selectionElement || this._anchorPosition != this._selectionPosition);
    }

    boolean anythingUnprotectedSelected() {
        if (this.anythingSelected()) {
            Element lastElement = this.bottomElement().next();
            Element element = this.topElement();
            while (element != lastElement) {
                if (element.visible(this._view) && !this._view.markList().protect(element)) {
                    return true;
                }
                element = element.next();
            }
        }
        return false;
    }

    boolean anythingNonshowUnprotectedSelected() {
        if (this.anythingSelected()) {
            Element lastElement = this.bottomElement().next();
            Element element = this.topElement();
            while (element != lastElement) {
                if (!element.show() && element.visible(this._view) && !this._view.markList().protect(element)) {
                    return true;
                }
                element = element.next();
            }
        }
        return false;
    }

    boolean anythingProtectedSelected() {
        if (this.anythingSelected()) {
            Element lastElement = this.bottomElement().next();
            Element element = this.topElement();
            while (element != lastElement) {
                if (element.visible(this._view) && this._view.markList().protect(element)) {
                    return true;
                }
                element = element.next();
            }
        }
        return false;
    }

    private boolean selectionVisible() {
        return this.topElement() != null;
    }

    View view() {
        return this._view;
    }

    Element anchorElement() {
        return this._anchorElement;
    }

    int anchorPosition() {
        int position = this._anchorPosition;
        if (this._type == 4) {
            if (this.anchorAtTop()) {
                position = 1;
            } else if (this._anchorElement != null) {
                position = this._anchorElement.end();
            }
        }
        return position;
    }

    void set(int type, View view, Element element, int position) {
        if (element == null) {
            return;
        }
        if (type < 0 || type > 4) {
            type = 0;
        }
        if (type != this._type || type == 0 || view != this._view || !this.selectionVisible()) {
            this.clear();
        }
        if (type != 0) {
            if (this._type == 0) {
                this._type = type;
                this._view = view;
                this._anchorElement = element;
                this._anchorPosition = position;
            }
            this._selectionElement = element;
            this._selectionPosition = position;
        }
    }

    void set(int type, View view) {
        if (view != null) {
            this.set(type, view, view.documentPosition().element(), view.documentPosition().position());
        }
    }

    void set(View view) {
        if (view != null) {
            int type;
            int n = type = view == this._view ? this._type : 0;
            if (type == 0 || !this.selectionVisible()) {
                type = BlockCommand.DefaultTypeParameter.getParameter().currentValue(view);
            }
            this.set(type, view);
        }
    }

    void clear() {
        this._view = null;
        this._anchorElement = null;
        this._selectionElement = null;
        this._type = 0;
    }

    void validate() {
        DocumentPosition documentPosition;
        if (this._type == 1 && ((documentPosition = this._view.documentPosition()).element() != this._selectionElement || documentPosition.position() != this._selectionPosition)) {
            this.clear();
        }
    }

    boolean anchorAtTop() {
        boolean anchorAtTop = false;
        if (this._anchorElement != null) {
            ElementList elementList;
            anchorAtTop = this._anchorElement != this._selectionElement ? (elementList = this._view.document().elementList()).ordinalOf(this._anchorElement) <= elementList.ordinalOf(this._selectionElement) : (this._type != 4 ? this._anchorPosition <= this._selectionPosition : true);
        }
        return anchorAtTop;
    }

    void elementRemoved(Element element) {
        if (element == this._anchorElement) {
            if (this._type == 1 || this._anchorElement == this._selectionElement) {
                this.clear();
            } else {
                if (this.anchorAtTop()) {
                    this._anchorElement = element.next();
                    this._anchorPosition = 1;
                } else {
                    this._anchorElement = element.prev();
                    this._anchorPosition = this._anchorElement.length();
                    if (this._anchorPosition == 0) {
                        this._anchorPosition = 1;
                    }
                }
                if (this._anchorElement == null) {
                    this.clear();
                }
            }
        }
        if (element == this._selectionElement) {
            if (this._type == 1) {
                this.clear();
            } else {
                if (!this.anchorAtTop()) {
                    this._selectionElement = element.next();
                    this._selectionPosition = 1;
                } else {
                    this._selectionElement = element.prev();
                    this._selectionPosition = element.length();
                    if (this._selectionPosition == 0) {
                        this._selectionPosition = 1;
                    }
                }
                if (this._selectionElement == null) {
                    this.clear();
                }
            }
        }
    }

    private boolean ignoreTextInserted() {
        return this._ignoreTextInsertedCount > 0;
    }

    void setIgnoreTextInserted() {
        ++this._ignoreTextInsertedCount;
    }

    void resetIgnoreTextInserted() {
        if (this._ignoreTextInsertedCount > 0) {
            --this._ignoreTextInsertedCount;
        }
    }

    void textInserted(View view, Element element, int position, int insertLength) {
        if (this._type == 0 || this._type == 4 || this._type == 3 && this._anchorElement != this._selectionElement || this._type == 1 && this._anchorPosition == this._selectionPosition) {
            return;
        }
        if (this.ignoreTextInserted()) {
            return;
        }
        if (element == this.topElement()) {
            if (this.anchorAtTop()) {
                if (position < this._anchorPosition) {
                    this._anchorPosition += insertLength;
                }
            } else if (this._type == 1) {
                if (position <= this._selectionPosition) {
                    this._selectionPosition += insertLength;
                    if (element == this._view.documentPosition().element()) {
                        this._view.documentPosition().right(insertLength);
                    }
                }
            } else if (position < this._selectionPosition) {
                this._selectionPosition += insertLength;
            }
        }
        if (element == this.bottomElement()) {
            if (this.anchorAtTop()) {
                if (this._type == 1) {
                    if (position <= this._selectionPosition) {
                        this._selectionPosition += insertLength;
                        if (element == this._view.documentPosition().element()) {
                            this._view.documentPosition().right(insertLength);
                        }
                    }
                } else if (position <= this._selectionPosition) {
                    this._selectionPosition += insertLength;
                }
            } else if (this._type == 1 && position < this._anchorPosition || this._type != 1 && position <= this._anchorPosition) {
                this._anchorPosition += insertLength;
            }
        }
    }

    void textDeleted(View view, Element element, int position, int deleteLength) {
        if (this._type == 0 || this._type == 4 || this._type == 3 && this._anchorElement != this._selectionElement || this._type == 1 && this._anchorPosition == this._selectionPosition) {
            return;
        }
        if (element == this.topElement()) {
            if (this.anchorAtTop()) {
                if (position < this._anchorPosition) {
                    this._anchorPosition -= deleteLength;
                    if (this._anchorPosition < position) {
                        this._anchorPosition = position;
                    }
                }
            } else if (position < this._selectionPosition) {
                if (deleteLength > this._selectionPosition - position + 1) {
                    deleteLength = this._selectionPosition - position + 1;
                }
                this._selectionPosition -= deleteLength;
                if (this._type == 1 && element == this._view.documentPosition().element()) {
                    this._view.documentPosition().left(deleteLength);
                }
            }
        }
        if (element == this.bottomElement()) {
            if (this.anchorAtTop()) {
                if (this._type == 1 && position < this._selectionPosition) {
                    if (deleteLength > this._selectionPosition - position) {
                        deleteLength = this._selectionPosition - position;
                    }
                    this._selectionPosition -= deleteLength;
                    if (element == this._view.documentPosition().element()) {
                        this._view.documentPosition().left(deleteLength);
                    }
                } else if (this._type != 1 && position <= this._selectionPosition) {
                    this._selectionPosition -= deleteLength;
                    if (this._selectionPosition < position) {
                        if (this._anchorPosition == position && this._selectionElement == this._anchorElement) {
                            this.clear();
                        } else {
                            this._selectionPosition = position - 1;
                            if (this._selectionPosition == 0) {
                                this._selectionElement = this._selectionElement.prev();
                                if (this._selectionElement == null) {
                                    this.clear();
                                } else {
                                    this._selectionPosition = Math.max(1, this._selectionElement.length());
                                }
                            }
                        }
                    }
                }
            } else if (this._type == 1 && position < this._anchorPosition) {
                this._anchorPosition -= deleteLength;
                if (this._anchorPosition < position + 1) {
                    if (this._selectionPosition == position && this._selectionElement == this._anchorElement) {
                        this.clear();
                    } else {
                        this._anchorPosition = position;
                    }
                }
            } else if (this._type != 1 && position <= this._anchorPosition) {
                this._anchorPosition -= deleteLength;
                if (this._anchorPosition < position) {
                    if (this._selectionPosition == position && this._selectionElement == this._anchorElement) {
                        this.clear();
                    } else {
                        this._anchorPosition = position - 1;
                        if (this._anchorPosition == 0) {
                            this._anchorElement = this._anchorElement.prev();
                            if (this._anchorElement == null) {
                                this.clear();
                            } else {
                                this._anchorPosition = Math.max(1, this._anchorElement.length());
                            }
                        }
                    }
                }
            }
        }
    }

    boolean partOfBlock(View view, Element element) {
        if (view != null && element != null && view == this._view && element.visible(this._view) && this.anythingSelected()) {
            ElementList elementList = view.document().elementList();
            int elementOrdinal = elementList.ordinalOf(element);
            return elementOrdinal >= elementList.ordinalOf(this.topElement()) && elementOrdinal <= elementList.ordinalOf(this.bottomElement());
        }
        return false;
    }

    boolean partOfBlock(View view, int x, int y) {
        Element e;
        Screen screen;
        int row;
        TextFontMetrics textFontMetrics;
        if (view != null && view == this._view && (textFontMetrics = view.screen().textFontMetrics()) != null && (row = y / textFontMetrics.textHeight() + 1) <= (screen = view.screen()).rows() && this.partOfBlock(view, e = screen.element(row))) {
            x += screen.scroll() - screen.expandHideAreaWidth() - screen.prefixAreaWidth();
            switch (this._type) {
                case 1: 
                case 2: {
                    if (LpexUtilities.isBidi()) {
                        int[] blockSegments = DisplayTextLayout.charBlockSegments(e.elementView(view));
                        int i = 0;
                        while (i < blockSegments.length) {
                            if (x >= blockSegments[i] && x <= blockSegments[i + 1]) {
                                return true;
                            }
                            i += 2;
                        }
                        return false;
                    }
                    int leftPixelPosition = e.elementView(view).pixelPosition(this.selectedTextStart(view, e));
                    int rightPixelPosition = e.elementView(view).pixelCharPosition(this.selectedTextEnd(view, e) + 1);
                    return x >= leftPixelPosition && x <= rightPixelPosition;
                }
                case 3: {
                    return x >= this.leftPixelPosition() && x <= this.rightPixelPosition();
                }
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean allShow() {
        Element lastElement = this.bottomElement().next();
        Element element = this.topElement();
        while (element != lastElement) {
            if (element.visible(this._view) && !element.show()) {
                return false;
            }
            element = element.next();
        }
        return true;
    }

    Element topElement() {
        Element lastElement;
        boolean anchorAtTop = this.anchorAtTop();
        Element element = lastElement = anchorAtTop ? this._selectionElement : this._anchorElement;
        if (lastElement != null) {
            lastElement = lastElement.next();
        }
        Element topElement = anchorAtTop ? this._anchorElement : this._selectionElement;
        while (topElement != null && topElement != lastElement) {
            if (topElement.visible(this._view)) {
                return topElement;
            }
            topElement = topElement.next();
        }
        return null;
    }

    int topPosition() {
        Element topElement = this.topElement();
        if (this.anchorAtTop()) {
            return this._type == 4 || topElement != this._anchorElement && this._type != 3 ? 1 : this._anchorPosition;
        }
        return this._type == 4 || topElement != this._selectionElement && this._type != 3 ? 1 : this._selectionPosition;
    }

    Element bottomElement() {
        Element firstElement;
        boolean anchorAtTop = this.anchorAtTop();
        Element element = firstElement = anchorAtTop ? this._anchorElement : this._selectionElement;
        if (firstElement != null) {
            firstElement = firstElement.prev();
        }
        Element bottomElement = anchorAtTop ? this._selectionElement : this._anchorElement;
        while (bottomElement != null && bottomElement != firstElement) {
            if (bottomElement.visible(this._view)) {
                return bottomElement;
            }
            bottomElement = bottomElement.prev();
        }
        return null;
    }

    int bottomPosition() {
        Element bottomElement = this.bottomElement();
        if (this.anchorAtTop()) {
            if (this._type == 4 || bottomElement != this._selectionElement && this._type != 3) {
                return bottomElement != null ? bottomElement.end() : 1;
            }
            return this._selectionPosition;
        }
        if (this._type == 4 || bottomElement != this._anchorElement && this._type != 3) {
            return bottomElement != null ? bottomElement.end() : 1;
        }
        return this._anchorPosition;
    }

    int leftPixelPosition() {
        int leftBottom;
        if (this._type != 3 || !this.anythingSelected()) {
            return 0;
        }
        int leftTop = this.topElement().elementView(this._view).pixelPosition(this.topPosition());
        return leftTop < (leftBottom = this.bottomElement().elementView(this._view).pixelPosition(this.bottomPosition())) ? leftTop : leftBottom;
    }

    int rightPixelPosition() {
        if (this._type != 3 || !this.anythingSelected()) {
            return 0;
        }
        Element topElement = this.topElement();
        int topPosition = this.topPosition();
        int rightTop = topElement.elementView(this._view).pixelCharPosition(topPosition) + this._view.charWidth(topElement, topPosition);
        Element bottomElement = this.bottomElement();
        int bottomPosition = this.bottomPosition();
        int rightBottom = bottomElement.elementView(this._view).pixelCharPosition(bottomPosition) + this._view.charWidth(bottomElement, bottomPosition);
        return rightBottom > rightTop ? rightBottom : rightTop;
    }

    int leftPosition(View view, Element element) {
        if (!this.partOfBlock(view, element) || element.length() == 0) {
            return 0;
        }
        int leftPosition = 1;
        switch (this._type) {
            case 1: 
            case 2: {
                if (this.topElement() == element) {
                    leftPosition = this.topPosition();
                    break;
                }
                if (this._type != 1 || this.bottomElement() != element || this.bottomPosition() > 1) break;
                leftPosition = 0;
                break;
            }
            case 3: {
                leftPosition = view.position(element.elementView(view), this.leftPixelPosition());
                break;
            }
        }
        if (element.length() < leftPosition) {
            leftPosition = 0;
        }
        return leftPosition;
    }

    int rightPosition(View view, Element element) {
        if (!this.partOfBlock(view, element) || element.length() == 0) {
            return 0;
        }
        int rightPosition = element.length();
        switch (this._type) {
            case 1: 
            case 2: {
                if (this.bottomElement() == element) {
                    int rightBlockPosition = this.bottomPosition();
                    if (this._type == 1) {
                        --rightBlockPosition;
                    }
                    if (rightBlockPosition >= rightPosition) break;
                    rightPosition = rightBlockPosition;
                    break;
                }
                if (this.topElement() != element || this.topPosition() <= rightPosition) break;
                rightPosition = 0;
                break;
            }
            case 3: {
                int rightBlockPosition = view.position(element.elementView(view), this.rightPixelPosition() - 1);
                if (rightBlockPosition >= rightPosition) break;
                rightPosition = rightBlockPosition;
                break;
            }
        }
        return rightPosition;
    }

    void delete() {
        if (this.anythingUnprotectedSelected() && this._view.changeAllowed()) {
            View view = this._view;
            switch (this._type) {
                case 1: 
                case 2: {
                    Element topElement = this.topElement();
                    Element bottomElement = this.bottomElement();
                    if (topElement != bottomElement || topElement != this._view.documentPosition().element()) {
                        this._view.document().resetUserActionElements();
                    }
                    int topPosition = this.topPosition();
                    int bottomPosition = this.bottomPosition();
                    if (this._type == 2) {
                        ++bottomPosition;
                    }
                    this.clear();
                    if (topElement != bottomElement && topElement.next() != bottomElement) {
                        this.deleteElements(view, topElement.next(), bottomElement.prev());
                    }
                    view.deleteText(topElement, topPosition, bottomElement, bottomPosition);
                    break;
                }
                case 4: {
                    this._view.document().resetUserActionElements();
                    Element first = this.topElement();
                    Element last = this.bottomElement();
                    this.clear();
                    this.deleteElements(view, first, last);
                    break;
                }
                case 3: {
                    this._view.document().resetUserActionElements();
                    int leftPosition = this.leftPixelPosition();
                    int rightPosition = this.rightPixelPosition();
                    Element element = this.topElement();
                    while (element != null && this._type != 0 && element != this.bottomElement().next()) {
                        ElementView elementView;
                        if (!element.show() && !this._view.markList().protect(element) && (elementView = element.elementView(this._view)).visible()) {
                            int startPosition = this._view.position(elementView, leftPosition);
                            int endPosition = this._view.position(elementView, rightPosition - 1);
                            this._view.deleteText(element, startPosition, endPosition - startPosition + 1);
                        }
                        element = element.next();
                    }
                    this.clear();
                    break;
                }
                default: {
                    return;
                }
            }
            view.verifyDocumentSection();
        }
    }

    void deleteElements(View view, Element first, Element last) {
        Element beforeFirst = first.prev();
        Element afterLast = last.next();
        Element e = first;
        while (e != null && e != afterLast) {
            if (e.visible(view) && !view.markList().protect(e)) {
                e.setDeletePending(true);
            }
            e = e.next();
        }
        boolean forceAllVisible = view.setForceAllVisible(true);
        e = last;
        while (e != null && e != beforeFirst) {
            Element prev = e.prev();
            if (e.deletePending()) {
                e.setDeletePending(false);
                view.deleteElement(e);
            }
            e = prev;
        }
        view.setForceAllVisible(forceAllVisible);
        ProcessPrefixCommand.coalesceExcludes(view, beforeFirst, afterLast);
    }

    void copy(View view) {
        String text;
        Element element = view.documentPosition().element();
        if (element == null || view.markList().insertElementProtect(element)) {
            return;
        }
        if (view.changeAllowed() && (text = this.selectedText()) != null) {
            boolean hasLines;
            boolean bl = hasLines = this._type == 4 || this._anchorElement != this._selectionElement;
            if (hasLines) {
                view.document().resetUserActionElements();
            } else if (view.autoCheck()) {
                view.document().undo().checkPoint(view);
            }
            this.insertText(view, text, this._type, this._type);
            if (!hasLines && view.autoCheck()) {
                view.document().undo().checkPoint(view);
            }
        }
    }

    void move(View view) {
        Element element = view.documentPosition().element();
        if (!(element != null && this.anythingSelected() && this._view.changeAllowed() && view.changeAllowed())) {
            return;
        }
        if (this.movingOntoItself(view)) {
            if (this._view == view) {
                if (this._type == 1) {
                    view.documentPosition().jump(this._selectionElement, this._selectionPosition);
                }
            } else {
                this._view = view;
                int initialCursorRow = view.screen().row(view.documentPosition().element());
                if (this._type == 1) {
                    view.documentPosition().jump(this._selectionElement, this._selectionPosition);
                }
                if (initialCursorRow != 0) {
                    view.screen().setCursorRow(initialCursorRow);
                }
            }
            return;
        }
        String text = this.selectedText();
        if (text == null) {
            return;
        }
        view.document().resetUserActionElements();
        this._view.document().resetUserActionElements();
        int type = this._type;
        this.delete();
        this.insertText(view, text, type, type);
    }

    private boolean movingOntoItself(View view) {
        if (this._view != view && this._view.document() != view.document()) {
            return false;
        }
        Element element = view.documentPosition().element();
        if (this._type == 4) {
            return this.partOfBlock(this._view, element) || this.partOfBlock(this._view, element.next());
        }
        if (this._type == 1 || this._type == 2) {
            int bottomPosition = this.bottomPosition();
            if (this._type == 2) {
                ++bottomPosition;
            }
            return this.partOfBlock(this._view, element) && view.documentPosition().compare(this.topElement(), this.topPosition()) <= 0 && view.documentPosition().compare(this.bottomElement(), bottomPosition) >= 0;
        }
        int position = view.documentPosition().position();
        return this.partOfBlock(this._view, element) && element == this.topElement() && position >= this.selectedTextStart(this._view, element) && position <= this.selectedTextEnd(this._view, element) + 1;
    }

    void overlay(View view) {
        this.overlay(view, false);
    }

    void overlay(View view, boolean transparent) {
        Element element = view.documentPosition().element();
        if ((this._type == 3 || this._type == 4 || this._type == 2 && this._anchorElement == this._selectionElement) && !element.show() && !view.markList().protect(element) && view.changeAllowed()) {
            int type = this._type;
            view.document().resetUserActionElements();
            int position = view.documentPosition().position();
            int initialCursorRow = view.screen().cursorRow();
            String text = this.selectedText();
            if (this._type == 4) {
                view.overlayElements(text, transparent);
            } else {
                view.overlayRectangle(text, transparent);
            }
            this.clear();
            this.set(type, view, element, position);
            int endPosition = view.documentPosition().position();
            if ((type == 3 || type == 2) && endPosition > 1) {
                --endPosition;
            }
            this.set(type, view, view.documentPosition().element(), endPosition);
            view.documentPosition().jump(element, position);
            view.screen().setCursorRow(initialCursorRow);
        }
    }

    void insertText(View view, String text, int type, int newType) {
        boolean inserted;
        DocumentPosition documentPosition = view.documentPosition();
        Element initialElement = documentPosition.element();
        int initialPosition = documentPosition.position();
        int initialCursorRow = view.screen().row(initialElement);
        boolean someInsertDone = false;
        boolean ignoreFieldsSet = false;
        boolean forceAllVisible = false;
        if (type == 4) {
            forceAllVisible = view.setForceAllVisible(true);
        }
        if (type == 4 || initialElement == null || initialElement.show() || view.markList().protect(initialElement)) {
            documentPosition.end();
            if ((2 & view.insertText("\n")) != 0) {
                someInsertDone = true;
            }
            view.setIgnoreFields();
            ignoreFieldsSet = true;
        }
        Element startElement = documentPosition.element();
        int startPosition = documentPosition.position();
        int originalType = this._type;
        this._type = 0;
        boolean bl = type == 3 ? view.insertTextRectangle(text) : (inserted = (view.insertText(text) & 2) != 0);
        if (inserted) {
            someInsertDone = true;
        }
        this._type = originalType;
        if (someInsertDone) {
            this.clear();
            this.set(newType, view, startElement, startPosition);
            int endPosition = documentPosition.position();
            if ((newType == 2 || newType == 3) && endPosition > 1) {
                --endPosition;
            }
            this.set(newType, view, documentPosition.element(), endPosition);
            if (newType != 1) {
                documentPosition.jump(initialElement, initialPosition);
                if (initialCursorRow != 0) {
                    view.screen().setCursorRow(initialCursorRow);
                }
            }
        }
        if (ignoreFieldsSet) {
            view.resetIgnoreFields();
        }
        if (type == 4) {
            view.setForceAllVisible(forceAllVisible);
        }
    }

    void upperCase() {
        this.changeCase(true);
    }

    void lowerCase() {
        this.changeCase(false);
    }

    private void changeCase(boolean upperCase) {
        if (this.anythingUnprotectedSelected() && this._view.changeAllowed()) {
            this._view.document().resetUserActionElements();
            int bottomPosition = this.bottomPosition();
            if (this._type == 2) {
                ++bottomPosition;
            }
            this._view.changeCase(this.topElement(), this.topPosition(), this.bottomElement(), bottomPosition, upperCase, this._type == 3);
        }
    }

    void fill(String fillString) {
        if (this.anythingUnprotectedSelected() && this._view.changeAllowed()) {
            this._view.document().resetUserActionElements();
            Element topElement = this.topElement();
            Element bottomElement = this.bottomElement();
            Element lastElement = bottomElement.next();
            Element element = topElement;
            while (element != lastElement) {
                ElementView elementView;
                if (!element.show() && (elementView = element.elementView(this._view)).visible()) {
                    switch (this._type) {
                        case 1: 
                        case 2: {
                            if (element == topElement && element == bottomElement) {
                                int topPosition = this.topPosition();
                                int length = this.bottomPosition() - topPosition;
                                if (this._type == 2) {
                                    ++length;
                                }
                                this._view.fill(element, topPosition, length, fillString);
                                break;
                            }
                            if (element == topElement) {
                                this._view.fill(element, this.topPosition(), fillString);
                                break;
                            }
                            if (element == bottomElement) {
                                int length = this.bottomPosition();
                                if (this._type == 1) {
                                    --length;
                                }
                                this._view.fill(element, 1, length, fillString);
                                break;
                            }
                            this._view.fill(element, fillString);
                            break;
                        }
                        case 4: {
                            this._view.fill(element, fillString);
                            break;
                        }
                        case 3: {
                            int leftPosition = this._view.position(elementView, this.leftPixelPosition());
                            int rightPosition = this._view.position(elementView, this.rightPixelPosition() - 1);
                            this._view.fill(element, leftPosition, rightPosition - leftPosition + 1, fillString);
                            break;
                        }
                    }
                }
                element = element.next();
            }
        }
    }

    void shift(int count) {
        if ((this._type == 4 || this._type == 3 || this._type == 2 && this._anchorElement == this._selectionElement) && this.anythingUnprotectedSelected() && this._view.changeAllowed()) {
            int originalSelectionPosition = this._selectionPosition;
            int originalAnchorPosition = this._anchorPosition;
            this._view.document().resetUserActionElements();
            Element topElement = this.topElement();
            Element bottomElement = this.bottomElement();
            Element lastElement = bottomElement.next();
            Element element = topElement;
            while (element != lastElement) {
                ElementView elementView;
                if (!element.show() && (elementView = element.elementView(this._view)).visible()) {
                    if (this._type == 4) {
                        this._view.shiftElement(element, count, true);
                    } else if (this._type == 2) {
                        this._view.shift(element, this.topPosition(), count);
                    } else {
                        int position = this._view.position(elementView, this.leftPixelPosition());
                        this._view.shift(element, position, count);
                    }
                }
                element = element.next();
            }
            if (this._type == 3 || this._type == 2) {
                this._selectionPosition = originalSelectionPosition + count;
                this._anchorPosition = originalAnchorPosition + count;
                if (this._selectionPosition <= 0) {
                    this._selectionPosition = 1;
                }
                if (this._anchorPosition <= 0) {
                    this._anchorPosition = 1;
                }
            }
        }
    }

    private int selectedTextStart(View view, Element element) {
        if (!this.partOfBlock(view, element)) {
            return 0;
        }
        int start = 0;
        switch (this._type) {
            case 1: {
                Element topElement = this.topElement();
                Element bottomElement = this.bottomElement();
                if (topElement == bottomElement) {
                    if (element != topElement) break;
                    start = this.topPosition();
                    break;
                }
                if (element == topElement) {
                    int topPosition = this.topPosition();
                    if (topPosition > element.length()) break;
                    start = topPosition;
                    break;
                }
                if (element == bottomElement) {
                    if (this.bottomPosition() <= 1) break;
                    start = 1;
                    break;
                }
                if (element.length() <= 0) break;
                start = 1;
                break;
            }
            case 2: {
                Element topElement = this.topElement();
                Element bottomElement = this.bottomElement();
                if (topElement == bottomElement) {
                    if (element != topElement) break;
                    start = this.topPosition();
                    break;
                }
                if (element == topElement) {
                    int topPosition = this.topPosition();
                    if (topPosition > element.length()) break;
                    start = topPosition;
                    break;
                }
                if (element == bottomElement) {
                    start = 1;
                    break;
                }
                if (element.length() <= 0) break;
                start = 1;
                break;
            }
            case 4: {
                if (element.length() <= 0) break;
                start = 1;
                break;
            }
            case 3: {
                start = this._view.position(element.elementView(this._view), this.leftPixelPosition());
                break;
            }
        }
        return start;
    }

    private int selectedTextEnd(View view, Element element) {
        if (!this.partOfBlock(view, element)) {
            return 0;
        }
        int end = 0;
        switch (this._type) {
            case 1: {
                Element topElement = this.topElement();
                Element bottomElement = this.bottomElement();
                if (topElement == bottomElement) {
                    if (element != topElement) break;
                    end = this.bottomPosition() - 1;
                    break;
                }
                if (element == topElement) {
                    if (this.topPosition() > element.length()) break;
                    end = element.length();
                    break;
                }
                if (element == bottomElement) {
                    end = this.bottomPosition() - 1;
                    break;
                }
                end = element.length();
                break;
            }
            case 2: {
                Element topElement = this.topElement();
                Element bottomElement = this.bottomElement();
                if (topElement == bottomElement) {
                    if (element != topElement) break;
                    end = this.bottomPosition();
                    break;
                }
                if (element == topElement) {
                    if (this.topPosition() > element.length()) break;
                    end = element.length();
                    break;
                }
                if (element == bottomElement) {
                    end = this.bottomPosition();
                    break;
                }
                end = element.length();
                break;
            }
            case 4: {
                end = element.length();
                break;
            }
            case 3: {
                end = this._view.position(element.elementView(this._view), this.rightPixelPosition() - 1);
                break;
            }
        }
        return end;
    }

    private int selectedTextLength(View view, Element element) {
        int end;
        if (this._type == 3 && LpexUtilities.isBidi() && this.partOfBlock(view, element)) {
            return DisplayTextLayout.logicalTextLength(element.elementView(view), this.leftPixelPosition(), this.rightPixelPosition());
        }
        int len = 0;
        int start = this.selectedTextStart(view, element);
        if (start != 0 && (end = this.selectedTextEnd(view, element)) != 0 && (len = end - start + 1) < 0) {
            len = 0;
        }
        return len;
    }

    private int selectedTextLength() {
        int len = -1;
        if (this.anythingSelected()) {
            len = 0;
            Element lastElement = this.bottomElement().next();
            boolean first = true;
            boolean includeShow = this.allShow();
            Element element = this.topElement();
            while (element != lastElement) {
                if ((includeShow || !element.show()) && element.visible(this._view)) {
                    if (!first) {
                        ++len;
                    }
                    len += this.selectedTextLength(this._view, element);
                    first = false;
                }
                element = element.next();
            }
        }
        return len;
    }

    String selectedText() {
        int len = this.selectedTextLength();
        return len >= 0 ? this.getSelectedText(len, "\n", false) : null;
    }

    void copyToClipboard() {
        int len = this.selectedTextLength();
        if (len >= 0) {
            boolean finalEol = this._type == 4;
            String eol = LpexUtilities.getPlatform() == 0 ? "\n" : _platformEol;
            String text = this.getSelectedText(len + 1, eol, finalEol);
            String rtfText = this.getSelectedRtfText(len + 1, finalEol);
            LpexUtilities.setClipboardContents(text, rtfText);
        }
    }

    void cutToClipboard() {
        if (this.anythingSelected() && !this.anythingProtectedSelected() && this._view.changeAllowed()) {
            this.copyToClipboard();
            this.delete();
        }
    }

    void getSelectedText(View view, Element element, StringBuilder buffer) {
        int end;
        if (this._type == 3 && LpexUtilities.isBidi() && this.partOfBlock(view, element)) {
            DisplayTextLayout.logicalText(element.elementView(view), this.leftPixelPosition(), this.rightPixelPosition(), buffer);
            return;
        }
        int start = this.selectedTextStart(view, element);
        if (start > 0 && (end = this.selectedTextEnd(view, element)) > 0) {
            String elementText = element.text();
            int elementTextLength = elementText.length();
            int i = start;
            while (i <= end) {
                buffer.append(i <= elementTextLength ? elementText.charAt(i - 1) : (char)' ');
                ++i;
            }
        }
    }

    private String getSelectedText(int len, String eol, boolean finalEol) {
        if (!this.anythingSelected()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(len + 1);
        Element lastElement = this.bottomElement().next();
        boolean first = true;
        boolean includeShow = this.allShow();
        Element element = this.topElement();
        while (element != lastElement) {
            if ((includeShow || !element.show()) && element.visible(this._view)) {
                if (!first) {
                    buffer.append(eol);
                }
                this.getSelectedText(this._view, element, buffer);
                first = false;
            }
            element = element.next();
        }
        if (finalEol) {
            buffer.append(eol);
        }
        return buffer.toString();
    }

    private String getSelectedRtfText(int len, boolean finalEol) {
        if (!this.anythingSelected()) {
            return null;
        }
        RtfWriter rtf = new RtfWriter(this._view, len);
        Element lastElement = this.bottomElement().next();
        boolean first = true;
        boolean includeShow = this.allShow();
        Element element = this.topElement();
        while (element != lastElement) {
            if ((includeShow || !element.show()) && element.visible(this._view)) {
                if (!first) {
                    rtf.newLine();
                }
                if (LpexUtilities.isBidi() && this._type == 3) {
                    StringBuilder textBuffer = new StringBuilder();
                    StringBuilder foregroundBuffer = new StringBuilder();
                    StringBuilder backgroundBuffer = new StringBuilder(0);
                    DisplayTextLayout.logicalText(element.elementView(this._view), this.leftPixelPosition(), this.rightPixelPosition(), textBuffer, foregroundBuffer, backgroundBuffer);
                    rtf.writeLine(textBuffer.toString(), foregroundBuffer.toString(), backgroundBuffer.length() == 0 ? null : backgroundBuffer.toString());
                } else {
                    int start = this.selectedTextStart(this._view, element);
                    if (start > 0) {
                        int end = this.selectedTextEnd(this._view, element);
                        rtf.writeLine(element, start, end);
                    }
                }
                first = false;
            }
            element = element.next();
        }
        if (finalEol) {
            rtf.newLine();
        }
        rtf.close();
        return rtf.toString();
    }
}

