/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.bidi.BidiFlag;
import com.ibm.lpex.bidi.BidiFlagSet;
import com.ibm.lpex.bidi.BidiText;
import com.ibm.lpex.bidi.BidiTransform;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.FormatLine;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.Screen;
import com.ibm.lpex.core.StatusLine;
import com.ibm.lpex.core.TextFontMetrics;
import com.ibm.lpex.core.Utilities;
import com.ibm.lpex.core.View;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

final class BidiCommentElement
implements FocusListener,
KeyListener,
ModifyListener {
    private LpexWindow _lpexWindow;
    private LpexView _lpexView;
    private View _view;
    private Shell _shell;
    Text _commentField;
    private String _text;
    private TextFontMetrics _tfm;
    private int _maxCommentLength;
    private int _orientation;
    private String _committedText = null;
    private int _commentOffset;

    BidiCommentElement(LpexWindow lpexWindow) {
        this._lpexWindow = lpexWindow;
        this._lpexView = this._lpexWindow.getLpexView();
        this._view = this._lpexView._view;
        this._maxCommentLength = this._view.getFieldLimit(this._view.documentPosition().position(), this._view.documentPosition().element()) - 1;
        this._lpexWindow.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BidiCommentElement.this.hide();
                BidiCommentElement.this._lpexWindow = null;
            }
        });
    }

    LpexView getMainDocLpexView() {
        return this._lpexWindow.getLpexView();
    }

    private void createBidiCommentElement() {
        this._shell = new Shell(16396);
        this._commentField = new Text((Composite)this._shell, 2052);
        Screen screen = this._view.screen();
        this._tfm = screen.textFontMetrics();
        int strWidth = this._tfm.stringWidth(new String(new char[this._maxCommentLength]).replace('\u0000', ' '));
        this._shell.setSize(strWidth + 1, this._commentField.computeSize((int)-1, (int)-1, (boolean)true).y);
        Point p = this._shell.getLocation();
        this._shell.setLocation(p);
        this._commentField.setSize(this._shell.getSize());
        this._commentField.setLocation(0, 0);
        this._orientation = this.calculateOrientation(this._text);
        this._commentField.setOrientation(this._orientation);
        int[] position = new int[]{this._lpexView.currentPosition()};
        if (this._orientation == 0x2000000) {
            this._text = this._text.replaceAll("\\s+$", "");
            this._commentField.setText(this._text);
        } else {
            this._text = this._text.replaceAll("^\\s+", "");
            int numOfSpaces = this._maxCommentLength - this._text.length();
            position[0] = position[0] - numOfSpaces;
            if (position[0] < 0) {
                position[0] = 0;
            }
            this._commentField.setText(this.transformToRTL(this._text, position));
        }
        this._commentField.setSelection(position[0] - 2);
        this._commentField.setFont(screen.currentFont().getFont());
        this._commentField.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BidiCommentElement.this._commentField.dispose();
                BidiCommentElement.this._commentField = null;
            }
        });
        this._commentField.addFocusListener((FocusListener)this);
        this._commentField.addKeyListener((KeyListener)this);
        this._commentField.addModifyListener((ModifyListener)this);
    }

    private String transformToRTL(String text, int[] position) {
        BidiFlagSet flags1 = new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.ORIENTATION_LTR, BidiFlag.SWAP_YES, BidiFlag.NUMERALS_NOMINAL, BidiFlag.TEXT_NOMINAL);
        BidiFlagSet flags2 = new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.ORIENTATION_RTL, BidiFlag.SWAP_YES, BidiFlag.NUMERALS_ANY, BidiFlag.TEXT_NOMINAL);
        BidiTransform bdx = new BidiTransform();
        bdx.flags = flags2;
        if (position != null && position.length != 0 && position[0] <= text.length()) {
            bdx.srcToDstMapRequired = true;
        }
        bdx.removeMarkers = true;
        BidiText src = new BidiText(flags1, text);
        BidiText dst = src.transform(bdx);
        String logicalText = dst.toString();
        if (position != null && position.length != 0) {
            int pos = position[0];
            if (pos == 0) {
                pos = 1;
            }
            if (bdx.removeMarkers) {
                while (pos <= text.length() && LpexNls.isBidiMark(text.charAt(pos - 1))) {
                    ++pos;
                }
            }
            position[0] = pos <= text.length() ? bdx.srcToDstMap[pos - 1] + 1 : logicalText.length() + (pos - text.length());
        }
        return logicalText;
    }

    private String transformFromRTL(String text) {
        BidiFlagSet flags1 = new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.ORIENTATION_RTL, BidiFlag.SWAP_YES, BidiFlag.NUMERALS_ANY, BidiFlag.TEXT_NOMINAL);
        BidiFlagSet flags2 = new BidiFlagSet(BidiFlag.TYPE_IMPLICIT, BidiFlag.ORIENTATION_LTR, BidiFlag.SWAP_YES, BidiFlag.NUMERALS_NOMINAL, BidiFlag.TEXT_NOMINAL);
        BidiTransform bdx = new BidiTransform();
        bdx.flags = flags2;
        bdx.removeMarkers = true;
        BidiText src = new BidiText(flags1, text);
        BidiText dst = src.transform(bdx);
        String logicalText = dst.toString();
        return logicalText;
    }

    void display(int commentOffset) {
        this._commentOffset = commentOffset;
        int currentElementIndx = this._lpexView.currentElement();
        this._text = this._lpexView.elementText(currentElementIndx);
        if (!this._text.startsWith("*")) {
            return;
        }
        this._text = this._text.substring(1);
        this.createBidiCommentElement();
        this._commentField.setSize(this._shell.getSize());
        this._commentField.setLocation(0, 0);
        this._shell.setLocation(this.getLocation());
        this._shell.setVisible(true);
        this._commentField.setFocus();
    }

    private void hide() {
        if (LpexUtilities.okToUse((Widget)this._shell)) {
            if (LpexUtilities.okToUse((Widget)this._commentField)) {
                this._commentField.removeFocusListener((FocusListener)this);
            }
            this._shell.setVisible(false);
            this._shell.dispose();
            this._shell = null;
        }
    }

    private Point getLocation() {
        Screen screen = this._view.screen();
        Point p = new Point(screen.expandHideAreaWidth() + screen.prefixAreaWidth(), (screen.cursorRow() - 1) * this._tfm.textHeight());
        p = this._lpexWindow.textWindow().toDisplay(p);
        Rectangle trim = this._commentField.computeTrim(0, 0, 0, 0);
        p.x += trim.x;
        p.y += trim.y;
        p.x += this._tfm.charWidth('*') + 1;
        return p;
    }

    void handleOk() {
        this.commit();
        this.hide();
    }

    void handleEsc() {
        this.hide();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.handleOk();
    }

    private int calculateOrientation(String str) {
        if (str.trim().length() == 0) {
            return 0x2000000;
        }
        int i = 0;
        while (i < str.length()) {
            byte directionality = Character.getDirectionality(str.charAt(i));
            if (directionality == 1 || directionality == 2) {
                return 0x4000000;
            }
            if (directionality == 0) {
                return 0x2000000;
            }
            ++i;
        }
        return 0x2000000;
    }

    void commit() {
        String currentText;
        Element currentElement = this._view.documentPosition().element();
        String string = currentText = this._orientation == 0x4000000 ? this.transformFromRTL(this._commentField.getText()) : this._commentField.getText();
        if (!currentText.equals(this._committedText)) {
            this._committedText = currentText;
            this._view.document().undo().check(this._view);
            int scroll = this._lpexView._view.screen().scroll();
            int e = this._view.document().elementList().ordinalOf(currentElement);
            this._lpexView.setElementText(e, this.generateCommentStr(currentText));
            this._lpexView._view.screen().setScroll(scroll);
            return;
        }
    }

    private String generateCommentStr(String currentText) {
        String commentStr = "*";
        if (this._orientation == 0x4000000 && currentText.length() < this._maxCommentLength) {
            commentStr = commentStr.concat(new String(new char[this._maxCommentLength - currentText.length() - 1]).replace('\u0000', ' '));
        }
        if ((commentStr = commentStr.concat(currentText)).length() - 1 > this._maxCommentLength) {
            commentStr = commentStr.substring(0, this._maxCommentLength);
        }
        return commentStr;
    }

    void handleShowing() {
        this._view.document().undo().check(this._view);
        this._view.block().validate();
        int column = this._view.currentColumn(this._view.documentPosition().element().elementView(this._view));
        if (this._lpexView != null) {
            ((FormatLine)this._lpexView.window().formatLine()).setColumn(column);
            this._lpexView.window().statusLineManager().setColumn(this._lpexView, column);
            this._lpexView.window().statusLineManager().setInputMode(this._view.insertMode() ? 1 : 2);
            int position = this._view.documentPosition().position();
            String info = position > 0 && position <= this._text.length() ? LpexNls.specialCharacterInfo(this._text.charAt(position - 1)) : null;
            this._lpexView.window().statusLineManager().setInfo(info);
            ((StatusLine)this._lpexView.window().statusLine()).updateStatus();
        }
    }

    public void keyPressed(KeyEvent event) {
        if (event.keyCode == 13) {
            this.handleOk();
        } else if (event.keyCode == 27) {
            this.handleEsc();
        } else if (event.keyCode == 0x1000001 || event.keyCode == 0x1000002) {
            this.handleOk();
            if (event.keyCode == 0x1000001) {
                this._view.documentPosition().up();
            } else {
                this._view.documentPosition().down();
            }
            Utilities.commentUncommentCobolLines(this._lpexView, this._commentOffset, true);
        }
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public void modifyText(ModifyEvent event) {
        int newOrientation;
        if (!(event.widget instanceof Text)) {
            return;
        }
        String newText = ((Text)event.widget).getText();
        if ((this._text.length() == 0 || newText.charAt(0) != this._text.charAt(0)) && (newOrientation = this.calculateOrientation(newText)) != this._orientation) {
            this._orientation = newOrientation;
            this._commentField.setOrientation(this._orientation);
        }
    }
}

