/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.List;
import com.ibm.lpex.core.ListNode;
import com.ibm.lpex.core.LpexActiveWindowListener;
import com.ibm.lpex.core.LpexLog;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.View;

final class ActiveWindowListenerList
extends List {
    ActiveWindowListenerList() {
    }

    void addListener(LpexActiveWindowListener listener) {
        if (this.find(listener) == null) {
            this.prepend(new ListenerNode(listener));
        }
    }

    void removeListener(LpexActiveWindowListener listener) {
        List.Node node;
        if (listener != null && (node = this.find(listener)) != null) {
            this.remove(node);
        }
    }

    void activeWindowChanged(LpexWindow lpexWindow) {
        this.beginScanning();
        List.Node node = this.first();
        while (node != null) {
            ListenerNode listenerNode = (ListenerNode)node;
            try {
                if (!listenerNode.isNotifying()) {
                    listenerNode.setNotifying(true);
                    listenerNode.listener().activeWindowChanged(lpexWindow);
                    listenerNode.setNotifying(false);
                }
            }
            catch (Throwable e) {
                LpexView lpexView;
                View view = null;
                String errorText = LpexResources.message("exception.listener", listenerNode.listener().toString());
                if (lpexWindow != null && !lpexWindow.isDisposed() && (lpexView = lpexWindow.getLpexView()) != null && !lpexView.isDisposed()) {
                    view = lpexView._view;
                    view.screen().setMessageText(errorText);
                }
                LpexLog.log(view, errorText, e);
                this.remove(node);
            }
            node = node.next();
        }
        this.endScanning();
    }

    List.Node find(LpexActiveWindowListener listener) {
        List.Node node = this.first();
        while (node != null) {
            if (((ListenerNode)node).listener() == listener) {
                return node;
            }
            node = node.next();
        }
        return null;
    }

    private static class ListenerNode
    extends ListNode {
        private LpexActiveWindowListener _listener;
        private boolean _isNotifying;

        ListenerNode(LpexActiveWindowListener listener) {
            this._listener = listener;
        }

        LpexActiveWindowListener listener() {
            return this._listener;
        }

        boolean isNotifying() {
            return this._isNotifying;
        }

        void setNotifying(boolean isNotifying) {
            this._isNotifying = isNotifying;
        }
    }
}

