/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.preferences.WhitespaceCharacterMapping;
import com.ibm.lpex.core.LpexResources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class WhitespaceCharacterUtil {
    public static final List<WhitespaceCharacterMapping> defaultMappingList = new ArrayList<WhitespaceCharacterMapping>();
    private static final Hashtable<Character, String> UNICODE_WHITESPACE_TABLE;
    private static String[] WHITESPACE_CHARACTER_NAMES;

    static {
        defaultMappingList.add(new WhitespaceCharacterMapping(' ', '\u00b7'));
        defaultMappingList.add(new WhitespaceCharacterMapping('\t', '\u00bb'));
        defaultMappingList.add(new WhitespaceCharacterMapping('\r', '\u00a4'));
        UNICODE_WHITESPACE_TABLE = new Hashtable();
        WHITESPACE_CHARACTER_NAMES = null;
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u0000'), LpexResources.message("preferences.whitespace.name.null"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u0001'), LpexResources.message("preferences.whitespace.name.start_of_heading"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u0002'), LpexResources.message("preferences.whitespace.name.start_of_text"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u0003'), LpexResources.message("preferences.whitespace.name.end_of_text"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u0004'), LpexResources.message("preferences.whitespace.name.end_of_transmission"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u0005'), LpexResources.message("preferences.whitespace.name.enquiry"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u0006'), LpexResources.message("preferences.whitespace.name.acknowledge"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u0007'), LpexResources.message("preferences.whitespace.name.bell"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\b'), LpexResources.message("preferences.whitespace.name.backspace"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\t'), LpexResources.message("preferences.whitespace.name.horizontal_tabulation"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u000b'), LpexResources.message("preferences.whitespace.name.vertical_tabulation"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\f'), LpexResources.message("preferences.whitespace.name.form_feed"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\r'), LpexResources.message("preferences.whitespace.name.carriage_return"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u0010'), LpexResources.message("preferences.whitespace.name.data_link_escape"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u0011'), LpexResources.message("preferences.whitespace.name.device_control_one"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u0012'), LpexResources.message("preferences.whitespace.name.device_control_two"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u0013'), LpexResources.message("preferences.whitespace.name.device_control_three"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u0014'), LpexResources.message("preferences.whitespace.name.device_control_four"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u0015'), LpexResources.message("preferences.whitespace.name.negative_acknowledge"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u0016'), LpexResources.message("preferences.whitespace.name.synchronous_idle"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u0017'), LpexResources.message("preferences.whitespace.name.end_of_transmission_block"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u0018'), LpexResources.message("preferences.whitespace.name.cancel"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u0019'), LpexResources.message("preferences.whitespace.name.end_of_medium"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u001a'), LpexResources.message("preferences.whitespace.name.substitute"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u001b'), LpexResources.message("preferences.whitespace.name.escape"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u001c'), LpexResources.message("preferences.whitespace.name.file_separator"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u001d'), LpexResources.message("preferences.whitespace.name.group_separator"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u001e'), LpexResources.message("preferences.whitespace.name.record_separator"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf('\u001f'), LpexResources.message("preferences.whitespace.name.unit_separator"));
        UNICODE_WHITESPACE_TABLE.put(Character.valueOf(' '), LpexResources.message("preferences.whitespace.name.space"));
    }

    public static String getWhitespaceName(char c) {
        return UNICODE_WHITESPACE_TABLE.get(Character.valueOf(c));
    }

    public static Character getWhitespaceCharacterByName(String name) {
        Set<Character> list = UNICODE_WHITESPACE_TABLE.keySet();
        for (char key : list) {
            if (!UNICODE_WHITESPACE_TABLE.get(Character.valueOf(key)).equalsIgnoreCase(name)) continue;
            return Character.valueOf(key);
        }
        return null;
    }

    public static String[] getWhitespaceCharacterNames() {
        if (WHITESPACE_CHARACTER_NAMES != null) {
            return WHITESPACE_CHARACTER_NAMES;
        }
        WHITESPACE_CHARACTER_NAMES = new String[UNICODE_WHITESPACE_TABLE.size()];
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(UNICODE_WHITESPACE_TABLE.values());
        Collections.sort(list);
        return list.toArray(WHITESPACE_CHARACTER_NAMES);
    }

    public static String getCharHexValue(char c) {
        return String.format("%#06X", c);
    }

    public static String buildWhitespaceCharMappingTableString(List<WhitespaceCharacterMapping> list) {
        StringBuilder res = new StringBuilder();
        for (WhitespaceCharacterMapping mapping : list) {
            res.append(WhitespaceCharacterUtil.getCharHexValue(mapping.getOriginal()));
            res.append(" ");
            res.append(WhitespaceCharacterUtil.getCharHexValue(mapping.getSubstitute()));
            res.append(" ");
        }
        return res.toString();
    }

    public static List<WhitespaceCharacterMapping> parseWhitespaceCharMappingTable(String mappingStr) {
        ArrayList<WhitespaceCharacterMapping> list = new ArrayList<WhitespaceCharacterMapping>();
        StringTokenizer st = new StringTokenizer(mappingStr);
        while (st.hasMoreTokens()) {
            String orgStr = st.nextToken();
            char original = WhitespaceCharacterUtil.getCharByHexString(orgStr);
            if (!st.hasMoreTokens()) continue;
            String subStr = st.nextToken();
            char substitute = WhitespaceCharacterUtil.getCharByHexString(subStr);
            list.add(new WhitespaceCharacterMapping(original, substitute));
        }
        return list;
    }

    public static Hashtable<Character, Character> getWhitespaceCharMappingHasttable(String mappingStr) {
        Hashtable<Character, Character> mappingTable = new Hashtable<Character, Character>();
        List<WhitespaceCharacterMapping> list = WhitespaceCharacterUtil.parseWhitespaceCharMappingTable(mappingStr);
        for (WhitespaceCharacterMapping m : list) {
            mappingTable.put(Character.valueOf(m.getOriginal()), Character.valueOf(m.getSubstitute()));
        }
        return mappingTable;
    }

    public static char getCharByHexString(String str) {
        if (str.startsWith("0X") || str.startsWith("0x")) {
            str = str.substring(2).trim();
        }
        return (char)Integer.parseInt(str, 16);
    }

    public static boolean isSupportedWhitespaceChar(char c) {
        return UNICODE_WHITESPACE_TABLE.containsKey(Character.valueOf(c));
    }
}

