/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.LpexBooleanFieldEditor;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.alef.preferences.LpexListEditor;
import com.ibm.lpex.alef.preferences.ParsersPreferencePage;
import com.ibm.lpex.core.LpexMultiWindow;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ViewParserPreferencePage
extends LpexFieldEditorPreferencePage {
    private LpexView _lpexView;
    private LpexMultiWindow _lpexMultiWindow;
    private String[] _parsers;
    private String _initialParser;
    private boolean _initialDisableParsing;
    private boolean _initialParseAfterEveryKey;
    private boolean _initialMaintainBidiMarks;
    private String _parserSetting;
    protected LpexListEditor _parserList;
    protected LpexBooleanFieldEditor _disableParsingCheckBox;
    protected LpexBooleanFieldEditor _parseAfterEveryKeyCheckBox;
    protected LpexBooleanFieldEditor _maintainBidiMarksCheckBox;
    private boolean _userDisabledMaintainBidiMarks;

    public ViewParserPreferencePage(LpexView lpexView) {
        super(LpexResources.message("preferences.viewParserTitle"), 1);
        Composite parent;
        this._lpexView = lpexView;
        LpexWindow lpexWindow = this._lpexView.window();
        if (lpexWindow != null && (parent = lpexWindow.getParent()) instanceof LpexMultiWindow) {
            this._lpexMultiWindow = (LpexMultiWindow)parent;
        }
    }

    protected Control createContents(Composite parent) {
        Utilities.setHelp((Control)parent, "viewParser_page");
        return super.createContents(parent);
    }

    protected void createFieldEditors() {
        this._parsers = this.getParserList(this._lpexView);
        Composite parent = this.getFieldEditorParent();
        this._parserList = new LpexListEditor(parent, "preferences.viewParserParser", this._parsers);
        this._disableParsingCheckBox = new LpexBooleanFieldEditor(parent, "pref.viewParserNoParser");
        new Label(parent, 0);
        new Label(parent, 0);
        this._parseAfterEveryKeyCheckBox = new LpexBooleanFieldEditor(parent, "pref.viewParserAfterEveryKey");
        new Label(parent, 0);
        new Label(parent, 0);
        this._maintainBidiMarksCheckBox = new LpexBooleanFieldEditor(parent, "pref.viewParserMaintainBidiMarks");
        this.addField(this._parserList);
        this.addField((FieldEditor)this._disableParsingCheckBox);
        this.addField((FieldEditor)this._parseAfterEveryKeyCheckBox);
        this.addField((FieldEditor)this._maintainBidiMarksCheckBox);
        this.initializePage(this._lpexView);
        this.fieldEditorsCreated();
        boolean bl = this._userDisabledMaintainBidiMarks = !this._maintainBidiMarksCheckBox.getEnabled();
        if (!this._userDisabledMaintainBidiMarks && !this._lpexView.nls().isSourceBidi()) {
            this._maintainBidiMarksCheckBox.setEnabled(false);
        }
    }

    protected String[] getParserList(LpexView lpexView) {
        LpexStringTokenizer st = new LpexStringTokenizer(LpexView.globalQuery("current.updateProfile.parsers"));
        String[] parsers = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            parsers[i] = st.nextToken();
            ++i;
        }
        return parsers;
    }

    private void initializePage(LpexView lpexView) {
        this._initialParser = lpexView.query("parser");
        if (this._initialParser == null) {
            this._initialParser = lpexView.query("current.updateProfile.parser");
            if ("associated".equals(this._initialParser)) {
                this._initialParser = null;
            }
        }
        this._initialDisableParsing = lpexView.queryOn("current.updateProfile.noParser");
        this._initialParseAfterEveryKey = lpexView.queryOn("current.parseAfterEveryKey");
        this._initialMaintainBidiMarks = "on".equals(lpexView.query("parserProperty.document.maintainBidiMarks"));
        this.updateSettings(this._initialParser, this._initialDisableParsing, this._initialParseAfterEveryKey, this._initialMaintainBidiMarks);
    }

    public void setVisible(boolean visible) {
        LpexView activeView;
        if (visible && this._lpexMultiWindow != null && !this._lpexMultiWindow.isDisposed() && (activeView = this._lpexMultiWindow.getActiveView()) != null && activeView != this._lpexView) {
            this._lpexView = activeView;
            this.initializePage(this._lpexView);
            if (!this._userDisabledMaintainBidiMarks) {
                this._maintainBidiMarksCheckBox.setEnabled(this._lpexView.nls().isSourceBidi());
            }
        }
        super.setVisible(visible);
    }

    public void dispose() {
        ParsersPreferencePage.setLastParserSelected(null);
    }

    public boolean performOk() {
        String currentParser = this._lpexView.query("parser");
        if (currentParser == null) {
            currentParser = "";
        }
        String newNoParser = this._disableParsingCheckBox.getOnOffValue();
        String newParser = this.getSelectedParser();
        if (!newNoParser.equals(this._lpexView.query("current.updateProfile.noParser")) || !currentParser.equals(newParser)) {
            this._lpexView.doCommand("set updateProfile.noParser " + newNoParser);
            this._lpexView.doCommand("set updateProfile.parser " + newParser);
            this._lpexView.doCommand("updateProfile");
            this._lpexView.doCommand("screenShow view");
        }
        String parseAfterEveryKey = this._parseAfterEveryKeyCheckBox.getOnOffValue();
        if (this._lpexView.query("parser") != null) {
            this._lpexView.doCommand("set parserProperty.view.parseAfterEveryKey " + parseAfterEveryKey);
        } else {
            this._lpexView.doCommand("set parseAfterEveryKey " + parseAfterEveryKey);
        }
        this._lpexView.doCommand("set parserProperty.document.maintainBidiMarks " + this._maintainBidiMarksCheckBox.getOnOffValue());
        return true;
    }

    protected void performDefaults() {
        String parseAfterEveryKey = this._lpexView.query("parserProperty.parseAfterEveryKey");
        if (parseAfterEveryKey == null || !"on".equals(parseAfterEveryKey) && !"off".equals(parseAfterEveryKey)) {
            parseAfterEveryKey = LpexView.globalQuery("current.parseAfterEveryKey");
        }
        this.updateSettings(this.getDefaultParser(this._lpexView), "on".equals(LpexView.globalQuery("current.updateProfile.noParser")), "on".equals(parseAfterEveryKey), "on".equals(this._lpexView.query("parserProperty.maintainBidiMarks")));
    }

    @Override
    protected void performReset() {
        this.updateSettings(this._initialParser, this._initialDisableParsing, this._initialParseAfterEveryKey, this._initialMaintainBidiMarks);
    }

    protected String getDefaultParser(LpexView lpexView) {
        if ("on".equals(LpexView.globalQuery("current.updateProfile.noParser"))) {
            return null;
        }
        String parserName = LpexView.globalQuery("current.updateProfile.parser");
        if ("associated".equals(parserName)) {
            String extension;
            parserName = null;
            Object baseName = ViewParserPreferencePage.baseName(lpexView);
            if (baseName != null) {
                if (((String)baseName).indexOf(46) == -1) {
                    baseName = (String)baseName + ".";
                }
                parserName = lpexView.query("current.updateProfile.parserAssociation." + (String)baseName);
            }
            if ((parserName == null || parserName.length() == 0) && (extension = ViewParserPreferencePage.nameExtension(lpexView)) != null) {
                parserName = lpexView.query("current.updateProfile.parserAssociation." + extension);
            }
        }
        return parserName;
    }

    private static String baseName(LpexView lpexView) {
        int i;
        String baseName = lpexView.query("name");
        if (baseName != null && (i = baseName.lastIndexOf(System.getProperty("file.separator"))) >= 0 && i < baseName.length() - 1) {
            baseName = baseName.substring(i + 1);
        }
        return baseName;
    }

    private static String nameExtension(LpexView lpexView) {
        String extension = lpexView.query("name");
        if (extension != null) {
            int i = extension.lastIndexOf(46);
            extension = i >= 0 ? extension.substring(i + 1) : null;
        }
        return extension;
    }

    private void updateSettings(String parser, boolean disableParsing, boolean parseAfterEveryKey, boolean maintainBidiMarks) {
        this._parserSetting = parser;
        if (parser != null && parser.length() != 0) {
            ParsersPreferencePage.setLastParserSelected(parser);
        }
        this._parserList.clearSelection();
        int i = 0;
        while (i < this._parsers.length) {
            if (this._parsers[i].equals(parser)) {
                this._parserList.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        this._disableParsingCheckBox.setSelected(disableParsing);
        this._parseAfterEveryKeyCheckBox.setSelected(parseAfterEveryKey);
        this._maintainBidiMarksCheckBox.setSelected(maintainBidiMarks);
    }

    private String getSelectedParser() {
        String parser = null;
        int index = this._parserList.getSelectedIndex();
        if (index >= 0 && index < this._parsers.length) {
            parser = this._parsers[index];
        } else {
            String string = parser = this._parserSetting != null ? this._parserSetting : "";
        }
        if (parser != null && parser.length() > 0) {
            ParsersPreferencePage.setLastParserSelected(parser);
        }
        return parser;
    }
}

