/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.ClassNameStringFieldEditor;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.alef.preferences.LpexStringFieldEditor;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class UserProfilePreferencePage
extends LpexFieldEditorPreferencePage {
    private String _initialUserProfile;
    private LpexStringFieldEditor _userProfileTextField;

    public UserProfilePreferencePage() {
        super(LpexResources.message("preferences.userProfileTitle"), 1);
    }

    protected Control createContents(Composite parent) {
        Utilities.setHelp((Control)parent, "userProfile_page");
        return super.createContents(parent);
    }

    protected void createFieldEditors() {
        this._initialUserProfile = LpexView.globalQuery("current.updateProfile.userProfile");
        this._userProfileTextField = new ClassNameStringFieldEditor(this.getFieldEditorParent(), "preferences.userProfileClassName", this._initialUserProfile);
        this.addField((FieldEditor)this._userProfileTextField);
    }

    public boolean performOk() {
        if (UserProfilePreferencePage.updateDefaultValue("updateProfile.userProfile", this._userProfileTextField.getStringValue().trim())) {
            LpexView.doGlobalCommand("updateProfile all");
            LpexView.doGlobalCommand("screenShow");
        }
        return true;
    }

    protected void performDefaults() {
        this.updateSettings(LpexView.globalQuery("install.updateProfile.userProfile"));
        super.performDefaults();
    }

    @Override
    protected void performReset() {
        this.updateSettings(this._initialUserProfile);
    }

    private void updateSettings(String userProfile) {
        this._userProfileTextField.setStringValue(userProfile);
    }
}

