/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.alef.preferences.LpexTableItem;
import com.ibm.lpex.alef.preferences.TablePreferencePage;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class UserActionsPreferencePage
extends TablePreferencePage {
    private static final String[] _valueTableNames = new String[]{LpexResources.message("preferences.userActionsTableName"), LpexResources.message("preferences.userActionsTableClassName")};
    private static final String[] _valueNames = new String[]{LpexResources.message("preferences.userActionsName"), LpexResources.message("preferences.userActionsClassName")};
    private static final int[] _valueWeights = new int[]{30, 70};
    private static final String[][] _samples = new String[][]{{"com.ibm.lpex.samples.BlockNewMarkToMouseAction", "blockMarkToMouse"}, {"com.ibm.lpex.samples.BlockTransferAction", "blockTransfer"}, {"com.ibm.lpex.samples.ComposeAction", "compose"}, {"com.ibm.lpex.samples.ComposeHebrewAction", "composeHebrew"}, {"com.ibm.lpex.samples.CopyLineAction", "copyLine"}, {"com.ibm.lpex.samples.FindNextDefaultAction", "findNextDefault"}, {"com.ibm.lpex.samples.KeyReferenceAction", "ref"}, {"com.ibm.lpex.samples.SetDateAction", "setDate"}, {"com.ibm.lpex.samples.TestAction", "deleteBlockDelete"}, {"com.ibm.lpex.samples.TestUserProfile$CloseJoin", "closeJoin"}, {"com.ibm.lpex.samples.TestUserProfile$FindNextSelection", "findNextSelection"}, {"com.ibm.lpex.samples.ZoomAction", "zoom"}};
    private String _value1errorMsg;
    private String _value2errorMsg;

    public UserActionsPreferencePage() {
        super(false, true);
    }

    @Override
    protected Control createContents(Composite parent) {
        Utilities.setHelp((Control)parent, "userActions_page");
        return super.createContents(parent);
    }

    @Override
    protected String[] getValueTableNames() {
        return _valueTableNames;
    }

    @Override
    protected String[] getValueNames() {
        return _valueNames;
    }

    @Override
    protected int[] getValueWeights() {
        return _valueWeights;
    }

    @Override
    protected String[] getValue2Options() {
        String[] samples = new String[_samples.length];
        int i = 0;
        while (i < _samples.length) {
            samples[i] = _samples[i][0];
            ++i;
        }
        return samples;
    }

    @Override
    protected Vector<LpexTableItem> initialize() {
        return this.updateSettings(LpexView.globalQuery("current.updateProfile.userActions"));
    }

    @Override
    protected Vector<LpexTableItem> initializeDefaults() {
        return this.updateSettings(LpexView.globalQuery("install.updateProfile.userActions"));
    }

    private Vector<LpexTableItem> updateSettings(String userActions) {
        Vector<LpexTableItem> items = new Vector<LpexTableItem>();
        if (userActions != null) {
            StringTokenizer st = new StringTokenizer(userActions);
            while (st.hasMoreTokens()) {
                String actionName = st.nextToken();
                if (!st.hasMoreTokens()) continue;
                items.addElement(new LpexTableItem(actionName, st.nextToken()));
            }
        }
        return items;
    }

    public boolean performOk() {
        Vector<LpexTableItem> items = this.getItems();
        StringBuilder newUserActions = new StringBuilder(320);
        int i = 0;
        while (i < items.size()) {
            LpexTableItem pi = items.elementAt(i);
            if (newUserActions.length() != 0) {
                newUserActions.append(' ');
            }
            newUserActions.append(pi.value1()).append(' ').append(pi.value2());
            ++i;
        }
        if (LpexFieldEditorPreferencePage.updateDefaultValue("updateProfile.userActions", newUserActions.toString())) {
            LpexView.doGlobalCommand("updateProfile all");
        }
        return true;
    }

    @Override
    protected void value1Modified() {
        String name = this.value1TextField().getText().trim();
        this._value1errorMsg = null;
        if (name.indexOf(32) >= 0) {
            this._value1errorMsg = LpexResources.message("preferences.incorrectValue", name);
        }
        String errorMsg = this._value1errorMsg != null ? this._value1errorMsg : this._value2errorMsg;
        this.setErrorMessage(errorMsg);
        this.setValid(errorMsg == null);
        super.value1Modified();
    }

    @Override
    protected void value2Modified() {
        this._value2errorMsg = LpexFieldEditorPreferencePage.validateClassName(this.getValue2());
        String errorMsg = this._value2errorMsg != null ? this._value2errorMsg : this._value1errorMsg;
        this.setErrorMessage(errorMsg);
        this.setValid(errorMsg == null);
    }

    @Override
    protected void value2ListSelectionModified() {
        String className = this.getValue2();
        int i = 0;
        while (i < _samples.length) {
            if (_samples[i][0].equals(className)) {
                this.value1TextField().setText(_samples[i][1]);
                return;
            }
            ++i;
        }
    }
}

