/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.LpexComboEditor;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SourceEncodingPreferencePage
extends LpexFieldEditorPreferencePage {
    private LpexView _lpexView;
    private static final String[] _sourceEncodings = new String[]{"Cp1364", "Cp1371", "Cp1388", "Cp1390", "Cp1399", "Cp930", "Cp933", "Cp935", "Cp937", "Cp939"};
    private String _initialSourceEncoding;
    protected LpexComboEditor _sourceEncodingList;

    public SourceEncodingPreferencePage(LpexView lpexView) {
        super(LpexResources.message("preferences.viewSourceEncodingTitle"), 1);
        this._lpexView = lpexView;
        if (this._lpexView == null) {
            throw new NullPointerException("lpexView");
        }
    }

    protected Control createContents(Composite parent) {
        if (this._lpexView != null) {
            Utilities.setHelp((Control)parent, "viewSourceEncoding_page");
        }
        return super.createContents(parent);
    }

    protected void createFieldEditors() {
        this._sourceEncodingList = new LpexComboEditor("preferences.viewSourceEncodingSourceEncoding", this.getFieldEditorParent(), _sourceEncodings);
        this.addField(this._sourceEncodingList);
        this._initialSourceEncoding = this._lpexView.query("current.sourceEncoding");
        this.updateSettings(this._initialSourceEncoding);
        this.fieldEditorsCreated();
    }

    public boolean performOk() {
        String newSourceEncoding;
        if (!this.validateEncoding()) {
            return false;
        }
        String currentSourceEncoding = this._lpexView.query("current.sourceEncoding");
        if (currentSourceEncoding == null) {
            currentSourceEncoding = "";
        }
        if (!currentSourceEncoding.equals(newSourceEncoding = this.sourceEncoding())) {
            this._lpexView.doCommand("set sourceEncoding " + newSourceEncoding);
            this._lpexView.doCommand("screenShow document");
        }
        return true;
    }

    protected void performDefaults() {
        this.updateSettings(LpexView.globalQuery("current.sourceEncoding"));
        super.performDefaults();
    }

    @Override
    protected void performReset() {
        this.updateSettings(this._initialSourceEncoding);
    }

    private void updateSettings(String sourceEncoding) {
        this._sourceEncodingList.setStringValue(sourceEncoding);
    }

    private String sourceEncoding() {
        return this._sourceEncodingList.getStringValue().trim();
    }

    private boolean validateEncoding() {
        boolean valid;
        String sourceEncoding = this.sourceEncoding();
        boolean bl = valid = sourceEncoding.length() == 0 ? true : LpexNls.isValidEncoding(sourceEncoding);
        if (!valid) {
            this.setErrorMessage(LpexResources.message("encoding.invalid", sourceEncoding));
        }
        return valid;
    }
}

