/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.alef.preferences.LpexIntegerFieldEditor;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexView;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SequenceNumbersPreferencePage
extends LpexFieldEditorPreferencePage {
    private LpexView _lpexView;
    private String _initialSequenceNumbers;
    protected SeqNumIntegerFieldEditor _numColumnTextField;
    protected SeqNumIntegerFieldEditor _numWidthTextField;
    protected SeqNumIntegerFieldEditor _textColumnTextField;
    protected SeqNumIntegerFieldEditor _textWidthTextField;

    public SequenceNumbersPreferencePage(LpexView lpexView) {
        super(LpexResources.message("preferences.sequenceNumbersTitle"), 1);
        this._lpexView = lpexView;
    }

    protected Control createContents(Composite parent) {
        if (this._lpexView != null) {
            Utilities.setHelp((Control)parent, "viewSequenceNumbers_page");
        }
        return super.createContents(parent);
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this._numColumnTextField = new SeqNumIntegerFieldEditor(parent, "preferences.sequenceNumbersNumColumn");
        this._numWidthTextField = new SeqNumIntegerFieldEditor(parent, "preferences.sequenceNumbersNumWidth");
        this._textColumnTextField = new SeqNumIntegerFieldEditor(parent, "preferences.sequenceNumbersTextColumn");
        this._textWidthTextField = new SeqNumIntegerFieldEditor(parent, "preferences.sequenceNumbersTextWidth");
        this.addField((FieldEditor)this._numColumnTextField);
        this.addField((FieldEditor)this._numWidthTextField);
        this.addField((FieldEditor)this._textColumnTextField);
        this.addField((FieldEditor)this._textWidthTextField);
        this._initialSequenceNumbers = this._lpexView != null ? this._lpexView.query("current.sequenceNumbers") : LpexView.globalQuery("current.sequenceNumbers");
        this.updateSettings(this._initialSequenceNumbers);
        this.fieldEditorsCreated();
    }

    public boolean performOk() {
        if (this._lpexView != null) {
            if (this.setValue(this.sequenceNumbers())) {
                this._lpexView.doDefaultCommand("parse");
                this._lpexView.doDefaultCommand("screenShow document");
            }
        } else if (this.setDefaultValue(this.sequenceNumbers())) {
            LpexView.doGlobalCommand("screenShow");
        }
        return true;
    }

    protected void performDefaults() {
        if (this._lpexView != null) {
            this.updateSettings(LpexView.globalQuery("current.sequenceNumbers"));
        } else {
            this.updateSettings(LpexView.globalQuery("install.sequenceNumbers"));
        }
        super.performDefaults();
    }

    @Override
    protected void performReset() {
        this.updateSettings(this._initialSequenceNumbers);
    }

    private void updateSettings(String sequenceNumbers) {
        LpexStringTokenizer st = new LpexStringTokenizer(sequenceNumbers);
        this._numColumnTextField.setStringValue(st.hasMoreTokens() ? st.nextToken() : "");
        this._numWidthTextField.setStringValue(st.hasMoreTokens() ? st.nextToken() : "");
        this._textColumnTextField.setStringValue(st.hasMoreTokens() ? st.nextToken() : "");
        this._textWidthTextField.setStringValue(st.hasMoreTokens() ? st.nextToken() : "");
    }

    private String sequenceNumbers() {
        return this._numColumnTextField.getStringValue() + " " + this._numWidthTextField.getStringValue() + " " + this._textColumnTextField.getStringValue() + " " + this._textWidthTextField.getStringValue();
    }

    protected void checkState() {
        super.checkState();
        if (this.isValid()) {
            this.setValid(this.validateSequenceNumbers());
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_is_valid")) {
            super.propertyChange(event);
        } else {
            this.checkState();
        }
    }

    protected boolean validateSequenceNumbers() {
        int numColumn = this._numColumnTextField.getIntValue();
        int numWidth = this._numWidthTextField.getIntValue();
        int textColumn = this._textColumnTextField.getIntValue();
        int textWidth = this._textWidthTextField.getIntValue();
        boolean valid = true;
        boolean adjacent = true;
        int value = 0;
        if (numWidth > 9) {
            value = numWidth;
            valid = false;
        } else if (textWidth > 9) {
            value = textWidth;
            valid = false;
        } else if (numColumn < 1) {
            value = numColumn;
            valid = false;
        } else if (textColumn < 1) {
            value = textColumn;
            valid = false;
        }
        if (valid && numWidth != 0 && textWidth != 0) {
            if (numColumn < textColumn) {
                if (numColumn + numWidth != textColumn) {
                    adjacent = false;
                }
            } else if (textColumn + textWidth != numColumn) {
                adjacent = false;
            }
        }
        if (!valid) {
            this.setErrorMessage(LpexResources.message("preferences.incorrectValue", value));
        } else if (!adjacent) {
            this.setErrorMessage(LpexResources.message("preferences.sequenceNumbers.notContiguous"));
        } else {
            this.setErrorMessage(null);
        }
        return valid && adjacent;
    }

    private boolean setValue(String value) {
        if (!value.equals(this._lpexView.query("current.sequenceNumbers"))) {
            this._lpexView.doCommand("set sequenceNumbers " + value);
            return true;
        }
        return false;
    }

    private boolean setDefaultValue(String value) {
        if (!value.equals(LpexView.globalQuery("current.sequenceNumbers"))) {
            LpexView.doGlobalCommand("set default.sequenceNumbers " + value);
            return true;
        }
        return false;
    }

    private static class SeqNumIntegerFieldEditor
    extends LpexIntegerFieldEditor {
        private String _errorMessage;

        public SeqNumIntegerFieldEditor(Composite parent, String labelKey) {
            super(parent, labelKey);
        }

        protected void clearErrorMessage() {
        }

        protected void showErrorMessage(String msg) {
            super.showErrorMessage(msg);
            this._errorMessage = msg;
        }

        @Override
        protected boolean checkState() {
            boolean valid = super.checkState();
            if (valid && this._errorMessage != null) {
                super.clearErrorMessage();
                this._errorMessage = null;
            }
            return valid;
        }

        public boolean isValid() {
            boolean valid = super.isValid();
            if (!valid && this._errorMessage != null && this.getPage().getErrorMessage() == null) {
                this.showErrorMessage(this._errorMessage);
            }
            return valid;
        }
    }
}

