/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.LpexBooleanFieldEditor;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.alef.preferences.LpexIntegerFieldEditor;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SavePreferencePage
extends LpexFieldEditorPreferencePage {
    private LpexView _lpexView;
    private String _initialTrim;
    private String _initialTextLimit;
    protected LpexBooleanFieldEditor _trimCheckBox;
    protected LpexIntegerFieldEditor _textLimitTextField;

    public SavePreferencePage(LpexView lpexView) {
        super(lpexView.query("name"), 1);
        this._lpexView = lpexView;
    }

    public SavePreferencePage() {
        super(LpexResources.message("preferences.saveTitle"), 1);
    }

    protected Control createContents(Composite parent) {
        Utilities.setHelp((Control)parent, this._lpexView == null ? "save_page" : "viewSave_page");
        return super.createContents(parent);
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this._trimCheckBox = new LpexBooleanFieldEditor(parent, "preferences.saveTrim");
        this._textLimitTextField = new LpexIntegerFieldEditor(parent, "preferences.saveTextLimit");
        this.addField((FieldEditor)this._trimCheckBox);
        this.addField((FieldEditor)this._textLimitTextField);
        if (this._lpexView != null) {
            this._initialTrim = this._lpexView.query("current.save.trim");
            this._initialTextLimit = this._lpexView.query("current.save.textLimit");
        } else {
            this._initialTrim = LpexView.globalQuery("current.save.trim");
            this._initialTextLimit = LpexView.globalQuery("current.save.textLimit");
        }
        this.updateSettings(this._initialTrim, this._initialTextLimit);
        this.fieldEditorsCreated();
    }

    public boolean performOk() {
        boolean refresh;
        if (this._lpexView != null) {
            this.setValue("save.trim", this._trimCheckBox.getOnOffValue());
            refresh = this.setValue("save.textLimit", this._textLimitTextField.getStringValue());
        } else {
            SavePreferencePage.updateDefaultValue("save.trim", this._trimCheckBox.getOnOffValue());
            refresh = SavePreferencePage.updateDefaultValue("save.textLimit", this._textLimitTextField.getStringValue());
        }
        if (refresh) {
            LpexView.doGlobalCommand("screenShow");
        }
        return true;
    }

    protected void performDefaults() {
        if (this._lpexView != null) {
            this.updateSettings(LpexView.globalQuery("current.save.trim"), LpexView.globalQuery("current.save.textLimit"));
        } else {
            this.updateSettings(LpexView.globalQuery("install.save.trim"), LpexView.globalQuery("install.save.textLimit"));
        }
        super.performDefaults();
    }

    @Override
    protected void performReset() {
        this.updateSettings(this._initialTrim, this._initialTextLimit);
    }

    private void updateSettings(String trim, String textLimit) {
        this._trimCheckBox.setSelected("on".equals(trim));
        this._textLimitTextField.setStringValue(textLimit);
    }

    private boolean setValue(String setting, String value) {
        if (!value.equals(this._lpexView.query("current." + setting))) {
            this._lpexView.doCommand("set " + setting + " " + value);
            return true;
        }
        return false;
    }
}

