/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.LpexBooleanFieldEditor;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.alef.preferences.LpexIntegerFieldEditor;
import com.ibm.lpex.alef.preferences.LpexStringFieldEditor;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexView;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public final class PrintPreferencePage
extends LpexFieldEditorPreferencePage {
    private String _initialBottomMargin;
    private String _initialLeftMargin;
    private String _initialLineNumbers;
    private String _initialSequenceNumbers;
    private String _initialRightMargin;
    private String _initialTokenized;
    private String _initialTopMargin;
    private String _initialHeader;
    private String _initialFooter;
    private LpexIntegerFieldEditor _bottomMarginTextField;
    private LpexIntegerFieldEditor _leftMarginTextField;
    private LpexBooleanFieldEditor _lineNumbersCheckBox;
    private LpexBooleanFieldEditor _sequenceNumbersCheckBox;
    private LpexIntegerFieldEditor _rightMarginTextField;
    private LpexBooleanFieldEditor _tokenizedCheckBox;
    private LpexIntegerFieldEditor _topMarginTextField;
    private LpexStringFieldEditor _headerTextField;
    private LpexStringFieldEditor _footerTextField;

    public PrintPreferencePage() {
        super(LpexResources.message("preferences.printTitle"), 1);
    }

    protected Control createContents(Composite parent) {
        Utilities.setHelp((Control)parent, "print_page");
        return super.createContents(parent);
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this._lineNumbersCheckBox = new LpexBooleanFieldEditor(parent, "preferences.printLineNumbers");
        this._sequenceNumbersCheckBox = new LpexBooleanFieldEditor(parent, "preferences.printSequenceNumbers");
        this._tokenizedCheckBox = new LpexBooleanFieldEditor(parent, "preferences.printTokenized");
        new Label(parent, 0);
        new Label(parent, 0);
        this._topMarginTextField = new LpexIntegerFieldEditor(parent, "preferences.printTopMargin");
        this._bottomMarginTextField = new LpexIntegerFieldEditor(parent, "preferences.printBottomMargin");
        this._leftMarginTextField = new LpexIntegerFieldEditor(parent, "preferences.printLeftMargin");
        this._rightMarginTextField = new LpexIntegerFieldEditor(parent, "preferences.printRightMargin");
        new Label(parent, 0);
        new Label(parent, 0);
        this._headerTextField = new LpexStringFieldEditor(parent, "preferences.printHeader");
        this._footerTextField = new LpexStringFieldEditor(parent, "preferences.printFooter");
        this.addField((FieldEditor)this._lineNumbersCheckBox);
        this.addField((FieldEditor)this._sequenceNumbersCheckBox);
        this.addField((FieldEditor)this._tokenizedCheckBox);
        this.addField((FieldEditor)this._topMarginTextField);
        this.addField((FieldEditor)this._bottomMarginTextField);
        this.addField((FieldEditor)this._leftMarginTextField);
        this.addField((FieldEditor)this._rightMarginTextField);
        this.addField((FieldEditor)this._headerTextField);
        this.addField((FieldEditor)this._footerTextField);
        this._initialBottomMargin = PrintPreferencePage.getDefaultValue("print.bottomMargin");
        this._initialLeftMargin = PrintPreferencePage.getDefaultValue("print.leftMargin");
        this._initialLineNumbers = PrintPreferencePage.getDefaultValue("print.lineNumbers");
        this._initialSequenceNumbers = PrintPreferencePage.getDefaultValue("print.sequenceNumbers");
        this._initialRightMargin = PrintPreferencePage.getDefaultValue("print.rightMargin");
        this._initialTokenized = PrintPreferencePage.getDefaultValue("print.tokenized");
        this._initialTopMargin = PrintPreferencePage.getDefaultValue("print.topMargin");
        this._initialHeader = LpexStringTokenizer.removeQuotes(PrintPreferencePage.getDefaultValue("print.header"));
        this._initialFooter = LpexStringTokenizer.removeQuotes(PrintPreferencePage.getDefaultValue("print.footer"));
        this.performReset();
    }

    public boolean performOk() {
        this.setDefaultValue("print.bottomMargin", this._bottomMarginTextField.getStringValue());
        this.setDefaultValue("print.leftMargin", this._leftMarginTextField.getStringValue());
        this.setDefaultValue("print.lineNumbers", this._lineNumbersCheckBox.getOnOffValue());
        this.setDefaultValue("print.sequenceNumbers", this._sequenceNumbersCheckBox.getOnOffValue());
        this.setDefaultValue("print.rightMargin", this._rightMarginTextField.getStringValue());
        this.setDefaultValue("print.tokenized", this._tokenizedCheckBox.getOnOffValue());
        this.setDefaultValue("print.topMargin", this._topMarginTextField.getStringValue());
        this.setHeaderDefaultValue("print.header", this._headerTextField.getStringValue());
        this.setHeaderDefaultValue("print.footer", this._footerTextField.getStringValue());
        return true;
    }

    protected void performDefaults() {
        this.updateSettings(LpexView.globalQuery("install.print.bottomMargin"), LpexView.globalQuery("install.print.leftMargin"), LpexView.globalQuery("install.print.lineNumbers"), LpexView.globalQuery("install.print.sequenceNumbers"), LpexView.globalQuery("install.print.rightMargin"), LpexView.globalQuery("install.print.tokenized"), LpexView.globalQuery("install.print.topMargin"), LpexStringTokenizer.removeQuotes(LpexView.globalQuery("install.print.header")), LpexStringTokenizer.removeQuotes(LpexView.globalQuery("install.print.footer")));
        super.performDefaults();
    }

    @Override
    protected void performReset() {
        this.updateSettings(this._initialBottomMargin, this._initialLeftMargin, this._initialLineNumbers, this._initialSequenceNumbers, this._initialRightMargin, this._initialTokenized, this._initialTopMargin, this._initialHeader, this._initialFooter);
    }

    private void updateSettings(String bottomMargin, String leftMargin, String lineNumbers, String sequenceNumbers, String rightMargin, String tokenized, String topMargin, String header, String footer) {
        this._bottomMarginTextField.setStringValue(bottomMargin);
        this._leftMarginTextField.setStringValue(leftMargin);
        this._lineNumbersCheckBox.setSelected("on".equals(lineNumbers));
        this._sequenceNumbersCheckBox.setSelected("on".equals(sequenceNumbers));
        this._rightMarginTextField.setStringValue(rightMargin);
        this._tokenizedCheckBox.setSelected("on".equals(tokenized));
        this._topMarginTextField.setStringValue(topMargin);
        this._headerTextField.setStringValue("none".equals(header) ? null : header);
        this._footerTextField.setStringValue("none".equals(footer) ? null : footer);
    }

    private void setDefaultValue(String setting, String value) {
        LpexView.doGlobalCommand("set default." + setting + (String)(value.equals(LpexView.globalQuery("install." + setting)) ? "" : " " + value));
    }

    private void setHeaderDefaultValue(String setting, String value) {
        if ((value = value.trim()).length() == 0 || value.equals("none")) {
            if (LpexView.globalQuery("install." + setting) == null) {
                LpexView.doGlobalCommand("set default." + setting);
                return;
            }
            value = "none";
        }
        this.setDefaultValue(setting, LpexStringTokenizer.addQuotes(value));
    }
}

