/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.alef.preferences.LpexTableItem;
import com.ibm.lpex.alef.preferences.ParsersPreferencePage;
import com.ibm.lpex.alef.preferences.TablePreferencePage;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class ParserAssociationsPreferencePage
extends TablePreferencePage {
    private static final String[] _valueTableNames = new String[]{LpexResources.message("preferences.parserAssociationsTableExtension"), LpexResources.message("preferences.parserAssociationsTableParser")};
    private static final String[] _valueNames = new String[]{LpexResources.message("preferences.parserAssociationsExtension"), LpexResources.message("preferences.parserAssociationsParser")};
    private static final int[] _valueWeights = new int[]{50, 50};

    public ParserAssociationsPreferencePage() {
        super(false, true);
    }

    @Override
    protected Control createContents(Composite parent) {
        Utilities.setHelp((Control)parent, "parserAssociations_page");
        return super.createContents(parent);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setValue2Options();
        }
    }

    @Override
    protected String[] getValueTableNames() {
        return _valueTableNames;
    }

    @Override
    protected String[] getValueNames() {
        return _valueNames;
    }

    @Override
    protected int[] getValueWeights() {
        return _valueWeights;
    }

    @Override
    protected String[] getValue2Options() {
        String parserNames = LpexView.globalQuery("current.updateProfile.parsers");
        if (parserNames == null) {
            parserNames = "";
        }
        return parserNames.split(" ");
    }

    @Override
    protected Vector<LpexTableItem> initialize() {
        Vector<LpexTableItem> items = new Vector<LpexTableItem>();
        StringTokenizer st = new StringTokenizer(LpexView.globalQuery("current.updateProfile.extensions"));
        while (st.hasMoreTokens()) {
            String extension = st.nextToken();
            String parser = LpexView.globalQuery("current.updateProfile.parserAssociation." + extension);
            if (parser == null || parser.length() <= 0) continue;
            items.addElement(new LpexTableItem(extension, parser));
        }
        return items;
    }

    @Override
    protected Vector<LpexTableItem> initializeDefaults() {
        Vector<LpexTableItem> items = new Vector<LpexTableItem>();
        StringTokenizer st = new StringTokenizer(LpexView.globalQuery("install.updateProfile.extensions"));
        while (st.hasMoreTokens()) {
            String extension = st.nextToken();
            String parser = LpexView.globalQuery("install.updateProfile.parserAssociation." + extension);
            if (parser == null || parser.length() <= 0) continue;
            items.addElement(new LpexTableItem(extension, parser));
        }
        return items;
    }

    @Override
    protected void tableSelectionModified(String newValue1, String newValue2) {
        ParsersPreferencePage.setLastParserSelected(newValue2);
    }

    public boolean performOk() {
        boolean parserAssociationChanged = false;
        Vector<LpexTableItem> items = this.getItems();
        Vector<String> extensions = new Vector<String>();
        StringTokenizer st = new StringTokenizer(LpexView.globalQuery("current.updateProfile.extensions"));
        while (st.hasMoreTokens()) {
            extensions.addElement(st.nextToken());
        }
        int i = 0;
        while (i < extensions.size()) {
            String extension = (String)extensions.elementAt(i);
            boolean found = false;
            int j = 0;
            while (j < items.size()) {
                String currentExtension = items.elementAt(j).value1();
                if (extension.equals(currentExtension)) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                String installSetting = LpexView.globalQuery("install.updateProfile.parserAssociation." + extension);
                if (installSetting == null) {
                    LpexView.doGlobalCommand("set default.updateProfile.parserAssociation." + extension + " install");
                } else {
                    LpexView.doGlobalCommand("set default.updateProfile.parserAssociation." + extension);
                }
                parserAssociationChanged = true;
            }
            ++i;
        }
        i = 0;
        while (i < items.size()) {
            LpexTableItem pi = items.elementAt(i);
            String extension = pi.value1();
            String parser = pi.value2();
            if (LpexFieldEditorPreferencePage.updateDefaultValue("updateProfile.parserAssociation." + extension, parser)) {
                parserAssociationChanged = true;
            }
            ++i;
        }
        if (parserAssociationChanged) {
            LpexView.doGlobalCommand("updateProfile all");
            LpexView.doGlobalCommand("screenShow");
        }
        return true;
    }

    @Override
    protected void doSetPressed(String extension, String documentParser) {
        if (extension.length() != 0 && "install".equals(documentParser)) {
            documentParser = LpexView.globalQuery("install.updateProfile.parserAssociation." + extension);
        }
        super.doSetPressed(extension, documentParser);
    }
}

