/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.core.LpexResources;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

final class LpexRadioGroupFieldEditor
extends FieldEditor {
    private String[][] labelsAndValues;
    private int _numColumns;
    private int _indent;
    private int _buttonsIndent = 8;
    private String value;
    private Composite radioBox;
    private Button[] radioButtons;
    private boolean _useGroup;
    private boolean _useLabel;

    LpexRadioGroupFieldEditor(String labelKey, int numColumns, String[][] labelAndValues, Composite parent, boolean useGroup, String initialValue, int indent) {
        boolean bl = this._useLabel = labelKey != null;
        if (this._useLabel) {
            this.setLabelText(LpexResources.message(labelKey));
        }
        if (indent >= 0) {
            this._indent = indent;
        }
        this.labelsAndValues = labelAndValues;
        this._numColumns = numColumns;
        this._useGroup = useGroup;
        this.createControl(parent);
        this.setValue(initialValue);
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        }
        ((GridData)this.radioBox.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        if (this._useGroup) {
            Composite control = this.getRadioBoxControl(parent);
            GridData gd = new GridData(768);
            gd.horizontalIndent = this._indent;
            control.setLayoutData((Object)gd);
        } else {
            if (this._useLabel) {
                GridData gd = new GridData();
                gd.horizontalSpan = numColumns;
                gd.horizontalIndent = this._indent;
                this.getLabelControl(parent).setLayoutData((Object)gd);
            }
            Composite control = this.getRadioBoxControl(parent);
            GridData gd = new GridData();
            gd.horizontalSpan = numColumns;
            gd.horizontalIndent = this._indent + (this._useLabel ? this._buttonsIndent : 0);
            control.setLayoutData((Object)gd);
        }
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }

    String getValue() {
        return this.value;
    }

    public int getNumberOfControls() {
        return 1;
    }

    Composite getRadioBoxControl(Composite parent) {
        if (this.radioBox == null) {
            Font font = parent.getFont();
            if (this._useGroup) {
                Group group = new Group(parent, 0);
                group.setFont(font);
                String text = this.getLabelText();
                if (text != null) {
                    group.setText(text);
                }
                this.radioBox = group;
                GridLayout layout = new GridLayout();
                layout.horizontalSpacing = 8;
                layout.numColumns = this._numColumns;
                this.radioBox.setLayout((Layout)layout);
            } else {
                this.radioBox = new Composite(parent, 0);
                GridLayout layout = new GridLayout();
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                layout.horizontalSpacing = 8;
                layout.numColumns = this._numColumns;
                this.radioBox.setLayout((Layout)layout);
                this.radioBox.setFont(font);
            }
            this.radioButtons = new Button[this.labelsAndValues.length];
            int i = 0;
            while (i < this.labelsAndValues.length) {
                Button radio;
                this.radioButtons[i] = radio = new Button(this.radioBox, 16400);
                String[] labelAndValue = this.labelsAndValues[i];
                String text = LpexResources.message(labelAndValue[0]);
                radio.setText(text != null ? text : labelAndValue[0]);
                radio.setData((Object)labelAndValue[1]);
                radio.setFont(font);
                radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        String oldValue = LpexRadioGroupFieldEditor.this.value;
                        LpexRadioGroupFieldEditor.this.value = (String)event.widget.getData();
                        LpexRadioGroupFieldEditor.this.setPresentsDefaultValue(false);
                        LpexRadioGroupFieldEditor.this.fireValueChanged("field_editor_value", oldValue, LpexRadioGroupFieldEditor.this.value);
                    }
                });
                ++i;
            }
            this.radioBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    LpexRadioGroupFieldEditor.this.radioBox = null;
                    LpexRadioGroupFieldEditor.this.radioButtons = null;
                }
            });
        } else {
            this.checkParent((Control)this.radioBox, parent);
        }
        return this.radioBox;
    }

    void setValue(String selectedValue) {
        this.value = selectedValue;
        if (this.radioButtons == null) {
            return;
        }
        if (this.value != null) {
            boolean found = false;
            int i = 0;
            while (i < this.radioButtons.length) {
                Button radio = this.radioButtons[i];
                boolean selection = false;
                if (((String)radio.getData()).equals(this.value)) {
                    selection = true;
                    found = true;
                }
                radio.setSelection(selection);
                ++i;
            }
            if (found) {
                return;
            }
        }
        if (this.radioButtons.length > 0) {
            this.radioButtons[0].setSelection(true);
            this.value = (String)this.radioButtons[0].getData();
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.radioButtons != null) {
            int i = 0;
            while (i < this.radioButtons.length) {
                this.radioButtons[i].setEnabled(enabled);
                ++i;
            }
        }
    }
}

