/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.preferences.LpexStringFieldEditor;
import com.ibm.lpex.core.LpexResources;
import org.eclipse.swt.widgets.Composite;

class LpexIntegerFieldEditor
extends LpexStringFieldEditor {
    int _verifyRanges = 1;
    int _minValue;
    int _maxValue = Integer.MAX_VALUE;
    int _minValue1;
    int _maxValue1;

    public LpexIntegerFieldEditor(Composite parent, String labelKey) {
        super(parent, labelKey, 3, null);
    }

    public LpexIntegerFieldEditor(Composite parent, String labelKey, int minValue, int maxValue) {
        this(parent, labelKey);
        this._minValue = minValue;
        this._maxValue = maxValue;
    }

    public LpexIntegerFieldEditor(Composite parent, String labelKey, int minValue, int maxValue, int minValue1, int maxValue1) {
        this(parent, labelKey, minValue, maxValue);
        this._verifyRanges = 2;
        this._minValue1 = minValue1;
        this._maxValue1 = maxValue1;
    }

    protected boolean checkState() {
        boolean result = true;
        String text = this.getStringValue();
        try {
            int value = Integer.parseInt(text);
            boolean bl = result = this._minValue <= value && this._maxValue >= value;
            if (!result && this._verifyRanges == 2) {
                result = this._minValue1 <= value && this._maxValue1 >= value;
            }
        }
        catch (NumberFormatException e) {
            result = false;
        }
        boolean bl = result = result && this.doCheckState();
        if (result) {
            this.clearErrorMessage();
        } else {
            this.showErrorMessage(LpexResources.message("preferences.incorrectValue", text));
        }
        return result;
    }

    @Override
    public String getStringValue() {
        String value = super.getStringValue().trim();
        return value.length() == 0 ? "0" : value;
    }

    public int getIntValue() {
        try {
            return Integer.parseInt(this.getStringValue());
        }
        catch (NumberFormatException e) {
            return Integer.MIN_VALUE;
        }
    }
}

