/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class LpexFieldEditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    protected LpexFieldEditorPreferencePage(String title, int style) {
        super(title, style);
    }

    protected void contributeButtons(Composite buttonBar) {
        ++((GridLayout)buttonBar.getLayout()).numColumns;
        Button resetButton = new Button(buttonBar, 8);
        resetButton.setFont(buttonBar.getFont());
        resetButton.setText(LpexResources.message("preferences.reset"));
        GridData data = new GridData(256);
        data.widthHint = Math.max(this.convertHorizontalDLUsToPixels(61), resetButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        resetButton.setLayoutData((Object)data);
        resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LpexFieldEditorPreferencePage.this.performReset();
            }
        });
    }

    protected void performReset() {
    }

    public void init(IWorkbench workbench) {
    }

    protected void fieldEditorsCreated() {
    }

    static String validateClassName(String value) {
        boolean valid = true;
        if (value != null && (value = value.trim()).length() != 0) {
            boolean start = true;
            int i = 0;
            while (valid && i < value.length()) {
                char c = value.charAt(i);
                if (start) {
                    start = false;
                    valid = Character.isJavaIdentifierStart(c);
                } else {
                    start = c == '.';
                    valid = start || Character.isJavaIdentifierPart(c);
                }
                ++i;
            }
            valid = valid && !start;
        }
        return valid ? null : LpexResources.message("className.invalid", value);
    }

    static String getDefaultValue(String parameter) {
        String value = LpexView.globalQuery("default." + parameter);
        if ("install".equals(value)) {
            value = LpexView.globalQuery("install." + parameter);
        }
        return value;
    }

    static boolean updateDefaultValue(String parameter, String newSetting) {
        if (newSetting != null) {
            String installSetting = LpexView.globalQuery("install." + parameter);
            String defaultSetting = LpexView.globalQuery("default." + parameter);
            if (installSetting == null) {
                installSetting = "";
            }
            if (defaultSetting == null) {
                defaultSetting = "";
            }
            if (newSetting.equals(installSetting)) {
                if (!"install".equals(defaultSetting)) {
                    LpexView.doGlobalCommand("set default." + parameter + " install");
                    return true;
                }
            } else if ("install".equals(defaultSetting) || !newSetting.equals(defaultSetting)) {
                LpexView.doGlobalCommand("set default." + parameter + " " + newSetting);
                return true;
            }
        }
        return false;
    }
}

