/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.core.LpexResources;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

final class LpexComboEditor
extends FieldEditor {
    private Combo _combo;

    protected LpexComboEditor(String labelKey, Composite parent, String[] values) {
        this.init("", LpexResources.message(labelKey));
        this.createControl(parent);
        int i = 0;
        while (i < values.length) {
            this._combo.add(values[i]);
            ++i;
        }
    }

    String getStringValue() {
        return this._combo.getText();
    }

    void setStringValue(String value) {
        this._combo.setText(value != null ? value : "");
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this._combo.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this._combo = this.getComboControl(parent);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns;
        this._combo.setLayoutData((Object)gd);
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }

    public Combo getComboControl(Composite parent) {
        if (this._combo == null) {
            this._combo = new Combo(parent, 2052);
            this._combo.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    LpexComboEditor.this._combo = null;
                }
            });
            this._combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LpexComboEditor.this.valueChanged();
                }
            });
        } else {
            this.checkParent((Control)this._combo, parent);
        }
        return this._combo;
    }

    public int getNumberOfControls() {
        return 2;
    }

    public void setFocus() {
        if (this._combo != null) {
            this._combo.setFocus();
        }
    }

    private void valueChanged() {
        this.clearErrorMessage();
    }

    public void setEnabled(boolean enabled) {
        if (this._combo != null) {
            this._combo.setEnabled(enabled);
            this.getLabelControl().setEnabled(enabled);
        }
    }
}

