/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.preferences.HostCharacterMapping;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class HostCharacterUtil {
    public static final List<HostCharacterMapping> defaultMappingList = new ArrayList<HostCharacterMapping>();

    public static String getCharHexValue(char c) {
        return "0X" + Integer.toHexString(c);
    }

    public static String buildHostCharMappingListString(List<HostCharacterMapping> mappingList, String codePage) {
        if (mappingList == null) {
            return "";
        }
        StringBuffer res = new StringBuffer();
        if (codePage == null || codePage.equals("")) {
            for (HostCharacterMapping mapping : mappingList) {
                res.append(mapping.getCodePage());
                res.append(" ");
                res.append(mapping.getCodePointString());
                res.append(" ");
                res.append(HostCharacterUtil.getCharHexValue(mapping.getSubstitute()));
                res.append(" ");
            }
        } else {
            for (HostCharacterMapping mapping : mappingList) {
                if (!mapping.getCodePage().equalsIgnoreCase(codePage)) continue;
                res.append(mapping.getCodePointString());
                res.append(" ");
                res.append(HostCharacterUtil.getCharHexValue(mapping.getSubstitute()));
                res.append(" ");
            }
        }
        return res.toString();
    }

    public static String[] getCodePageNames() {
        String[] codePages = new String[]{"Cp037", "Cp273", "Cp277", "Cp278", "Cp280", "Cp284", "Cp285", "Cp297", "Cp420", "Cp424", "Cp500", "Cp870", "Cp871", "Cp875", "Cp930", "Cp933", "Cp935", "Cp937", "Cp939", "Cp1047", "Cp1140", "Cp1141", "Cp1142", "Cp1143", "Cp1144", "Cp1145", "Cp1146", "Cp1147", "Cp1148", "Cp1149", "Cp1390", "Cp1399", "Cp1364", "Cp1371", "Cp1388"};
        return codePages;
    }

    public static boolean isSupportedCodePageString(String codePageStr) {
        if ((codePageStr = codePageStr.toUpperCase()) == null) {
            return false;
        }
        return codePageStr.startsWith("CP") || codePageStr.startsWith("IBM") || codePageStr.startsWith("UTF") || codePageStr.startsWith("ISO");
    }

    public static boolean isSupportedCodePointString(String codePointStr) {
        codePointStr = codePointStr.toUpperCase();
        int index = 0;
        if (codePointStr.length() > 2 && (index = codePointStr.indexOf(45)) != -1) {
            String codePointFrom = codePointStr.substring(0, index);
            String codePointTo = codePointStr.substring(index + 1);
            if (HostCharacterUtil.getDecimalValue(codePointFrom) != -1 && HostCharacterUtil.getDecimalValue(codePointTo) != -1) {
                return true;
            }
        } else {
            String singleCodePoint = codePointStr;
            if (HostCharacterUtil.getDecimalValue(singleCodePoint) != -1) {
                return true;
            }
        }
        return false;
    }

    public static char getCharByHexString(String str) {
        if (str.startsWith("0X") || str.startsWith("0x")) {
            str = str.substring(2).trim();
        }
        return (char)Integer.parseInt(str, 16);
    }

    public static boolean isSupportedHostChar(char c) {
        return true;
    }

    public static int getDecimalValue(String hexString) {
        String hexValue = hexString.trim().toUpperCase();
        int value = 0;
        try {
            if (hexValue.toUpperCase().startsWith("0X")) {
                hexValue = hexValue.substring(2).trim();
                value = Integer.parseInt(hexValue, 16);
            } else {
                value = Integer.parseInt(hexValue);
            }
            return value;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static String getHexString(String decimalString) {
        if (decimalString == null) {
            return null;
        }
        try {
            if (decimalString.toUpperCase().startsWith("0X")) {
                return decimalString;
            }
            return "0X" + Integer.toHexString(Integer.parseInt(decimalString));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<HostCharacterMapping> getHostCharMappingList(String value) {
        List<HostCharacterMapping> list = HostCharacterUtil.parseHostCharMappingString(value);
        return list;
    }

    public static List<HostCharacterMapping> parseHostCharMappingString(String mappingStr) {
        ArrayList<HostCharacterMapping> list = new ArrayList<HostCharacterMapping>();
        if (mappingStr == null) {
            return list;
        }
        StringTokenizer st = new StringTokenizer(mappingStr);
        while (st.hasMoreTokens()) {
            HostCharacterMapping map;
            Character substitute = null;
            String codePoint = null;
            String codePointFrom = null;
            String codePointTo = null;
            String singleCodePoint = null;
            String codePage = st.nextToken();
            codePoint = st.nextToken();
            int index = 0;
            if (codePoint.length() > 2 && (index = codePoint.indexOf(45)) != -1) {
                codePointFrom = codePoint.substring(0, index);
                codePointTo = codePoint.substring(index + 1);
            } else {
                singleCodePoint = codePoint;
            }
            if (st.hasMoreTokens()) {
                try {
                    String subStr = st.nextToken();
                    substitute = Character.valueOf(HostCharacterUtil.getCharByHexString(subStr));
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (HostCharacterUtil.isMappingExisted(map = singleCodePoint != null ? new HostCharacterMapping(codePage, HostCharacterUtil.getDecimalValue(codePoint), substitute.charValue()) : new HostCharacterMapping(codePage, HostCharacterUtil.getDecimalValue(codePointFrom), HostCharacterUtil.getDecimalValue(codePointTo), substitute.charValue()), list)) continue;
            list.add(map);
        }
        return list;
    }

    public static Character findMappingChar(String codePage, int codePoint, List<HostCharacterMapping> mappingList) {
        if (mappingList == null || codePage == null) {
            return null;
        }
        for (HostCharacterMapping map : mappingList) {
            if (map.isSingleType()) {
                if (!map.getCodePage().equalsIgnoreCase(codePage) || map.getSingleCodePoint() != codePoint) continue;
                return Character.valueOf(map.getSubstitute());
            }
            int codePointFrom = map.getCodePointFrom();
            int codePointTo = map.getCodePointTo();
            int codePointThis = codePoint;
            if (!codePage.equalsIgnoreCase(map.getCodePage()) || codePointFrom == -1 || codePointTo == -1 || codePointThis == -1 || codePointThis < codePointFrom || codePointThis > codePointTo) continue;
            return Character.valueOf(map.getSubstitute());
        }
        return null;
    }

    public static boolean isMappingExisted(HostCharacterMapping mapping, List<HostCharacterMapping> mappingList) {
        if (mapping == null) {
            return false;
        }
        if (mappingList == null) {
            return false;
        }
        for (HostCharacterMapping map : mappingList) {
            if (!(map.isSingleType() ? map.getCodePage().equalsIgnoreCase(mapping.getCodePage()) && map.getSingleCodePoint() == mapping.getSingleCodePoint() : map.getCodePage().equalsIgnoreCase(mapping.getCodePage()) && map.getCodePointFrom() == mapping.getCodePointFrom() && map.getCodePointTo() == mapping.getCodePointTo())) continue;
            return true;
        }
        return false;
    }

    public static boolean updateMappingList(StringBuilder value, List<HostCharacterMapping> mappingList) {
        LinkedList<HostCharacterMapping> addList = new LinkedList<HostCharacterMapping>();
        String mapString = value.toString();
        StringTokenizer st = new StringTokenizer(mapString);
        String token = st.nextToken();
        while (st.hasMoreTokens()) {
            Character substitute = null;
            String codePoint = null;
            String codePointFrom = null;
            String codePointTo = null;
            String singleCodePoint = null;
            String codePage = null;
            if (!token.equalsIgnoreCase("-cp")) {
                return HostCharacterUtil.updataMappingListByPreferencePage(mapString, mappingList);
            }
            codePage = st.nextToken();
            if (!HostCharacterUtil.isSupportedCodePageString(codePage)) {
                return false;
            }
            HostCharacterUtil.deleteExistedCodePage(codePage, mappingList);
            token = null;
            while (st.hasMoreTokens() && !(token = st.nextToken()).equalsIgnoreCase("-cp")) {
                singleCodePoint = null;
                codePoint = token;
                int index = 0;
                if (codePoint.length() > 2 && (index = codePoint.indexOf(45)) != -1) {
                    codePointFrom = codePoint.substring(0, index);
                    codePointTo = codePoint.substring(index + 1);
                    if (!HostCharacterUtil.isSupportedCodePointString(codePointFrom) || !HostCharacterUtil.isSupportedCodePointString(codePointTo)) {
                        return false;
                    }
                } else {
                    singleCodePoint = codePoint;
                    if (!HostCharacterUtil.isSupportedCodePointString(singleCodePoint)) {
                        return false;
                    }
                }
                if (st.hasMoreTokens()) {
                    try {
                        String subStr = st.nextToken();
                        substitute = Character.valueOf(HostCharacterUtil.getCharByHexString(subStr));
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                HostCharacterMapping map = null;
                if (singleCodePoint != null) {
                    map = new HostCharacterMapping(codePage, HostCharacterUtil.getDecimalValue(codePoint), substitute.charValue());
                } else {
                    int to;
                    int from = HostCharacterUtil.getDecimalValue(codePointFrom);
                    if (from < (to = HostCharacterUtil.getDecimalValue(codePointTo))) {
                        map = new HostCharacterMapping(codePage, from, to, substitute.charValue());
                    }
                }
                if (map == null || HostCharacterUtil.isMappingExisted(map, addList)) continue;
                addList.add(map);
            }
        }
        if (addList != null) {
            mappingList.addAll(addList);
        }
        return true;
    }

    private static boolean updataMappingListByPreferencePage(String mapString, List<HostCharacterMapping> mappingList) {
        LinkedList<HostCharacterMapping> addList = new LinkedList<HostCharacterMapping>();
        StringTokenizer st = new StringTokenizer(mapString);
        while (st.hasMoreTokens()) {
            HostCharacterMapping map;
            Character substitute = null;
            String codePoint = null;
            String codePointFrom = null;
            String codePointTo = null;
            String singleCodePoint = null;
            String codePage = null;
            String token = st.nextToken();
            codePage = token;
            if (!HostCharacterUtil.isSupportedCodePageString(codePage)) {
                return false;
            }
            HostCharacterUtil.deleteExistedCodePage(codePage, mappingList);
            codePoint = st.nextToken();
            int index = 0;
            if (codePoint.length() > 2 && (index = codePoint.indexOf(45)) != -1) {
                codePointFrom = codePoint.substring(0, index);
                codePointTo = codePoint.substring(index + 1);
                if (!HostCharacterUtil.isSupportedCodePointString(codePointFrom) || !HostCharacterUtil.isSupportedCodePointString(codePointTo)) {
                    return false;
                }
            } else {
                singleCodePoint = codePoint;
                if (!HostCharacterUtil.isSupportedCodePointString(singleCodePoint)) {
                    return false;
                }
            }
            if (st.hasMoreTokens()) {
                try {
                    String subStr = st.nextToken();
                    substitute = Character.valueOf(HostCharacterUtil.getCharByHexString(subStr));
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (HostCharacterUtil.isMappingExisted(map = singleCodePoint != null ? new HostCharacterMapping(codePage, HostCharacterUtil.getDecimalValue(codePoint), substitute.charValue()) : new HostCharacterMapping(codePage, HostCharacterUtil.getDecimalValue(codePointFrom), HostCharacterUtil.getDecimalValue(codePointTo), substitute.charValue()), addList)) continue;
            addList.add(map);
        }
        if (addList != null) {
            mappingList.addAll(addList);
        }
        return true;
    }

    private static void deleteExistedCodePage(String codePage, List<HostCharacterMapping> mappingList) {
        if (codePage == null || mappingList == null) {
            return;
        }
        LinkedList<HostCharacterMapping> deleteList = new LinkedList<HostCharacterMapping>();
        for (HostCharacterMapping map : mappingList) {
            if (!map.getCodePage().equalsIgnoreCase(codePage)) continue;
            deleteList.add(map);
        }
        mappingList.removeAll(deleteList);
    }
}

