/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.preferences.HostCharacterUtil;

public class HostCharacterMapping {
    private char substitute;
    private String codePage;
    private int singleCodePoint;
    private boolean isSingleType;
    private int codePointFrom;
    private int codePointTo;

    public HostCharacterMapping(String codePage, int codePoint, char substitute) {
        this.codePointFrom = -1;
        this.codePointTo = -1;
        this.codePage = codePage.toUpperCase();
        this.singleCodePoint = codePoint;
        this.substitute = substitute;
        this.isSingleType = true;
    }

    public HostCharacterMapping(String codePage, int codePointFrom, int codePointTo, char substitute) {
        this.singleCodePoint = -1;
        this.codePage = codePage.toUpperCase();
        this.codePointFrom = codePointFrom;
        this.substitute = substitute;
        this.codePointTo = codePointTo;
        this.isSingleType = false;
    }

    public String getCodePage() {
        return this.codePage;
    }

    public void setCodePage(String codePage) {
        this.codePage = codePage.toUpperCase();
    }

    public char getSubstitute() {
        return this.substitute;
    }

    public void setSubstitute(char substitute) {
        this.substitute = substitute;
    }

    public String getCodePointString() {
        if (this.isSingleType) {
            return HostCharacterUtil.getHexString(String.valueOf(this.singleCodePoint));
        }
        return HostCharacterUtil.getHexString(String.valueOf(this.codePointFrom)) + "-" + HostCharacterUtil.getHexString(String.valueOf(this.codePointTo));
    }

    public int getSingleCodePoint() {
        return this.singleCodePoint;
    }

    public void setSingleCodePoint(int codePoint) {
        this.singleCodePoint = codePoint;
    }

    public boolean isSingleType() {
        return this.isSingleType;
    }

    public void setSingleType(boolean isSingleType) {
        this.isSingleType = isSingleType;
    }

    public int getCodePointFrom() {
        return this.codePointFrom;
    }

    public void setCodePointFrom(int codePointFrom) {
        this.codePointFrom = codePointFrom;
    }

    public int getCodePointTo() {
        return this.codePointTo;
    }

    public void setCodePointTo(int codePointTo) {
        this.codePointTo = codePointTo;
    }
}

