/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

final class ColorEditor {
    private Button _button;
    private Image _image;
    private Point _extent;
    private RGB _colorValue;
    private Color _color;

    ColorEditor(Composite parent) {
        this._button = new Button(parent, 8);
        this._extent = this.computeImageSize((Control)parent);
        this._image = new Image((Device)parent.getDisplay(), this._extent.x, this._extent.y);
        GC gc = new GC((Drawable)this._image);
        gc.setBackground(this._button.getBackground());
        gc.fillRectangle(0, 0, this._extent.x, this._extent.y);
        gc.dispose();
        this._button.setImage(this._image);
        this._button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog colorDialog = new ColorDialog(ColorEditor.this._button.getShell());
                colorDialog.setRGB(ColorEditor.this._colorValue);
                RGB newRgb = colorDialog.open();
                if (newRgb != null) {
                    ColorEditor.this.updateColor(newRgb);
                }
            }
        });
        this._button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ColorEditor.this.handleDisposed();
            }
        });
        this._button.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ColorEditor.this.handlePaint(e);
            }
        });
    }

    private void handleDisposed() {
        if (this._image != null) {
            this._image.dispose();
            this._image = null;
        }
        if (this._color != null) {
            this._color.dispose();
            this._color = null;
        }
    }

    private void handlePaint(PaintEvent e) {
        if (!this._button.getEnabled()) {
            e.gc.setBackground(this._button.getBackground());
            e.gc.fillRectangle((this._button.getSize().x - this._extent.x) / 2, (this._button.getSize().y - this._extent.y) / 2, this._extent.x + 1, this._extent.y + 1);
        }
    }

    Button getButton() {
        return this._button;
    }

    RGB getColorValue() {
        return this._colorValue;
    }

    void setColorValue(RGB newRgb) {
        if (!this._button.getEnabled()) {
            this._button.setEnabled(true);
        }
        this.updateColor(newRgb);
    }

    void setEnabled(boolean enabled) {
        if (!enabled) {
            this.updateColor(null);
        }
        this._button.setEnabled(enabled);
    }

    private void updateColor(RGB newRgb) {
        this._colorValue = newRgb;
        if (this._color != null) {
            this._color.dispose();
        }
        GC gc = new GC((Drawable)this._image);
        if (this._colorValue != null) {
            Display display = this._button.getDisplay();
            gc.setForeground(display.getSystemColor(2));
            gc.drawRectangle(0, 2, this._extent.x - 1, this._extent.y - 4);
            this._color = new Color((Device)display, this._colorValue);
            gc.setBackground(this._color);
            gc.fillRectangle(1, 3, this._extent.x - 2, this._extent.y - 5);
        } else {
            this._color = null;
            gc.setBackground(this._button.getBackground());
            gc.fillRectangle(0, 0, this._extent.x, this._extent.y);
        }
        gc.dispose();
        this._button.setImage(this._image);
    }

    private Point computeImageSize(Control window) {
        int height = 12;
        return new Point(height * 3 - 6, height);
    }
}

