/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.ColorEditor;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.alef.preferences.StyleNode;
import com.ibm.lpex.core.LpexAction;
import com.ibm.lpex.core.LpexBaseAction;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexPaletteAttributes;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexViewAdapter;
import com.ibm.lpex.core.LpexWindow;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public final class AppearancePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button _useThemeButton;
    private Link _themeLink;
    private Combo _paletteCombo;
    private Label _fontNameLabel;
    private Label _previewLabel;
    private Button _changeFontButton;
    private List _stylesList;
    private Button _fgCheckBox;
    private boolean _fgCheckBoxEditable;
    private ColorEditor _fgColorEditor;
    private ColorEditor _bgColorEditor;
    private ColorEditor _efColorEditor;
    private Button _underlineCheckBox;
    private Button _squiggleCheckBox;
    private Button _strikeoutCheckBox;
    private Button _outlineCheckBox;
    private Button _boldCheckBox;
    private Link parseLink;
    private boolean _handleUpdateProfile;
    private boolean _handlePaletteChanged;
    private LpexView _lpexView;
    private LpexWindow _lpexWindow;
    private Button _resetButton;
    private String[] _palettes;
    private String[] _paletteNames;
    private String _initialPalette;
    private String _initialFontDataString;
    private FontData[] _selectedFontData;
    private int _lastStyleIndex;
    private static boolean _updateMessageLine;
    private String[][] _initialAttributes;
    private String[][] _currentAttributes;
    Map<String, String> map = new HashMap<String, String>();
    protected IEclipsePreferences.IPreferenceChangeListener themeChangeListener = null;
    private static final String DARK_THEME_ECLIPSE_ID = "org.eclipse.e4.ui.css.theme.e4_dark";
    private static final String DEFAULT_THEME_ECLIPSE_ID = "org.eclipse.e4.ui.css.theme.e4_default";
    private static final String THEME_ID = "themeid";
    private static final String DEFAULT_THEME_ID = "DEFAULT";
    private static final String ECLIPSE_THEME_PLUGIN_ID = "org.eclipse.e4.ui.css.swt.theme";
    private static final String WORKBENCH_RENDERERS_PLUGIN_ID = "org.eclipse.e4.ui.workbench.renderers.swt";
    private static final String ENABLE_THEME_ID = "themeEnabled";
    private static final String ON = "on";
    private static final String OFF = "off";
    private static final String DARK_PALETTE = "dark";
    private static final String ECLIPSE_PALETTE = "eclipse";
    private static final StyleNode[] _styles;

    static {
        _styles = new StyleNode[]{new StyleNode("addedLines", true, true, true, true), new StyleNode("background", false, false, false, false), new StyleNode("currentLine", true, true, true, true), new StyleNode("cursor", false, false, false, false), new StyleNode("default", true, true, true, false), new StyleNode("deletedLines", true, true, true, true), new StyleNode("emphasis", true, false, false, false), new StyleNode("expandHide", false, false, false, true), new StyleNode("formatLine", false, true, false, false), new StyleNode("messageLine", true, true, false, false), new StyleNode("parserDefault", true, true, true, false), new StyleNode("parserMessage", true, true, true, false), new StyleNode("prefixArea", true, true, true, false), new StyleNode("prefixText", true, true, true, false), new StyleNode("selection", true, false, false, false), new StyleNode("statusLine", true, true, false, false)};
    }

    protected Control createContents(Composite ancestor) {
        Utilities.setHelp((Control)ancestor, "appearance_page");
        final Composite parent = new Composite(ancestor, 0);
        parent.setLayout((Layout)new GridLayout());
        this.parseLink = new Link(parent, 0);
        this.parseLink.setText(LpexResources.message("preferences.appearance.parser"));
        this.parseLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"com.ibm.lpex.alef.preferences.ParserStylesPreferencePage", null, null);
            }
        });
        this._themeLink = new Link(parent, 0);
        this._themeLink.setText(LpexResources.message("preferences.appearance.themelink"));
        this._themeLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"org.eclipse.ui.preferencePages.Views", null, null);
            }
        });
        this._useThemeButton = new Button(parent, 32);
        this._useThemeButton.setText(LpexResources.message("preferences.appearance.theme"));
        this._useThemeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AppearancePreferencePage.this.useThemeChanged();
            }
        });
        Composite topComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 8;
        topComposite.setLayout((Layout)layout);
        topComposite.setLayoutData((Object)new GridData(768));
        Composite paletteComposite = new Composite(topComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        paletteComposite.setLayout((Layout)layout);
        paletteComposite.setLayoutData((Object)new GridData(2));
        Label l = new Label(paletteComposite, 0);
        l.setText(LpexResources.message("preferences.appearance.palette"));
        this._paletteCombo = new Combo(paletteComposite, 2060);
        this._paletteCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AppearancePreferencePage.this.paletteChanged();
            }
        });
        Composite fontComposite = new Composite(topComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        fontComposite.setLayout((Layout)layout);
        fontComposite.setLayoutData((Object)new GridData(768));
        l = new Label(fontComposite, 0);
        l.setText(LpexResources.message("preferences.fontTitle"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        this._fontNameLabel = new Label(fontComposite, 18432);
        this._fontNameLabel.setLayoutData((Object)new GridData(768));
        this._changeFontButton = new Button(fontComposite, 8);
        this._changeFontButton.setText(LpexResources.message("preferences.change"));
        this._changeFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FontDialog fontDialog = new FontDialog(AppearancePreferencePage.this._changeFontButton.getShell());
                fontDialog.setFontList(AppearancePreferencePage.this._selectedFontData);
                if (fontDialog.open() != null) {
                    AppearancePreferencePage.this.fontChanged(fontDialog.getFontList());
                }
            }
        });
        l = new Label(parent, 0);
        l.setText(LpexResources.message("preferences.appearance.styles"));
        Composite editorComposite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 8;
        editorComposite.setLayout((Layout)layout);
        editorComposite.setLayoutData((Object)new GridData(768));
        this._stylesList = new List(editorComposite, 2564);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.heightHint = this._stylesList.getItemHeight() * 8;
        this._stylesList.setLayoutData((Object)gd);
        this._stylesList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AppearancePreferencePage.this.styleSelectionChanged(true);
            }
        });
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 4;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        SelectionListener attributesListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AppearancePreferencePage.this.attributesChanged(e);
            }
        };
        this._fgCheckBox = new Button(stylesComposite, 32);
        this._fgCheckBox.setText(LpexResources.message("preferences.appearance.foreground"));
        this._fgCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AppearancePreferencePage.this.enableFgSelectionChanged();
            }
        });
        this._fgColorEditor = new ColorEditor(stylesComposite);
        Button fgColorButton = this._fgColorEditor.getButton();
        fgColorButton.addSelectionListener(attributesListener);
        fgColorButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LpexResources.message("accessible.nameForeground");
            }

            public void getHelp(AccessibleEvent e) {
                e.result = LpexResources.message("accessible.roleForeground");
            }
        });
        fgColorButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getValue(AccessibleControlEvent e) {
                RGB c = AppearancePreferencePage.this._fgColorEditor.getColorValue();
                e.result = c != null ? "R " + c.red + ", G " + c.green + ", B " + c.blue : LpexResources.message("accessible.valueNone");
            }
        });
        l = new Label(stylesComposite, 16384);
        l.setText(LpexResources.message("preferences.appearance.background"));
        gd = new GridData();
        gd.horizontalIndent = 10;
        l.setLayoutData((Object)gd);
        this._bgColorEditor = new ColorEditor(stylesComposite);
        Button bgColorButton = this._bgColorEditor.getButton();
        bgColorButton.addSelectionListener(attributesListener);
        bgColorButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LpexResources.message("accessible.nameBackground");
            }

            public void getHelp(AccessibleEvent e) {
                e.result = LpexResources.message("accessible.roleBackground");
            }
        });
        bgColorButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getValue(AccessibleControlEvent e) {
                RGB c = AppearancePreferencePage.this._bgColorEditor.getColorValue();
                e.result = "R " + c.red + ", G " + c.green + ", B " + c.blue;
            }
        });
        l = new Label(stylesComposite, 16384);
        l.setText(LpexResources.message("pref.appearance.effects") + " ");
        l.setLayoutData((Object)new GridData(128));
        this._efColorEditor = new ColorEditor(stylesComposite);
        Button efColorButton = this._efColorEditor.getButton();
        gd = new GridData();
        gd.horizontalSpan = 3;
        efColorButton.setLayoutData((Object)gd);
        efColorButton.addSelectionListener(attributesListener);
        efColorButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LpexResources.message("acc.nameEffects");
            }

            public void getHelp(AccessibleEvent e) {
                e.result = LpexResources.message("acc.roleEffects");
            }
        });
        efColorButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getValue(AccessibleControlEvent e) {
                RGB c = AppearancePreferencePage.this._efColorEditor.getColorValue();
                e.result = "R " + c.red + ", G " + c.green + ", B " + c.blue;
            }
        });
        this._underlineCheckBox = new Button(stylesComposite, 32);
        this._underlineCheckBox.setText(LpexResources.message("preferences.appearance.underline"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalIndent = 10;
        this._underlineCheckBox.setLayoutData((Object)gd);
        this._underlineCheckBox.addSelectionListener(attributesListener);
        this._squiggleCheckBox = new Button(stylesComposite, 32);
        this._squiggleCheckBox.setText(LpexResources.message("preferences.appearance.squiggle"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalIndent = 10;
        this._squiggleCheckBox.setLayoutData((Object)gd);
        this._squiggleCheckBox.addSelectionListener(attributesListener);
        this._strikeoutCheckBox = new Button(stylesComposite, 32);
        this._strikeoutCheckBox.setText(LpexResources.message("preferences.appearance.strikeout"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this._strikeoutCheckBox.setLayoutData((Object)gd);
        this._strikeoutCheckBox.addSelectionListener(attributesListener);
        this._outlineCheckBox = new Button(stylesComposite, 32);
        this._outlineCheckBox.setText(LpexResources.message("preferences.appearance.outline"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this._outlineCheckBox.setLayoutData((Object)gd);
        this._outlineCheckBox.addSelectionListener(attributesListener);
        this._previewLabel = new Label(parent, 0);
        this._previewLabel.setText(LpexResources.message("preferences.appearance.preview"));
        this._previewLabel.setLayoutData((Object)new GridData(768));
        Composite lpex = new Composite(parent, 0);
        lpex.setLayoutData((Object)new GridData(1808));
        lpex.setLayout((Layout)new FillLayout());
        this.createLpexPreview(lpex);
        this.initialize();
        return parent;
    }

    private void createLpexPreview(Composite parent) {
        this._lpexWindow = new LpexWindow(parent, 2048);
        this._lpexView = new LpexView(false);
        this._lpexView.setWindow(this._lpexWindow);
        this.cmd("set updateProfile.baseProfile none");
        this.cmd("set updateProfile.userActions");
        this.cmd("set updateProfile.userCommands");
        this.cmd("set updateProfile.userKeyActions tab nextTab s-tab prevTab");
        this.cmd("set updateProfile.userMouseActions 3-pressed.1 popupAtMouse 1-pressed.1.t.p selectTextArea 1-pressed.1.e selectExpandHide 1-dragged.t.p selectTextArea dragged.t.p selectTextArea 1-dragged.e selectExpandHide dragged.e selectExpandHide");
        this.cmd("set updateProfile.userProfile");
        this._lpexView.addLpexViewListener(new LpexViewAdapter(){

            @Override
            public void updateProfile(LpexView view) {
                AppearancePreferencePage.this.handleUpdateProfile(view);
            }
        });
        this._lpexWindow.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AppearancePreferencePage.this._lpexView != null) {
                    AppearancePreferencePage.this._lpexView.dispose();
                    AppearancePreferencePage.this._lpexView = null;
                }
            }
        });
        this._lpexWindow.textWindow().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = AppearancePreferencePage.this.getLabelText(AppearancePreferencePage.this._previewLabel);
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                e.result = AppearancePreferencePage.this.getLabelShortcut(AppearancePreferencePage.this._previewLabel);
            }
        });
        MouseAdapter m = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AppearancePreferencePage.this.setStyleSelectionFromPreview(e);
            }
        };
        this._lpexWindow.statusLine().addMouseListener((MouseListener)m);
        this._lpexWindow.formatLine().addMouseListener((MouseListener)m);
        this._lpexWindow.messageLine().getChildren()[0].addMouseListener((MouseListener)m);
        this.cmd("set text Emphasis, current line, default text\n** ERR001 Embedded parser message.\nSelection Text in parser default style\nCompare added line text\nCompare deleted line text\n");
        this._lpexView.jump(1, 1);
        this.cmd("set emphasisLength 8");
        this.cmd("set insertMode off");
        this.cmd("updateProfile");
        this.cmd("screenShow view");
    }

    String getLabelText(Label label) {
        int indexOfMnemonic;
        Object text = label.getText();
        if (text != null && (indexOfMnemonic = ((String)text).indexOf(38)) >= 0 && indexOfMnemonic + 1 < ((String)text).length()) {
            text = ((String)text).substring(0, indexOfMnemonic) + ((String)text).substring(indexOfMnemonic + 1);
        }
        return text;
    }

    String getLabelShortcut(Label label) {
        int indexOfMnemonic;
        String text = label.getText();
        if (text != null && (indexOfMnemonic = text.indexOf(38)) >= 0 && indexOfMnemonic + 1 < text.length()) {
            return LpexResources.message("key.alt") + "+" + Character.toLowerCase(text.charAt(indexOfMnemonic + 1));
        }
        return null;
    }

    private void handleUpdateProfile(LpexView lpexView) {
        String defaultBaseProfile;
        if (!this._handleUpdateProfile) {
            return;
        }
        this.cmd("set readonly on");
        this.cmd("set prefixProtect off");
        if (!lpexView.queryOn("prefixArea") && ("ispf".equals(defaultBaseProfile = LpexView.globalQuery("default.updateProfile.baseProfile")) || "seu".equals(defaultBaseProfile) || "xedit".equals(defaultBaseProfile))) {
            this.cmd("set prefixArea on");
        }
        this.setPopup();
        LpexDocumentLocation loc = new LpexDocumentLocation(1, 1);
        this.cmd(loc, "set prefixText cc");
        this.updateEmulationStyles();
        loc.element = 2;
        this.cmd(loc, "set style mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm");
        loc.element = 3;
        this.cmd(loc, "set style sssssssssppppppppppppppppppppppppppppp");
        loc.element = 4;
        this.cmd(loc, "set style !!!!!!!!ggggg!rrrr!bbbb");
        this.cmd(loc, "set mark.added element");
        this.cmd("set markStyle.added a");
        this.cmd("set markHighlight.added on");
        loc.element = 5;
        this.cmd(loc, "set style !!!!!!!!ggggggg!rrrr!bbbb");
        this.cmd(loc, "set mark.deleted element");
        this.cmd("set markStyle.deleted d");
        this.cmd("set markHighlight.deleted on");
        this.cmd("set class.exclude on");
        loc.element = 6;
        this.cmd(loc, "set elementClasses exclude");
        this.cmd("set excludedClasses exclude");
        this.cmd("set messageText " + lpexView.query("version"));
        lpexView.defineAction("nextTab", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                if (view.queryOn("current.commandLine")) {
                    view.doDefaultAction(69);
                } else if (AppearancePreferencePage.this._resetButton != null) {
                    AppearancePreferencePage.this._resetButton.setFocus();
                }
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.defineAction("prevTab", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                if (AppearancePreferencePage.this._boldCheckBox != null && AppearancePreferencePage.this._boldCheckBox.isEnabled()) {
                    AppearancePreferencePage.this._boldCheckBox.setFocus();
                } else if (AppearancePreferencePage.this._outlineCheckBox != null && AppearancePreferencePage.this._outlineCheckBox.isEnabled()) {
                    AppearancePreferencePage.this._outlineCheckBox.setFocus();
                } else if (AppearancePreferencePage.this._strikeoutCheckBox != null && AppearancePreferencePage.this._strikeoutCheckBox.isEnabled()) {
                    AppearancePreferencePage.this._strikeoutCheckBox.setFocus();
                } else if (AppearancePreferencePage.this._bgColorEditor != null && AppearancePreferencePage.this._bgColorEditor.getButton().isEnabled()) {
                    AppearancePreferencePage.this._bgColorEditor.getButton().setFocus();
                } else {
                    AppearancePreferencePage.this._stylesList.setFocus();
                }
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.defineAction("update", new LpexBaseAction(){

            @Override
            public void doAction(LpexView view) {
                _updateMessageLine = !_updateMessageLine;
                AppearancePreferencePage.this.setPopup();
            }

            @Override
            public String getHelpId(LpexView view) {
                return "com.ibm.lpex.appearance_updateMessage";
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.defineAction("selectExpandHide", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                AppearancePreferencePage.this.setStyleSelection("expandHide", false);
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.defineAction("selectTextArea", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                view.doDefaultAction(84);
                int element = view.queryInt("element");
                String styleName = null;
                if (view.queryOn("inPrefix")) {
                    styleName = element == 1 ? "prefixText" : "prefixArea";
                    view.doDefaultCommand("set inPrefix off");
                } else if (view.queryInt("currentMousePoint.y") > view.queryInt("rowHeight") * 5) {
                    styleName = "background";
                } else if (element == 1) {
                    int position = view.queryInt("position");
                    styleName = position <= 1 ? "cursor" : (position <= 8 ? "emphasis" : (position >= 11 && position <= 22 ? "currentLine" : "default"));
                } else if (element == 2) {
                    styleName = "parserMessage";
                } else if (element == 3) {
                    int position = view.queryInt("position");
                    styleName = position <= 9 ? "selection" : "parserDefault";
                } else if (element == 4) {
                    styleName = "addedLines";
                } else if (element == 5) {
                    styleName = "deletedLines";
                }
                AppearancePreferencePage.this.setStyleSelection(styleName, false);
                view.jump(1, 1);
                view.doDefaultCommand("set emphasisLength 8");
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
    }

    private void updateEmulationStyles() {
        this.cmd("set styleAttributes.a " + this._lpexView.query("styleAttributes.addedLines"));
        this.cmd("set styleAttributes.d " + this._lpexView.query("styleAttributes.deletedLines"));
        this.cmd("set styleAttributes.m " + this._lpexView.query("styleAttributes.parserMessage"));
        this.cmd("set styleAttributes.p " + this._lpexView.query("styleAttributes.parserDefault"));
        this.cmd("set styleAttributes.s " + this._lpexView.query("styleAttributes.selection"));
        String defaultBackground = LpexPaletteAttributes.background(this._lpexView);
        this.cmd("set styleAttributes.r 128 0 0 " + defaultBackground);
        this.cmd("set styleAttributes.g 0 100 100 " + defaultBackground);
        this.cmd("set styleAttributes.b 0 0 0 " + defaultBackground);
    }

    private void setPopup() {
        this.cmd("set popup " + (_updateMessageLine ? "preferences.appearance.noUpdate" : "preferences.appearance.update") + " update");
    }

    public void init(IWorkbench workbench) {
    }

    protected void contributeButtons(Composite buttonBar) {
        ++((GridLayout)buttonBar.getLayout()).numColumns;
        this._resetButton = new Button(buttonBar, 8);
        this._resetButton.setFont(buttonBar.getFont());
        this._resetButton.setText(LpexResources.message("preferences.reset"));
        GridData data = new GridData(256);
        data.widthHint = Math.max(this.convertHorizontalDLUsToPixels(61), this._resetButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this._resetButton.setLayoutData((Object)data);
        this._resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AppearancePreferencePage.this.performReset();
            }
        });
    }

    protected void performDefaults() {
        this._useThemeButton.setSelection(ON.equals(LpexView.globalQuery("install.useTheme")));
        String installPalette = LpexView.globalQuery("install.updateProfile.palette");
        if (this._useThemeButton.getSelection()) {
            installPalette = this.getPaletteForTheme(this.getCurrentTheme());
        }
        int currentPaletteIndex = this.selectPalette(installPalette);
        int p = 0;
        while (p < this._palettes.length) {
            int i = 0;
            while (i < _styles.length) {
                String installAttributes;
                StyleNode style = _styles[i];
                this._currentAttributes[p][i] = installAttributes = LpexView.globalQuery("install.updateProfile.paletteAttributes." + style.name + "." + this._palettes[p]);
                if (p == currentPaletteIndex) {
                    this.cmd("set styleAttributes." + style.name + " " + installAttributes);
                }
                ++i;
            }
            ++p;
        }
        this.updateEmulationStyles();
        this.styleSelectionChanged(false);
        this.fontChanged(LpexUtilities.fontDataFromString(LpexStringTokenizer.removeQuotes(LpexView.globalQuery("install.font.fontData"))));
        this._paletteCombo.setEnabled(!this._useThemeButton.getSelection());
        this.map.clear();
    }

    protected void performReset() {
        this._useThemeButton.setSelection(ON.equals(LpexView.globalQuery("current.useTheme")));
        int currentPaletteIndex = this.selectPalette(this._initialPalette);
        int p = 0;
        while (p < this._palettes.length) {
            int i = 0;
            while (i < _styles.length) {
                if (this._currentAttributes[p][i] != null) {
                    this._currentAttributes[p][i] = this._initialAttributes[p][i];
                }
                if (p == currentPaletteIndex) {
                    this.cmd("set styleAttributes." + AppearancePreferencePage._styles[i].name + " " + this._initialAttributes[p][i]);
                }
                ++i;
            }
            ++p;
        }
        this.updateEmulationStyles();
        this.styleSelectionChanged(false);
        this.fontChanged(LpexUtilities.fontDataFromString(this._initialFontDataString));
        this._paletteCombo.setEnabled(!this._useThemeButton.getSelection());
        this.map.clear();
    }

    public boolean performOk() {
        LpexFieldEditorPreferencePage.updateDefaultValue("useTheme", this._useThemeButton.getSelection() ? ON : OFF);
        String newPalette = this.selectedPalette();
        String installPalette = LpexView.globalQuery("install.updateProfile.palette");
        boolean save = !newPalette.equals(installPalette);
        this.cmd("set default.updateProfile.palette" + (String)(save ? " " + newPalette : ""));
        String setting = StringConverter.asString((FontData)this._selectedFontData[0]);
        String defaultSetting = LpexStringTokenizer.removeQuotes(LpexView.globalQuery("default.font"));
        String installSetting = LpexStringTokenizer.removeQuotes(LpexView.globalQuery("install.font"));
        if (installSetting.equals(setting)) {
            if (!defaultSetting.equals("install")) {
                this.cmd("set default.font");
            }
        } else if (defaultSetting.equals("install") || !defaultSetting.equals(setting)) {
            this.cmd("set default.font.fontData " + LpexStringTokenizer.addQuotes(LpexUtilities.fontDataToString(this._selectedFontData)));
        }
        int p = 0;
        while (p < this._palettes.length) {
            String palette = this._palettes[p];
            int i = 0;
            while (i < _styles.length) {
                StyleNode style = _styles[i];
                String attributes = this._currentAttributes[p][i];
                if (attributes != null) {
                    String installAttributes = this._lpexView.query("install.updateProfile.paletteAttributes." + style.name + "." + palette);
                    boolean bl = save = !attributes.equals(installAttributes);
                    if (save) {
                        this.cmd("set default.updateProfile.paletteAttributes." + style.name + "." + palette + " " + attributes);
                    } else if (!this.map.isEmpty() && this.map.containsKey(style.name)) {
                        this.cmd("set default.updateProfile.paletteAttributes." + style.name + "." + palette + " " + this.map.get(style.name));
                    } else {
                        this.cmd("set default.updateProfile.paletteAttributes." + style.name + "." + palette);
                    }
                } else if (!this.map.isEmpty() && this.map.containsKey(style.name)) {
                    this.cmd("set default.updateProfile.paletteAttributes." + style.name + "." + palette + " " + this.map.get(style.name));
                }
                ++i;
            }
            ++p;
        }
        LpexView.doGlobalCommand("updateProfile all");
        LpexView.doGlobalCommand("screenShow");
        return true;
    }

    private void initialize() {
        this._useThemeButton.setSelection(ON.equals(LpexView.globalQuery("current.useTheme")));
        this._initialPalette = LpexView.globalQuery("current.updateProfile.palette");
        this._initialFontDataString = LpexStringTokenizer.removeQuotes(LpexView.globalQuery("default.font.fontData"));
        LpexStringTokenizer st = new LpexStringTokenizer(LpexView.globalQuery("current.updateProfile.palettes"));
        int paletteCount = st.countTokens();
        this._initialAttributes = new String[paletteCount][_styles.length];
        this._currentAttributes = new String[paletteCount][_styles.length];
        this._palettes = new String[paletteCount];
        this._paletteNames = new String[paletteCount];
        int i = 0;
        while (st.hasMoreTokens()) {
            this._palettes[i] = st.nextToken();
            this._paletteNames[i] = LpexResources.message("paletteName." + this._palettes[i]);
            if (this._paletteNames[i] == null) {
                this._paletteNames[i] = this._palettes[i];
            }
            this._paletteNames[i] = this._paletteNames[i] + " ";
            ++i;
        }
        this._paletteCombo.setItems(this._paletteNames);
        this._paletteCombo.setEnabled(!this._useThemeButton.getSelection());
        i = 0;
        while (i < _styles.length) {
            this._stylesList.add(AppearancePreferencePage._styles[i].name);
            ++i;
        }
        this._stylesList.select(0);
        int p = 0;
        while (p < this._palettes.length) {
            this.cmd("set updateProfile.palette " + this._palettes[p]);
            this.cmd("updateProfile");
            int i2 = 0;
            while (i2 < _styles.length) {
                this._initialAttributes[p][i2] = this._lpexView.query("styleAttributes." + AppearancePreferencePage._styles[i2].name);
                ++i2;
            }
            ++p;
        }
        this._handleUpdateProfile = true;
        String curSelectedPalette = LpexView.globalQuery("default.updateProfile.palette");
        String selectedPalette = null;
        if (this._useThemeButton.getSelection()) {
            selectedPalette = this.getPaletteForTheme(this.getCurrentTheme());
        } else if (curSelectedPalette == "install") {
            selectedPalette = LpexView.globalQuery("install.updateProfile.palette");
        } else {
            String[] stringArray = this._palettes;
            int n = this._palettes.length;
            int n2 = 0;
            while (n2 < n) {
                String p2 = stringArray[n2];
                if (p2.equals(curSelectedPalette)) {
                    selectedPalette = p2;
                    break;
                }
                ++n2;
            }
        }
        this.selectPalette(selectedPalette);
        this.fontChanged(LpexUtilities.fontDataFromString(this._initialFontDataString));
        this.themeChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent arg0) {
                if (arg0.getKey().equals(AppearancePreferencePage.THEME_ID) && AppearancePreferencePage.this._useThemeButton.getSelection()) {
                    String curSelectedPalette = LpexView.globalQuery("default.updateProfile.palette");
                    int paletteInd = -1;
                    if (curSelectedPalette == "install") {
                        curSelectedPalette = AppearancePreferencePage.this.getPaletteForTheme(arg0.getNewValue().toString());
                    }
                    int i = 0;
                    while (i < AppearancePreferencePage.this._palettes.length) {
                        if (AppearancePreferencePage.this._palettes[i].equals(curSelectedPalette)) {
                            paletteInd = i;
                            break;
                        }
                        ++i;
                    }
                    AppearancePreferencePage.this._paletteCombo.select(paletteInd);
                }
            }
        };
        this.addThemeChangeListener();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this._lpexView != null) {
            this.cmd("screenShow view");
        }
    }

    private String selectedPalette() {
        String paletteName = this._paletteCombo.getText();
        int i = 0;
        while (i < this._palettes.length) {
            if (this._paletteNames[i].equals(paletteName)) {
                return this._palettes[i];
            }
            ++i;
        }
        return "";
    }

    private int selectPalette(String palette) {
        int paletteIndex = this.paletteIndex(palette);
        this._handlePaletteChanged = false;
        this._paletteCombo.setText(this._paletteNames[paletteIndex]);
        this._handlePaletteChanged = true;
        this.paletteChanged();
        return paletteIndex;
    }

    private int paletteIndex(String palette) {
        int i = 0;
        while (i < this._palettes.length) {
            if (this._palettes[i].equals(palette)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private void paletteChanged() {
        if (!this._handlePaletteChanged) {
            return;
        }
        String selectedPalette = this.selectedPalette();
        this.cmd("set updateProfile.palette " + selectedPalette);
        this.cmd("updateProfile");
        int p = this.paletteIndex(selectedPalette);
        int i = 0;
        while (i < _styles.length) {
            String newAttributes = null;
            if (this._currentAttributes[p][i] != null) {
                newAttributes = this._currentAttributes[p][i];
                if (!this.map.isEmpty() && this.map.containsKey(AppearancePreferencePage._styles[i].name)) {
                    newAttributes = this.map.get(AppearancePreferencePage._styles[i].name);
                }
                this.cmd("set styleAttributes." + AppearancePreferencePage._styles[i].name + " " + newAttributes);
            } else if (!this.map.isEmpty() && this.map.containsKey(AppearancePreferencePage._styles[i].name)) {
                newAttributes = this.map.get(AppearancePreferencePage._styles[i].name);
                this.cmd("set styleAttributes." + AppearancePreferencePage._styles[i].name + " " + newAttributes);
            }
            ++i;
        }
        this.updateEmulationStyles();
        this.cmd("screenShow view");
        this.styleSelectionChanged(false);
    }

    private void fontChanged(FontData[] newFontData) {
        this._selectedFontData = newFontData;
        this._fontNameLabel.setText(" " + StringConverter.asString((FontData)this._selectedFontData[0]));
        this.cmd("set font.fontData " + LpexStringTokenizer.addQuotes(LpexUtilities.fontDataToString(this._selectedFontData)));
        this.cmd("screenShow view");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void styleSelectionChanged(boolean doScreenShow) {
        block28: {
            block30: {
                block29: {
                    styleIndex = this._stylesList.getSelectionIndex();
                    if (styleIndex < 0) break block29;
                    this._lastStyleIndex = styleIndex;
                    styleAttributes = this._lpexView.query("styleAttributes." + this._stylesList.getItem(this._lastStyleIndex));
                    if (AppearancePreferencePage._updateMessageLine) {
                        this.cmd("set messageText styleAttributes." + this._stylesList.getItem(this._lastStyleIndex) + " " + styleAttributes);
                        if (doScreenShow) {
                            this.cmd("screenShow view");
                        }
                    }
                    if (styleAttributes == null) break block29;
                    st = new StringTokenizer(styleAttributes);
                    token = st.nextToken();
                    colors = new int[9];
                    effectsColorSpecified = false;
                    underline = false;
                    squiggle = false;
                    strikeout = false;
                    outline = false;
                    bold = false;
                    try {
                        i = 0;
                        while (i < 9 && token != null) {
                            colors[i] = Integer.parseInt(token);
                            if (i > 5) {
                                effectsColorSpecified = true;
                            }
                            token = st.hasMoreTokens() != false ? st.nextToken() : null;
                            ++i;
                        }
                        ** GOTO lbl63
                    }
                    catch (NumberFormatException i) {}
                    if (true) ** GOTO lbl63
                }
                this._fgColorEditor.setEnabled(false);
                this._bgColorEditor.setEnabled(false);
                this._efColorEditor.setEnabled(false);
                this._underlineCheckBox.setSelection(false);
                this._underlineCheckBox.setEnabled(false);
                this._squiggleCheckBox.setSelection(false);
                this._squiggleCheckBox.setEnabled(false);
                this._strikeoutCheckBox.setSelection(false);
                this._strikeoutCheckBox.setEnabled(false);
                this._outlineCheckBox.setSelection(false);
                this._outlineCheckBox.setEnabled(false);
                if (this._boldCheckBox == null) return;
                this._boldCheckBox.setSelection(false);
                this._boldCheckBox.setEnabled(false);
                return;
                do {
                    if (token.equals("underline")) {
                        underline = true;
                    } else if (token.equals("squiggle")) {
                        squiggle = true;
                    } else if (token.equals("strikeout")) {
                        strikeout = true;
                    } else if (token.equals("bold")) {
                        bold = true;
                    } else if (token.equals("outline")) {
                        outline = true;
                    }
                    v0 = token = st.hasMoreTokens() != false ? st.nextToken() : null;
lbl63:
                    // 3 sources

                } while (token != null);
                bgOnly = colors[0] == -1;
                this._fgColorEditor.setColorValue(bgOnly != false ? null : new RGB(colors[0], colors[1], colors[2]));
                this._bgColorEditor.setColorValue(new RGB(colors[3], colors[4], colors[5]));
                lastStyle = AppearancePreferencePage._styles[this._lastStyleIndex];
                if (!lastStyle.usesExtraline && !lastStyle.usesOutline && !lastStyle.name.equals("formatLine")) break block30;
                if (effectsColorSpecified) {
                    this._efColorEditor.setColorValue(new RGB(colors[6], colors[7], colors[8]));
                    break block28;
                } else if (bgOnly) {
                    this._efColorEditor.setColorValue(this.getDefaultStyleFgRGB());
                    break block28;
                } else {
                    this._efColorEditor.setColorValue(new RGB(colors[0], colors[1], colors[2]));
                }
                break block28;
            }
            this._efColorEditor.setEnabled(false);
        }
        if (lastStyle.canBeBackgroundOnly) {
            this.setFgEditable(bgOnly == false, true);
        } else {
            this.setFgEditable(true, false);
        }
        if (lastStyle.usesExtraline) {
            this._underlineCheckBox.setEnabled(true);
            this._underlineCheckBox.setSelection(underline);
            this._squiggleCheckBox.setEnabled(true);
            this._squiggleCheckBox.setSelection(squiggle);
            this._strikeoutCheckBox.setEnabled(true);
            this._strikeoutCheckBox.setSelection(strikeout);
        } else {
            this._underlineCheckBox.setSelection(false);
            this._underlineCheckBox.setEnabled(false);
            this._squiggleCheckBox.setSelection(false);
            this._squiggleCheckBox.setEnabled(false);
            this._strikeoutCheckBox.setSelection(false);
            this._strikeoutCheckBox.setEnabled(false);
        }
        if (this._boldCheckBox != null) {
            if (lastStyle.usesBold) {
                this._boldCheckBox.setEnabled(true);
                this._boldCheckBox.setSelection(bold);
            } else {
                this._boldCheckBox.setSelection(false);
                this._boldCheckBox.setEnabled(false);
            }
        }
        if (lastStyle.usesOutline) {
            this._outlineCheckBox.setEnabled(true);
            this._outlineCheckBox.setSelection(outline);
            return;
        }
        this._outlineCheckBox.setSelection(false);
        this._outlineCheckBox.setEnabled(false);
    }

    private RGB getDefaultStyleFgRGB() {
        String[] defaultStyle = this._lpexView.query("styleAttributes.!").split(" ");
        return new RGB(Integer.parseInt(defaultStyle[0]), Integer.parseInt(defaultStyle[1]), Integer.parseInt(defaultStyle[2]));
    }

    private void setFgEditable(boolean selected, boolean editable) {
        if (this._fgCheckBox.getSelection() != selected) {
            this._fgCheckBox.setSelection(selected);
        }
        this._fgCheckBoxEditable = editable;
    }

    private void enableFgSelectionChanged() {
        boolean selected = this._fgCheckBox.getSelection();
        if (!this._fgCheckBoxEditable) {
            this._fgCheckBox.setSelection(!selected);
        } else if (!selected) {
            this._fgColorEditor.setColorValue(null);
            this.attributesChanged();
        }
    }

    private void attributesChanged() {
        this.attributesChanged(null);
    }

    private void attributesChanged(SelectionEvent event) {
        String newAttributes;
        StyleNode style = _styles[this._lastStyleIndex];
        RGB f = this._fgColorEditor.getColorValue();
        RGB b = this._bgColorEditor.getColorValue();
        RGB e = null;
        if (style.usesExtraline || style.usesOutline || style.name.equals("formatLine")) {
            if (event != null && event.widget == this._fgColorEditor.getButton()) {
                e = f;
                if (e == null) {
                    e = this.getDefaultStyleFgRGB();
                }
                this._efColorEditor.setColorValue(e);
            } else {
                e = this._efColorEditor.getColorValue();
            }
        }
        boolean underline = this._underlineCheckBox.getSelection();
        boolean squiggle = this._squiggleCheckBox.getSelection();
        boolean strikeout = this._strikeoutCheckBox.getSelection();
        boolean outline = this._outlineCheckBox.getSelection();
        if (underline && event != null && event.widget == this._underlineCheckBox) {
            squiggle = false;
            this._squiggleCheckBox.setSelection(false);
        } else if (squiggle && event != null && event.widget == this._squiggleCheckBox) {
            underline = false;
            this._underlineCheckBox.setSelection(false);
        }
        StringBuilder att = new StringBuilder(64);
        if (f != null) {
            att.append(f.red).append(' ').append(f.green).append(' ').append(f.blue).append(' ');
            this._fgCheckBox.setSelection(true);
        } else {
            att.append("-1 -1 -1 ");
        }
        att.append(b.red).append(' ').append(b.green).append(' ').append(b.blue);
        if (e != null && !e.equals((Object)f) && (underline || squiggle || strikeout || outline || style.name.equals("formatLine"))) {
            att.append(' ').append(e.red).append(' ').append(e.green).append(' ').append(e.blue);
        }
        if (underline) {
            att.append(" underline");
        }
        if (squiggle) {
            att.append(" squiggle");
        }
        if (strikeout) {
            att.append(" strikeout");
        }
        if (outline) {
            att.append(" outline");
        }
        if (this._boldCheckBox != null && this._boldCheckBox.getSelection()) {
            att.append(" bold");
        }
        this._currentAttributes[this.paletteIndex((String)this.selectedPalette())][this._lastStyleIndex] = newAttributes = att.toString();
        this.map.put(AppearancePreferencePage._styles[this._lastStyleIndex].name, newAttributes);
        String cmd = "styleAttributes." + style.name + " " + newAttributes;
        this.cmd("set " + cmd);
        if (_updateMessageLine) {
            this.cmd("set messageText " + cmd);
        }
        this.updateEmulationStyles();
        this.cmd("screenShow view");
    }

    private void setStyleSelectionFromPreview(MouseEvent e) {
        if (e.button != 1) {
            return;
        }
        String styleName = null;
        styleName = e.widget == this._lpexWindow.statusLine() ? "statusLine" : (e.widget == this._lpexWindow.formatLine() ? "formatLine" : "messageLine");
        this.setStyleSelection(styleName, false);
    }

    private void setStyleSelection(String styleName, boolean doScreenShow) {
        this._stylesList.setSelection(this.styleIndex(styleName));
        this._stylesList.showSelection();
        this.styleSelectionChanged(doScreenShow);
    }

    private int styleIndex(String styleName) {
        int i = 0;
        while (i < _styles.length) {
            if (AppearancePreferencePage._styles[i].name.equals(styleName)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private void cmd(String command) {
        this._lpexView.doDefaultCommand(command);
    }

    private void cmd(LpexDocumentLocation loc, String command) {
        this._lpexView.doDefaultCommand(loc, command);
    }

    private void addThemeChangeListener() {
        InstanceScope.INSTANCE.getNode(ECLIPSE_THEME_PLUGIN_ID).addPreferenceChangeListener(this.themeChangeListener);
    }

    public void removeThemeChangeListener() {
        InstanceScope.INSTANCE.getNode(ECLIPSE_THEME_PLUGIN_ID).removePreferenceChangeListener(this.themeChangeListener);
        this.themeChangeListener = null;
    }

    private void useThemeChanged() {
        if (this._useThemeButton.getSelection()) {
            String selectedPalette = this.getPaletteForTheme(this.getCurrentTheme());
            this.selectPalette(selectedPalette);
        }
        this._paletteCombo.setEnabled(!this._useThemeButton.getSelection());
    }

    private String getPaletteForTheme(String theme) {
        return theme.equals(DARK_THEME_ECLIPSE_ID) ? DARK_PALETTE : ECLIPSE_PALETTE;
    }

    private String getCurrentTheme() {
        IEclipsePreferences theme_prefs = InstanceScope.INSTANCE.getNode(WORKBENCH_RENDERERS_PLUGIN_ID);
        String curTheme = theme_prefs.get(ENABLE_THEME_ID, DEFAULT_THEME_ID);
        if (curTheme.equals(DEFAULT_THEME_ID)) {
            curTheme = Display.isSystemDarkTheme() ? DARK_THEME_ECLIPSE_ID : DEFAULT_THEME_ID;
        } else if (curTheme.equals("false")) {
            curTheme = DEFAULT_THEME_ID;
        } else {
            theme_prefs = InstanceScope.INSTANCE.getNode(ECLIPSE_THEME_PLUGIN_ID);
            curTheme = theme_prefs.get(THEME_ID, DEFAULT_THEME_ID);
        }
        return curTheme;
    }

    public void dispose() {
        this.removeThemeChangeListener();
        super.dispose();
    }
}

