/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.contentassist;

import com.ibm.lpex.alef.contentassist.ContentAssistant;
import com.ibm.lpex.core.LpexUtilities;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

class PopupCloser
implements FocusListener,
SelectionListener {
    private ContentAssistant fContentAssistant;
    private Table fTable;
    private ScrollBar fScrollbar;
    private boolean fScrollbarClicked;

    PopupCloser() {
    }

    public void install(ContentAssistant contentAssistant, Table table) {
        this.fContentAssistant = contentAssistant;
        this.fTable = table;
        if (LpexUtilities.okToUse((Widget)this.fTable)) {
            this.fTable.addFocusListener((FocusListener)this);
            this.fScrollbar = this.fTable.getVerticalBar();
            if (this.fScrollbar != null) {
                this.fScrollbar.addSelectionListener((SelectionListener)this);
            }
        }
    }

    public void uninstall() {
        if (LpexUtilities.okToUse((Widget)this.fScrollbar)) {
            this.fScrollbar.removeSelectionListener((SelectionListener)this);
        }
        if (LpexUtilities.okToUse((Widget)this.fTable)) {
            this.fTable.removeFocusListener((FocusListener)this);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        this.fScrollbarClicked = true;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.fScrollbarClicked = true;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(final FocusEvent e) {
        this.fScrollbarClicked = false;
        Display d = this.fTable.getDisplay();
        d.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (LpexUtilities.okToUse((Widget)PopupCloser.this.fTable) && !PopupCloser.this.fTable.isFocusControl() && !PopupCloser.this.fScrollbarClicked) {
                    PopupCloser.this.fContentAssistant.popupFocusLost(e);
                }
            }
        });
    }
}

