/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.contentassist;

import com.ibm.lpex.alef.contentassist.IContentAssistProcessor;
import com.ibm.lpex.alef.contentassist.IContextInformation;
import com.ibm.lpex.alef.contentassist.IContextInformationValidator;
import com.ibm.lpex.core.LpexDocumentLocation;
import org.eclipse.jface.text.ITextViewer;

public final class ContextInformationValidator
implements IContextInformationValidator {
    private IContentAssistProcessor fProcessor;
    private IContextInformation fContextInformation;
    private ITextViewer fViewer;

    public ContextInformationValidator(IContentAssistProcessor processor) {
        this.fProcessor = processor;
    }

    @Override
    public void install(IContextInformation contextInformation, ITextViewer viewer, LpexDocumentLocation location) {
        this.fContextInformation = contextInformation;
        this.fViewer = viewer;
    }

    @Override
    public boolean isContextInformationValid(LpexDocumentLocation location) {
        if (this.fContextInformation == null) {
            return false;
        }
        IContextInformation[] infos = this.fProcessor.computeContextInformation(this.fViewer, 0);
        if (infos != null) {
            int i = 0;
            while (i < infos.length) {
                if (this.fContextInformation.equals(infos[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

