/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.contentassist;

import com.ibm.lpex.alef.LpexTextViewer;
import com.ibm.lpex.alef.contentassist.ICompletionProposal;
import com.ibm.lpex.alef.contentassist.IContextInformation;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexView;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Image;

public final class CompletionProposal
implements ICompletionProposal {
    private String fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private Image fImage;
    private IContextInformation fContextInformation;
    private String fAdditionalProposalInfo;

    public CompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, null, null, null, null);
    }

    public CompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        Assert.isNotNull((Object)replacementString);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fImage = image;
        this.fDisplayString = displayString;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo;
    }

    @Override
    public void apply(LpexTextViewer viewer) {
        int completionIndex = -this.fReplacementOffset;
        if (completionIndex >= 0) {
            LpexView lpexView = viewer.getLpexView();
            LpexDocumentLocation loc = lpexView.documentLocation();
            if (loc.element != 0) {
                if (completionIndex != 0) {
                    if (completionIndex >= loc.position) {
                        completionIndex = loc.position - 1;
                    }
                    loc.position -= completionIndex;
                    lpexView.jump(loc);
                }
                if (this.fReplacementLength > 0) {
                    lpexView.doCommand("deleteText " + this.fReplacementLength);
                }
                lpexView.doCommand("insertText " + this.fReplacementString);
                lpexView.doCommand("screenShow document");
            }
        }
    }

    @Override
    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    @Override
    public Image getImage() {
        return this.fImage;
    }

    @Override
    public String getDisplayString() {
        return this.fDisplayString != null ? this.fDisplayString : this.fReplacementString;
    }

    @Override
    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }
}

