/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexAnnotationBarHoverManager;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

class OverviewRulerHoverManager
extends LpexAnnotationBarHoverManager {
    public OverviewRulerHoverManager(IOverviewRuler ruler, ISourceViewer sourceViewer, IAnnotationHover annotationHover, IInformationControlCreator creator) {
        super((IVerticalRulerInfo)ruler, sourceViewer, annotationHover, creator);
        this.setAnchor(ANCHOR_LEFT);
    }

    @Override
    protected void computeInformation() {
        Point location = this.getHoverEventLocation();
        int line = this.getVerticalRulerInfo().toDocumentLineNumber(location.y);
        IAnnotationHover hover = this.getAnnotationHover();
        IInformationControlCreator controlCreator = null;
        if (hover instanceof IAnnotationHoverExtension) {
            controlCreator = ((IAnnotationHoverExtension)hover).getHoverControlCreator();
        }
        this.setCustomInformationControlCreator(controlCreator);
        this.setInformation(hover.getHoverInfo(this.getSourceViewer(), line), this.computeArea(location.y));
    }

    private Rectangle computeArea(int y) {
        IOverviewRuler overviewRuler = (IOverviewRuler)this.getVerticalRulerInfo();
        int hover_height = overviewRuler.getAnnotationHeight();
        int hover_width = this.getVerticalRulerInfo().getControl().getSize().x;
        int hover_y = y;
        boolean hasAnnotation = true;
        while (hasAnnotation && hover_y > y - hover_height) {
            hasAnnotation = overviewRuler.hasAnnotation(--hover_y);
        }
        return new Rectangle(0, ++hover_y, hover_width, hover_height);
    }
}

