/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexSourceViewer;
import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceNode;

public class LpexViewPreferenceNode
extends PreferenceNode {
    public static final int VIEW_BASE_PREFERENCE_NODE = 0;
    public static final int VIEW_PARSER_PREFERENCE_NODE = 1;
    public static final int VIEW_SEQUENCE_NUMBERS_PREFERENCE_NODE = 2;
    public static final int VIEW_SOURCE_ENCODING_PREFERENCE_NODE = 3;
    private static final String EMPTYNAME = "";
    LpexViewPreferenceNode _next;
    private LpexSourceViewer _lpexSourceViewer;
    private LpexView _lpexView;
    private static int _nodeId;
    private static final Object _nodeLockObject;
    private int _nodeType;
    private static int _availableNodeType;
    private static final Object _availableNodeTypeLockObject;

    static {
        _nodeLockObject = new Object();
        _availableNodeType = 10;
        _availableNodeTypeLockObject = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int getNodeId() {
        Object object = _nodeLockObject;
        synchronized (object) {
            return _nodeId++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getAvailableNodeType() {
        Object object = _availableNodeTypeLockObject;
        synchronized (object) {
            return _availableNodeType++;
        }
    }

    LpexViewPreferenceNode(LpexSourceViewer lpexSourceViewer, int nodeType) {
        super("LPEX" + LpexViewPreferenceNode.getNodeId());
        this._lpexSourceViewer = lpexSourceViewer;
        this._nodeType = nodeType;
        if (this._nodeType != 0) {
            this._lpexSourceViewer.addViewPreferenceNode(this);
        }
    }

    LpexViewPreferenceNode(LpexView lpexView, int nodeType) {
        super("LPEX" + LpexViewPreferenceNode.getNodeId());
        this._lpexView = lpexView;
        this._nodeType = nodeType;
    }

    public LpexViewPreferenceNode(LpexSourceViewer lpexSourceViewer) {
        this(lpexSourceViewer, LpexViewPreferenceNode.getAvailableNodeType());
    }

    LpexView lpexView() {
        return this._lpexView;
    }

    public int getNodeType() {
        return this._nodeType;
    }

    public String getLabelText() {
        switch (this._nodeType) {
            case 0: {
                String name = null;
                if (this._lpexSourceViewer != null) {
                    name = Utilities.getViewName(this._lpexSourceViewer);
                }
                if (name == null) {
                    name = Utilities.getViewName(this._lpexView);
                }
                return name == null ? EMPTYNAME : name;
            }
            case 1: {
                return LpexResources.message("preferences.viewParserTitle");
            }
            case 2: {
                return LpexResources.message("preferences.sequenceNumbersTitle");
            }
            case 3: {
                return LpexResources.message("preferences.viewSourceEncodingTitle");
            }
        }
        return "???";
    }

    public final void createPage() {
        IPreferencePage newPage = this._lpexSourceViewer != null ? this._lpexSourceViewer.createViewPreferencePage(this._lpexSourceViewer.getFirstLpexView(), this._nodeType) : Utilities.createViewPreferencePage(this._lpexView, this._nodeType);
        this.setPage(newPage);
    }

    static void remove(IPreferenceNode baseLpexNode, IPreferenceNode baseViewNode) {
        if (baseViewNode != null) {
            IPreferenceNode[] viewSubNodes = baseViewNode.getSubNodes();
            int i = 0;
            while (i < viewSubNodes.length) {
                baseViewNode.remove(viewSubNodes[i]);
                ++i;
            }
            if (baseLpexNode != null) {
                baseLpexNode.remove(baseViewNode);
            }
            i = 0;
            while (i < viewSubNodes.length) {
                viewSubNodes[i].disposeResources();
                ++i;
            }
            baseViewNode.disposeResources();
        }
    }
}

