/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexAbstractTextEditor;
import com.ibm.lpex.alef.LpexAnnotationBarHoverManager;
import com.ibm.lpex.alef.LpexAnnotationRulerColumn;
import com.ibm.lpex.alef.LpexCompositeRuler;
import com.ibm.lpex.alef.LpexLanguageHelp;
import com.ibm.lpex.alef.LpexLanguageHelpExtension;
import com.ibm.lpex.alef.LpexSourceViewerConfiguration;
import com.ibm.lpex.alef.LpexStickyHoverManager;
import com.ibm.lpex.alef.LpexTextViewer;
import com.ibm.lpex.alef.LpexViewPreferenceNode;
import com.ibm.lpex.alef.OverviewRulerHoverManager;
import com.ibm.lpex.alef.contentassist.ContentAssistant;
import com.ibm.lpex.alef.contentassist.IContentAssistant;
import com.ibm.lpex.alef.preferences.SequenceNumbersPreferencePage;
import com.ibm.lpex.alef.preferences.SourceEncodingPreferencePage;
import com.ibm.lpex.alef.preferences.ViewBasePreferencePage;
import com.ibm.lpex.alef.preferences.ViewParserPreferencePage;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.jface.internal.text.InformationControlReplacer;
import org.eclipse.jface.internal.text.NonDeletingPositionUpdater;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension8;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.ISourceViewerExtension3;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.texteditor.ITextEditor;

public class LpexSourceViewer
extends LpexTextViewer
implements ISourceViewer,
ISourceViewerExtension,
ISourceViewerExtension2,
ISourceViewerExtension3 {
    protected static final int GAP_SIZE_1 = 1;
    protected static final String _SELECTION_POSITION_CATEGORY = "__selection_category";
    protected static final Object MODEL_ANNOTATION_MODEL = new Object();
    protected IContentAssistant fContentAssistant;
    protected boolean fContentAssistantInstalled;
    protected IReconciler fReconciler;
    protected IPresentationReconciler fPresentationReconciler;
    protected IAnnotationHover fAnnotationHover;
    protected final Stack<Position> fSelections = new Stack();
    protected IPositionUpdater fSelectionUpdater;
    protected String fSelectionCategory;
    protected IAnnotationHover fOverviewRulerAnnotationHover;
    protected IInformationPresenter fInformationPresenter;
    private IVerticalRuler fVerticalRuler;
    private boolean fIsVerticalRulerVisible;
    private Composite fComposite;
    private Composite _promptWindow;
    private IAnnotationModel fVisualAnnotationModel;
    private Annotation fRangeIndicator;
    private LpexAnnotationBarHoverManager fVerticalRulerHoveringController;
    private AbstractHoverInformationControlManager fOverviewRulerHoveringController;
    private IOverviewRuler fOverviewRuler;
    private boolean fIsOverviewRulerVisible;
    private LpexAbstractTextEditor _textEditor;
    private static final String LPEX_BASE_PREFERENCE_PAGE = "com.ibm.lpex.alef.preferences.LpexBasePreferencePage";
    private LpexViewPreferenceNode _viewBasePreferenceNode;
    private LpexViewPreferenceNode _childViewPreferenceNodes;
    private LpexLanguageHelp _languageHelp;
    private boolean fControlCreated = false;

    public LpexSourceViewer(Composite parent, ITextEditor textEditor, IVerticalRuler ruler, int styles) {
        this(parent, textEditor, ruler, null, false, styles);
    }

    public LpexSourceViewer(Composite parent, ITextEditor textEditor, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        this._textEditor = (LpexAbstractTextEditor)textEditor;
        this._classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        this.fVerticalRuler = verticalRuler;
        this.fIsVerticalRulerVisible = verticalRuler != null;
        this.fOverviewRuler = overviewRuler;
        this.fIsOverviewRulerVisible = showAnnotationsOverview && overviewRuler != null;
        this.createControl(parent, styles);
    }

    @Override
    public LpexAbstractTextEditor getTextEditor() {
        return this._textEditor;
    }

    @Override
    protected void createControl(Composite parent, int styles) {
        this.fComposite = new Canvas(parent, 0);
        this.fComposite.setLayout(this.createLayout());
        super.createControl(this.fComposite, styles &= 0xFFFFF7FF);
        if (this.fVerticalRuler != null) {
            this.fVerticalRuler.createControl(this.fComposite, (ITextViewer)this);
        }
        if (this.fOverviewRuler != null) {
            this.fOverviewRuler.createControl(this.fComposite, (ITextViewer)this);
        }
        this.fControlCreated = true;
        if (this.fIsVerticalRulerVisible && this.fVerticalRuler instanceof LpexCompositeRuler) {
            this.addViewportListener((LpexCompositeRuler)this.fVerticalRuler);
        }
    }

    protected Layout createLayout() {
        return new RulerLayout(1);
    }

    @Override
    public Control getControl() {
        return this.fComposite != null ? this.fComposite : super.getControl();
    }

    public Composite getPromptWindow() {
        if (this._promptWindow == null && this.fComposite != null) {
            this._promptWindow = new Composite(this.fComposite, 0);
            this._promptWindow.setVisible(false);
            this.fComposite.layout();
            this._promptWindow.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    LpexSourceViewer.this._promptWindow = null;
                    if (LpexSourceViewer.this.fComposite != null) {
                        LpexSourceViewer.this.fComposite.layout();
                    }
                }
            });
        }
        return this._promptWindow;
    }

    public void setAnnotationHover(IAnnotationHover annotationHover) {
        this.fAnnotationHover = annotationHover;
    }

    public void setOverviewRulerAnnotationHover(IAnnotationHover annotationHover) {
        this.fOverviewRulerAnnotationHover = annotationHover;
    }

    public void configure(SourceViewerConfiguration configuration) {
        if (this.getLpexView() == null) {
            return;
        }
        this.setDocumentPartitioning(configuration.getConfiguredDocumentPartitioning((ISourceViewer)this));
        this.fPresentationReconciler = configuration.getPresentationReconciler((ISourceViewer)this);
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.install((ITextViewer)this);
        }
        this.fReconciler = configuration.getReconciler((ISourceViewer)this);
        if (this.fReconciler != null) {
            this.fReconciler.install((ITextViewer)this);
        }
        if (configuration instanceof LpexSourceViewerConfiguration) {
            this.fContentAssistant = ((LpexSourceViewerConfiguration)configuration).getLpexContentAssistant(this);
        }
        if (this.fContentAssistant != null) {
            this.fContentAssistant.install(this);
            this.fContentAssistantInstalled = true;
        }
        this.fInformationPresenter = configuration.getInformationPresenter((ISourceViewer)this);
        if (this.fInformationPresenter != null) {
            this.fInformationPresenter.install((ITextViewer)this);
        }
        this.setAnnotationHover(configuration.getAnnotationHover((ISourceViewer)this));
        this.setOverviewRulerAnnotationHover(configuration.getOverviewRulerAnnotationHover((ISourceViewer)this));
        this.setHoverControlCreator(configuration.getInformationControlCreator((ISourceViewer)this));
        this.setHyperlinkPresenter(configuration.getHyperlinkPresenter((ISourceViewer)this));
        IHyperlinkDetector[] hyperlinkDetectors = configuration.getHyperlinkDetectors((ISourceViewer)this);
        int eventStateMask = configuration.getHyperlinkStateMask((ISourceViewer)this);
        this.setHyperlinkDetectors(hyperlinkDetectors, eventStateMask);
        String[] types = configuration.getConfiguredContentTypes((ISourceViewer)this);
        int i = 0;
        while (i < types.length) {
            String t = types[i];
            int[] stateMasks = configuration.getConfiguredTextHoverStateMasks((ISourceViewer)this, t);
            if (stateMasks != null) {
                int j = 0;
                while (j < stateMasks.length) {
                    int stateMask = stateMasks[j];
                    this.setTextHover(configuration.getTextHover((ISourceViewer)this, t, stateMask), t, stateMask);
                    ++j;
                }
            } else {
                this.setTextHover(configuration.getTextHover((ISourceViewer)this, t), t, 255);
            }
            ++i;
        }
        this.activatePlugins();
    }

    protected void ensureAnnotationHoverManagerInstalled() {
        if (!(this.fVerticalRuler == null || this.fAnnotationHover == null && this.isVerticalRulerOnlyShowingAnnotations() || this.fVerticalRulerHoveringController != null || this.fHoverControlCreator == null)) {
            this.fVerticalRulerHoveringController = new LpexAnnotationBarHoverManager((IVerticalRulerInfo)this.fVerticalRuler, this, this.fAnnotationHover, this.fHoverControlCreator);
            this.fVerticalRulerHoveringController.install(this.fVerticalRuler.getControl());
            this.fVerticalRulerHoveringController.getInternalAccessor().setInformationControlReplacer((InformationControlReplacer)new LpexStickyHoverManager(this, (AbstractHoverInformationControlManager)this.fVerticalRulerHoveringController));
        }
    }

    protected void ensureOverviewHoverManagerInstalled() {
        if (this.fOverviewRuler != null && this.fOverviewRulerAnnotationHover != null && this.fOverviewRulerHoveringController == null && this.fHoverControlCreator != null) {
            this.fOverviewRulerHoveringController = new OverviewRulerHoverManager(this.fOverviewRuler, (ISourceViewer)this, this.fOverviewRulerAnnotationHover, this.fHoverControlCreator);
            this.fOverviewRulerHoveringController.install(this.fOverviewRuler.getControl());
            this.fOverviewRulerHoveringController.getInternalAccessor().setInformationControlReplacer((InformationControlReplacer)new LpexStickyHoverManager(this, this.fOverviewRulerHoveringController));
        }
    }

    @Override
    public void setHoverEnrichMode(ITextViewerExtension8.EnrichMode mode) {
        super.setHoverEnrichMode(mode);
        if (this.fVerticalRulerHoveringController != null) {
            this.fVerticalRulerHoveringController.getInternalAccessor().setHoverEnrichMode(mode);
        }
        if (this.fOverviewRulerHoveringController != null) {
            this.fOverviewRulerHoveringController.getInternalAccessor().setHoverEnrichMode(mode);
        }
    }

    @Override
    public void activatePlugins() {
        this.ensureAnnotationHoverManagerInstalled();
        this.ensureOverviewHoverManagerInstalled();
        super.activatePlugins();
    }

    @Override
    public void setDocument(IDocument document) {
        this.setDocument(document, null, -1, -1);
    }

    @Override
    public void setDocument(IDocument document, int visibleRegionOffset, int visibleRegionLength) {
        this.setDocument(document, null, visibleRegionOffset, visibleRegionLength);
    }

    public void setDocument(IDocument document, IAnnotationModel annotationModel) {
        this.setDocument(document, annotationModel, -1, -1);
    }

    protected IAnnotationModel createVisualAnnotationModel(IAnnotationModel annotationModel) {
        AnnotationModel model = new AnnotationModel();
        model.addAnnotationModel(MODEL_ANNOTATION_MODEL, annotationModel);
        return (IAnnotationModel)model;
    }

    protected void disposeVisualAnnotationModel() {
        if (this.fVisualAnnotationModel != null) {
            if (this.getDocument() != null) {
                this.fVisualAnnotationModel.disconnect(this.getDocument());
            }
            if (this.fVisualAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fVisualAnnotationModel).removeAnnotationModel(MODEL_ANNOTATION_MODEL);
            }
            this.fVisualAnnotationModel = null;
        }
    }

    public void setDocument(IDocument document, IAnnotationModel annotationModel, int modelRangeOffset, int modelRangeLength) {
        this._annotationModel = annotationModel;
        this.disposeVisualAnnotationModel();
        if (annotationModel != null && document != null) {
            this.fVisualAnnotationModel = this.createVisualAnnotationModel(annotationModel);
            if (this.getActiveLpexWindow() != null) {
                this.getActiveLpexWindow().setModel(this.fVisualAnnotationModel);
            }
            if (annotationModel instanceof ISynchronizable && this.fVisualAnnotationModel instanceof ISynchronizable) {
                ISynchronizable sync = (ISynchronizable)this.fVisualAnnotationModel;
                sync.setLockObject(((ISynchronizable)annotationModel).getLockObject());
            }
            this.fVisualAnnotationModel.connect(document);
        }
        if (modelRangeOffset == -1 && modelRangeLength == -1) {
            super.setDocument(document);
        } else {
            super.setDocument(document, modelRangeOffset, modelRangeLength);
        }
        if (this.fVerticalRuler != null) {
            this.fVerticalRuler.setModel(this.fVisualAnnotationModel);
        }
        if (this.fOverviewRuler != null) {
            this.fOverviewRuler.setModel(this.fVisualAnnotationModel);
        }
    }

    public IAnnotationModel getAnnotationModel() {
        if (this.fVisualAnnotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension extension = (IAnnotationModelExtension)this.fVisualAnnotationModel;
            return extension.getAnnotationModel(MODEL_ANNOTATION_MODEL);
        }
        return null;
    }

    public IAnnotationModel getVisualAnnotationModel() {
        return this.fVisualAnnotationModel;
    }

    public void unconfigure() {
        this.clearRememberedSelection();
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.uninstall();
            this.fPresentationReconciler = null;
        }
        if (this.fReconciler != null) {
            this.fReconciler.uninstall();
            this.fReconciler = null;
        }
        if (this.fContentAssistant != null) {
            this.fContentAssistant.uninstall();
            this.fContentAssistantInstalled = false;
            this.fContentAssistant = null;
        }
        if (this.fInformationPresenter != null) {
            this.fInformationPresenter.uninstall();
            this.fInformationPresenter = null;
        }
        this.fTextHovers = null;
        if (this.fVerticalRulerHoveringController != null) {
            this.fVerticalRulerHoveringController.dispose();
            this.fVerticalRulerHoveringController = null;
        }
        if (this.fOverviewRulerHoveringController != null) {
            this.fOverviewRulerHoveringController.dispose();
            this.fOverviewRulerHoveringController = null;
        }
        this.setHyperlinkDetectors(null, 0);
    }

    @Override
    protected void handleDispose() {
        this.unconfigure();
        this.disposeVisualAnnotationModel();
        this.fVerticalRuler = null;
        this.fOverviewRuler = null;
        this.disposeViewPreferencePages();
        this.fComposite = null;
        super.handleDispose();
    }

    @Override
    public boolean canDoOperation(int operation) {
        if (this.getLpexView() == null) {
            return false;
        }
        if (operation == 13) {
            return this.fContentAssistant != null && this.fContentAssistantInstalled && this.isEditable();
        }
        if (operation == 14) {
            return this.fContentAssistant != null && this.fContentAssistantInstalled && this.isEditable();
        }
        if (operation == 16) {
            return this.fInformationPresenter != null;
        }
        return super.canDoOperation(operation);
    }

    protected Point rememberSelection() {
        Point selection = this.getSelectedRange();
        IDocument document = this.getDocument();
        if (this.fSelections.isEmpty()) {
            this.fSelectionCategory = _SELECTION_POSITION_CATEGORY + ((Object)((Object)this)).hashCode();
            this.fSelectionUpdater = new NonDeletingPositionUpdater(this.fSelectionCategory);
            document.addPositionCategory(this.fSelectionCategory);
            document.addPositionUpdater(this.fSelectionUpdater);
        }
        try {
            Position position = new Position(selection.x, selection.y);
            document.addPosition(this.fSelectionCategory, position);
            this.fSelections.push(position);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            // empty catch block
        }
        return selection;
    }

    protected void restoreSelection() {
        if (!this.fSelections.isEmpty()) {
            IDocument document = this.getDocument();
            Position position = this.fSelections.pop();
            try {
                document.removePosition(this.fSelectionCategory, position);
                Point currentSelection = this.getSelectedRange();
                if (currentSelection == null || currentSelection.x != position.getOffset() || currentSelection.y != position.getLength()) {
                    this.setSelectedRange(position.getOffset(), position.getLength());
                }
                if (this.fSelections.isEmpty()) {
                    this.clearRememberedSelection();
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
        }
    }

    protected void clearRememberedSelection() {
        IDocument document;
        if (!this.fSelections.isEmpty()) {
            this.fSelections.clear();
        }
        if ((document = this.getDocument()) != null && this.fSelectionUpdater != null) {
            document.removePositionUpdater(this.fSelectionUpdater);
            try {
                document.removePositionCategory(this.fSelectionCategory);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
        }
        this.fSelectionUpdater = null;
        this.fSelectionCategory = null;
    }

    @Override
    public void doOperation(int operation) {
        LpexView lpexView = this.getLpexView();
        if (lpexView == null) {
            return;
        }
        switch (operation) {
            case 13: {
                this.fContentAssistant.showPossibleCompletions();
                return;
            }
            case 14: {
                this.fContentAssistant.showContextInformation();
                return;
            }
            case 16: {
                this.fInformationPresenter.showInformation();
                return;
            }
        }
        super.doOperation(operation);
    }

    @Override
    public void enableOperation(int operation, boolean enable) {
        switch (operation) {
            case 13: 
            case 14: {
                if (this.fContentAssistant == null) {
                    return;
                }
                if (enable) {
                    if (this.fContentAssistantInstalled) break;
                    this.fContentAssistant.install(this);
                    this.fContentAssistantInstalled = true;
                    break;
                }
                if (!this.fContentAssistantInstalled) break;
                this.fContentAssistant.uninstall();
                this.fContentAssistantInstalled = false;
                break;
            }
        }
    }

    public void setRangeIndicator(Annotation rangeIndicator) {
        this.fRangeIndicator = rangeIndicator;
    }

    public void setRangeIndication(int start, int len, boolean moveCursor) {
        if (moveCursor) {
            LpexDocumentLocation cursor = this.getDocumentAdapter().getLpexDocumentLocation(start);
            if (cursor.element != 0) {
                LpexView lpexView = this.getFirstLpexView();
                lpexView.jump(cursor);
                lpexView.doCommand("screenShow view");
            }
        }
        if (this.fRangeIndicator != null && this.fVisualAnnotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension extension = (IAnnotationModelExtension)this.fVisualAnnotationModel;
            extension.modifyAnnotationPosition(this.fRangeIndicator, new Position(start, len));
        }
    }

    public IRegion getRangeIndication() {
        Position position;
        if (this.fRangeIndicator != null && this.fVisualAnnotationModel != null && (position = this.fVisualAnnotationModel.getPosition(this.fRangeIndicator)) != null) {
            return new Region(position.getOffset(), position.getLength());
        }
        return null;
    }

    public void removeRangeIndication() {
        if (this.fRangeIndicator != null && this.fVisualAnnotationModel != null) {
            this.fVisualAnnotationModel.removeAnnotation(this.fRangeIndicator);
        }
    }

    public void showAnnotations(boolean show) {
        boolean old = this.fIsVerticalRulerVisible;
        boolean bl = this.fIsVerticalRulerVisible = this.fVerticalRuler != null && (show || !this.isVerticalRulerOnlyShowingAnnotations());
        if (old != this.fIsVerticalRulerVisible && this.fComposite != null && !this.fComposite.isDisposed()) {
            this.fComposite.layout();
        }
        if (this.fIsVerticalRulerVisible && show) {
            this.ensureAnnotationHoverManagerInstalled();
        } else if (this.fVerticalRulerHoveringController != null) {
            this.fVerticalRulerHoveringController.dispose();
            this.fVerticalRulerHoveringController = null;
        }
    }

    private boolean isVerticalRulerOnlyShowingAnnotations() {
        if (this.fVerticalRuler instanceof LpexCompositeRuler) {
            Iterator iter = ((LpexCompositeRuler)this.fVerticalRuler).getDecoratorIterator();
            return iter.hasNext() && iter.next() instanceof LpexAnnotationRulerColumn && !iter.hasNext();
        }
        return false;
    }

    protected final IVerticalRuler getVerticalRuler() {
        return this.fVerticalRuler;
    }

    public void addVerticalRulerColumn(IVerticalRulerColumn column) {
        IVerticalRuler ruler = this.getVerticalRuler();
        if (ruler instanceof CompositeRuler) {
            CompositeRuler compositeRuler = (CompositeRuler)ruler;
            compositeRuler.addDecorator(99, column);
        }
    }

    public void removeVerticalRulerColumn(IVerticalRulerColumn column) {
        IVerticalRuler ruler = this.getVerticalRuler();
        if (ruler instanceof CompositeRuler) {
            CompositeRuler compositeRuler = (CompositeRuler)ruler;
            compositeRuler.removeDecorator(column);
        }
    }

    public void showAnnotationsOverview(boolean show) {
        boolean old = this.fIsOverviewRulerVisible;
        boolean bl = this.fIsOverviewRulerVisible = show && this.fOverviewRuler != null;
        if (old != this.fIsOverviewRulerVisible) {
            if (this.fComposite != null && !this.fComposite.isDisposed()) {
                this.fComposite.layout();
            }
            if (this.fIsOverviewRulerVisible) {
                this.ensureOverviewHoverManagerInstalled();
            } else if (this.fOverviewRulerHoveringController != null) {
                this.fOverviewRulerHoveringController.dispose();
                this.fOverviewRulerHoveringController = null;
            }
        }
    }

    public IAnnotationHover getCurrentAnnotationHover() {
        return this.fVerticalRulerHoveringController == null ? null : this.fVerticalRulerHoveringController.getCurrentAnnotationHover();
    }

    @Override
    void initLpexView(LpexView lpexView) {
        super.initLpexView(lpexView);
        if (this._textEditor != null) {
            this._textEditor.initLpexView(lpexView);
        }
        if (this.fContentAssistant != null && this.fContentAssistant instanceof ContentAssistant) {
            ((ContentAssistant)this.fContentAssistant).newLpexView(lpexView);
        }
    }

    @Override
    void handleLpexViewDisposed(LpexView lpexView) {
        super.handleLpexViewDisposed(lpexView);
        if (this.fContentAssistant != null && this.fContentAssistant instanceof ContentAssistant) {
            ((ContentAssistant)this.fContentAssistant).disposeLpexView(lpexView);
        }
    }

    @Override
    void initPrimaryLpexWindow(LpexWindow lpexWindow) {
        super.initPrimaryLpexWindow(lpexWindow);
        if (this._textEditor != null) {
            this._textEditor.initPrimaryLpexWindow(lpexWindow);
        }
    }

    @Override
    void initSecondaryLpexWindow(LpexWindow lpexWindow) {
        super.initSecondaryLpexWindow(lpexWindow);
        if (this._textEditor != null) {
            this._textEditor.initSecondaryLpexWindow(lpexWindow);
        }
    }

    @Override
    protected void updateProfile(LpexView lpexView) {
        super.updateProfile(lpexView);
        if (this._textEditor != null) {
            this._textEditor.doUpdateProfile(lpexView);
        }
    }

    @Override
    void widgetContentsSet(LpexView lpexView) {
        if (this._textEditor != null) {
            this._textEditor.widgetContentsSet(lpexView);
        }
    }

    @Override
    void activeWindowChanged(LpexWindow lpexWindow) {
        super.activeWindowChanged(lpexWindow);
        lpexWindow.setModel(this.fVisualAnnotationModel);
        if (this._textEditor != null) {
            this._textEditor.activeWindowChanged(lpexWindow);
        }
    }

    protected void setLanguageHelp(LpexLanguageHelp lsh) {
        this._languageHelp = lsh;
    }

    @Override
    void performHelp(LpexView lpexView) {
        if (lpexView == null) {
            lpexView = this.getLpexView();
        }
        if (lpexView == null || lpexView.window() == null) {
            return;
        }
        if (lpexView.window().textWindow().isFocusControl()) {
            IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
            if (lpexView.queryOn("inPrefix")) {
                helpSystem.displayHelpResource("/com.ibm.lpex.doc.user/ref/rlb" + lpexView.query("baseProfile") + ".htm#PrefixCommands");
            } else {
                String helpContextId;
                if (this._languageHelp != null) {
                    String helpPage = this._languageHelp.getHelpPage(lpexView);
                    if (helpPage != null) {
                        helpSystem.displayHelpResource(helpPage);
                        return;
                    }
                    if (this._languageHelp instanceof LpexLanguageHelpExtension && !((LpexLanguageHelpExtension)((Object)this._languageHelp)).isDisplayEditorHelp(lpexView)) {
                        return;
                    }
                }
                if (this._textEditor != null && (helpContextId = this._textEditor.getHelpContextId()) != null) {
                    helpSystem.displayHelp(helpContextId);
                }
            }
        } else {
            this.displayCommandLineHelp(lpexView);
        }
    }

    protected void createViewPreferenceNodes(LpexSourceViewer lpexSourceViewer) {
        if (this._textEditor != null) {
            this._textEditor.createViewPreferenceNodes(lpexSourceViewer);
        }
    }

    protected IPreferencePage createViewPreferencePage(LpexView lpexView, int nodeType) {
        Object newPage = null;
        if (this._textEditor != null) {
            newPage = this._textEditor.createViewPreferencePage(lpexView, nodeType);
        }
        if (newPage == null) {
            switch (nodeType) {
                case 0: {
                    newPage = new ViewBasePreferencePage(lpexView);
                    break;
                }
                case 1: {
                    newPage = new ViewParserPreferencePage(lpexView);
                    break;
                }
                case 2: {
                    newPage = new SequenceNumbersPreferencePage(lpexView);
                    break;
                }
                case 3: {
                    newPage = new SourceEncodingPreferencePage(lpexView);
                    break;
                }
            }
        }
        return newPage;
    }

    void updatePreferencePage() {
        IPreferenceNode lpexBaseNode = PlatformUI.getWorkbench().getPreferenceManager().find(LPEX_BASE_PREFERENCE_PAGE);
        if (lpexBaseNode == null) {
            return;
        }
        LpexViewPreferenceNode.remove(lpexBaseNode, (IPreferenceNode)this._viewBasePreferenceNode);
        this._childViewPreferenceNodes = null;
        this._viewBasePreferenceNode = new LpexViewPreferenceNode(this, 0);
        new LpexViewPreferenceNode(this, 1);
        new LpexViewPreferenceNode(this, 2);
        new LpexViewPreferenceNode(this, 3);
        this.createViewPreferenceNodes(this);
        lpexBaseNode.add((IPreferenceNode)this._viewBasePreferenceNode);
        LpexViewPreferenceNode v = this._childViewPreferenceNodes;
        while (v != null) {
            this._viewBasePreferenceNode.add((IPreferenceNode)v);
            v = v._next;
        }
    }

    private void disposeViewPreferencePages() {
        IPreferenceNode lpexBaseNode = PlatformUI.getWorkbench().getPreferenceManager().find(LPEX_BASE_PREFERENCE_PAGE);
        LpexViewPreferenceNode.remove(lpexBaseNode, (IPreferenceNode)this._viewBasePreferenceNode);
        this._childViewPreferenceNodes = null;
        this._viewBasePreferenceNode = null;
    }

    void addViewPreferenceNode(LpexViewPreferenceNode newNode) {
        LpexViewPreferenceNode v = this._childViewPreferenceNodes;
        while (v != null) {
            if (v._next == null) {
                v._next = newNode;
                return;
            }
            v = v._next;
        }
        this._childViewPreferenceNodes = newNode;
    }

    public IQuickAssistAssistant getQuickAssistAssistant() {
        return null;
    }

    public IQuickAssistInvocationContext getQuickAssistInvocationContext() {
        return null;
    }

    class RulerLayout
    extends Layout {
        protected int fGap;

        public RulerLayout(int gap) {
            this.fGap = gap;
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (LpexSourceViewer.this.fControlCreated) {
                Control[] children = composite.getChildren();
                Point s = children[children.length - 1].computeSize(-1, -1, flushCache);
                if (LpexSourceViewer.this.fVerticalRuler != null && LpexSourceViewer.this.fIsVerticalRulerVisible) {
                    s.x += LpexSourceViewer.this.fVerticalRuler.getWidth() + this.fGap;
                }
                if (LpexSourceViewer.this._promptWindow != null && LpexSourceViewer.this._promptWindow.getVisible()) {
                    s.y += LpexSourceViewer.this._promptWindow.computeSize((int)-1, (int)-1, (boolean)flushCache).y;
                }
                return s;
            }
            return composite.computeSize(-1, -1, flushCache);
        }

        protected void layout(Composite composite, boolean flushCache) {
            if (LpexSourceViewer.this.fControlCreated) {
                Rectangle clientArea = composite.getClientArea();
                Rectangle trim = LpexSourceViewer.this.getLpexMultiWindow().computeTrim(0, 0, 0, 0);
                int x = clientArea.x;
                int width = clientArea.width;
                int promptHeight = LpexSourceViewer.this._promptWindow != null && LpexSourceViewer.this._promptWindow.getVisible() ? LpexSourceViewer.this._promptWindow.computeSize((int)-1, (int)-1).y : 0;
                int textWidgetHeight = clientArea.height - promptHeight;
                int overviewRulerWidth = 0;
                if (LpexSourceViewer.this.fOverviewRuler != null && LpexSourceViewer.this.fIsOverviewRulerVisible) {
                    overviewRulerWidth = LpexSourceViewer.this.fOverviewRuler.getWidth();
                    width -= overviewRulerWidth + this.fGap;
                }
                if (LpexSourceViewer.this.fVerticalRuler != null && LpexSourceViewer.this.fIsVerticalRulerVisible) {
                    int verticalRulerWidth = LpexSourceViewer.this.fVerticalRuler.getWidth();
                    Control verticalRulerControl = LpexSourceViewer.this.fVerticalRuler.getControl();
                    int oldWidth = verticalRulerControl.getBounds().width;
                    verticalRulerControl.setBounds(x, clientArea.y, verticalRulerWidth, textWidgetHeight - trim.height);
                    if (flushCache && LpexSourceViewer.this.getVisualAnnotationModel() != null && oldWidth == verticalRulerWidth) {
                        verticalRulerControl.redraw();
                    }
                    width -= verticalRulerWidth + this.fGap;
                    x += verticalRulerWidth + this.fGap;
                }
                LpexSourceViewer.this.getLpexMultiWindow().setBounds(x, clientArea.y, width, textWidgetHeight);
                if (LpexSourceViewer.this.fOverviewRuler != null && LpexSourceViewer.this.fIsOverviewRulerVisible) {
                    int overviewRulerX = clientArea.x + clientArea.width - overviewRulerWidth - 1;
                    Rectangle textWindowLocation = LpexSourceViewer.this.getFirstLpexWindow().textWindow().getBounds();
                    int scrollBarHeight = LpexSourceViewer.this.getFirstLpexWindow().horizontalScrollBar().getSize().y;
                    int overviewRulerHeight = 0;
                    if (LpexSourceViewer.this.getFirstLpexWindow().verticalScrollBar().isVisible()) {
                        overviewRulerHeight = LpexSourceViewer.this.getFirstLpexWindow().verticalScrollBar().getSize().y - scrollBarHeight * 2;
                    } else {
                        overviewRulerHeight = textWindowLocation.height;
                        if (LpexSourceViewer.this.getFirstLpexWindow().horizontalScrollBar().isVisible()) {
                            overviewRulerHeight -= scrollBarHeight;
                        }
                        scrollBarHeight = 0;
                    }
                    LpexSourceViewer.this.fOverviewRuler.getControl().setBounds(overviewRulerX, textWindowLocation.y + scrollBarHeight, overviewRulerWidth, overviewRulerHeight);
                    LpexSourceViewer.this.fOverviewRuler.getHeaderControl().setBounds(overviewRulerX, clientArea.y, overviewRulerWidth, textWindowLocation.y + scrollBarHeight - clientArea.y);
                }
                if (promptHeight != 0) {
                    LpexSourceViewer.this._promptWindow.setBounds(clientArea.x, clientArea.y + textWidgetHeight, clientArea.width, promptHeight);
                }
            }
        }
    }
}

