/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexSourceViewer;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexLog;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexViewAdapter;
import com.ibm.lpex.core.LpexWindow;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Method;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.source.AbstractRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.IVerticalRulerInfoExtension;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.rulers.IContributedRulerColumn;
import org.eclipse.ui.texteditor.rulers.RulerColumnDescriptor;

public class LpexRulerColumnWrapper
implements IVerticalRulerColumn,
IVerticalRulerInfo,
IVerticalRulerInfoExtension,
IContributedRulerColumn {
    private AbstractRulerColumn _column;
    private Canvas fCanvas;
    private CompositeRuler fParentRuler;
    private final MouseHandler fMouseHandler = new MouseHandler();
    private LpexSourceViewer _lpexViewer;
    private LpexViewAdapter _lpexViewListener;

    LpexRulerColumnWrapper(AbstractRulerColumn column, LpexSourceViewer lpexViewer) {
        this._column = column;
        this._lpexViewer = lpexViewer;
    }

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        LpexView lpexView;
        Control c = this._column.createControl(parentRuler, parentControl);
        Font font = c.getFont();
        c.dispose();
        if (parentRuler.getTextViewer() != null) {
            try {
                Field fInternalListener = AbstractRulerColumn.class.getDeclaredField("fInternalListener");
                fInternalListener.setAccessible(true);
                Object test = fInternalListener.get(this._column);
                if (test instanceof IViewportListener) {
                    parentRuler.getTextViewer().removeViewportListener((IViewportListener)test);
                }
            }
            catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NullPointerException | SecurityException | InaccessibleObjectException e) {
                LpexLog.log(e);
            }
        }
        this.fParentRuler = parentRuler;
        this.setParentRuler(parentRuler);
        this.setTextViewer(parentRuler.getTextViewer());
        this.fCanvas = new Canvas(parentControl, this.getCanvasStyle());
        this.setCanvas(this.fCanvas);
        this.fCanvas.setBackground(this.getDefaultBackground());
        this.fCanvas.setFont(font);
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                LpexRulerColumnWrapper.this.paintControl(event);
            }
        });
        if (parentRuler.getTextViewer() != null) {
            parentRuler.getTextViewer().addViewportListener(new IViewportListener(){

                public void viewportChanged(int verticalOffset) {
                    LpexRulerColumnWrapper.this.fCanvas.redraw();
                }
            });
        }
        this.fCanvas.addMouseListener((MouseListener)this.fMouseHandler);
        this.fCanvas.addMouseMoveListener((MouseMoveListener)this.fMouseHandler);
        if (this._lpexViewer != null && (lpexView = this._lpexViewer.getFirstLpexView()) != null) {
            if (this._lpexViewListener == null) {
                this._lpexViewListener = new LpexViewAdapter(){

                    @Override
                    public void shown(LpexView view) {
                        LpexRulerColumnWrapper.this.redraw();
                    }
                };
            }
            lpexView.addLpexViewListener(this._lpexViewListener);
        }
        return this.fCanvas;
    }

    private void setTextViewer(ITextViewer textViewer) {
        try {
            Field fTextViewer = AbstractRulerColumn.class.getDeclaredField("fTextViewer");
            fTextViewer.setAccessible(true);
            fTextViewer.set(this._column, textViewer);
        }
        catch (Exception e) {
            LpexLog.log(e);
        }
    }

    private int getCanvasStyle() {
        Class[] parms = new Class[]{};
        Object[] args = new Object[]{};
        Method getCanvasStyle = null;
        try {
            getCanvasStyle = this._column.getClass().getDeclaredMethod("getCanvasStyle", parms);
        }
        catch (NoSuchMethodException e) {
            try {
                getCanvasStyle = AbstractRulerColumn.class.getDeclaredMethod("getCanvasStyle", parms);
            }
            catch (Exception e2) {
                LpexLog.log(e2);
            }
        }
        catch (Exception e) {
            LpexLog.log(e);
        }
        if (getCanvasStyle != null) {
            getCanvasStyle.setAccessible(true);
            try {
                Object value = getCanvasStyle.invoke((Object)this._column, args);
                if (value instanceof Integer) {
                    return (Integer)value;
                }
            }
            catch (Exception e) {
                LpexLog.log(e);
            }
        }
        return 0;
    }

    private void setCanvas(Canvas canvas) {
        try {
            Field fCanvas = AbstractRulerColumn.class.getDeclaredField("fCanvas");
            fCanvas.setAccessible(true);
            fCanvas.set(this._column, canvas);
        }
        catch (Exception e) {
            LpexLog.log(e);
        }
    }

    private void setParentRuler(CompositeRuler parentRuler) {
        try {
            Field fParentRuler = AbstractRulerColumn.class.getDeclaredField("fParentRuler");
            fParentRuler.setAccessible(true);
            fParentRuler.set(this._column, parentRuler);
        }
        catch (Exception e) {
            LpexLog.log(e);
        }
    }

    public Control getControl() {
        return this.fCanvas;
    }

    public int getWidth() {
        return this._column.getWidth();
    }

    public void redraw() {
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.redraw();
        }
    }

    public void setFont(Font font) {
        if (this.fCanvas.getFont() != font) {
            this.fCanvas.setFont(font);
            this.redraw();
        }
    }

    public void setModel(IAnnotationModel model) {
        this._column.setModel(model);
        this.redraw();
    }

    public int getLineOfLastMouseButtonActivity() {
        return this._column.getLineOfLastMouseButtonActivity();
    }

    public int toDocumentLineNumber(int yCoordinate) {
        return this._column.toDocumentLineNumber(yCoordinate);
    }

    public void addVerticalRulerListener(IVerticalRulerListener listener) {
        this._column.addVerticalRulerListener(listener);
    }

    public IAnnotationHover getHover() {
        return this._column.getHover();
    }

    public IAnnotationModel getModel() {
        return this._column.getModel();
    }

    public void removeVerticalRulerListener(IVerticalRulerListener listener) {
        this._column.removeVerticalRulerListener(listener);
    }

    public void columnCreated() {
        ((IContributedRulerColumn)this._column).columnCreated();
    }

    public void columnRemoved() {
        ((IContributedRulerColumn)this._column).columnRemoved();
    }

    public RulerColumnDescriptor getDescriptor() {
        return ((IContributedRulerColumn)this._column).getDescriptor();
    }

    public ITextEditor getEditor() {
        return ((IContributedRulerColumn)this._column).getEditor();
    }

    public void setDescriptor(RulerColumnDescriptor descriptor) {
        ((IContributedRulerColumn)this._column).setDescriptor(descriptor);
    }

    public void setEditor(ITextEditor editor) {
        ((IContributedRulerColumn)this._column).setEditor(editor);
    }

    private void paintControl(PaintEvent event) {
        if (this._lpexViewer == null) {
            return;
        }
        GC gc = event.gc;
        LpexView view = this._lpexViewer.getFirstLpexView();
        LpexWindow window = view.window();
        Rectangle bounds = window.textWindow().getBounds();
        int headerHeight = 0;
        if (bounds != null) {
            headerHeight = bounds.y;
        }
        gc.setBackground(this.getDefaultBackground());
        gc.fillRectangle(0, 0, this.getWidth(), headerHeight);
        int end = 0;
        if (bounds != null) {
            end = bounds.y + bounds.height;
        }
        if (window.textWindow().getHorizontalBar().isVisible()) {
            end -= window.textWindow().getHorizontalBar().getSize().y;
        }
        ILineRange lines = this.computeDirtyWidgetLines(event, Math.max(0, event.y + event.height - end));
        this.paint(gc, lines, headerHeight);
        gc.setBackground(this.getDefaultBackground());
        gc.fillRectangle(0, end, this.getWidth(), event.y + event.height - end);
    }

    private Color getDefaultBackground() {
        Class[] parms = new Class[]{};
        Object[] args = new Object[]{};
        Method getDefaultBackground = null;
        Color result = null;
        try {
            getDefaultBackground = this._column.getClass().getDeclaredMethod("getDefaultBackground", parms);
        }
        catch (NoSuchMethodException e) {
            try {
                getDefaultBackground = AbstractRulerColumn.class.getDeclaredMethod("getDefaultBackground", parms);
            }
            catch (Exception e2) {
                LpexLog.log(e2);
            }
        }
        catch (Exception e) {
            LpexLog.log(e);
        }
        if (getDefaultBackground != null) {
            getDefaultBackground.setAccessible(true);
            try {
                Object value = getDefaultBackground.invoke((Object)this._column, args);
                if (value instanceof Color) {
                    result = (Color)value;
                }
            }
            catch (Exception e) {
                LpexLog.log(e);
            }
        }
        return result;
    }

    protected void paint(GC gc, ILineRange lines, int headerHeight) {
        LpexView view = this._lpexViewer.getFirstLpexView();
        if (view != null) {
            int firstRow = lines.getStartLine() + 1;
            int currentRow = view.queryInt("cursorRow");
            int element = view.documentLocation().element;
            while (element > 0 && currentRow != firstRow) {
                --currentRow;
                --element;
                while (element > 0 && !view.queryOn("visible", new LpexDocumentLocation(element, 1))) {
                    --element;
                }
            }
            int lastRow = lines.getStartLine() + lines.getNumberOfLines();
            int row = firstRow - 1;
            while (row <= lastRow) {
                int modelLine = -1;
                if (element > 0 && !view.show(element)) {
                    modelLine = view.queryInt("line", new LpexDocumentLocation(element, 1)) - 1;
                }
                int lineHeight = view.queryInt("rowHeight");
                int linePixel = lineHeight * row + headerHeight;
                this.paintLine(gc, modelLine, row, linePixel, lineHeight);
                ++element;
                while (element <= view.elements() && !view.queryOn("visible", new LpexDocumentLocation(element, 1))) {
                    ++element;
                }
                ++row;
            }
        }
    }

    protected void paintLine(GC gc, int modelLine, int widgetLine, int linePixel, int lineHeight) {
        Class[] parms = new Class[]{GC.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
        Object[] args = new Object[]{gc, modelLine, widgetLine, linePixel, lineHeight};
        Method paintLine = null;
        try {
            paintLine = this._column.getClass().getDeclaredMethod("paintLine", parms);
        }
        catch (NoSuchMethodException e) {
            try {
                paintLine = AbstractRulerColumn.class.getDeclaredMethod("paintLine", parms);
            }
            catch (Exception e2) {
                LpexLog.log(e2);
            }
        }
        catch (Exception e) {
            LpexLog.log(e);
        }
        if (paintLine != null) {
            paintLine.setAccessible(true);
            try {
                paintLine.invoke((Object)this._column, args);
            }
            catch (Exception e) {
                LpexLog.log(e);
            }
        }
    }

    private ILineRange computeDirtyWidgetLines(PaintEvent event, int bottom) {
        LpexView view = this._lpexViewer.getFirstLpexView();
        if (view != null) {
            int rows = view.queryInt("rows");
            int firstLine = 0;
            int lastLine = rows;
            int height = view.queryInt("rowHeight");
            while ((firstLine + 1) * height < event.y && firstLine < lastLine) {
                ++firstLine;
            }
            while (lastLine * height > event.y + event.height - bottom && firstLine < lastLine) {
                --lastLine;
            }
            return new LineRange(firstLine, lastLine - firstLine + 1);
        }
        return new LineRange(1, 0);
    }

    private final class MouseHandler
    implements MouseListener,
    MouseMoveListener {
        private MouseHandler() {
        }

        public void mouseUp(MouseEvent event) {
        }

        public void mouseDown(MouseEvent event) {
            LpexRulerColumnWrapper.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
        }

        public void mouseDoubleClick(MouseEvent event) {
            LpexRulerColumnWrapper.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
        }

        public void mouseMove(MouseEvent event) {
            LpexRulerColumnWrapper.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
        }
    }
}

