/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.core.LpexAction;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import org.eclipse.jface.internal.text.revisions.Colors;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LpexLineChangeInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension3,
IInformationControlExtension5,
DisposeListener {
    private LpexView _parentView;
    private LpexView _lpexView;
    private LpexWindow _lpexWindow;
    private Shell _shell;
    private int _maxWidth;
    private int _maxHeight;
    private Label fSeparator;
    private Label fStatusField;
    private Font fStatusTextFont;
    private Color fStatusTextForegroundColor;

    public LpexLineChangeInformationControl(Shell parent, LpexView parentView, boolean isResizable, String statusFieldText) {
        this._parentView = parentView;
        this._shell = new Shell(parent, 4 | (isResizable ? 16 : 0) | 0x4000);
        Display display = this._shell.getDisplay();
        this._shell.setBackground(display.getSystemColor(2));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this._shell.setLayout((Layout)layout);
        Composite composite = new Composite((Composite)this._shell, 0);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        if (statusFieldText != null) {
            composite = new Composite(composite, 0);
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            GridData gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            composite.setForeground(display.getSystemColor(28));
            composite.setBackground(display.getSystemColor(29));
        }
        this.createLpexText(composite, isResizable);
        if (statusFieldText != null) {
            this.fSeparator = new Label(composite, 259);
            this.fSeparator.setLayoutData((Object)new GridData(768));
            this.fStatusField = new Label(composite, 131072);
            this.fStatusField.setText(statusFieldText);
            Font font = this.fStatusField.getFont();
            FontData[] fontDatas = font.getFontData();
            int i = 0;
            while (i < fontDatas.length) {
                fontDatas[i].setHeight(fontDatas[i].getHeight() * 9 / 10);
                ++i;
            }
            this.fStatusTextFont = new Font((Device)this.fStatusField.getDisplay(), fontDatas);
            this.fStatusField.setFont(this.fStatusTextFont);
            GridData gd2 = new GridData(1842);
            this.fStatusField.setLayoutData((Object)gd2);
            this.fStatusTextForegroundColor = new Color((Device)this.fStatusField.getDisplay(), Colors.blend((RGB)display.getSystemColor(29).getRGB(), (RGB)display.getSystemColor(28).getRGB(), (float)0.56f));
            this.fStatusField.setForeground(this.fStatusTextForegroundColor);
            this.fStatusField.setBackground(display.getSystemColor(29));
        }
        this.addDisposeListener(this);
    }

    private void createLpexText(Composite parent, boolean isResizable) {
        this._lpexWindow = new LpexWindow(parent);
        this._lpexWindow.setForceNoScrollBars(!isResizable);
        this._lpexWindow.setForceScrollBars(isResizable);
        this._lpexWindow.setLayoutData(new GridData(1809));
        this._lpexView = new LpexView(false);
        this._lpexView.setWindow(this._lpexWindow);
        this._lpexView.doDefaultCommand("set statusLine off");
        this._lpexView.doDefaultCommand("set formatLine off");
        this._lpexView.doDefaultCommand("set messageLine off");
        this._lpexView.doDefaultCommand("set commandLine off");
        this._lpexView.doDefaultCommand("set highlightCurrentLine off");
        this._lpexView.setFont(this._parentView.getFont());
        this._lpexView.doDefaultCommand("set tabs " + this._parentView.query("current.tabs"));
        Color fg = parent.getDisplay().getSystemColor(28);
        Color bg = parent.getDisplay().getSystemColor(29);
        this._lpexView.doDefaultCommand("set styleAttributes.! " + fg.getRed() + " " + fg.getGreen() + " " + fg.getBlue() + " " + bg.getRed() + " " + bg.getGreen() + " " + bg.getBlue());
        fg = parent.getDisplay().getSystemColor(16);
        this._lpexView.doDefaultCommand("set styleAttributes.prefixArea " + fg.getRed() + " " + fg.getGreen() + " " + fg.getBlue() + " " + bg.getRed() + " " + bg.getGreen() + " " + bg.getBlue());
        this._lpexView.doDefaultCommand("set styleAttributes.background " + fg.getRed() + " " + fg.getGreen() + " " + fg.getBlue() + " " + bg.getRed() + " " + bg.getGreen() + " " + bg.getBlue());
        this._lpexView.doDefaultCommand("set sequenceNumbers 1 0 1 2");
        this._lpexView.doDefaultCommand("set prefixAreaText sequenceNumbers");
        this._lpexView.doDefaultCommand("set sequenceNumbersFormat X");
        this._lpexView.doDefaultCommand("set prefixAreaMargin 2");
        this._lpexView.doDefaultCommand("set prefixArea on");
        this._lpexView.defineAction("escape", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                LpexLineChangeInformationControl.this._shell.dispose();
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        this._lpexView.doCommand("set keyAction.escape escape");
    }

    public void setInformation(String content) {
        this._lpexView.setText(content);
        this._lpexView.doDefaultCommand("screenShow view");
    }

    public void setVisible(boolean visible) {
        this._shell.setVisible(visible);
    }

    public void dispose() {
        if (this._shell != null && !this._shell.isDisposed()) {
            this._shell.dispose();
        } else {
            this.widgetDisposed(null);
        }
    }

    public void widgetDisposed(DisposeEvent event) {
        this._shell = null;
        if (this._lpexView != null) {
            this._lpexView.dispose();
            this._lpexView = null;
        }
    }

    public void setSize(int width, int height) {
        if (this.fStatusField != null) {
            GridData gd = (GridData)this._lpexWindow.getLayoutData();
            Point statusSize = this.fStatusField.computeSize(-1, -1, true);
            Point separatorSize = this.fSeparator.computeSize(-1, -1, true);
            gd.heightHint = height - statusSize.y - separatorSize.y;
        }
        this._shell.setSize(width, height);
        if (this.fStatusField != null) {
            this._shell.pack(true);
        }
    }

    public void setLocation(Point location) {
        Rectangle trim = this._shell.computeTrim(0, 0, 0, 0);
        Point textLocation = this._lpexWindow.getLocation();
        if (this._lpexWindow.getForceNoScrollBars()) {
            location.x += trim.x - textLocation.x;
            location.y += trim.y - textLocation.y;
        }
        this._shell.setLocation(location);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        this._maxWidth = maxWidth;
        this._maxHeight = maxHeight;
    }

    public Point computeSizeHint() {
        int x = -1;
        int y = -1;
        Point size = this._shell.computeSize(x, y);
        int width = this._parentView.queryInt("pixelPosition", new LpexDocumentLocation(1, 2));
        int prefixWidth = this._lpexView.queryInt("prefixAreaMargin");
        int prefixNumChars = this._lpexView.query("sequenceNumbersFormat").length() + 1;
        size.x += width * prefixNumChars + prefixWidth;
        size.x = Math.min(size.x, this._maxWidth);
        size.y = Math.min(size.y, this._maxHeight);
        return size;
    }

    public void addDisposeListener(DisposeListener listener) {
        this._shell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this._shell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
    }

    public void setBackgroundColor(Color background) {
    }

    public boolean isFocusControl() {
        return this._shell.getDisplay().getActiveShell() == this._shell;
    }

    public void setFocus() {
        if (this._shell != null) {
            this._shell.forceFocus();
        }
        if (this._lpexWindow != null && !this._lpexWindow.isDisposed()) {
            this._lpexWindow.setFocus();
        }
    }

    public void addFocusListener(FocusListener listener) {
        this._lpexWindow.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this._lpexWindow.removeFocusListener(listener);
    }

    public boolean hasContents() {
        return this._lpexView.text().length() > 0;
    }

    public Rectangle computeTrim() {
        Rectangle trim = this._shell.computeTrim(0, 0, 0, 0);
        this.addInternalTrim(trim);
        return trim;
    }

    private void addInternalTrim(Rectangle trim) {
        if (this.fStatusField != null) {
            trim.height += this.fSeparator.computeSize((int)-1, (int)-1).y;
            trim.height += this.fStatusField.computeSize((int)-1, (int)-1).y;
        }
        if (this._lpexWindow.getForceScrollBars()) {
            trim.height += this._lpexWindow.horizontalScrollBar().getSize().y;
            trim.width += this._lpexWindow.verticalScrollBar().getSize().x;
        }
    }

    public Rectangle getBounds() {
        return this._shell.getBounds();
    }

    public boolean restoresLocation() {
        return false;
    }

    public boolean restoresSize() {
        return false;
    }

    public Point computeSizeConstraints(int widthInChars, int heightInChars) {
        int width = this._parentView.queryInt("pixelPosition", new LpexDocumentLocation(1, 2));
        int height = this._parentView.queryInt("rowHeight");
        return new Point(widthInChars * width, heightInChars * height);
    }

    public boolean containsControl(Control control) {
        do {
            if (control == this._shell) {
                return true;
            }
            if (!(control instanceof Shell)) continue;
            return false;
        } while ((control = control.getParent()) != null);
        return false;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new LpexLineChangeInformationControl(parent, LpexLineChangeInformationControl.this._parentView, true, null);
            }
        };
    }

    public boolean isVisible() {
        return this._shell != null && !this._shell.isDisposed() && this._shell.isVisible();
    }
}

