/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexTextViewer;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexMultiWindow;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.Utilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.hyperlink.HyperlinkManager;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetectorExtension2;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenterExtension;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenterExtension2;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class LpexHyperlinkManager
implements ITextListener,
Listener,
KeyListener,
MouseListener,
MouseMoveListener,
FocusListener,
DisposeListener {
    private LpexTextViewer fTextViewer;
    private boolean fActive;
    private LpexWindow _lpexWindow;
    private int fHyperlinkStateMask;
    private int fActiveHyperlinkStateMask;
    private IHyperlink[] fActiveHyperlinks;
    private IHyperlinkDetector[] fHyperlinkDetectors;
    private IHyperlinkPresenter fHyperlinkPresenter;
    private final HyperlinkManager.DETECTION_STRATEGY fDetectionStrategy;

    public LpexHyperlinkManager(HyperlinkManager.DETECTION_STRATEGY detectionStrategy) {
        Assert.isNotNull((Object)detectionStrategy);
        this.fDetectionStrategy = detectionStrategy;
    }

    public void install(LpexTextViewer textViewer, IHyperlinkPresenter hyperlinkPresenter, IHyperlinkDetector[] hyperlinkDetectors, int eventStateMask) {
        Assert.isNotNull((Object)((Object)textViewer));
        Assert.isNotNull((Object)hyperlinkPresenter);
        this.fTextViewer = textViewer;
        this.fHyperlinkPresenter = hyperlinkPresenter;
        Assert.isLegal((this.fHyperlinkPresenter.canShowMultipleHyperlinks() || this.fDetectionStrategy == HyperlinkManager.FIRST || this.fDetectionStrategy == HyperlinkManager.LONGEST_REGION_FIRST ? 1 : 0) != 0);
        this.setHyperlinkDetectors(hyperlinkDetectors);
        this.setHyperlinkStateMask(eventStateMask);
        LpexMultiWindow lpexMultiWindow = this.fTextViewer.getLpexMultiWindow();
        if (lpexMultiWindow == null || lpexMultiWindow.isDisposed()) {
            return;
        }
        lpexMultiWindow.getDisplay().addFilter(2, (Listener)this);
        LpexWindow[] lpexWindows = lpexMultiWindow.getWindows();
        int i = 0;
        while (i < lpexWindows.length) {
            this.install(lpexWindows[i]);
            ++i;
        }
        this.fTextViewer.addTextListener(this);
        this.fHyperlinkPresenter.install((ITextViewer)this.fTextViewer);
    }

    void install(LpexWindow lpexWindow) {
        if (this.fTextViewer == null) {
            return;
        }
        if (lpexWindow == null || lpexWindow.isDisposed()) {
            return;
        }
        Composite text = lpexWindow.textWindow();
        if (text.isDisposed()) {
            return;
        }
        text.addKeyListener((KeyListener)this);
        text.addMouseListener((MouseListener)this);
        text.addMouseMoveListener((MouseMoveListener)this);
        text.addFocusListener((FocusListener)this);
        lpexWindow.addDisposeListener(this);
    }

    public void setHyperlinkDetectors(IHyperlinkDetector[] hyperlinkDetectors) {
        Assert.isTrue((hyperlinkDetectors != null && hyperlinkDetectors.length > 0 ? 1 : 0) != 0);
        this.fHyperlinkDetectors = new IHyperlinkDetector[hyperlinkDetectors.length];
        System.arraycopy(hyperlinkDetectors, 0, this.fHyperlinkDetectors, 0, hyperlinkDetectors.length);
    }

    public void setHyperlinkStateMask(int eventStateMask) {
        this.fHyperlinkStateMask = eventStateMask;
    }

    public void uninstall() {
        this.deactivate();
        LpexMultiWindow lpexMultiWindow = this.fTextViewer.getLpexMultiWindow();
        if (lpexMultiWindow != null && !lpexMultiWindow.isDisposed()) {
            LpexWindow[] lpexWindows = lpexMultiWindow.getWindows();
            int i = 0;
            while (i < lpexWindows.length) {
                this.uninstall(lpexWindows[i]);
                ++i;
            }
            lpexMultiWindow.getDisplay().removeFilter(2, (Listener)this);
        }
        this.fTextViewer.removeTextListener(this);
        this.fHyperlinkPresenter.uninstall();
        this.fHyperlinkPresenter = null;
        this.fTextViewer = null;
        this.fHyperlinkDetectors = null;
        this._lpexWindow = null;
    }

    void uninstall(LpexWindow lpexWindow) {
        if (lpexWindow == null || lpexWindow.isDisposed()) {
            return;
        }
        Composite text = lpexWindow.textWindow();
        if (text.isDisposed()) {
            return;
        }
        text.removeKeyListener((KeyListener)this);
        text.removeMouseListener((MouseListener)this);
        text.removeMouseMoveListener((MouseMoveListener)this);
        text.removeFocusListener((FocusListener)this);
        lpexWindow.removeDisposeListener(this);
    }

    protected void deactivate() {
        this.fHyperlinkPresenter.hideHyperlinks();
        this.fActive = false;
    }

    protected IHyperlink[] findHyperlinks() {
        int offset = this.getCurrentTextOffset();
        if (offset == -1) {
            return null;
        }
        Region region = new Region(offset, 0);
        return this.findHyperlinks((IRegion)region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHyperlink[] findHyperlinks(IRegion region) {
        ArrayList<IHyperlink> allHyperlinks = new ArrayList<IHyperlink>(this.fHyperlinkDetectors.length * 2);
        IHyperlinkDetector[] iHyperlinkDetectorArray = this.fHyperlinkDetectors;
        synchronized (this.fHyperlinkDetectors) {
            int i = 0;
            int length = this.fHyperlinkDetectors.length;
            while (i < length) {
                int stateMask;
                IHyperlinkDetector detector = this.fHyperlinkDetectors[i];
                if (detector != null && !(!(detector instanceof IHyperlinkDetectorExtension2) ? this.fActiveHyperlinkStateMask != this.fHyperlinkStateMask : (stateMask = ((IHyperlinkDetectorExtension2)detector).getStateMask()) != -1 && stateMask != this.fActiveHyperlinkStateMask || stateMask == -1 && this.fActiveHyperlinkStateMask != this.fHyperlinkStateMask)) {
                    boolean canShowMultipleHyperlinks = this.fHyperlinkPresenter.canShowMultipleHyperlinks();
                    IHyperlink[] hyperlinks = detector.detectHyperlinks((ITextViewer)this.fTextViewer, region, canShowMultipleHyperlinks);
                    if (hyperlinks != null) {
                        Assert.isLegal((hyperlinks.length > 0 ? 1 : 0) != 0);
                        if (this.fDetectionStrategy == HyperlinkManager.FIRST) {
                            if (hyperlinks.length == 1) {
                                // ** MonitorExit[var3_3] (shouldn't be in output)
                                return hyperlinks;
                            }
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return new IHyperlink[]{hyperlinks[0]};
                        }
                        allHyperlinks.addAll(Arrays.asList(hyperlinks));
                    }
                }
                ++i;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (allHyperlinks.isEmpty()) {
                return null;
            }
            if (this.fDetectionStrategy != HyperlinkManager.ALL) {
                int maxLength = this.computeLongestHyperlinkLength(allHyperlinks);
                for (IHyperlink hyperlink : new ArrayList(allHyperlinks)) {
                    if (hyperlink.getHyperlinkRegion().getLength() >= maxLength) continue;
                    allHyperlinks.remove(hyperlink);
                }
            }
            if (this.fDetectionStrategy == HyperlinkManager.LONGEST_REGION_FIRST) {
                return new IHyperlink[]{(IHyperlink)allHyperlinks.get(0)};
            }
            return allHyperlinks.toArray(new IHyperlink[allHyperlinks.size()]);
        }
    }

    protected int computeLongestHyperlinkLength(List<?> hyperlinks) {
        Assert.isLegal((hyperlinks != null && !hyperlinks.isEmpty() ? 1 : 0) != 0);
        Iterator<?> iter = hyperlinks.iterator();
        int length = Integer.MIN_VALUE;
        while (iter.hasNext()) {
            IRegion region = ((IHyperlink)iter.next()).getHyperlinkRegion();
            if (region.getLength() < length) continue;
            length = region.getLength();
        }
        return length;
    }

    protected int getCurrentTextOffset() {
        LpexMultiWindow lpexMultiWindow = this.fTextViewer.getLpexMultiWindow();
        if (lpexMultiWindow == null || lpexMultiWindow.isDisposed()) {
            return -1;
        }
        Point displayPt = lpexMultiWindow.getDisplay().getCursorLocation();
        Point multiWindowPt = lpexMultiWindow.toControl(displayPt);
        LpexWindow lpexWindow = lpexMultiWindow.getWindow(multiWindowPt.x, multiWindowPt.y);
        if (lpexWindow == null || lpexWindow.isDisposed()) {
            return -1;
        }
        Composite text = lpexWindow.textWindow();
        if (text.isDisposed()) {
            return -1;
        }
        this._lpexWindow = lpexWindow;
        Point textWindowPt = text.toControl(displayPt);
        LpexDocumentLocation loc = Utilities.getTextLocationAtPoint(lpexWindow.getLpexView(), textWindowPt.x, textWindowPt.y);
        return this.fTextViewer.getDocumentAdapter().getDocOffset(loc);
    }

    public void keyPressed(KeyEvent event) {
        if (this.fActive || !this.isRegisteredStateMask(event.keyCode)) {
            this.deactivate();
            return;
        }
        this.fActive = true;
        this.fActiveHyperlinkStateMask = event.keyCode;
    }

    public void keyReleased(KeyEvent event) {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent event) {
        if (!this.fActive) {
            return;
        }
        if (event.stateMask != this.fActiveHyperlinkStateMask || event.button != 1) {
            this.deactivate();
            return;
        }
    }

    public void mouseUp(MouseEvent e) {
        if (!this.fActive) {
            this.fActiveHyperlinks = null;
            return;
        }
        if (e.button != 1) {
            this.fActiveHyperlinks = null;
        }
        this.deactivate();
        if (this.fActiveHyperlinks != null) {
            this.fActiveHyperlinks[0].open();
        }
    }

    public void mouseMove(MouseEvent event) {
        if (this.fHyperlinkPresenter instanceof IHyperlinkPresenterExtension && !((IHyperlinkPresenterExtension)this.fHyperlinkPresenter).canHideHyperlinks()) {
            return;
        }
        if (!this.isRegisteredStateMask(event.stateMask)) {
            if (this.fActive) {
                this.deactivate();
            }
            return;
        }
        this.fActive = true;
        this.fActiveHyperlinkStateMask = event.stateMask;
        LpexMultiWindow lpexMultiWindow = this.fTextViewer.getLpexMultiWindow();
        if (lpexMultiWindow == null || lpexMultiWindow.isDisposed()) {
            this.deactivate();
            return;
        }
        if ((event.stateMask & 0x80000) != 0) {
            this.deactivate();
            return;
        }
        this.fActiveHyperlinks = this.findHyperlinks();
        this.showHyperlinks(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isRegisteredStateMask(int stateMask) {
        if (stateMask == this.fHyperlinkStateMask) {
            return true;
        }
        IHyperlinkDetector[] iHyperlinkDetectorArray = this.fHyperlinkDetectors;
        synchronized (this.fHyperlinkDetectors) {
            int i = 0;
            while (true) {
                if (i >= this.fHyperlinkDetectors.length) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                if (this.fHyperlinkDetectors[i] instanceof IHyperlinkDetectorExtension2 && stateMask == ((IHyperlinkDetectorExtension2)this.fHyperlinkDetectors[i]).getStateMask()) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
                ++i;
            }
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (this.fActive && this._lpexWindow != null && !this._lpexWindow.isDisposed() && this._lpexWindow.textWindow() == e.widget) {
            this.deactivate();
        }
    }

    public void handleEvent(Event event) {
        this.deactivate();
    }

    public void textChanged(TextEvent event) {
        if (event.getDocumentEvent() != null) {
            this.deactivate();
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (e.widget instanceof LpexWindow) {
            this.uninstall((LpexWindow)e.widget);
        }
    }

    private boolean showHyperlinks(boolean takesFocusWhenVisible) {
        if (this.fActiveHyperlinks == null || this.fActiveHyperlinks.length == 0) {
            this.fHyperlinkPresenter.hideHyperlinks();
            return false;
        }
        if (this.fActiveHyperlinks.length == 1 && takesFocusWhenVisible) {
            this.fActiveHyperlinks[0].open();
        } else if (this.fHyperlinkPresenter instanceof IHyperlinkPresenterExtension2) {
            ((IHyperlinkPresenterExtension2)this.fHyperlinkPresenter).showHyperlinks(this.fActiveHyperlinks, takesFocusWhenVisible);
        } else {
            this.fHyperlinkPresenter.showHyperlinks(this.fActiveHyperlinks);
        }
        return true;
    }

    public boolean openHyperlink() {
        this.fActiveHyperlinkStateMask = this.fHyperlinkStateMask;
        if (this.fHyperlinkPresenter instanceof IHyperlinkPresenterExtension && !((IHyperlinkPresenterExtension)this.fHyperlinkPresenter).canHideHyperlinks()) {
            return false;
        }
        ITextSelection sel = (ITextSelection)this.fTextViewer.getSelection();
        int offset = sel.getOffset();
        if (offset == -1) {
            return false;
        }
        Region region = new Region(offset, 0);
        this.fActiveHyperlinks = this.findHyperlinks((IRegion)region);
        return this.showHyperlinks(true);
    }
}

