/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexTextViewer;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexMultiWindow;
import com.ibm.lpex.core.LpexPaletteAttributes;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenterExtension;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public class LpexDefaultHyperlinkPresenter
implements IHyperlinkPresenter,
IHyperlinkPresenterExtension,
IPropertyChangeListener {
    private LpexTextViewer _textViewer;
    private IPreferenceStore _preferenceStore;
    private String MARK_NAME = "@HYPERLINK";
    private char MARK_STYLE = (char)6;
    private String MARK_STYLE_ATTRIBUTES;
    private IRegion _activeRegion;
    private LpexWindow _lpexWindow;

    public LpexDefaultHyperlinkPresenter(IPreferenceStore preferenceStore) {
        this._preferenceStore = preferenceStore;
        this.setMarkStyleAttributes(preferenceStore);
    }

    public LpexDefaultHyperlinkPresenter(Color color) {
        this.setMarkStyleAttributes(color);
    }

    public LpexDefaultHyperlinkPresenter(RGB rgb) {
        this.setMarkStyleAttributes(rgb);
    }

    public void setColor(Color color) {
        Assert.isNotNull((Object)((Object)this._textViewer));
        this.setMarkStyleAttributes(color);
    }

    public boolean canShowMultipleHyperlinks() {
        return false;
    }

    public void install(ITextViewer textViewer) {
        Assert.isNotNull((Object)textViewer);
        this._textViewer = (LpexTextViewer)textViewer;
        if (this._preferenceStore != null) {
            this._preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    public void uninstall() {
        this._textViewer = null;
        this._lpexWindow = null;
        if (this._preferenceStore != null) {
            this._preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    public void showHyperlinks(IHyperlink[] hyperlinks) {
        Assert.isLegal((hyperlinks != null && hyperlinks.length == 1 ? 1 : 0) != 0);
        LpexMultiWindow lpexMultiWindow = this._textViewer.getLpexMultiWindow();
        if (lpexMultiWindow == null || lpexMultiWindow.isDisposed()) {
            return;
        }
        IRegion region = hyperlinks[0].getHyperlinkRegion();
        if (region.equals(this._activeRegion)) {
            return;
        }
        Point displayPt = lpexMultiWindow.getDisplay().getCursorLocation();
        Point multiWindowPt = lpexMultiWindow.toControl(displayPt);
        this._lpexWindow = lpexMultiWindow.getWindow(multiWindowPt.x, multiWindowPt.y);
        if (this._lpexWindow == null || this._lpexWindow.isDisposed()) {
            return;
        }
        LpexView lpexView = this._lpexWindow.getLpexView();
        if (lpexView == null) {
            return;
        }
        LpexDocumentLocation start = this._textViewer.getDocumentAdapter().getLpexDocumentLocation(region.getOffset());
        LpexDocumentLocation end = this._textViewer.getDocumentAdapter().getLpexDocumentLocation(region.getOffset() + region.getLength() - 1);
        lpexView.doCommand(new StringBuilder(64).append("set mark." + this.MARK_NAME + " ").append(start.element).append(' ').append(start.position).append(' ').append(end.element).append(' ').append(end.position).toString());
        String attributes = LpexPaletteAttributes.convert(this.MARK_STYLE_ATTRIBUTES, "255 255 255", LpexPaletteAttributes.background(lpexView));
        lpexView.doCommand("set styleAttributes." + this.MARK_STYLE + " " + attributes);
        lpexView.doCommand("set markStyle." + this.MARK_NAME + " " + this.MARK_STYLE);
        lpexView.doCommand("set markHighlight." + this.MARK_NAME + " on");
        this._activeRegion = region;
        this._lpexWindow.textWindow().setCursor(this._lpexWindow.getDisplay().getSystemCursor(21));
        lpexView.doCommand("screenShow view");
    }

    public void hideHyperlinks() {
        if (this._activeRegion == null) {
            return;
        }
        this._activeRegion = null;
        if (this._lpexWindow == null || this._lpexWindow.isDisposed()) {
            return;
        }
        this._lpexWindow.textWindow().setCursor(null);
        LpexView lpexView = this._lpexWindow.getLpexView();
        if (lpexView == null) {
            return;
        }
        lpexView.doCommand("set mark." + this.MARK_NAME + " clear");
        lpexView.doCommand("screenShow view");
        this._lpexWindow = null;
    }

    private void setMarkStyleAttributes(IPreferenceStore pref) {
        RGB rgb = null;
        if (pref.contains("hyperlinkColor")) {
            rgb = pref.isDefault("hyperlinkColor") ? PreferenceConverter.getDefaultColor((IPreferenceStore)pref, (String)"hyperlinkColor") : PreferenceConverter.getColor((IPreferenceStore)pref, (String)"hyperlinkColor");
        }
        this.setMarkStyleAttributes(rgb);
    }

    private void setMarkStyleAttributes(Color color) {
        this.setMarkStyleAttributes(color == null ? null : color.getRGB());
    }

    private void setMarkStyleAttributes(RGB rgb) {
        this.MARK_STYLE_ATTRIBUTES = rgb != null ? new StringBuilder(64).append(rgb.red).append(' ').append(rgb.green).append(' ').append(rgb.blue).append(" 255 255 255 underline").toString() : "0 0 255 255 255 255 underline";
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("hyperlinkColor".equals(e.getProperty())) {
            this.setMarkStyleAttributes(this._preferenceStore);
        }
    }

    public boolean canHideHyperlinks() {
        return true;
    }
}

