/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexCompositeRuler;
import com.ibm.lpex.alef.LpexSourceViewer;
import com.ibm.lpex.alef.LpexTextViewer;
import com.ibm.lpex.core.LpexLog;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexViewAdapter;
import com.ibm.lpex.core.LpexViewListener;
import com.ibm.lpex.core.LpexWindow;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.IVerticalRulerInfoExtension;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.texteditor.quickdiff.DocumentLineDiffer;

public class LpexAnnotationRulerColumn
implements IVerticalRulerColumn,
IVerticalRulerInfo,
IVerticalRulerInfoExtension {
    private LpexCompositeRuler fParentRuler;
    private LpexTextViewer fCachedTextViewer;
    private Canvas fCanvas;
    private IAnnotationModel fModel;
    private Image fBuffer;
    private InternalListener fInternalListener = new InternalListener();
    private LpexViewListener _lpexViewListener;
    private int fWidth;
    private boolean fAllowSetModel = true;
    private Set<Object> fConfiguredAnnotationTypes = new HashSet<Object>();
    private Map<Object, Boolean> fAllowedAnnotationTypes = new HashMap<Object, Boolean>();
    private IAnnotationAccessExtension fAnnotationAccessExtension;
    private IAnnotationHover fHover;
    private Cursor fHitDetectionCursor;
    private Cursor fLastCursor;
    private MouseListener fMouseListener;
    private Rectangle _r = new Rectangle(0, 0, 0, 0);

    public LpexAnnotationRulerColumn(IAnnotationModel model, int width, IAnnotationAccess annotationAccess) {
        this(width, annotationAccess);
        this.fAllowSetModel = false;
        this.fModel = model;
        this.fModel.addAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
    }

    public LpexAnnotationRulerColumn(int width, IAnnotationAccess annotationAccess) {
        this.fWidth = width;
        if (annotationAccess instanceof IAnnotationAccessExtension) {
            this.fAnnotationAccessExtension = (IAnnotationAccessExtension)annotationAccess;
        }
    }

    public LpexAnnotationRulerColumn(IAnnotationModel model, int width) {
        this.fWidth = width;
        this.fAllowSetModel = false;
        this.fModel = model;
        this.fModel.addAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
    }

    public LpexAnnotationRulerColumn(int width) {
        this.fWidth = width;
    }

    public Control getControl() {
        return this.fCanvas;
    }

    public int getWidth() {
        return this.fWidth;
    }

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        LpexView lpexView;
        assert (parentRuler instanceof LpexCompositeRuler);
        this.fParentRuler = (LpexCompositeRuler)parentRuler;
        this.fCachedTextViewer = (LpexTextViewer)parentRuler.getTextViewer();
        this.fHitDetectionCursor = parentControl.getDisplay().getSystemCursor(21);
        this.fCanvas = this.createCanvas(parentControl);
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (LpexAnnotationRulerColumn.this.fCachedTextViewer != null) {
                    LpexAnnotationRulerColumn.this.doubleBufferPaint(event.gc);
                }
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LpexAnnotationRulerColumn.this.handleDispose();
                LpexAnnotationRulerColumn.this.fCachedTextViewer = null;
            }
        });
        this.fMouseListener = new MouseListener(){

            public void mouseUp(MouseEvent event) {
                int lineNumber;
                if (LpexAnnotationRulerColumn.this.isPropagatingMouseListener()) {
                    LpexAnnotationRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
                    lineNumber = LpexAnnotationRulerColumn.this.fParentRuler.getLineOfLastMouseButtonActivity();
                } else {
                    lineNumber = LpexAnnotationRulerColumn.this.fParentRuler.toDocumentLineNumber(event.y);
                }
                if (1 == event.button) {
                    LpexAnnotationRulerColumn.this.mouseClicked(lineNumber);
                }
            }

            public void mouseDown(MouseEvent event) {
                int lineNumber;
                if (LpexAnnotationRulerColumn.this.isPropagatingMouseListener()) {
                    LpexAnnotationRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
                    lineNumber = LpexAnnotationRulerColumn.this.fParentRuler.getLineOfLastMouseButtonActivity();
                } else {
                    lineNumber = LpexAnnotationRulerColumn.this.fParentRuler.toDocumentLineNumber(event.y);
                }
                if (1 == event.button) {
                    LpexAnnotationRulerColumn.this.mouseDown(lineNumber);
                }
            }

            public void mouseDoubleClick(MouseEvent event) {
                int lineNumber;
                if (LpexAnnotationRulerColumn.this.isPropagatingMouseListener()) {
                    LpexAnnotationRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
                    lineNumber = LpexAnnotationRulerColumn.this.fParentRuler.getLineOfLastMouseButtonActivity();
                } else {
                    lineNumber = LpexAnnotationRulerColumn.this.fParentRuler.toDocumentLineNumber(event.y);
                }
                if (1 == event.button) {
                    LpexAnnotationRulerColumn.this.mouseDoubleClicked(lineNumber);
                }
            }
        };
        this.fCanvas.addMouseListener(this.fMouseListener);
        this.fCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                LpexAnnotationRulerColumn.this.handleMouseMove(e);
            }
        });
        if (this.fCachedTextViewer != null && (lpexView = this.fCachedTextViewer.getFirstLpexView()) != null) {
            if (this._lpexViewListener == null) {
                this._lpexViewListener = new LpexViewAdapter(){

                    @Override
                    public void shown(LpexView view) {
                        LpexAnnotationRulerColumn.this.handleLpexViewShown(view);
                    }
                };
            }
            lpexView.addLpexViewListener(this._lpexViewListener);
        }
        return this.fCanvas;
    }

    private void handleLpexViewShown(LpexView lpexView) {
        this.redraw();
    }

    private Canvas createCanvas(Composite parent) {
        return new Canvas(parent, 0x200C0000){

            public void addMouseListener(MouseListener listener) {
                if (LpexAnnotationRulerColumn.this.isPropagatingMouseListener() || listener == LpexAnnotationRulerColumn.this.fMouseListener) {
                    super.addMouseListener(listener);
                }
            }
        };
    }

    protected boolean isPropagatingMouseListener() {
        return true;
    }

    protected void mouseDoubleClicked(int rulerLine) {
    }

    protected void mouseClicked(int rulerLine) {
    }

    private void handleMouseMove(MouseEvent event) {
        this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
        if (this.fCachedTextViewer != null) {
            Cursor cursor;
            int line = this.toDocumentLineNumber(event.y);
            Cursor cursor2 = cursor = line != -1 && this.hasAnnotation(line) ? this.fHitDetectionCursor : null;
            if (cursor != this.fLastCursor) {
                this.fCanvas.setCursor(cursor);
                this.fLastCursor = cursor;
            }
        }
    }

    protected boolean hasAnnotation(int lineNumber) {
        IDocument d;
        IAnnotationModel model;
        block6: {
            model = this.fModel;
            if (this.fModel instanceof IAnnotationModelExtension) {
                model = ((IAnnotationModelExtension)this.fModel).getAnnotationModel(LpexSourceViewer.MODEL_ANNOTATION_MODEL);
            }
            if (model == null) {
                return false;
            }
            try {
                d = this.fCachedTextViewer.getDocument();
                if (d != null) break block6;
                return false;
            }
            catch (BadLocationException ex) {
                return false;
            }
        }
        IRegion line = d.getLineInformation(lineNumber);
        int lineStart = line.getOffset();
        int lineLength = line.getLength();
        Iterator e = this.fModel instanceof IAnnotationModelExtension2 ? ((IAnnotationModelExtension2)this.fModel).getAnnotationIterator(lineStart, lineLength + 1, false, true) : model.getAnnotationIterator();
        while (e.hasNext()) {
            Position p;
            Annotation a = (Annotation)e.next();
            if (a.isMarkedDeleted() || this.skip(a) || (p = model.getPosition(a)) == null || p.isDeleted() || !p.overlapsWith(lineStart, lineLength) && (p.length != 0 || p.offset != lineStart + lineLength)) continue;
            return true;
        }
        return false;
    }

    private void handleDispose() {
        LpexView lpexView;
        if (this.fCachedTextViewer != null && (lpexView = this.fCachedTextViewer.getFirstLpexView()) != null) {
            lpexView.removeLpexViewListener(this._lpexViewListener);
            this._lpexViewListener = null;
        }
        if (this.fModel != null) {
            this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
        }
        if (this.fBuffer != null) {
            this.fBuffer.dispose();
            this.fBuffer = null;
        }
        this.fConfiguredAnnotationTypes.clear();
        this.fAllowedAnnotationTypes.clear();
        this.fAnnotationAccessExtension = null;
    }

    private void doubleBufferPaint(GC dest) {
        Point size = this.fCanvas.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            Rectangle r = this.fBuffer.getBounds();
            if (r.width != size.x || r.height != size.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.fCanvas.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.fBuffer);
        try {
            gc.setBackground(this.fCanvas.getBackground());
            gc.fillRectangle(0, 0, size.x, size.y);
            this.doPaint(gc);
        }
        finally {
            gc.dispose();
        }
        dest.drawImage(this.fBuffer, 0, 0);
    }

    protected void doPaint(GC gc) {
        if (this.fModel == null || this.fCachedTextViewer == null) {
            return;
        }
        LpexView lpexView = this.fCachedTextViewer.getFirstLpexView();
        LpexWindow lpexWindow = this.fCachedTextViewer.getFirstLpexWindow();
        int lineHeight = lpexView.queryInt("rowHeight");
        int rows = lpexView.queryInt("rows");
        int shift = this.fCachedTextViewer.getTopInset() + lpexWindow.textWindow().getLocation().y;
        int lowestShowing = lpexView.elementOfLine(lpexView.queryInt("lines") - (lpexView.linesBeforeStart() + lpexView.linesAfterEnd())) + 1;
        int highestShowing = 0;
        int i = 1;
        while (i <= rows) {
            int element = lpexView.elementOfRow(i);
            if (element != 0 && !lpexView.show(element)) {
                int line = element;
                if (line < lowestShowing) {
                    lowestShowing = line;
                }
                if (line > highestShowing) {
                    highestShowing = line;
                }
            }
            ++i;
        }
        if (highestShowing == 0) {
            return;
        }
        IDocument doc = this.fCachedTextViewer.getDocument();
        if (doc == null) {
            return;
        }
        if (highestShowing == lpexView.elements() && (lpexView.elementText(highestShowing) == null || lpexView.elementText(highestShowing).length() == 0)) {
            highestShowing = --highestShowing > lowestShowing ? highestShowing : lowestShowing;
        }
        int lowestShowingOffset = 0;
        try {
            lowestShowingOffset = doc.getLineOffset(lpexView.lineOfElement(lowestShowing) - 1);
        }
        catch (BadLocationException e) {
            LpexLog.log(e);
        }
        int highPosition = lpexView.elementText(highestShowing).length();
        if (highPosition == 0) {
            highPosition = 1;
        }
        int highestShowingOffset = 0;
        try {
            int line = lpexView.lineOfElement(highestShowing) - 1;
            int docNumberOfLines = doc.getNumberOfLines();
            if (line >= docNumberOfLines && docNumberOfLines > 0) {
                line = docNumberOfLines - 1;
            }
            highestShowingOffset = doc.getLineOffset(line) + highPosition;
            String lineDelimiter = doc.getLineDelimiter(line);
            if (lineDelimiter != null) {
                highestShowingOffset += lineDelimiter.length();
            }
        }
        catch (BadLocationException e) {
            LpexLog.log(e);
        }
        Point dimension = this.fCanvas.getSize();
        this._r.x = 0;
        this._r.width = dimension.x;
        int maxLayer = 1;
        int layer = 0;
        while (layer < maxLayer) {
            Iterator iter = this.fModel instanceof IAnnotationModelExtension2 ? ((IAnnotationModelExtension2)this.fModel).getAnnotationIterator(lowestShowingOffset, highestShowingOffset - lowestShowingOffset + 1, false, true) : this.fModel.getAnnotationIterator();
            while (iter.hasNext()) {
                int endLine;
                int startLine;
                Position position;
                Annotation annotation = (Annotation)iter.next();
                int lay = 0;
                if (this.fAnnotationAccessExtension != null) {
                    lay = this.fAnnotationAccessExtension.getLayer(annotation);
                }
                maxLayer = Math.max(maxLayer, lay + 1);
                if (lay != layer || this.skip(annotation) || (position = this.fModel.getPosition(annotation)) == null) continue;
                int offset = position.getOffset();
                int len = position.getLength();
                try {
                    startLine = lpexView.elementOfLine(doc.getLineOfOffset(offset) + 1);
                    endLine = lpexView.elementOfLine(doc.getLineOfOffset(offset + (len == 0 ? 0 : len - 1)) + 1);
                }
                catch (BadLocationException e) {
                    startLine = highestShowing + 1;
                    endLine = lowestShowing - 1;
                }
                if (startLine > highestShowing || endLine < lowestShowing) continue;
                int startRow = -1;
                int endRow = -1;
                int i2 = 1;
                while (i2 <= rows) {
                    int element = lpexView.elementOfRow(i2);
                    if (element != 0 && !lpexView.show(element)) {
                        int line = element;
                        if (line == startLine) {
                            startRow = i2 - 1;
                        } else if (line > startLine && startRow == -1 && line <= endLine) {
                            endRow = startRow = i2 - 1;
                        }
                        if (line > endLine) break;
                        if (line == endLine) {
                            endRow = i2 - 1;
                            break;
                        }
                        if (line < endLine && startRow != -1) {
                            endRow = i2 - 1;
                        }
                    }
                    ++i2;
                }
                if (startRow < 0) continue;
                this._r.y = startRow * lineHeight + shift;
                if (this._r.y >= dimension.y || this.fAnnotationAccessExtension == null) continue;
                this._r.height = (endRow - startRow + 1) * lineHeight;
                this.fAnnotationAccessExtension.paint(annotation, gc, this.fCanvas, this._r);
            }
            ++layer;
        }
    }

    public void redraw() {
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            GC gc = new GC((Drawable)this.fCanvas);
            this.doubleBufferPaint(gc);
            gc.dispose();
        }
    }

    public void setModel(IAnnotationModel model) {
        if (this.fAllowSetModel && model != this.fModel) {
            if (this.fModel != null) {
                this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
            }
            this.fModel = model;
            if (this.fModel != null) {
                this.fModel.addAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
            }
            if (this.fParentRuler != null) {
                this.fParentRuler.postRedraw();
            }
        }
    }

    public void setFont(Font font) {
    }

    protected ITextViewer getCachedTextViewer() {
        return this.fCachedTextViewer;
    }

    public IAnnotationModel getModel() {
        return this.fModel;
    }

    public void addAnnotationType(Object annotationType) {
        this.fConfiguredAnnotationTypes.add(annotationType);
        this.fAllowedAnnotationTypes.clear();
    }

    public int getLineOfLastMouseButtonActivity() {
        return this.fParentRuler.getLineOfLastMouseButtonActivity();
    }

    public int toDocumentLineNumber(int y_coordinate) {
        return this.fParentRuler.toDocumentLineNumber(y_coordinate);
    }

    public void removeAnnotationType(Object annotationType) {
        this.fConfiguredAnnotationTypes.remove(annotationType);
        this.fAllowedAnnotationTypes.clear();
    }

    private boolean skip(Annotation annotation) {
        String annotationType = annotation.getType();
        Boolean allowed = this.fAllowedAnnotationTypes.get(annotationType);
        if (allowed != null) {
            return allowed == false;
        }
        boolean skip = this.skip(annotationType);
        this.fAllowedAnnotationTypes.put(annotationType, !skip ? Boolean.TRUE : Boolean.FALSE);
        return skip;
    }

    private boolean skip(Object annotationType) {
        if (this.fAnnotationAccessExtension != null) {
            Iterator<Object> e = this.fConfiguredAnnotationTypes.iterator();
            while (e.hasNext()) {
                if (!this.fAnnotationAccessExtension.isSubtype(annotationType, e.next())) continue;
                return false;
            }
            return true;
        }
        return !this.fConfiguredAnnotationTypes.contains(annotationType);
    }

    public IAnnotationHover getHover() {
        return this.fHover;
    }

    public void setHover(IAnnotationHover hover) {
        this.fHover = hover;
    }

    public void addVerticalRulerListener(IVerticalRulerListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeVerticalRulerListener(IVerticalRulerListener listener) {
        throw new UnsupportedOperationException();
    }

    protected void mouseDown(int rulerLine) {
    }

    class InternalListener
    implements IAnnotationModelListener,
    IAnnotationModelListenerExtension {
        InternalListener() {
        }

        public void modelChanged(IAnnotationModel model) {
            if (LpexAnnotationRulerColumn.this.fParentRuler != null) {
                LpexAnnotationRulerColumn.this.fParentRuler.postRedraw();
            }
        }

        public void modelChanged(AnnotationModelEvent event) {
            if (!(event.getAnnotationModel() instanceof DocumentLineDiffer) && LpexAnnotationRulerColumn.this.fParentRuler != null) {
                LpexAnnotationRulerColumn.this.fParentRuler.postRedraw();
            }
        }
    }
}

