/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexTextViewer;
import com.ibm.lpex.core.LpexDocumentListener;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexLog;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.Utilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ILineDifferExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

final class DocumentAdapter
implements IDocumentListener,
LpexDocumentListener {
    private LpexTextViewer _lpexTextViewer;
    private IDocument _eclipseDocument;
    private LpexView _lpexView;
    private boolean _lpexDocumentSeriesOfChanges;
    private boolean _lpexResetTextPending;
    private boolean _eclipseDocumentSeriesOfChanges;
    private DocumentRewriteSession _eclipseDocumentRewriteSession;
    private ArrayList<SavedAnnotation> _savedAnnotations;
    private DocumentEvent _event;
    private DocumentEvent _originalEvent = new DocumentEvent();
    private boolean _eventTotalDoc;
    private int _eventEndLine;
    private int _eventEndPosition;
    private int _originalFirstLineLength;
    private DocumentReplaceCommand _replaceCommand = new DocumentReplaceCommand();
    private String _eol;
    List<Annotation> _annotationsToRemove = new ArrayList<Annotation>();
    Map<Annotation, Position> _annotationsToAdd = new HashMap<Annotation, Position>();
    private boolean _processingPendingEclipseChange = false;

    public DocumentAdapter(LpexTextViewer lpexTextViewer) {
        this._lpexTextViewer = lpexTextViewer;
    }

    void setEclipseDocument(IDocument eclipseDocument) {
        this.listenToEclipseDocument(false);
        this._eclipseDocument = eclipseDocument;
        this._eol = null;
        this._eclipseDocumentSeriesOfChanges = false;
        this._savedAnnotations = null;
        this.listenToEclipseDocument(true);
    }

    void setLpexView(LpexView lpexView) {
        this.listenToLpexDocument(false);
        this._lpexDocumentSeriesOfChanges = false;
        this._lpexView = lpexView;
        this.listenToLpexDocument(true);
        if (this._lpexView != null) {
            this._lpexView.setAdapter(this);
        }
    }

    void listenToEclipseDocument(boolean listen) {
        if (this._eclipseDocument != null) {
            if (listen) {
                this._eclipseDocument.addPrenotifiedDocumentListener((IDocumentListener)this);
            } else {
                this._eclipseDocument.removePrenotifiedDocumentListener((IDocumentListener)this);
            }
        }
    }

    void listenToLpexDocument(boolean listen) {
        if (this._lpexView != null) {
            if (listen) {
                this._lpexView.addLpexDocumentListener(this);
            } else {
                this._lpexView.removeLpexDocumentListener(this);
            }
        }
    }

    void listenToLpexDocumentAdjust(boolean listen) {
        if (this._lpexView != null) {
            if (listen) {
                this._lpexView.addLpexDocumentAdjustListener(this);
            } else {
                this._lpexView.removeLpexDocumentAdjustListener(this);
            }
        }
    }

    private void listenToDirectLpexDocumentAdjust(boolean listen) {
        if (this._lpexView != null) {
            if (listen) {
                this._lpexView.addLpexDocumentAdjustListener(this);
            } else {
                this._lpexView.removeLpexDocumentAdjustListener(this);
            }
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this._event = event;
        this._originalEvent.fOffset = event.getOffset();
        this._originalEvent.fLength = event.getLength();
        this._originalEvent.fText = event.getText();
        try {
            this._originalFirstLineLength = this._eclipseDocument.getLineLength(0);
        }
        catch (BadLocationException e) {
            this._originalFirstLineLength = 0;
        }
        int offset = event.getOffset();
        int len = event.getLength();
        boolean bl = this._eventTotalDoc = offset == 0 && len == this._eclipseDocument.getLength() && this._eclipseDocument.getLength() != 0;
        if (!this._eventTotalDoc && len != 0) {
            this._eventEndLine = this.getDocLine(offset += len);
            this._eventEndPosition = offset - this.getDocOffset(this._eventEndLine) + 1;
        } else {
            this._eventEndLine = 0;
        }
    }

    public void documentChanged(DocumentEvent event) {
        if (event == null || event != this._event || this._lpexView == null) {
            return;
        }
        if (!this._eventTotalDoc) {
            this._eventTotalDoc = this._originalEvent.getOffset() != event.getOffset() || this._originalEvent.getLength() != event.getLength() || !this._originalEvent.getText().equals(event.getText());
        }
        this._processingPendingEclipseChange = true;
        if (this._eventTotalDoc) {
            this._eol = null;
            this.lpexUpdate(event.getText());
        } else {
            if (event.getOffset() < this._originalFirstLineLength) {
                this._eol = null;
            }
            this.lpexUpdate(event.getText(), event.getOffset(), event.getLength());
        }
        this._processingPendingEclipseChange = false;
    }

    private ILineDifferExtension getLineDiffer() {
        IAnnotationModelExtension model;
        IAnnotationModel diff;
        ISourceViewer viewer;
        IAnnotationModel m;
        if (this._lpexTextViewer instanceof ISourceViewer && (m = (viewer = (ISourceViewer)this._lpexTextViewer).getAnnotationModel()) instanceof IAnnotationModelExtension && (diff = (model = (IAnnotationModelExtension)m).getAnnotationModel((Object)"diff")) instanceof ILineDifferExtension) {
            return (ILineDifferExtension)diff;
        }
        return null;
    }

    @Override
    public void documentChanged(LpexView lpexView, int type, int line, int position, int count) {
        Object docText;
        int delLen;
        int docOffset;
        if (this._eclipseDocument == null) {
            return;
        }
        if (type == 6) {
            this.startEclipseChanges();
            return;
        }
        if (type == 7) {
            this.endEclipseChanges();
            return;
        }
        boolean lastLine = false;
        if (type != 0 && type != 1 && type != 2) {
            int eclipseLines = this._eclipseDocument.getNumberOfLines();
            boolean bl = type == 5 ? line > eclipseLines : (lastLine = line >= eclipseLines);
            if (lastLine && line > eclipseLines) {
                this.docUpdate(this.getEOL(), this._eclipseDocument.getLength(), 0);
            }
        }
        switch (type) {
            case 0: {
                String lpexLine;
                docOffset = this.getDocOffset(line, position);
                delLen = count;
                docText = "";
                if (!this._lpexView.nls().isSmartLogical() || (lpexLine = this.getLpexText(line).substring(position - 1)).length() != count) break;
                int actLen = this._lpexView.nls().visualToLogical(lpexLine).length();
                int endDocLineOffset = line == this._eclipseDocument.getNumberOfLines() ? this._eclipseDocument.getLength() : this.getDocOffset(line + 1);
                String docLine = this._eclipseDocument.get().substring(docOffset, endDocLineOffset).replace("\r", "").replace("\n", "");
                delLen = Math.min(actLen, docLine.length());
                break;
            }
            case 1: {
                docOffset = this.getDocOffset(line, position);
                delLen = count;
                docText = this.getLpexText(line, position, count);
                break;
            }
            case 2: {
                docOffset = this.getDocOffset(line, position);
                delLen = 0;
                docText = this.getLpexText(line, position, count);
                break;
            }
            case 3: {
                docOffset = this.getDocOffset(line);
                delLen = this.getDocLineLength(line);
                docText = "";
                if (!lastLine || line <= 1 || this.fileEndingEol()) break;
                try {
                    String eol = this._eclipseDocument.getLineDelimiter(line - 2);
                    int eolLength = eol == null ? 0 : eol.length();
                    docOffset -= eolLength;
                    delLen += eolLength;
                }
                catch (BadLocationException eol) {}
                break;
            }
            case 4: {
                docOffset = this.getDocOffset(line);
                delLen = this.getDocLineLength(line);
                docText = this.getLpexText(line);
                if (!lastLine || this.fileEndingEol()) {
                    String oldTextEol = null;
                    try {
                        oldTextEol = this._eclipseDocument.getLineDelimiter(line - 1);
                    }
                    catch (BadLocationException eolLength) {
                        // empty catch block
                    }
                    if (oldTextEol != null) {
                        delLen -= oldTextEol.length();
                    } else {
                        docText = (String)docText + this.getEOL();
                    }
                }
                String oldText = this.getDocText(docOffset, delLen);
                int start = 0;
                int end = ((String)docText).length();
                while (delLen > 0 && start < end && oldText.charAt(start) == ((String)docText).charAt(start)) {
                    ++docOffset;
                    --delLen;
                    ++start;
                }
                int i = oldText.length() - 1;
                while (delLen > 0 && end > start && oldText.charAt(i) == ((String)docText).charAt(end - 1)) {
                    --delLen;
                    --i;
                    --end;
                }
                if (start == end) {
                    if (delLen == 0) {
                        return;
                    }
                    docText = "";
                    break;
                }
                docText = ((String)docText).substring(start, end);
                break;
            }
            case 5: {
                docOffset = this.getDocOffset(line);
                delLen = 0;
                docText = this.getLpexText(line);
                if (lastLine && !this.fileEndingEol()) break;
                docText = (String)docText + this.getEOL();
                break;
            }
            default: {
                return;
            }
        }
        this.docUpdate((String)docText, docOffset, delLen);
    }

    private boolean fileEndingEol() {
        return this._lpexView.queryOn("current.fileEndingEol");
    }

    private String getEOL() {
        if (this._eol == null) {
            this._eol = TextUtilities.getDefaultLineDelimiter((IDocument)this._eclipseDocument);
        }
        return this._eol;
    }

    private void startEclipseChanges() {
        if (this._eclipseDocument instanceof IDocumentExtension4) {
            if (!this._eclipseDocumentSeriesOfChanges) {
                this._eclipseDocumentRewriteSession = ((IDocumentExtension4)this._eclipseDocument).startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
            }
            this._eclipseDocumentSeriesOfChanges = true;
            this.listenToEclipseDocument(false);
        }
        if (this._savedAnnotations != null) {
            return;
        }
        IAnnotationModel model = this._lpexTextViewer._annotationModel;
        if (model != null) {
            this._savedAnnotations = new ArrayList(20);
            Iterator e = model.getAnnotationIterator();
            while (e.hasNext()) {
                Annotation a = (Annotation)e.next();
                Position pos = model.getPosition(a);
                if (pos == null || pos.isDeleted()) continue;
                this._savedAnnotations.add(new SavedAnnotation(a, pos));
            }
            if (this._savedAnnotations.size() != 0) {
                model.disconnect(this._eclipseDocument);
            }
        }
    }

    private void endEclipseChanges() {
        if (this._eclipseDocument instanceof IDocumentExtension4) {
            if (this._eclipseDocumentSeriesOfChanges) {
                ((IDocumentExtension4)this._eclipseDocument).stopRewriteSession(this._eclipseDocumentRewriteSession);
            }
            this._eclipseDocumentSeriesOfChanges = false;
            this.listenToEclipseDocument(true);
        }
        if (this._savedAnnotations != null && this._savedAnnotations.size() != 0) {
            IAnnotationModel model = this._lpexTextViewer._annotationModel;
            model.connect(this._eclipseDocument);
            int i = 0;
            while (i < this._savedAnnotations.size()) {
                this._savedAnnotations.get(i).update(model);
                ++i;
            }
            if (model instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)model).replaceAnnotations(this._annotationsToRemove.toArray(new Annotation[this._annotationsToRemove.size()]), this._annotationsToAdd);
                this._annotationsToRemove.clear();
                this._annotationsToAdd.clear();
            }
        }
        this._savedAnnotations = null;
    }

    void startLpexChanges() {
        this._lpexDocumentSeriesOfChanges = true;
        this._lpexResetTextPending = false;
    }

    void endLpexChanges() {
        this._lpexDocumentSeriesOfChanges = false;
        if (this._lpexResetTextPending) {
            this._lpexResetTextPending = false;
            this.lpexResetText(this._eclipseDocument.get(), true);
            this._lpexView.doCommand("set dirty on");
        } else {
            this._lpexView.doDefaultCommand("undo check");
        }
        this._lpexView.doCommand("screenShow document");
    }

    private int getDocLine(int offset) {
        try {
            return this._eclipseDocument.getLineOfOffset(offset) + 1;
        }
        catch (BadLocationException x) {
            SWT.error((int)5);
            return -1;
        }
    }

    private int getDocOffset(int line) {
        try {
            return this._eclipseDocument.getLineOffset(line - 1);
        }
        catch (BadLocationException x) {
            SWT.error((int)5);
            return -1;
        }
    }

    private int getDocOffset(int line, int position) {
        try {
            return this._eclipseDocument.getLineOffset(line - 1) + position - 1;
        }
        catch (BadLocationException x) {
            SWT.error((int)5);
            return -1;
        }
    }

    int getDocOffset(LpexDocumentLocation documentLocation) {
        int position;
        if (documentLocation == null || documentLocation.element < 1 || this._lpexView == null) {
            return -1;
        }
        int element = documentLocation.element;
        int line = this._lpexView.lineOfElement(element);
        if (this._lpexView.show(element)) {
            element = this._lpexView.elementOfLine(line);
            String text = this._lpexView.elementText(element);
            if (text == null) {
                return 0;
            }
            position = text.length() + 1;
        } else {
            String text = this._lpexView.elementText(element);
            if (text == null) {
                return -1;
            }
            position = documentLocation.position;
            if (position > text.length() + 1) {
                position = text.length() + 1;
            }
        }
        return this.getDocOffset(line, Utilities.textToFullTextPosition(this._lpexView, element, position));
    }

    private int getFullTextDocOffset(LpexDocumentLocation documentLocation) {
        if (documentLocation == null || this._lpexView == null) {
            return -1;
        }
        String fullText = this._lpexView.elementFullText(documentLocation.element);
        if (fullText == null) {
            return -1;
        }
        int position = documentLocation.position;
        if (position > fullText.length() + 1) {
            position = fullText.length() + 1;
        }
        return this.getDocOffset(this._lpexView.lineOfElement(documentLocation.element), position);
    }

    private int getDocLineLength(int line) {
        try {
            return this._eclipseDocument.getLineLength(--line);
        }
        catch (BadLocationException x) {
            SWT.error((int)5);
            return -1;
        }
    }

    private String getDocText(int offset, int len) {
        try {
            return this._eclipseDocument.get(offset, len);
        }
        catch (BadLocationException x) {
            SWT.error((int)5);
            return "";
        }
    }

    LpexDocumentLocation getLpexDocumentLocation(int offset) {
        try {
            int eclipseLine = this._eclipseDocument.getLineOfOffset(offset);
            int position = offset - this._eclipseDocument.getLineOffset(eclipseLine) + 1;
            int element = this._lpexView.elementOfLine(eclipseLine + 1);
            return new LpexDocumentLocation(element, Utilities.fullTextToTextPosition(this._lpexView, element, position));
        }
        catch (BadLocationException x) {
            SWT.error((int)5);
            return new LpexDocumentLocation(0, 0);
        }
    }

    private LpexDocumentLocation getFullTextLpexDocumentLocation(int offset) {
        if (offset >= this._eclipseDocument.getLength()) {
            return new LpexDocumentLocation(-1, -1);
        }
        try {
            int eclipseLine = this._eclipseDocument.getLineOfOffset(offset);
            int position = offset - this._eclipseDocument.getLineOffset(eclipseLine) + 1;
            return new LpexDocumentLocation(this._lpexView.elementOfLine(eclipseLine + 1), position);
        }
        catch (BadLocationException x) {
            SWT.error((int)5);
            return new LpexDocumentLocation(0, 0);
        }
    }

    private String getLpexText(int line) {
        return this._lpexView.lineFullText(line);
    }

    private String getLpexText(int line, int position, int len) {
        return this._lpexView.lineFullText(line).substring(position - 1, position - 1 + len);
    }

    private void docUpdate(String text, int offset, int len) {
        if (!this._eclipseDocumentSeriesOfChanges) {
            this.listenToEclipseDocument(false);
        }
        this._replaceCommand.replace(offset, len, text);
        if (!this._eclipseDocumentSeriesOfChanges) {
            this.listenToEclipseDocument(true);
        }
    }

    private void docUpdateEndingEol() {
        try {
            int eol;
            int len = this._eclipseDocument.getLength();
            int n = eol = len == 0 ? 0 : (int)this._eclipseDocument.getChar(len - 1);
            if (eol != 13 && eol != 10) {
                this.docUpdate(this.getEOL(), this._eclipseDocument.getLength(), 0);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void lpexSetText() {
        if (this.fileEndingEol()) {
            this.docUpdateEndingEol();
        }
        this.listenToLpexDocument(false);
        this.listenToLpexDocumentAdjust(true);
        this._lpexView.setText(this._eclipseDocument.get());
        this.listenToLpexDocumentAdjust(false);
        this.listenToLpexDocument(true);
    }

    private void lpexResetText(String text, boolean keepEnvironment) {
        this.listenToLpexDocument(false);
        this.listenToDirectLpexDocumentAdjust(true);
        Utilities.resetText(this._lpexView, text, keepEnvironment);
        this.listenToDirectLpexDocumentAdjust(false);
        this.listenToLpexDocument(true);
    }

    private void lpexUpdate(String text) {
        this.lpexResetText(text, false);
        if (this._lpexView != null) {
            this._lpexView.doCommand("screenShow document");
        }
    }

    private void lpexUpdate(String text, int offset, int len) {
        if (this._lpexDocumentSeriesOfChanges && this._lpexResetTextPending) {
            return;
        }
        this.listenToLpexDocument(false);
        this.listenToDirectLpexDocumentAdjust(true);
        int line = this.getDocLine(offset);
        int position = offset - this.getDocOffset(line) + 1;
        LpexView lpexView = this._lpexTextViewer.getActiveLpexView();
        boolean done = Utilities.updateText(lpexView, line, position, this._eventEndLine, this._eventEndPosition, text);
        this.listenToDirectLpexDocumentAdjust(false);
        this.listenToLpexDocument(true);
        if (done) {
            if (!this._lpexDocumentSeriesOfChanges) {
                this._lpexView.doDefaultCommand("undo check");
                this._lpexView.triggerAction(146);
            }
        } else if (this._lpexDocumentSeriesOfChanges) {
            this._lpexResetTextPending = true;
        } else {
            this.lpexResetText(this._eclipseDocument.get(), true);
            this._lpexView.doCommand("set dirty on");
            this._lpexView.doCommand("screenShow document");
        }
    }

    private class DocumentReplaceCommand
    implements Runnable {
        private int _offset;
        private int _len;
        private String _text;

        private DocumentReplaceCommand() {
        }

        @Override
        public void run() {
            ILineDifferExtension d = null;
            if (DocumentAdapter.this._processingPendingEclipseChange && (d = DocumentAdapter.this.getLineDiffer()) != null) {
                d.suspend();
            }
            try {
                DocumentAdapter.this._eclipseDocument.replace(this._offset, this._len, this._text);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (Exception e) {
                LpexLog.log(e);
            }
            if (d != null) {
                d.resume();
            }
        }

        public void replace(int offset, int len, String text) {
            this._offset = offset;
            this._len = len;
            this._text = text;
            if (Display.getCurrent() != null) {
                this.run();
            } else {
                Display.getDefault().syncExec((Runnable)this);
            }
        }
    }

    final class SavedAnnotation {
        private Annotation _annotation;
        private LpexDocumentLocation _start;
        private LpexDocumentLocation _end;

        SavedAnnotation(Annotation annotation, Position pos) {
            this._annotation = annotation;
            int _offset = pos.getOffset();
            int _len = pos.getLength();
            this._start = DocumentAdapter.this.getFullTextLpexDocumentLocation(_offset);
            this._end = DocumentAdapter.this.getFullTextLpexDocumentLocation(_offset + _len);
        }

        void update(IAnnotationModel model) {
            int newLen;
            int newOffset;
            if (this._start.element == -1 && this._start.position == -1) {
                newOffset = DocumentAdapter.this._eclipseDocument.getLength();
                newLen = 0;
            } else {
                newOffset = DocumentAdapter.this.getFullTextDocOffset(this._start);
                newLen = DocumentAdapter.this.getFullTextDocOffset(this._end) - newOffset;
            }
            if (newOffset >= 0 && newLen >= 0) {
                Position pos = new Position(newOffset, newLen);
                Position old = model.getPosition(this._annotation);
                if (old == null || !old.equals((Object)pos)) {
                    if (model instanceof IAnnotationModelExtension) {
                        DocumentAdapter.this._annotationsToRemove.add(this._annotation);
                        DocumentAdapter.this._annotationsToAdd.put(this._annotation, pos);
                    } else {
                        model.removeAnnotation(this._annotation);
                        model.addAnnotation(this._annotation, pos);
                    }
                }
            }
        }
    }
}

