/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idz.system.util;

import com.ibm.ftt.core.CorePlugin;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class SystemUtils {
    public static final String OS_NAME_PROPERTY = "os.name";
    public static final String OS_NAME_WIN = "win";
    public static final String OS_NAME_MAC = "mac";
    public static final String OS_NAME_ZOS = "z/os";
    public static final String OS_NAME_AIX = "aix";
    public static final String OS_NAME_LINUX = "linux";
    public static final String NO_OS_NAME = "";

    public static boolean isWindows() {
        String OS = System.getProperty(OS_NAME_PROPERTY, NO_OS_NAME).toLowerCase();
        return OS.indexOf(OS_NAME_WIN) >= 0;
    }

    public static boolean isMac() {
        String OS = System.getProperty(OS_NAME_PROPERTY, NO_OS_NAME).toLowerCase();
        return OS.indexOf(OS_NAME_MAC) >= 0;
    }

    public static boolean isZos() {
        String OS = System.getProperty(OS_NAME_PROPERTY, NO_OS_NAME).toLowerCase();
        return OS.indexOf(OS_NAME_ZOS) >= 0;
    }

    public static boolean isAix() {
        String OS = System.getProperty(OS_NAME_PROPERTY, NO_OS_NAME).toLowerCase();
        return OS.indexOf(OS_NAME_AIX) >= 0;
    }

    public static boolean isLinux() {
        String OS = System.getProperty(OS_NAME_PROPERTY, NO_OS_NAME).toLowerCase();
        return OS.indexOf(OS_NAME_LINUX) >= 0;
    }

    public static boolean doesBundleNameExist(String bundleName) {
        boolean bBundleExists = false;
        try {
            BundleContext ctx = FrameworkUtil.getBundle(CorePlugin.class).getBundleContext();
            Bundle[] bundles = ctx.getBundles();
            int i = 0;
            while (i < bundles.length) {
                String name;
                Bundle b = bundles[i];
                if (b != null && (name = b.toString().toLowerCase().trim()).contains(bundleName)) {
                    bBundleExists = true;
                    return bBundleExists;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            bBundleExists = false;
        }
        return bBundleExists;
    }

    public static final boolean isThereABundle(Class<?> referenceClass, String beginsWith) {
        if (referenceClass != null && beginsWith != null) {
            BundleContext ctx = FrameworkUtil.getBundle(referenceClass).getBundleContext();
            Bundle[] bundles = ctx.getBundles();
            int b = 0;
            while (b < bundles.length) {
                if (bundles[b] != null && bundles[b].toString().toLowerCase().trim().startsWith(beginsWith.toLowerCase().trim())) {
                    return true;
                }
                ++b;
            }
        }
        return false;
    }

    public static final boolean platformHasBundle(String bundleName) {
        if (bundleName != null) {
            if (Platform.getBundle((String)bundleName) != null) {
                return true;
            }
            return SystemUtils.doesBundleNameExist(bundleName);
        }
        return false;
    }
}

