/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idz.system.util;

import com.ibm.dmh.scan.classify.ScanProperties;
import com.ibm.ftt.resources.zos.util.extension.IMVSFileClassifier;
import com.ibm.jjson.JsonMap;
import com.ibm.teamz.classify.ClassifyFileContent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public class RAAFileClassifier
implements IMVSFileClassifier {
    private static String CobolMainId = "com.ibm.ftt.language.cobol.core.CobolLanguage";
    private static String PliMainId = "com.ibm.ftt.language.pli.core.PLiLanguage";
    private static String CMainId = "org.eclipse.cdt.core.cSource";
    private static String CppMainId = "org.eclipse.cdt.core.cxxSource";
    private static String CobolInclId = "com.ibm.ftt.language.cobol.core.CobolCopybookLanguage";
    private static String PliInclId = "com.ibm.ftt.language.pli.core.PLIIncludeLanguage";
    private static String CInclId = "org.eclipse.cdt.core.cHeader";
    private static String CppInclId = "org.eclipse.cdt.core.cxxHeader";
    private static String AsmId = "org.eclipse.cdt.core.asmSource";
    private static String JavaId = "org.eclipse.jdt.core.javaSource";
    private static String JclId = "com.ibm.ftt.language.jcl";
    private static String XmlId = "org.eclipse.core.runtime.xml";

    public String classifyFile(String fileName, String containerName) {
        ClassifyFileContent cfc = new ClassifyFileContent();
        cfc.setDebug(0);
        ScanProperties scanProperties = new ScanProperties();
        scanProperties.setAllowIncludeInAnyColumn(null);
        scanProperties.setCaptureComments("false");
        scanProperties.setCaptureLiterals("false");
        scanProperties.setCapturePictures("false");
        scanProperties.setCaptureSymbolsReserved("false");
        scanProperties.setCaptureSymbolsUserDefined("false");
        scanProperties.setCodePage("ISO-8859-1");
        scanProperties.setExpandIncludeInComment("false");
        scanProperties.setFreeFormatCobol(null);
        scanProperties.setJsonResponseFormat("ADI");
        scanProperties.setLanguageHint(null);
        scanProperties.setReportNetViewMacros(null);
        scanProperties.setTruncateFilenames(null);
        String metaData = cfc.getFilesMetadata(containerName, fileName, null, null, scanProperties);
        JsonMap scanResult = new JsonMap((CharSequence)metaData);
        if (((String)scanResult.get((Object)"languageCd")).equals("EMP?") || ((String)scanResult.get((Object)"languageCd")).equals("????")) {
            return "UNKN";
        }
        String languageCd = (String)scanResult.get((Object)"languageCd");
        Languages language = Languages.UNKN;
        if (!(languageCd == null || languageCd.isEmpty() || languageCd.equals("EMP?") || languageCd.equals("????"))) {
            language = Languages.valueOf(languageCd);
        }
        FileTypes fileType = FileTypes.UNKN;
        String fileTypeCd = (String)scanResult.get((Object)"fileTypeCd");
        if (fileTypeCd != null && !fileTypeCd.isEmpty()) {
            fileType = FileTypes.valueOf(fileTypeCd);
        }
        String extent = "UNKN";
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType contentType = null;
        switch (language) {
            case COB: {
                if (fileType == FileTypes.MAIN) {
                    contentType = contentTypeManager.getContentType(CobolMainId);
                    extent = "cbl";
                    break;
                }
                contentType = contentTypeManager.getContentType(CobolInclId);
                extent = "cpy";
                break;
            }
            case PLI: {
                if (fileType == FileTypes.MAIN) {
                    contentType = contentTypeManager.getContentType(PliMainId);
                    extent = "pli";
                    break;
                }
                contentType = contentTypeManager.getContentType(PliInclId);
                extent = "inc";
                break;
            }
            case C: {
                if (fileType == FileTypes.MAIN) {
                    contentType = contentTypeManager.getContentType(CMainId);
                    extent = "c";
                    break;
                }
                contentType = contentTypeManager.getContentType(CInclId);
                extent = "h";
                break;
            }
            case CPP: {
                if (fileType == FileTypes.MAIN) {
                    contentType = contentTypeManager.getContentType(CppMainId);
                    extent = "cpp";
                    break;
                }
                contentType = contentTypeManager.getContentType(CppInclId);
                extent = "h";
                break;
            }
            case ASM: {
                if (fileType == FileTypes.MAP) {
                    extent = "bms";
                    break;
                }
                if (fileType == FileTypes.MFS) {
                    extent = "mfs";
                    break;
                }
                if (fileType == FileTypes.MAC) {
                    extent = "mac";
                    break;
                }
                contentType = contentTypeManager.getContentType(AsmId);
                extent = "asm";
                break;
            }
            case JAVA: {
                contentType = contentTypeManager.getContentType(JavaId);
                extent = "java";
                break;
            }
            case JCL: {
                contentType = contentTypeManager.getContentType(JclId);
                extent = "jcl";
                break;
            }
            case XML: {
                contentType = contentTypeManager.getContentType(XmlId);
                extent = "xml";
                break;
            }
            case PLX: {
                extent = "plx";
                break;
            }
            case REXX: {
                extent = "rexx";
                break;
            }
            case SQL: {
                extent = "sql";
                break;
            }
            case EASY: {
                extent = "ezt";
                break;
            }
        }
        if (contentType != null) {
            String[] typeList = contentType.getFileSpecs(8);
            boolean exists = false;
            String[] stringArray = typeList;
            int n = typeList.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                if (type.equals(extent)) {
                    exists = true;
                    break;
                }
                ++n2;
            }
            if (!exists) {
                extent = contentType.getFileSpecs(8)[0];
            }
        }
        return extent;
    }

    private static enum FileTypes {
        CSD,
        DBD,
        INCL,
        MAC,
        MAIN,
        MAP,
        MFS,
        PROC,
        PSB,
        PTRN,
        UNKN;

    }

    private static enum Languages {
        ARCH,
        ASM,
        BIN,
        C,
        CLAS,
        COB,
        CPP,
        EASY,
        GENE,
        GONE,
        ISPF,
        JAVA,
        JCL,
        PLI,
        PLX,
        REXX,
        SORT,
        SQL,
        TEXT,
        UNKN,
        XML,
        ZBND;

    }
}

