/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.rse.debug.subsystems;

import com.ibm.ftt.rse.debug.subsystems.DebugSessionListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.rse.connectorservice.dstore.DStoreConnectorService;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.dstore.util.DStoreStatusMonitor;
import org.eclipse.rse.services.files.RemoteFileException;

public class DebugSubSystem
extends SubSystem {
    private DebugSessionListener _debugSessionListener;

    public DebugSubSystem(IHost host, IConnectorService connectorService) {
        super(host, connectorService);
        this.setHidden(true);
    }

    public void initializeSubSystem(IProgressMonitor monitor) throws SystemMessageException {
        super.initializeSubSystem(monitor);
        DataStore ds = this.getDataStore();
        this._debugSessionListener = new DebugSessionListener(this.getHostName(), ds, this);
    }

    public void uninitializeSubSystem(IProgressMonitor monitor) {
        super.uninitializeSubSystem(monitor);
        if (this._debugSessionListener != null) {
            this._debugSessionListener.dispose();
            this._debugSessionListener = null;
        }
    }

    private DataStore getDataStore() {
        DStoreConnectorService cs = (DStoreConnectorService)this.getConnectorService();
        return cs.getDataStore();
    }

    public boolean readyToDebug() {
        if (this.isConnected() && this._debugSessionListener != null) {
            return this._debugSessionListener.readyToDebug();
        }
        return false;
    }

    public String getDBMVersion() {
        if (this.isConnected() && this._debugSessionListener != null) {
            return this._debugSessionListener.getDBMVersion();
        }
        return null;
    }

    public APIServerInfo getAPIServerInfo() throws ServerInfoException {
        if (!this.isConnected()) {
            throw new ServerInfoException("ERROR_NOT_CONNECTED");
        }
        try {
            if (!this.supportsCommand("C_GET_API_SERVER_INFO")) {
                throw new ServerInfoException("ERROR_UNKNOWN_COMMAND");
            }
            DataElement cmd = this.getCommand("C_GET_API_SERVER_INFO");
            DataElement status = this.runCommand(cmd);
            if (status != null) {
                if ("done".equals(status.getAttribute(2))) {
                    String port = status.getAttribute(4);
                    String secureport = status.getAttribute(0);
                    String contextroot = status.getAttribute(3);
                    String portOverride = this.getDebugProfilePortOverride();
                    if (portOverride != null) {
                        if (this.getDataStore().usingSSL()) {
                            secureport = portOverride;
                        } else {
                            port = portOverride;
                        }
                    }
                    APIServerInfo serverInfo = new APIServerInfo(port, secureport, contextroot);
                    return serverInfo;
                }
                if ("failed".equals(status.getAttribute(2))) {
                    String errorID = status.getAttribute(4);
                    if (errorID == null) {
                        errorID = "ERROR_UNKNOWN";
                    }
                    throw new ServerInfoException(errorID);
                }
            }
        }
        catch (RemoteFileException remoteFileException) {
            // empty catch block
        }
        throw new ServerInfoException("ERROR_UNKNOWN");
    }

    private DataElement getDebugNodeElement() throws RemoteFileException {
        DataElement minerInfo = this.getDataStore().findMinerInformation("com.ibm.ftt.rse.debug.miners.DebugMiner");
        DataElement deDebugNode = this.getDataStore().find(minerInfo, 2, "debug.node", 2);
        return deDebugNode;
    }

    protected String getDebugProfilePortOverride() {
        String ovrSP;
        String portOverride = null;
        IHost host = this.getHost();
        IPropertySet portOverrideSet = host.getPropertySet("port.overrides");
        if (portOverrideSet != null && (ovrSP = portOverrideSet.getPropertyValue("override.debug.profile.port")) != null && ovrSP.equals("true")) {
            portOverride = portOverrideSet.getPropertyValue("debug.profile.port");
        }
        return portOverride;
    }

    public boolean supportsCommand(String cmdStr) {
        if (this.getDataStore() != null && this.getDataStore().isConnected()) {
            DataElement cmd = null;
            try {
                cmd = this.getCommand(cmdStr);
            }
            catch (RemoteFileException remoteFileException) {
                // empty catch block
            }
            return cmd != null;
        }
        return false;
    }

    private DataElement getCommand(String cmdStr) throws RemoteFileException {
        DataStore dataStore = this.getDataStore();
        DataElement subject = this.getDebugNodeElement();
        DataElement cmd = null;
        if (dataStore != null && subject != null) {
            cmd = dataStore.localDescriptorQuery(subject.getDescriptor(), cmdStr);
        }
        return cmd;
    }

    private DataElement runCommand(DataElement command) throws RemoteFileException {
        DataStore dataStore = this.getDataStore();
        DataElement subject = this.getDebugNodeElement();
        DataElement status = dataStore.command(command, subject);
        int patience = 10;
        DStoreStatusMonitor mon = new DStoreStatusMonitor(dataStore);
        while (!mon.determineStatusDone(status)) {
            try {
                mon.waitForUpdate(status, 100);
                --patience;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (patience < 0) break;
        }
        return status;
    }

    public class APIServerInfo {
        public String port;
        public String secureport;
        public String contextroot;
        public String errorID;

        public APIServerInfo(String port, String secureport, String contextroot) {
            this.port = port;
            this.secureport = secureport;
            this.contextroot = contextroot;
        }

        public APIServerInfo(String errorID) {
            this.errorID = errorID;
        }
    }

    public class ServerInfoException
    extends Exception {
        private static final long serialVersionUID = 1037706186825423973L;
        private String errorID;

        public ServerInfoException(String errorID) {
            super(errorID);
            this.errorID = errorID;
        }

        public String getErrorID() {
            return this.errorID;
        }
    }
}

