/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.rse.debug.subsystems;

import com.ibm.etools.common.navigator.core.CommonNavigatorPlugin;
import com.ibm.etools.common.navigator.extensionpoints.IDebugInformationResolver;
import com.ibm.ftt.common.logging.LogUtil;
import com.ibm.ftt.rse.debug.DebugSubSystemUtil;
import com.ibm.ftt.rse.debug.extensionpoints.IDebugEngineLauncher;
import com.ibm.ftt.rse.debug.subsystems.DebugSubSystem;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.extra.DomainEvent;
import org.eclipse.dstore.extra.IDataElement;
import org.eclipse.dstore.extra.IDomainListener;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;

public class DebugSessionListener
implements IDomainListener {
    private String _hostname = null;
    private DataStore _dataStore = null;
    private DebugSubSystem _debugSubSystem = null;
    private DataElement _initializeStatus = null;
    private DataElement _debugSessionContainer = null;
    private boolean _usingSSL = false;
    private String _keystoreLocation = null;
    private String _pkcsKeystoreLocation = null;
    private boolean _registrationAccepted = false;
    private String _dbmVersion = null;
    private boolean _needToFireInitializationEvent = true;

    public DebugSessionListener(String hostname, DataStore datastore, DebugSubSystem debugSubSystem) {
        this._hostname = hostname;
        this._dataStore = datastore;
        this._debugSubSystem = debugSubSystem;
        this._initializeStatus = this._dataStore.activateMiner("com.ibm.ftt.rse.debug.miners.DebugMiner");
        this._dataStore.getDomainNotifier().addDomainListener((IDomainListener)this);
        this._usingSSL = this._dataStore.usingSSL();
        this._pkcsKeystoreLocation = this._dataStore.getKeyStoreLocation() + "pkcs";
        this._keystoreLocation = this._dataStore.getKeyStoreLocation();
    }

    public void dispose() {
        if (this._dataStore != null) {
            RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(16, 4, (Object)this._debugSubSystem, null);
            this._hostname = null;
            this._initializeStatus = null;
            this._debugSessionContainer = null;
            this._dataStore.getDomainNotifier().removeDomainListener((IDomainListener)this);
            this._dataStore = null;
            this._debugSubSystem = null;
            this._dbmVersion = null;
        }
    }

    private boolean determineStatusDone(DataElement status) {
        boolean statusDone = status.getAttribute(3).equals("done") || status.getAttribute(2).equals("done") || status.getAttribute(2).equals("cancelled");
        return statusDone;
    }

    public boolean listeningTo(DomainEvent event) {
        if (this._initializeStatus != null) {
            IDataElement parent;
            boolean ready;
            if (this._debugSessionContainer == null && (ready = this.determineStatusDone(this._initializeStatus))) {
                if (this._initializeStatus.getValue().equals("failed")) {
                    LogUtil.log((int)4, (String)"The miner, com.ibm.ftt.rse.debug.miners.DebugMiner, was not found on the server.  Integrated debug sessions will not be possible until this is resolved.", (String)"com.ibm.ftt.rse.debug");
                    this.dispose();
                    return false;
                }
                this._debugSessionContainer = this._dataStore.findMinerInformation("com.ibm.ftt.rse.debug.miners.DebugMiner");
            }
            if (this._debugSessionContainer != null && (parent = event.getParent()) == this._debugSessionContainer) {
                return true;
            }
        }
        return false;
    }

    public void domainChanged(DomainEvent event) {
        if (this._needToFireInitializationEvent) {
            this._needToFireInitializationEvent = false;
            RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(4, 4, (Object)this._debugSubSystem, null);
        }
        int size = this._debugSessionContainer.getNestedSize();
        int i = 0;
        while (i < size) {
            DataElement element = this._debugSessionContainer.get(i);
            boolean handled = element.getAttribute(4).equals("handled");
            if (!handled) {
                String msg;
                String[] segs;
                String type = element.getType();
                if (type.equals("T_DEBUG_SESSION")) {
                    if (this.startDebugEngine(element.getName())) {
                        element.setAttribute(4, "handled");
                    }
                } else if (type.equals("T_DEBUG_MESSAGE") && (segs = (msg = element.getName()).split(",")).length > 1) {
                    String msgSeg = segs[1];
                    if (msgSeg.startsWith("Invalid")) {
                        this.dispose();
                    } else if (msgSeg.startsWith("Failed")) {
                        this._registrationAccepted = false;
                    } else if (msgSeg.startsWith("disconnect")) {
                        this._registrationAccepted = false;
                    } else if (msgSeg.startsWith("accept")) {
                        this._registrationAccepted = true;
                        if (segs.length > 2) {
                            this._dbmVersion = segs[2];
                        }
                    }
                    element.setAttribute(4, "handled");
                }
            }
            ++i;
        }
    }

    protected String getDebugPortOverride() {
        String ovrSP;
        String portOverride = null;
        IHost host = this._debugSubSystem.getHost();
        IPropertySet portOverrideSet = host.getPropertySet("port.overrides");
        if (portOverrideSet != null && (ovrSP = portOverrideSet.getPropertyValue("override.debug.port")) != null && ovrSP.equals("true")) {
            portOverride = portOverrideSet.getPropertyValue("debug.port");
        }
        return portOverride;
    }

    private boolean startDebugEngine(String sessionInfo) {
        String[] segs = sessionInfo.split(",");
        if (segs.length > 3) {
            IDebugEngineLauncher launcher;
            String host;
            if (this._dbmVersion == null) {
                this._dbmVersion = segs[0];
            }
            String portStr = segs[2];
            String override = this.getDebugPortOverride();
            if (override != null) {
                portStr = override;
            }
            String key = segs[3];
            String debugEngineLauncherId = "zpicl";
            if (segs.length > 6) {
                debugEngineLauncherId = segs[6];
            }
            String probeVersion = segs[segs.length < 9 ? segs.length - 1 : 7];
            String string = host = segs.length > 8 ? segs[8] : this._hostname;
            if (debugEngineLauncherId.equals(probeVersion)) {
                debugEngineLauncherId = "zpicl";
            }
            if ((launcher = DebugSubSystemUtil.getDebugEngineLauncher(debugEngineLauncherId)) == null && !debugEngineLauncherId.equals("zpicl")) {
                launcher = DebugSubSystemUtil.getDebugEngineLauncher("zpicl");
            }
            if (launcher != null) {
                IDebugInformationResolver dbResolver = CommonNavigatorPlugin.getDebugInformationResolver();
                if (dbResolver != null) {
                    dbResolver.startDaemonListening();
                }
                try {
                    int port = Integer.parseInt(portStr);
                    String keyStore = launcher.usePKCSKeystore() ? this._pkcsKeystoreLocation : this._keystoreLocation;
                    return launcher.launchEngine(host, port, key, probeVersion, this._usingSSL, keyStore, this._dataStore.getKeyStorePassword());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public boolean readyToDebug() {
        return this._debugSessionContainer != null && this._registrationAccepted;
    }

    public String getDBMVersion() {
        if (this.readyToDebug()) {
            if (this._dbmVersion == null) {
                this._dbmVersion = "1.1.0";
            }
            return this._dbmVersion;
        }
        return null;
    }
}

