/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xmlui.ui;

import com.ibm.debug.xmlui.Activator;
import com.ibm.debug.xmlui.api.IXUIElement;
import com.ibm.debug.xmlui.api.XUIAttributeList;
import com.ibm.debug.xmlui.api.XUIModel;
import com.ibm.debug.xmlui.api.XUIParseException;
import com.ibm.debug.xmlui.internal.parser.XUIAttributesParser;
import com.ibm.debug.xmlui.internal.parser.XUICheckedButton;
import com.ibm.debug.xmlui.internal.parser.XUICombo;
import com.ibm.debug.xmlui.internal.parser.XUIGroup;
import com.ibm.debug.xmlui.internal.parser.XUILabel;
import com.ibm.debug.xmlui.internal.parser.XUIParser;
import com.ibm.debug.xmlui.internal.parser.XUIRadioButton;
import com.ibm.debug.xmlui.internal.parser.XUIRadioGroup;
import com.ibm.debug.xmlui.ui.XUIReconciler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;

public class XUIBuilder {
    protected XUIModel fModel;
    protected XUIReconciler fReconciler;
    private WidgetListener fListener = new WidgetListener();

    public XUIBuilder(URL url) throws XUIParseException {
        this(url, null);
    }

    public XUIBuilder(URL url, ClassLoader cl) throws XUIParseException {
        if (url == null) {
            throw new XUIParseException("URL should not be null");
        }
        XUIParser parser = new XUIParser();
        this.fModel = parser.parse(url, cl);
        this.createReconciler(this.fModel);
    }

    public XUIBuilder(InputStream inputStream) throws XUIParseException {
        this(inputStream, null);
    }

    public XUIBuilder(InputStream inputStream, ClassLoader cl) throws XUIParseException {
        XUIParser parser = new XUIParser();
        this.fModel = parser.parse(inputStream, cl);
        this.createReconciler(this.fModel);
    }

    public XUIBuilder(XUIModel model) {
        this.fModel = model;
        this.createReconciler(this.fModel);
    }

    public XUIModel getModel() {
        return this.fModel;
    }

    protected XUIReconciler createReconciler(XUIModel root) {
        this.fReconciler = new XUIReconciler(this.fModel);
        return this.fReconciler;
    }

    public XUIReconciler getReconciler() {
        return this.fReconciler;
    }

    public void reconcileAttributes(XUIAttributeList attributes) {
        this.fReconciler.reconcileAttributes(attributes);
    }

    public void reconcileAttributes(String attributesString) {
        byte[] bytes = attributesString.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
        XUIAttributesParser parser = new XUIAttributesParser();
        try {
            XUIAttributeList attributes = parser.parse(byteStream);
            this.fReconciler.reconcileAttributes(attributes);
        }
        catch (XUIParseException ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.debug.xmlui", ex.getMessage(), (Throwable)ex));
        }
    }

    public Control createContents(Composite parent) {
        return this.createChildren(parent, this.fModel, false, 5);
    }

    private Control createElementContents(Composite composite, IXUIElement element) {
        switch (element.getType()) {
            case 2: {
                this.createCheckButton(composite, (XUICheckedButton)element);
                break;
            }
            case 1: {
                this.createGroup(composite, (XUIGroup)element);
                break;
            }
            case 3: {
                this.createRadioButton(composite, (XUIRadioButton)element);
                break;
            }
            case 4: {
                this.createRadioGroup(composite, (XUIRadioGroup)element);
                break;
            }
            case 6: {
                this.createLabel(composite, (XUILabel)element);
                break;
            }
            case 7: {
                this.createCombo(composite, (XUICombo)element);
                break;
            }
        }
        return composite;
    }

    private Control createChildren(Composite parent, IXUIElement element, boolean isEditable, int indent) {
        return this.createChildren(parent, element, isEditable, false, indent);
    }

    private Control createChildren(Composite parent, IXUIElement element, boolean isEditable, boolean horizontalLayout, int indent) {
        if (element.getChildCount() == 0) {
            return parent;
        }
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        int numColumns = 1;
        if (horizontalLayout) {
            numColumns = element.getChildCount();
            layout.horizontalSpacing = 20;
        }
        layout.numColumns = numColumns;
        layout.marginWidth = indent;
        container.setLayout((Layout)layout);
        GridData gridData = new GridData(2);
        if (isEditable) {
            gridData.horizontalSpan = 2;
        }
        container.setLayoutData((Object)gridData);
        ArrayList<IXUIElement> children = element.getChildElements();
        int i = 0;
        while (i < children.size()) {
            IXUIElement child = children.get(i);
            if (child != null) {
                this.createElementContents(container, child);
            }
            ++i;
        }
        return container;
    }

    private Control createCheckButton(Composite parent, XUICheckedButton checkElement) {
        Composite container = parent;
        boolean isEditable = checkElement.isEditable();
        if (isEditable) {
            container = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            container.setLayout((Layout)layout);
            GridData gridData = new GridData();
            container.setLayoutData((Object)gridData);
        }
        Button checkButton = new Button(container, 32);
        checkButton.setText(checkElement.getName());
        String toolTipText = checkElement.getToolTipText();
        checkButton.addSelectionListener((SelectionListener)this.fListener);
        if (toolTipText != null && toolTipText.trim().length() > 0) {
            this.createTooltip((Control)checkButton, toolTipText);
        }
        this.fReconciler.registerElement(checkElement, (Control)checkButton);
        if (isEditable) {
            Text editableField = new Text(container, 2048);
            GridData gridData = new GridData();
            gridData.widthHint = 200;
            editableField.setLayoutData((Object)gridData);
            checkElement.setData(editableField);
        }
        this.createChildren(container, checkElement, isEditable, 20);
        return container;
    }

    private Control createRadioButton(Composite parent, XUIRadioButton radioElement) {
        return this.createRadioButton(parent, radioElement, false);
    }

    private Control createRadioButton(Composite parent, XUIRadioButton radioElement, boolean horizontalSpan) {
        String toolTipText;
        boolean isEditable;
        Button radioButton = new Button(parent, 16);
        radioButton.setText(radioElement.getName());
        radioButton.addSelectionListener((SelectionListener)this.fListener);
        this.fReconciler.registerElement(radioElement, (Control)radioButton);
        if (horizontalSpan) {
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            radioButton.setLayoutData((Object)gridData);
        }
        if (radioElement.isDefault()) {
            radioButton.setSelection(true);
        }
        if (isEditable = radioElement.isEditable()) {
            Text editableField = new Text(parent, 2048);
            GridData gridData = new GridData();
            gridData.widthHint = 200;
            editableField.setLayoutData((Object)gridData);
            radioElement.setData(editableField);
        }
        if ((toolTipText = radioElement.getToolTipText()) != null && toolTipText.trim().length() > 0) {
            this.createTooltip((Control)radioButton, toolTipText);
        }
        this.createChildren(parent, radioElement, isEditable, 20);
        return parent;
    }

    private Control createGroup(Composite composite, XUIGroup groupElement) {
        String groupName = groupElement.getName();
        Group group = null;
        if (groupElement.isBorderVisible()) {
            group = new Group(composite, 0);
            if (groupName != null && groupName.length() > 0) {
                group.setText(groupName);
            }
        } else {
            group = new Composite(composite, 0);
        }
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        String toolTipText = groupElement.getToolTipText();
        if (toolTipText != null && toolTipText.trim().length() > 0) {
            this.createTooltip((Control)group, toolTipText);
        }
        boolean horizontalLayout = groupElement.getLayout() == 1;
        this.createChildren((Composite)group, groupElement, false, horizontalLayout, 10);
        return group;
    }

    private Control createRadioGroup(Composite parent, XUIRadioGroup radioGroup) {
        Composite container = new Composite(parent, 0);
        int numColumns = 1;
        GridLayout layout = new GridLayout();
        if (radioGroup.getLayout() == 1) {
            numColumns = radioGroup.getChildCount();
            layout.horizontalSpacing = 40;
        } else if (this.hasEditableChild(radioGroup)) {
            numColumns = 2;
        }
        layout.numColumns = numColumns;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        container.setLayoutData((Object)gridData);
        ArrayList<IXUIElement> children = radioGroup.getChildElements();
        int i = 0;
        while (i < children.size()) {
            IXUIElement child = children.get(i);
            if (child instanceof XUIRadioButton) {
                XUIRadioButton radioElement = (XUIRadioButton)child;
                boolean horizontalSpan = false;
                if (radioGroup.getLayout() != 1 && numColumns == 2 && !radioElement.isEditable()) {
                    horizontalSpan = true;
                }
                this.createRadioButton(container, radioElement, horizontalSpan);
            }
            ++i;
        }
        return container;
    }

    private Control createLabel(Composite parent, XUILabel labelElement) {
        Composite container = parent;
        boolean isEditable = labelElement.isEditable();
        if (isEditable) {
            container = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            container.setLayout((Layout)layout);
            GridData gridData = new GridData();
            container.setLayoutData((Object)gridData);
        }
        Label label = new Label(container, 64);
        label.setText(labelElement.getName());
        this.fReconciler.registerElement(labelElement, (Control)label);
        if (isEditable) {
            Text textField = new Text(container, 2048);
            GridData gridData = new GridData();
            gridData.widthHint = 200;
            textField.setLayoutData((Object)gridData);
            labelElement.setData(textField);
        }
        this.createChildren(container, labelElement, isEditable, 20);
        return container;
    }

    private Control createCombo(Composite parent, XUICombo comboElement) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gridData = new GridData();
        container.setLayoutData((Object)gridData);
        Label comboNameLabel = new Label(container, 0);
        comboNameLabel.setText(comboElement.getName());
        int style = comboElement.isReadOnly() ? 8 : 0;
        Combo combo = new Combo(container, style);
        combo.setItems(comboElement.getItems());
        combo.select(comboElement.getSelectionIndex());
        this.fReconciler.registerElement(comboElement, (Control)combo);
        combo.addSelectionListener((SelectionListener)this.fListener);
        return container;
    }

    private boolean hasEditableChild(XUIRadioGroup radioGroup) {
        ArrayList<IXUIElement> children = radioGroup.getChildElements();
        int i = 0;
        while (i < children.size()) {
            IXUIElement child = children.get(i);
            if (child instanceof XUIRadioButton && ((XUIRadioButton)child).isEditable()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public XUIAttributeList getAttributes() {
        this.fReconciler.updateSelection();
        return this.fModel.getAttributes();
    }

    public void cleanup() {
        this.fReconciler.dispose();
        this.fModel = null;
    }

    private void createTooltip(Control widget, String tooltipText) {
        final ToolTip tip = new ToolTip(widget.getShell(), 0);
        tip.setMessage(tooltipText);
        widget.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent event) {
                Control widget = (Control)event.widget;
                Point loc = widget.getDisplay().getCursorLocation();
                tip.setLocation(loc.x, loc.y + 25);
                tip.setVisible(true);
            }

            public void mouseExit(MouseEvent event) {
                tip.setVisible(false);
            }

            public void mouseEnter(MouseEvent event) {
            }
        });
    }

    private class WidgetListener
    implements SelectionListener {
        private WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Combo combo;
            IXUIElement element;
            Object source = e.getSource();
            if (source instanceof Combo && (element = XUIBuilder.this.fReconciler.getElementFromWidget((Control)(combo = (Combo)source))) instanceof XUICombo) {
                ((XUICombo)element).selectItem(combo.getSelectionIndex());
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

