/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xmlui.internal.parser;

import com.ibm.debug.xmlui.api.IXUIConstants;
import com.ibm.debug.xmlui.api.IXUIElement;
import com.ibm.debug.xmlui.api.XUIModel;
import com.ibm.debug.xmlui.api.XUIParseException;
import com.ibm.debug.xmlui.internal.parser.XUIAbstractElement;
import com.ibm.debug.xmlui.internal.parser.XUIAbstractParser;
import com.ibm.debug.xmlui.internal.parser.XUICheckedButton;
import com.ibm.debug.xmlui.internal.parser.XUICombo;
import com.ibm.debug.xmlui.internal.parser.XUIGroup;
import com.ibm.debug.xmlui.internal.parser.XUILabel;
import com.ibm.debug.xmlui.internal.parser.XUIRadioButton;
import com.ibm.debug.xmlui.internal.parser.XUIRadioGroup;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XUIParser
extends XUIAbstractParser
implements IXUIConstants {
    private String fBundle = null;
    private ClassLoader fClassLoader = null;

    public XUIModel parse(URL url) throws XUIParseException {
        return this.parse(url, this.getClass().getClassLoader());
    }

    public XUIModel parse(URL url, ClassLoader cl) throws XUIParseException {
        this.fClassLoader = cl;
        try {
            InputStream stream = url.openStream();
            XUIModel root = this.parse(stream);
            stream.close();
            return root;
        }
        catch (IOException ioe) {
            throw new XUIParseException(ioe);
        }
    }

    public XUIModel parse(InputStream stream, ClassLoader cl) throws XUIParseException {
        this.fClassLoader = cl;
        return this.parse(stream);
    }

    public XUIModel parse(InputStream stream) throws XUIParseException {
        Document dom = this.getDocument(stream);
        Element rootElement = dom.getDocumentElement();
        if (!this.nodeNameEquals(rootElement, "http:///com/ibm/debug/xmlui", "model")) {
            throw new XUIParseException("Invalid configuration file: The root element must be a <xmlui:root> node.");
        }
        XUIModel uiRoot = new XUIModel();
        this.fBundle = rootElement.getAttribute("bundle");
        String name = rootElement.getAttribute("name");
        if (name != null && name.trim().length() > 0) {
            uiRoot.setName(name);
        }
        NodeList childNodes = rootElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                IXUIElement spElement = this.createXUIElement((Element)node, uiRoot);
                uiRoot.addChildElement(spElement);
            }
            ++i;
        }
        return uiRoot;
    }

    private IXUIElement createXUIElement(Element node, IXUIElement parent) throws XUIParseException {
        if (this.isGroup(node)) {
            return this.createGroup(node, parent);
        }
        if (this.isCheckButton(node)) {
            return this.createCheckButton(node, parent);
        }
        if (this.isRadioGroup(node)) {
            return this.createRadioGroup(node, parent);
        }
        if (this.isRadioButton(node)) {
            return this.createRadioButton(node, parent);
        }
        if (this.isLabel(node)) {
            return this.createLabel(node, parent);
        }
        if (this.isCombo(node)) {
            return this.createCombo(node, parent);
        }
        return null;
    }

    private void processChildNodes(Node node, IXUIElement parent) throws XUIParseException {
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node child = childNodes.item(i);
            short nodeType = child.getNodeType();
            if (nodeType == 1) {
                IXUIElement element = this.createXUIElement((Element)child, parent);
                parent.addChildElement(element);
            }
            ++i;
        }
    }

    private void setElementAttributes(XUIAbstractElement element, Element node) {
        String id = this.getId(node);
        element.setId(id);
        String name = this.getName(node);
        element.setName(name);
        String nameKey = this.getNameKey(node);
        if (nameKey != null) {
            element.setNamekey(nameKey);
        }
    }

    private XUIGroup createGroup(Element node, IXUIElement parent) throws XUIParseException {
        XUIGroup group = new XUIGroup(parent);
        this.setElementAttributes(group, node);
        boolean isBorderVisible = true;
        String borderVisibleStr = node.getAttribute("borderVisible");
        if (borderVisibleStr.toLowerCase().equals("false")) {
            isBorderVisible = false;
        }
        group.setBorderVisible(isBorderVisible);
        String layoutStr = node.getAttribute("layout");
        int layout = this.getLayoutValue(layoutStr);
        group.setLayout(layout);
        String toolTipText = node.getAttribute("toolTipText");
        if (toolTipText.trim().length() > 0) {
            group.setToolTipText(toolTipText.trim());
        }
        this.processChildNodes(node, group);
        return group;
    }

    private XUICheckedButton createCheckButton(Element node, IXUIElement parent) throws XUIParseException {
        XUICheckedButton checkButton = new XUICheckedButton(parent);
        this.setElementAttributes(checkButton, node);
        String editableStr = node.getAttribute("editable");
        boolean editable = Boolean.parseBoolean(editableStr);
        checkButton.setEditable(editable);
        String toolTipText = node.getAttribute("toolTipText");
        if (toolTipText.trim().length() > 0) {
            checkButton.setToolTipText(toolTipText.trim());
        }
        this.processChildNodes(node, checkButton);
        return checkButton;
    }

    private XUIRadioGroup createRadioGroup(Element node, IXUIElement parent) throws XUIParseException {
        XUIRadioGroup radioGroup = new XUIRadioGroup(parent);
        this.setElementAttributes(radioGroup, node);
        String layoutStr = node.getAttribute("layout");
        int layout = this.getLayoutValue(layoutStr);
        radioGroup.setLayout(layout);
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node child = childNodes.item(i);
            short nodeType = child.getNodeType();
            if (nodeType == 1) {
                if (this.isRadioButton(child)) {
                    XUIRadioButton radioButton = this.createRadioButton((Element)child, radioGroup);
                    radioGroup.addChildElement(radioButton);
                } else {
                    throw new XUIParseException("Only <radioButton> nodes are allowed inside <radioGroup>");
                }
            }
            ++i;
        }
        return radioGroup;
    }

    private XUIRadioButton createRadioButton(Element node, IXUIElement parent) throws XUIParseException {
        XUIRadioButton radioElement = new XUIRadioButton(parent);
        this.setElementAttributes(radioElement, node);
        String editableStr = node.getAttribute("editable");
        boolean editable = Boolean.parseBoolean(editableStr);
        radioElement.setEditable(editable);
        String defaultStr = node.getAttribute("default");
        boolean isDefault = Boolean.parseBoolean(defaultStr);
        radioElement.setDefault(isDefault);
        String toolTipText = node.getAttribute("toolTipText");
        if (toolTipText.trim().length() > 0) {
            radioElement.setToolTipText(toolTipText.trim());
        }
        this.processChildNodes(node, radioElement);
        return radioElement;
    }

    private XUILabel createLabel(Element node, IXUIElement parent) throws XUIParseException {
        XUILabel label = new XUILabel(parent);
        this.setElementAttributes(label, node);
        String editableStr = node.getAttribute("editable");
        boolean editable = Boolean.parseBoolean(editableStr);
        label.setEditable(editable);
        this.processChildNodes(node, label);
        return label;
    }

    private XUICombo createCombo(Element node, IXUIElement parent) throws XUIParseException {
        XUICombo combo = new XUICombo(parent);
        this.setElementAttributes(combo, node);
        String[] items = this.getComboItems(node);
        combo.setItems(items);
        String selectionIndexStr = node.getAttribute("select");
        if (selectionIndexStr != null && selectionIndexStr.trim().length() > 0) {
            try {
                int selectionIndex = Integer.parseInt(selectionIndexStr);
                combo.selectItem(selectionIndex);
            }
            catch (NumberFormatException selectionIndex) {
                // empty catch block
            }
        }
        String readOnlyStr = node.getAttribute("readOnly");
        boolean readOnly = Boolean.parseBoolean(readOnlyStr);
        combo.setReadOnly(readOnly);
        this.processChildNodes(node, combo);
        return combo;
    }

    private String[] getComboItems(Element node) {
        String itemsStr = node.getAttribute("items");
        if (itemsStr == null || itemsStr.trim().length() == 0) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(itemsStr, ",");
        int size = tokenizer.countTokens();
        String[] items = new String[size];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            String token;
            String item = token = tokenizer.nextToken();
            if (token.startsWith("%")) {
                String id = token.substring(1);
                item = this.getMessage(id);
            }
            items[index] = item;
            ++index;
        }
        return items;
    }

    private int getLayoutValue(String str) {
        if (str != null) {
            if (str.equals("horizontal")) {
                return 1;
            }
            if (str.equals("vertical")) {
                return 0;
            }
        }
        return 2;
    }

    private boolean isRadioButton(Node node) {
        return this.nodeNameEquals(node, "http:///com/ibm/debug/xmlui", "radioButton");
    }

    private boolean isGroup(Node node) {
        return this.nodeNameEquals(node, "http:///com/ibm/debug/xmlui", "group");
    }

    private boolean isCheckButton(Node node) {
        return this.nodeNameEquals(node, "http:///com/ibm/debug/xmlui", "checkButton");
    }

    private boolean isRadioGroup(Node node) {
        return this.nodeNameEquals(node, "http:///com/ibm/debug/xmlui", "radioGroup");
    }

    private boolean isLabel(Node node) {
        return this.nodeNameEquals(node, "http:///com/ibm/debug/xmlui", "label");
    }

    private boolean isCombo(Node node) {
        return this.nodeNameEquals(node, "http:///com/ibm/debug/xmlui", "combo");
    }

    private String getId(Element node) {
        String idAttr = node.getAttribute("id");
        if (idAttr != null && idAttr.length() > 0) {
            return idAttr;
        }
        return null;
    }

    private String getName(Element node) {
        String name = node.getAttribute("name");
        if (name != null && name.startsWith("%")) {
            String id = name.substring(1);
            return this.getMessage(id);
        }
        return name;
    }

    private String getNameKey(Element node) {
        String name = node.getAttribute("name");
        if (name != null && name.startsWith("%")) {
            return name.substring(1);
        }
        return null;
    }

    private String getMessage(String key) {
        if (this.fBundle != null && this.fBundle.length() > 0) {
            try {
                ResourceBundle res = this.fClassLoader != null ? ResourceBundle.getBundle(this.fBundle, Locale.getDefault(), this.fClassLoader) : ResourceBundle.getBundle(this.fBundle);
                return res.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return key;
    }
}

